# -*- coding: utf-8 -*-
import xbmc, xbmcaddon, xbmcgui
import sys, os, urllib2, json, time, urlparse

AddonID = 'plugin.program.redalert'
Addon = xbmcaddon.Addon(AddonID)
AddonName = Addon.getAddonInfo("name")
icon = Addon.getAddonInfo('icon')
profileDir = xbmc.translatePath(Addon.getAddonInfo("profile")).decode("utf-8")
addonDir = Addon.getAddonInfo('path').decode('utf-8')
audioDir = '{0}/resources/audio'.format(addonDir)
if not os.path.exists(profileDir):
	os.makedirs(profileDir)


def GetRedAlerts():
	newAlerts = []
	try:
		req = urllib2.Request('http://redalert.me/alerts', headers={'Connection': 'Keep-Alive', 'User-Agent': 'Apache-HttpClient/UNAVAILABLE (java 1.4)'})
		text = urllib2.urlopen(req).read()
		alerts = json.loads(text)
		if len(alerts) < 1:
			return newAlerts
	except:
		xbmc.log('Cannot get alerts from server', 5)
		return newAlerts
	lastAlert = 0
	lastAlertFile = os.path.join(profileDir, 'lastalert.txt')
	if os.path.isfile(lastAlertFile):
		try:
			with open(lastAlertFile, 'r') as handle:
				lastAlert = int(handle.read())
		except:
			pass
	newestAlert = alerts[0]['date']
	if newestAlert > lastAlert:
		with open(lastAlertFile, 'w') as handle:
			handle.write(str(newestAlert))
	else:
		return newAlerts
	now = int(time.time())
	for alert in alerts:
		if now <= (alert['date'] + 180):
			newAlerts.append(alert['area'])
	return newAlerts

def GetIntSetting(key, defValue):
	valS = Addon.getSetting(key).strip()
	try:
		val = int(valS)
	except:
		xbmc.log('Bad {0}.  -{1}-'.format(key, valS), 5)
		val = defValue
	return val

def RedAlert(test=False):
	notification = ''
	newAlerts = GetTestAlerts() if test else GetRedAlerts()
	if len(newAlerts) < 1:
		return
	for newAlert in newAlerts:
		notification = '{0} | {1}'.format(notification, newAlert)
	xbmc.log(notification, 5)
	notificationDuration = GetIntSetting('notificationDuration', 30)
	playSound = Addon.getSetting('playSound') == 'true'
	xbmcgui.Dialog().notification(AddonName, notification[2:], icon, notificationDuration*1000, False)
	if playSound:
		alertWav = '{0}/alert.wav'.format(audioDir)
		xbmc.playSFX(alertWav)

def Loop():
	if Addon.getSetting('isServiceActive') != 'true':
		Addon.setSetting('isServiceActive', 'true')
	seconds = GetIntSetting('interval', 10)
	redAlertCommand = 'XBMC.RunPlugin(plugin://plugin.program.redalert/?mode=0)'
	xbmc.executebuiltin('XBMC.AlarmClock(redalert,{0},{1:02d}:{2:02d},silent)'.format(redAlertCommand, seconds//60, seconds%60))

def Mute():
	xbmc.executebuiltin('XBMC.CancelAlarm(redalert,silent)')
	if Addon.getSetting('isServiceActive') != 'false':
		Addon.setSetting('isServiceActive', 'false')
 
def GetTestAlerts():
	newAlerts = ['בדיקה 1', 'בדיקה 2', 'בדיקה 3', 'בדיקה 4', 'בדיקה 5', 'בדיקה 6', 'בדיקה 7', 'בדיקה 8', 'בדיקה 9', 'בדיקה 10']
	return newAlerts
 
params = dict(urlparse.parse_qsl(sys.argv[2].replace('?','')))
mode = int(params.get('mode','-1'))

if mode == -1:
	Addon.openSettings()
elif mode == 0:
	RedAlert()
	Loop()
elif mode == 1:
	RedAlert()
elif mode == 2:
	Mute()
elif mode == 3:
	RedAlert(test=True)
