import xbmcgui, xbmcaddon
import requests
import json
import time
from modules.fen_cache import cache_object
from modules.utils import to_utf8
# from modules.utils import logger

__addon_id__ = 'plugin.video.fen'
__addon__ = xbmcaddon.Addon(id=__addon_id__)

progressDialog = xbmcgui.DialogProgress()

class AllDebridAPI:
    def __init__(self):
        self.user_agent = 'fen_for_kodi'
        self.base_url = 'https://api.alldebrid.com/'
        self.token = __addon__.getSetting('ad.token')

    def ad_enabled(self):
        if self.token == '':
            return False
        else:
            return True

    def auth_loop(self):
        if progressDialog.iscanceled():
            progressDialog.close()
            return
        time.sleep(5)
        response = requests.get(self.check_url).json()
        if 'error' in response:
            self.token = 'failed'
            return xbmcgui.Dialog().ok('All Debrid Authorization', 'Authentication failed. Try Again.')
        if response['activated']:
            try:
                progressDialog.close()
                self.token = str(response['token'])
                __addon__.setSetting('ad.token', self.token)
            except:
                self.token = 'failed'
                return xbmcgui.Dialog().ok('All Debrid Authorization', 'Authentication failed. Try Again.')
        return

    def auth(self):
        self.token = ''
        url = self.base_url + '/pin/get?agent=%s' % self.user_agent
        response = requests.get(url).json()
        progressDialog.create('All Debrid Authorization', '')
        progressDialog.update(-1, 'All Debrid Authentication','Navigate to: [B]%s[/B]' % response.get('base_url'),
                                    'Enter the following code: [B]%s[/B]'% response.get('pin'))
        self.check_url = response.get('check_url')
        time.sleep(2)
        while not self.token:
            self.auth_loop()
        if self.token in (None, '', 'failed'): return
        time.sleep(2)
        account_info = self._get('user/login')
        __addon__.setSetting('ad.account_id', str(account_info['user']['username']))
        xbmcgui.Dialog().ok('All Debrid Authorization', 'Authentication Successful.')

    def account_info(self):
        response = self._get('user/login')
        return response

    def check_cache(self, hashes):
        data = {'magnets[]': hashes}
        result = self._post('magnet/instant', data)
        return result

    def user_cloud(self):
        url = 'magnet/status'
        string = "fen_ad_user_cloud"
        return cache_object(self._get, string, url, False, 2)

    def unrestrict_link(self, link):
        url = 'link/unlock'
        url_append = '&link=%s' % link
        response = self._get(url, url_append)
        try: return response['infos']['link']
        except: return None

    def create_transfer(self, magnet):
        url = 'magnet/upload'
        url_append = '&magnet=%s' % magnet
        result = self._get(url, url_append)
        if result.get('success', False):
            return result.get('id', "")

    def list_transfer(self, transfer_id):
        url = 'magnet/status'
        url_append = '&id=%s' % transfer_id
        result = self._get(url, url_append)
        if result.get('success', False):
            return result

    def delete_transfer(self, transfer_id):
        url = 'magnet/delete'
        url_append = '&id=%s' % transfer_id
        result = self._get(url, url_append)
        if result.get('success', False):
            return True

    def resolve_magnet(self, magnet, info_hash):
        from modules.utils import supported_video_extensions
        extensions = supported_video_extensions()
        transfer_id = self.create_transfer(magnet)
        transfer_info = self.list_transfer(transfer_id)
        for link, file in transfer_info.get('links').items():
            if any(file.lower().endswith(x) for x in extensions):
                media_id = link.replace("\/", "/")
                break
        self.delete_transfer(transfer_id)
        file_url = self.unrestrict_link(media_id)
        return file_url

    def get_hosts(self):
        hosts = []
        url = 'hosts/domains'
        string = "fen_ad_valid_hosts"
        try:
            result = cache_object(self._get, string, url, False, 8)
            result = json.loads(result)
            if result.get('success', False):
                hosts = [host.replace('www.', '') for host in result.get('hosts', [])]
                hosts.extend([u'torrent', u'magnet'])
            else:
                pass
        except:
            pass
        return hosts

    def valid_url(self, host):
        self.hosts = self.get_hosts()
        if any(host in item for item in self.hosts):
            return True
        return False

    def _get(self, url, url_append=''):
        if self.token == '': return None
        url = self.base_url + url + '?agent=%s&token=%s' % (self.user_agent, self.token) + url_append
        return requests.get(url).json()

    def _post(self, url, data={}):
        if self.token == '': return None
        url = self.base_url + url + '?agent=%s&token=%s' % (self.user_agent, self.token)
        return requests.post(url, data=data).json()

    def revoke_auth(self):
        __addon__.setSetting('ad.account_id', '')
        __addon__.setSetting('ad.token', '')
        xbmcgui.Dialog().ok('All Debrid', 'Revoke Authentication Successful.')

    def clear_cache(self):
        try:
            import xbmc, xbmcvfs
            import os
            AD_DATABASE = os.path.join(xbmc.translatePath(__addon__.getAddonInfo('profile')), 'fen_cache.db')
            if not xbmcvfs.exists(AD_DATABASE): return True
            try: from sqlite3 import dbapi2 as database
            except ImportError: from pysqlite2 import dbapi2 as database
            window = xbmcgui.Window(10000)
            dbcon = database.connect(AD_DATABASE)
            dbcur = dbcon.cursor()
            dbcur.execute("""DELETE FROM fencache WHERE id=?""", ('fen_ad_user_cloud',))
            window.clearProperty('fen_ad_user_cloud')
            dbcon.commit()
            dbcon.close()
            return True
        except: return False