
import xbmc, xbmcaddon, xbmcvfs, xbmcgui
import json
import re
from modules.utils import get_release_quality, get_file_info,  clean_file_name, to_utf8
from modules import settings
# from modules.utils import logger

__addon__ = xbmcaddon.Addon(id='plugin.video.fen')
window = xbmcgui.Window(10000)

class LocalLibrarySource:
    def __init__(self):
        self.scrape_provider = 'local'
        self.sources = []
        self.highlight_type = __addon__.getSetting('highlight.type')
        if self.highlight_type == '': self.highlight_type = '0'
        self.provider_color = settings.provider_color(self.scrape_provider)
        self.second_line_color = __addon__.getSetting('secondline.identify')
        if self.second_line_color == 'No Color': self.second_line_color = ''
        self.show_extra_info = settings.show_extra_info()
        self.show_filenames = settings.show_filenames()

    def results(self, info):
        try:
            self.info = info
            self.db_type = self.info.get("db_type")
            self.title = self.info.get("title")
            self.year = self.info.get("year")
            self.season = self.info.get("season")
            self.episode = self.info.get("episode")
            self.db_info = self._get_library_video(self.db_type, self.title, self.year, self.season, self.episode)
            if not self.db_info: return self.sources
            self._label_settings()
            self.file_name = self.db_info.get("name")
            self.file_id = self.db_info.get("file_id")
            self.file_dl = self.db_info.get("file_id")
            self.size = self._get_size(self.file_dl)
            self.details = get_file_info(self.file_name)
            self.video_quality = get_release_quality(self.file_name, self.file_dl)
            labels = self._build_label()
            label = labels[0]
            multiline_label = labels[1]
            self.sources.append({'name': self.file_name,
                            'label': label,
                            'multiline_label': multiline_label,
                            'quality': self.video_quality,
                            'size': self.size,
                            'url_dl': self.file_dl,
                            'url': self.file_dl,
                            'id': self.file_id,
                            'local': True,
                            'direct': True,
                            'source': self.scrape_provider,
                            'scrape_provider': self.scrape_provider})

            window.setProperty('local_source_results', json.dumps(self.sources))
        except Exception as e:
            from modules.utils import logger
            logger('FEN local scraper Exception', e)
        
        return self.sources

    def _get_library_video(self, db_type, title, year, season=None, episode=None):
        try:
            name = None
            years = (str(year), str(int(year)+1), str(int(year)-1))
            if db_type == 'movie':
                r = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetMovies", "params": {"filter":{"or": [{"field": "year", "operator": "is", "value": "%s"}, {"field": "year", "operator": "is", "value": "%s"}, {"field": "year", "operator": "is", "value": "%s"}]}, "properties": ["imdbnumber", "title", "originaltitle", "file"]}, "id": 1}' % years)
                r = to_utf8(r)
                r = json.loads(r)['result']['movies']
                try:
                    r = [i for i in r if clean_file_name(title).lower() in clean_file_name(to_utf8(i['title'])).lower()]
                    r = [i for i in r if not to_utf8(i['file']).endswith('.strm')][0]
                except: return None
                r = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetMovieDetails", "params": {"properties": ["streamdetails", "file"], "movieid": %s }, "id": 1}' % str(r['movieid']))
                r = to_utf8(r)
                r = json.loads(r)['result']['moviedetails']
            else:
                r = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetTVShows", "params": {"filter":{"or": [{"field": "year", "operator": "is", "value": "%s"}, {"field": "year", "operator": "is", "value": "%s"}, {"field": "year", "operator": "is", "value": "%s"}]}, "properties": ["title"]}, "id": 1}' % years)
                r = to_utf8(r)
                r = json.loads(r)['result']['tvshows']
                try:
                    r = [i for i in r if clean_file_name(title).lower() in (clean_file_name(to_utf8(i['title'])).lower() if not ' (' in to_utf8(i['title']) else clean_file_name(to_utf8(i['title'])).lower().split(' (')[0])][0]
                except: return None

                r = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetEpisodes", "params": {"filter":{"and": [{"field": "season", "operator": "is", "value": "%s"}, {"field": "episode", "operator": "is", "value": "%s"}]}, "properties": ["file"], "tvshowid": %s }, "id": 1}' % (str(season), str(episode), str(r['tvshowid'])))
                r = to_utf8(r)
                r = json.loads(r)['result']['episodes']
                try:
                    r = [i for i in r if not to_utf8(i['file']).endswith('.strm')][0]
                except:
                    return None
                r = xbmc.executeJSONRPC('{"jsonrpc": "2.0", "method": "VideoLibrary.GetEpisodeDetails", "params": {"properties": ["streamdetails", "file"], "episodeid": %s }, "id": 1}' % str(r['episodeid']))
                r = to_utf8(r)
                r = json.loads(r)['result']['episodedetails']
            url = r['file'].encode('utf-8')
            try: name = url.split('/')[-1:][0]
            except: name = None
            if not name:
                try: name = url.split('\\')[-1:][0]
                except: name = None
            if not name:
                name = title
            return {'name': name, 'file_id': url}
        except: pass

    def _label_settings(self):
        if self.highlight_type == '1':
            self.highlight_4K = __addon__.getSetting('scraper_4k_highlight')
            if self.highlight_4K == '': self.highlight_4K = 'magenta'
            self.highlight_1080p = __addon__.getSetting('scraper_1080p_highlight')
            if self.highlight_1080p == '': self.highlight_1080p = 'lawngreen'
            self.highlight_720p = __addon__.getSetting('scraper_720p_highlight')
            if self.highlight_720p == '': self.highlight_720p = 'gold'
            self.highlight_SD = __addon__.getSetting('scraper_SD_highlight')
            if self.highlight_SD == '': self.highlight_SD = 'lightsaltegray'
        else:
            # Single Line...
            if self.provider_color == '':
                self.single_leading = ''
                self.single_closing = ''
            else:
                self.single_leading = '[COLOR=%s]' % self.provider_color
                self.single_closing = '[/COLOR]'
            # Multiline...
            if self.provider_color == '':
                self.multi1_leading = ''
                self.multi1_closing = ''
            else:
                self.multi1_leading = '[COLOR=%s]' % self.provider_color
                self.multi1_closing = '[/COLOR]'
            if self.second_line_color == '':
                self.multi2_leading = self.multi1_leading
                self.multi2_closing = self.multi1_closing
            else:
                self.multi2_leading = '[COLOR=%s]' % self.second_line_color
                self.multi2_closing = '[/COLOR]'

    def _build_label(self):
        if self.show_filenames: filename = self.file_name.replace('.', ' ')
        else: filename = ''
        if self.show_extra_info: details = self.details
        else: details = ''
        label = '[B]LOCAL[/B] | [I][B]%s[/B][/I] | %.2f GB' % (self.video_quality, self.size)
        multiline_label1 = '[B]LOCAL[/B] | [I][B]%s[/B][/I] | %.2f GB' % (self.video_quality, self.size)
        if self.show_extra_info: label += ' | %s' % details
        multiline_label2 = ''
        if self.show_filenames:
            label += ' | %s' % filename
            multiline_label1 += ' | %s' % details
            multiline_label2 += '\n        %s' % filename
        else:
            multiline_label2 += '\n        %s' % details
        label = label.replace('| 0 |', '|').replace(' | [I]0 [/I]', '')
        label = re.sub('\[I\]\s+\[/I\]', ' ', label)
        label = re.sub('\|\s+\|', '|', label)
        label = re.sub('\|(?:\s+|)$', '', label)
        label = label.upper()
        multiline_label1 = multiline_label1.replace('| 0 |', '|').replace(' | [I]0 [/I]', '')
        multiline_label1 = re.sub('\[I\]\s+\[/I\]', ' ', multiline_label1)
        multiline_label1 = re.sub('\|\s+\|', '|', multiline_label1)
        multiline_label1 = re.sub('\|(?:\s+|)$', '', multiline_label1)
        multiline_label1 = multiline_label1.upper()
        if multiline_label2 != '':
            multiline_label2 = multiline_label2.replace('| 0 |', '|').replace(' | [I]0 [/I]', '')
            multiline_label2 = re.sub('\[I\]\s+\[/I\]', ' ', multiline_label2)
            multiline_label2 = re.sub('\|\s+\|', '|', multiline_label2)
            multiline_label2 = re.sub('\|(?:\s+|)$', '', multiline_label2)
            multiline_label2 = multiline_label2.upper()
        if self.highlight_type == '1':
            if self.video_quality.upper() == '4K': leading_color = self.highlight_4K
            elif self.video_quality.upper()  == '1080P': leading_color = self.highlight_1080p
            elif self.video_quality.upper() == '720P': leading_color = self.highlight_720p
            else: leading_color = self.highlight_SD
            if self.second_line_color == '': multiline_open = leading_color
            else: multiline_open = self.second_line_color
            label = '[COLOR=%s]' % leading_color + label + '[/COLOR]'
            multiline_label = '[COLOR=%s]' % leading_color + multiline_label1 + '[/COLOR]' + '[COLOR=%s]' % multiline_open + multiline_label2 + '[/COLOR]'
        else:
            label = self.single_leading + label + self.single_closing
            multiline_label = self.multi1_leading + multiline_label1 + self.multi1_closing + self.multi2_leading + multiline_label2 + self.multi2_closing
        return label, multiline_label

    def _get_size(self, file):
        f = xbmcvfs.File(file) ; s = f.size() ; f.close()
        size = float(s)/1073741824
        return size
