import xbmcaddon, xbmcgui
import re
import json
from datetime import timedelta
from apis.furk_api import FurkAPI
from modules import fen_cache
from modules.utils import get_release_quality, get_file_info, clean_file_name
from modules import settings
# from modules.utils import logger

Furk = FurkAPI()
__addon__ = xbmcaddon.Addon(id='plugin.video.fen')
window = xbmcgui.Window(10000)

class FurkSource:
    def __init__(self):
        self.scrape_provider = 'furk'
        self.sources = []
        self.furk_limit = int(__addon__.getSetting('furk.limit'))
        self.max_gb = int(__addon__.getSetting('furk_maxgb'))
        self.highlight_type = __addon__.getSetting('highlight.type')
        if self.highlight_type == '': self.highlight_type = '0'
        self.provider_color = settings.provider_color(self.scrape_provider)
        if self.provider_color == 'No Color': self.provider_color = ''
        self.second_line_color = __addon__.getSetting('secondline.identify')
        if self.second_line_color == 'No Color': self.second_line_color = ''
        self.show_extra_info = settings.show_extra_info()
        self.show_filenames = settings.show_filenames()

    def results(self, info):
        try:
            self.info = info
            search_name = self._search_name()
            files = Furk.search(search_name)
            if not files: return self.sources
            active_downloads = self.get_active_downloads()
            cached_files = [i for i in files if i.get('type') not in ('default', 'audio', '') and i.get('is_ready') == '1'][0:self.furk_limit]
            uncached_files = [i for i in files if i.get('type') not in ('default', 'audio', '') and i not in cached_files]
            self._label_settings()
            for i in cached_files:
                try:
                    self.file_name = i['name']
                    self.file_id = i['id']
                    self.files_num_video = i['files_num_video']
                    self.size = float(int(i['size']))/1073741824
                    if not int(self.files_num_video) > 3:
                        if self.size > self.max_gb:
                            continue
                    self.file_dl = i['url_dl']
                    self.video_info = i['video_info']
                    self.details = get_file_info(self.file_name)
                    self.video_quality = get_release_quality(self.file_name, self.file_dl)
                    labels = self._build_label()
                    label = labels[0]
                    multiline_label = labels[1]
                    self.sources.append({'name': self.file_name,
                                    'label': label,
                                    'multiline_label': multiline_label,
                                    'title': self.file_name,
                                    'quality': self.video_quality,
                                    'size': self.size,
                                    'url_dl': self.file_dl,
                                    'id': self.file_id,
                                    'local': False,
                                    'direct': True,
                                    'source': self.scrape_provider,
                                    'scrape_provider': self.scrape_provider})
                except Exception as e:
                    from modules.utils import logger
                    logger('FURK ERROR - 70', e)
                    pass
            for i in uncached_files:
                try:
                    self.file_name = i['name']
                    info_hash = i['info_hash']
                    try: self.files_num_video = i['files_num_video']
                    except: self.files_num_video = 1
                    try: self.size = float(int(i['size']))/1073741824
                    except: self.size = 0
                    active_download = True if info_hash in active_downloads else False
                    self.details = get_file_info(self.file_name)
                    self.video_quality = get_release_quality(self.file_name)
                    labels = self._build_label(uncached=True, active_download=active_download)
                    label = labels[0]
                    multiline_label = labels[1]
                    self.sources.append({'name': self.file_name,
                                    'label': label,
                                    'multiline_label': multiline_label,
                                    'title': self.file_name,
                                    'quality': self.video_quality,
                                    'size': self.size,
                                    'url_dl': info_hash,
                                    'id': info_hash,
                                    'local': False,
                                    'direct': True,
                                    'uncached': True,
                                    'source': self.scrape_provider,
                                    'scrape_provider': self.scrape_provider})
                except Exception as e:
                    from modules.utils import logger
                    logger('FURK ERROR - 99', e)
                    pass

            window.setProperty('furk_source_results', json.dumps([i for i in self.sources if not 'uncached' in i]))
        except Exception as e:
            from modules.utils import logger
            logger('FEN furk scraper Exception', e)

        return self.sources

    def get_active_downloads(self):
        _cache = fen_cache.FenCache()
        cache = _cache.get('furk_active_downloads')
        if cache != None: result = cache
        else:
            active_downloads = Furk.file_get_active()
            result = [i['info_hash'] for i in active_downloads]
            _cache.set('furk_active_downloads', result, expiration=timedelta(hours=1))
        return result

    def _search_name(self):
        search_title = clean_file_name(self.info.get("title"))
        search_title = search_title.replace(' ', '+')
        db_type = self.info.get("db_type")
        if db_type == 'movie':
            year = self.info.get("year")
            years = '%s+|+%s+|+%s' % (str(int(year - 1)), year, str(int(year + 1)))
            search_name = '@name+%s+%s' % (search_title, years)
        else:
            season = self.info.get("season")
            episode = self.info.get("episode")
            queries = self._seas_ep_query_list(season, episode)
            search_name = '@name+%s+@files+%s+|+%s+|+%s+|+%s+|+%s' % (search_title, queries[0], queries[1], queries[2], queries[3], queries[4])
        return search_name

    def _label_settings(self):
        if self.highlight_type == '1':
            self.highlight_4K = __addon__.getSetting('scraper_4k_highlight')
            if self.highlight_4K == '': self.highlight_4K = 'magenta'
            self.highlight_1080p = __addon__.getSetting('scraper_1080p_highlight')
            if self.highlight_1080p == '': self.highlight_1080p = 'lawngreen'
            self.highlight_720p = __addon__.getSetting('scraper_720p_highlight')
            if self.highlight_720p == '': self.highlight_720p = 'gold'
            self.highlight_SD = __addon__.getSetting('scraper_SD_highlight')
            if self.highlight_SD == '': self.highlight_SD = 'lightsaltegray'
        else:
            # Single Line...
            if self.provider_color == '':
                self.single_leading = ''
                self.single_closing = ''
            else:
                self.single_leading = '[COLOR=%s]' % self.provider_color
                self.single_closing = '[/COLOR]'
            # Multiline...
            if self.provider_color == '':
                self.multi1_leading = ''
                self.multi1_closing = ''
            else:
                self.multi1_leading = '[COLOR=%s]' % self.provider_color
                self.multi1_closing = '[/COLOR]'
            if self.second_line_color == '':
                self.multi2_leading = self.multi1_leading
                self.multi2_closing = self.multi1_closing
            else:
                self.multi2_leading = '[COLOR=%s]' % self.second_line_color
                self.multi2_closing = '[/COLOR]'

    def _build_label(self, uncached=False, active_download=False):
        if self.show_filenames: filename = self.file_name.replace('.', ' ')
        else: filename = ''
        if self.show_extra_info: details = self.details
        else: details = ''
        result_type = ''
        if uncached:
            if active_download: result_type += '[B]ACTIVE[/B]'
            else: result_type += '[B]UNCACHED[/B]'
        if int(self.files_num_video) > 3: result_type += ' | PACK [B](x%02d)[/B]' % int(self.files_num_video)
        else: result_type += ' | SINGLE'
        label = '[B]FURK[/B] | [I][B]%s[/B][/I] | %.2f GB | %s' % (self.video_quality, self.size, result_type)
        multiline_label1 = '[B]FURK[/B] | [I][B]%s[/B][/I] | %.2f GB | %s' % (self.video_quality, self.size, result_type)
        if self.show_extra_info: label += ' | %s' % details
        multiline_label2 = ''
        if self.show_filenames:
            label += ' | %s' % filename
            multiline_label1 += ' | %s' % details
            multiline_label2 += '\n        %s' % filename
        else:
            multiline_label2 += '\n        %s' % details
        label = label.replace('| 0 |', '|').replace(' | [I]0 [/I]', '')
        label = re.sub('\[I\]\s+\[/I\]', ' ', label)
        label = re.sub('\|\s+\|', '|', label)
        label = re.sub('\|(?:\s+|)$', '', label)
        label = label.upper()
        multiline_label1 = multiline_label1.replace('| 0 |', '|').replace(' | [I]0 [/I]', '')
        multiline_label1 = re.sub('\[I\]\s+\[/I\]', ' ', multiline_label1)
        multiline_label1 = re.sub('\|\s+\|', '|', multiline_label1)
        multiline_label1 = re.sub('\|(?:\s+|)$', '', multiline_label1)
        multiline_label1 = multiline_label1.upper()
        if multiline_label2 != '':
            multiline_label2 = multiline_label2.replace('| 0 |', '|').replace(' | [I]0 [/I]', '')
            multiline_label2 = re.sub('\[I\]\s+\[/I\]', ' ', multiline_label2)
            multiline_label2 = re.sub('\|\s+\|', '|', multiline_label2)
            multiline_label2 = re.sub('\|(?:\s+|)$', '', multiline_label2)
            multiline_label2 = multiline_label2.upper()
        if uncached:
            if self.second_line_color == '': multiline_open = ''
            else: multiline_open = '[COLOR %s]' % self.second_line_color
            if multiline_open == '': multiline_close = ''
            else: multiline_close = '[/COLOR]'
            label = '[I]' + label.replace('[B]FURK[/B]', '[COLOR %s][B]FURK[/B][/COLOR]' % self.provider_color).replace('[B]UNCACHED[/B]', '[COLOR %s][B]UNCACHED[/B][/COLOR]' % self.provider_color).replace('[B]ACTIVE[/B]', '[COLOR lawngreen][B]ACTIVE[/B][/COLOR]').replace('[/I]', '') + '[/I]'
            multiline_label = '[I]' + multiline_label1.replace('[B]FURK[/B]', '[COLOR %s][B]FURK[/B][/COLOR]' % self.provider_color).replace('[B]UNCACHED[/B]', '[COLOR %s][B]UNCACHED[/B][/COLOR]' % self.provider_color).replace('[B]ACTIVE[/B]', '[COLOR lawngreen][B]ACTIVE[/B][/COLOR]').replace('[/I]', '') + multiline_open + multiline_label2 + multiline_close + '[/I]'
        elif self.highlight_type == '1':
            if self.video_quality.upper() == '4K': leading_color = self.highlight_4K
            elif self.video_quality.upper()  == '1080P': leading_color = self.highlight_1080p
            elif self.video_quality.upper() == '720P': leading_color = self.highlight_720p
            else: leading_color = self.highlight_SD
            if self.second_line_color == '': multiline_open = leading_color
            else: multiline_open = self.second_line_color
            label = '[COLOR=%s]' % leading_color + label + '[/COLOR]'
            multiline_label = '[COLOR=%s]' % leading_color + multiline_label1 + '[/COLOR]' + '[COLOR=%s]' % multiline_open + multiline_label2 + '[/COLOR]'
        else:
            label = self.single_leading + label + self.single_closing
            multiline_label = self.multi1_leading + multiline_label1 + self.multi1_closing + self.multi2_leading + multiline_label2 + self.multi2_closing
        return label, multiline_label

    def _seas_ep_query_list(self, season, episode):
        return ['s%02de%02d' % (int(season), int(episode)),
                '%dx%02d' % (int(season), int(episode)),
                '%02dx%02d' % (int(season), int(episode)),
                '"season %d episode %d"' % (int(season), int(episode)),
                '"season %02d episode %02d"' % (int(season), int(episode))]

