import xbmcaddon, xbmcgui
import re
import json
from apis.easynews_api import EasyNewsAPI
from modules.utils import get_release_quality, get_file_info, clean_file_name
from modules import settings
# from modules.utils import logger

__addon_id__ = 'plugin.video.fen'
__addon__ = xbmcaddon.Addon(id=__addon_id__)
window = xbmcgui.Window(10000)
EasyNews = EasyNewsAPI()

class EasyNewsSource:
    def __init__(self):
        self.scrape_provider = 'easynews'
        self.sources = []
        self.max_results = int(__addon__.getSetting('easynews_limit'))
        self.max_gb = __addon__.getSetting('easynews_maxgb')
        self.max_bytes = int(self.max_gb) * 1024 * 1024 * 1024
        self.highlight_type = __addon__.getSetting('highlight.type')
        if self.highlight_type == '': self.highlight_type = '0'
        self.provider_color = settings.provider_color(self.scrape_provider)
        if self.provider_color == 'No Color': self.provider_color = ''
        self.second_line_color = __addon__.getSetting('secondline.identify')
        if self.second_line_color == 'No Color': self.second_line_color = ''
        self.show_extra_info = settings.show_extra_info()
        self.show_filenames = settings.show_filenames()

    def results(self, info):
        try:
            self.info = info
            search_name = self._search_name()
            files = EasyNews.search(search_name)
            files = files[0:self.max_results]
            self._label_settings()
            for item in files:
                try:
                    if self.max_bytes:
                        match = re.search('([\d.]+)\s+(.*)', item['size'])
                        if match:
                            size_bytes = self.to_bytes(*match.groups())
                            if size_bytes > self.max_bytes:
                                continue
                    self.file_name = item['name']
                    self.file_dl = item['url_dl']
                    self.size = float(int(item['rawSize']))/1073741824
                    self.details = get_file_info(self.file_name)
                    self.video_quality = get_release_quality(self.file_name, self.file_dl)
                    labels = self._build_label()
                    label = labels[0]
                    multiline_label = labels[1]
                    self.sources.append({'name': self.file_name,
                                    'label': label,
                                    'multiline_label': multiline_label,
                                    'quality': self.video_quality,
                                    'size': self.size,
                                    'url_dl': self.file_dl,
                                    'id': self.file_dl,
                                    'local': False,
                                    'direct': True,
                                    'source': self.scrape_provider,
                                    'scrape_provider': self.scrape_provider})
                except: pass

            window.setProperty('easynews_source_results', json.dumps(self.sources))
        except Exception as e:
            from modules.utils import logger
            logger('FEN easynews scraper Exception', e)

        return self.sources

    def _search_name(self):
        search_title = clean_file_name(self.info.get("title"))
        db_type = self.info.get("db_type")
        year = self.info.get("year")
        years = '%s,%s,%s' % (str(int(year - 1)), year, str(int(year + 1)))
        season = self.info.get("season")
        episode = self.info.get("episode")
        if db_type == 'movie': search_name = '"%s" %s' % (search_title, years)
        else: search_name = '%s S%02dE%02d' % (search_title,  int(season), int(episode))
        return search_name

    def to_bytes(self, num, unit):
        unit = unit.upper()
        if unit.endswith('B'): unit = unit[:-1]
        units = ['', 'K', 'M', 'G', 'T', 'P', 'E', 'Z']
        try: mult = pow(1024, units.index(unit))
        except: mult = sys.maxint
        return int(float(num) * mult)

    def _label_settings(self):
        if self.highlight_type == '1':
            self.highlight_4K = __addon__.getSetting('scraper_4k_highlight')
            if self.highlight_4K == '': self.highlight_4K = 'magenta'
            self.highlight_1080p = __addon__.getSetting('scraper_1080p_highlight')
            if self.highlight_1080p == '': self.highlight_1080p = 'lawngreen'
            self.highlight_720p = __addon__.getSetting('scraper_720p_highlight')
            if self.highlight_720p == '': self.highlight_720p = 'gold'
            self.highlight_SD = __addon__.getSetting('scraper_SD_highlight')
            if self.highlight_SD == '': self.highlight_SD = 'lightsaltegray'
        else:
            # Single Line...
            if self.provider_color == '':
                self.single_leading = ''
                self.single_closing = ''
            else:
                self.single_leading = '[COLOR=%s]' % self.provider_color
                self.single_closing = '[/COLOR]'
            # Multiline...
            if self.provider_color == '':
                self.multi1_leading = ''
                self.multi1_closing = ''
            else:
                self.multi1_leading = '[COLOR=%s]' % self.provider_color
                self.multi1_closing = '[/COLOR]'
            if self.second_line_color == '':
                self.multi2_leading = self.multi1_leading
                self.multi2_closing = self.multi1_closing
            else:
                self.multi2_leading = '[COLOR=%s]' % self.second_line_color
                self.multi2_closing = '[/COLOR]'

    def _build_label(self):
        if self.show_filenames: filename = self.file_name.replace('.', ' ')
        else: filename = ''
        if self.show_extra_info: details = self.details
        else: details = ''
        label = '[B]EASY[/B] | [I][B]%s[/B][/I] | %.2f GB' % (self.video_quality, self.size)
        multiline_label1 = '[B]EASY[/B] | [I][B]%s[/B][/I] | %.2f GB' % (self.video_quality, self.size)
        if self.show_extra_info: label += ' | %s' % details
        multiline_label2 = ''
        if self.show_filenames:
            label += ' | %s' % filename
            multiline_label1 += ' | %s' % details
            multiline_label2 += '\n        %s' % filename
        else:
            multiline_label2 += '\n        %s' % details
        label = label.replace('| 0 |', '|').replace(' | [I]0 [/I]', '')
        label = re.sub('\[I\]\s+\[/I\]', ' ', label)
        label = re.sub('\|\s+\|', '|', label)
        label = re.sub('\|(?:\s+|)$', '', label)
        label = label.upper()
        multiline_label1 = multiline_label1.replace('| 0 |', '|').replace(' | [I]0 [/I]', '')
        multiline_label1 = re.sub('\[I\]\s+\[/I\]', ' ', multiline_label1)
        multiline_label1 = re.sub('\|\s+\|', '|', multiline_label1)
        multiline_label1 = re.sub('\|(?:\s+|)$', '', multiline_label1)
        multiline_label1 = multiline_label1.upper()
        if multiline_label2 != '':
            multiline_label2 = multiline_label2.replace('| 0 |', '|').replace(' | [I]0 [/I]', '')
            multiline_label2 = re.sub('\[I\]\s+\[/I\]', ' ', multiline_label2)
            multiline_label2 = re.sub('\|\s+\|', '|', multiline_label2)
            multiline_label2 = re.sub('\|(?:\s+|)$', '', multiline_label2)
            multiline_label2 = multiline_label2.upper()
        if self.highlight_type == '1':
            if self.video_quality.upper() == '4K': leading_color = self.highlight_4K
            elif self.video_quality.upper()  == '1080P': leading_color = self.highlight_1080p
            elif self.video_quality.upper() == '720P': leading_color = self.highlight_720p
            else: leading_color = self.highlight_SD
            if self.second_line_color == '': multiline_open = leading_color
            else: multiline_open = self.second_line_color
            label = '[COLOR=%s]' % leading_color + label + '[/COLOR]'
            multiline_label = '[COLOR=%s]' % leading_color + multiline_label1 + '[/COLOR]' + '[COLOR=%s]' % multiline_open + multiline_label2 + '[/COLOR]'
        else:
            label = self.single_leading + label + self.single_closing
            multiline_label = self.multi1_leading + multiline_label1 + self.multi1_closing + self.multi2_leading + multiline_label2 + self.multi2_closing
        return label, multiline_label
        return label, multiline_label

