import xbmc, xbmcgui
import sys
import time
from datetime import datetime, timedelta
import _strptime  # fix bug in python import
# from threading import Thread
from modules import settings
# from modules.utils import logger

__addon__ = settings.addon()
window = xbmcgui.Window(10000)

# class Services:
#     def runServiceThreads(self, services):
#         service_threads = []
#         for i in services:
#             service_threads.append(Thread(target=i[0], args=i[1]))
#         [i.start() for i in service_threads]
#         while not xbmc.abortRequested:
#             time.sleep(2)
#         xbmc.log("[FEN] Killing All Services", 2)
#         sys.exit()

class AutoRun:
    def run(self):
        xbmc.log("[FEN] Auto starting...", 2)
        if settings.auto_start_fen():
            xbmc.log("[FEN] Killing Autostart Service", 2)
            return xbmc.executebuiltin('RunAddon(plugin.video.fen)')
        else: 
            xbmc.log("[FEN] Killing Autostart Service", 2)
            return

class SubscriptionsUpdater:
    def run(self):
        xbmc.log("[FEN] Subscription Service Starting...", 2)
        if settings.subscription_update():
            while not xbmc.abortRequested:
                try:
                    service_time = settings.subscription_service_time()
                    next_run  = datetime.fromtimestamp(time.mktime(time.strptime(service_time, "%Y-%m-%d %H:%M:%S")))
                    now = datetime.now()
                    if now > next_run:
                        if xbmc.Player().isPlaying() == False:
                            if xbmc.getCondVisibility('Library.IsScanningVideo') == False:
                                window.setProperty('fen_updating_subscriptions', 'true')
                                xbmc.log("[FEN'] Updating video subscriptions", 2)
                                time.sleep(1)
                                xbmc.executebuiltin('RunPlugin(plugin://plugin.video.fen/?&mode=update_subscriptions)')
                                while window.getProperty('fen_updating_subscriptions') == 'true':
                                    time.sleep(1)
                                time.sleep(1)
                                if __addon__.getSetting('subsciptions.update_type') == '1': __addon__.setSetting('service_time', str(next_run + timedelta(hours=24)).split('.')[0])
                                else: __addon__.setSetting('service_time', str(now + timedelta(hours=settings.subscription_timer())).split('.')[0])
                                time.sleep(1)
                                xbmc.log("[FEN] Subscriptions updated. Next run at " + settings.subscription_service_time(), 2)
                        else:
                            xbmc.log("[FEN] Player is running, waiting until finished")
                except: pass
                time.sleep(3)
        xbmc.log("[FEN] Killing Subscriptions Service", 2)
        sys.exit()

# subscriptions = SubscriptionsUpdater()
# autorun = AutoRun()
# Services().runServiceThreads([(subscriptions.run, ()), (autorun.run, ())])

AutoRun().run()
SubscriptionsUpdater().run()