import xbmcaddon, xbmcgui
import re
import json
from datetime import timedelta
from apis.furk_api import FurkAPI
from modules import fen_cache
from modules.utils import get_release_quality, get_file_info, clean_file_name, to_utf8
from scrapers import build_internal_scrapers_label
from modules import settings
# from modules.utils import logger

Furk = FurkAPI()
__addon__ = xbmcaddon.Addon(id='plugin.video.fen')
window = xbmcgui.Window(10000)

class FurkSource:
    def __init__(self):
        self.scrape_provider = 'furk'
        self.sources = []
        self.furk_limit = int(__addon__.getSetting('furk.limit'))
        self.max_gb = int(__addon__.getSetting('furk_maxgb'))

    def results(self, info):
        try:
            self.info = info
            search_name = self._search_name()
            files = Furk.search(search_name)
            if not files: return self.sources
            active_downloads = self.get_active_downloads()
            cached_files = [i for i in files if i.get('type') not in ('default', 'audio', '') and i.get('is_ready') == '1'][0:self.furk_limit]
            uncached_files = [i for i in files if i.get('type') not in ('default', 'audio', '') and i not in cached_files]
            self._label_settings()
            for i in cached_files:
                try:
                    file_name = i['name']
                    file_id = i['id']
                    files_num_video = i['files_num_video']
                    size = float(int(i['size']))/1073741824
                    if not int(files_num_video) > 3:
                        if size > self.max_gb:
                            continue
                    file_dl = i['url_dl']
                    details = get_file_info(file_name)
                    video_quality = get_release_quality(file_name, file_dl)
                    labels = self._build_label(file_name, details, size, video_quality)
                    label = labels[0]
                    multiline_label = labels[1]
                    self.sources.append({'name': file_name,
                                    'label': label,
                                    'multiline_label': multiline_label,
                                    'title': file_name,
                                    'quality': video_quality,
                                    'size': size,
                                    'url_dl': file_dl,
                                    'id': file_id,
                                    'local': False,
                                    'direct': True,
                                    'source': self.scrape_provider,
                                    'scrape_provider': self.scrape_provider})
                except Exception as e:
                    from modules.utils import logger
                    logger('FURK ERROR - 65', e)
                    pass
            for i in uncached_files:
                try:
                    file_name = i['name']
                    info_hash = i['info_hash']
                    try: files_num_video = i['files_num_video']
                    except: files_num_video = 1
                    try: size = float(int(i['size']))/1073741824
                    except: size = 0
                    active_download = True if info_hash in active_downloads else False
                    details = get_file_info(file_name)
                    video_quality = get_release_quality(file_name)
                    labels = self._build_label(file_name, details, size, video_quality)
                    label = labels[0]
                    multiline_label = labels[1]
                    self.sources.append({'name': file_name,
                                    'label': label,
                                    'multiline_label': multiline_label,
                                    'title': file_name,
                                    'quality': video_quality,
                                    'size': size,
                                    'url_dl': info_hash,
                                    'id': info_hash,
                                    'local': False,
                                    'direct': True,
                                    'uncached': True,
                                    'source': self.scrape_provider,
                                    'scrape_provider': self.scrape_provider})
                except Exception as e:
                    from modules.utils import logger
                    logger('FURK ERROR - 96', e)
                    pass

            window.setProperty('furk_source_results', json.dumps([i for i in self.sources if not 'uncached' in i]))
        
        except Exception as e:
            from modules.utils import logger
            logger('FEN furk scraper Exception', e)
            pass

        return self.sources

    def get_active_downloads(self):
        _cache = fen_cache.FenCache()
        cache = _cache.get('furk_active_downloads')
        if cache != None: result = cache
        else:
            active_downloads = Furk.file_get_active()
            result = [i['info_hash'] for i in active_downloads]
            _cache.set('furk_active_downloads', result, expiration=timedelta(hours=1))
        return result

    def _search_name(self):
        search_title = clean_file_name(to_utf8(self.info.get("title")))
        search_title = search_title.replace(' ', '+')
        db_type = self.info.get("db_type")
        if db_type == 'movie':
            year = self.info.get("year")
            years = '%s+|+%s+|+%s' % (str(int(year - 1)), year, str(int(year + 1)))
            search_name = '@name+%s+%s' % (search_title, years)
        else:
            season = self.info.get("season")
            episode = self.info.get("episode")
            queries = self._seas_ep_query_list(season, episode)
            search_name = '@name+%s+@files+%s+|+%s+|+%s+|+%s+|+%s' % (search_title, queries[0], queries[1], queries[2], queries[3], queries[4])
        return search_name

    def _seas_ep_query_list(self, season, episode):
        return ['s%02de%02d' % (int(season), int(episode)),
                '%dx%02d' % (int(season), int(episode)),
                '%02dx%02d' % (int(season), int(episode)),
                '"season %d episode %d"' % (int(season), int(episode)),
                '"season %02d episode %02d"' % (int(season), int(episode))]

    def _label_settings(self):
        scraper_settings = json.loads(self.info['scraper_settings'])
        self.provider_color = settings.provider_color(self.scrape_provider)
        self.show_extra_info = scraper_settings['extra_info']
        self.show_filenames = scraper_settings['show_filenames']
        self.second_line_color = scraper_settings['multiline_highlight']
        self.highlight_type = scraper_settings['highlight_type']
        if self.highlight_type == '1':
            self.highlight_4K = scraper_settings['highlight_4K']
            self.highlight_1080p = scraper_settings['highlight_1080p']
            self.highlight_720p = scraper_settings['highlight_720p']
            self.highlight_SD = scraper_settings['highlight_SD']
        else:
            # Single Line...
            if self.provider_color == '':
                self.single_leading = ''
                self.single_closing = ''
            else:
                self.single_leading = '[COLOR=%s]' % self.provider_color
                self.single_closing = '[/COLOR]'
            # Multiline...
            if self.provider_color == '':
                self.multi1_leading = ''
                self.multi1_closing = ''
            else:
                self.multi1_leading = '[COLOR=%s]' % self.provider_color
                self.multi1_closing = '[/COLOR]'
            if self.second_line_color == '':
                self.multi2_leading = self.multi1_leading
                self.multi2_closing = self.multi1_closing
            else:
                self.multi2_leading = '[COLOR=%s]' % self.second_line_color
                self.multi2_closing = '[/COLOR]'

    def _build_label(self, file_name, details, size, video_quality, uncached=False, active_download=False):
        furk_settings = {'uncached': uncached, 'active_download': active_download}
        label, multiline_label1, multiline_label2 = build_internal_scrapers_label('FURK', self.show_filenames, self.show_extra_info, file_name, details, size, video_quality, **furk_settings)
        if uncached:
            if self.second_line_color == '': multiline_open = ''
            else: multiline_open = '[COLOR %s]' % self.second_line_color
            if multiline_open == '': multiline_close = ''
            else: multiline_close = '[/COLOR]'
            label = '[I]' + label.replace('[B]FURK[/B]', '[COLOR %s][B]FURK[/B][/COLOR]' % self.provider_color).replace('[B]UNCACHED[/B]', '[COLOR %s][B]UNCACHED[/B][/COLOR]' % self.provider_color).replace('[B]ACTIVE[/B]', '[COLOR lawngreen][B]ACTIVE[/B][/COLOR]').replace('[/I]', '') + '[/I]'
            multiline_label = '[I]' + multiline_label1.replace('[B]FURK[/B]', '[COLOR %s][B]FURK[/B][/COLOR]' % self.provider_color).replace('[B]UNCACHED[/B]', '[COLOR %s][B]UNCACHED[/B][/COLOR]' % self.provider_color).replace('[B]ACTIVE[/B]', '[COLOR lawngreen][B]ACTIVE[/B][/COLOR]').replace('[/I]', '') + multiline_open + multiline_label2 + multiline_close + '[/I]'
        elif self.highlight_type == '1':
            if self.video_quality.upper() == '4K': leading_color = self.highlight_4K
            elif self.video_quality.upper()  == '1080P': leading_color = self.highlight_1080p
            elif self.video_quality.upper() == '720P': leading_color = self.highlight_720p
            else: leading_color = self.highlight_SD
            if self.second_line_color == '': multiline_open = leading_color
            else: multiline_open = self.second_line_color
            label = '[COLOR=%s]' % leading_color + label + '[/COLOR]'
            multiline_label = '[COLOR=%s]' % leading_color + multiline_label1 + '[/COLOR]' + '[COLOR=%s]' % multiline_open + multiline_label2 + '[/COLOR]'
        else:
            label = self.single_leading + label + self.single_closing
            multiline_label = self.multi1_leading + multiline_label1 + self.multi1_closing + self.multi2_leading + multiline_label2 + self.multi2_closing
        return label, multiline_label

