# -*- coding: utf-8 -*-
# from modules.utils import logger

def build_internal_scrapers_label(scraper_name, show_filenames, show_extra_info, file_name, details, size, video_quality, **kwargs):
    if show_filenames: filename = file_name.replace('.', ' ')
    else: filename = ''
    if not show_extra_info: details = ''
    if kwargs:
        result_type = ''
        if kwargs['uncached']:
            if kwargs['active_download']: result_type += ' | [B]ACTIVE[/B]'
            else: result_type += ' | [B]UNCACHED[/B]'
        label = '[B]%s[/B] | [I][B]%s[/B][/I] | %.2f GB%s' % (scraper_name, video_quality, size, result_type)
        multiline_label1 = '[B]%s[/B] | [I][B]%s[/B][/I] | %.2f GB%s' % (scraper_name, video_quality, size, result_type)
    else:
        label = '[B]%s[/B] | [I][B]%s[/B][/I] | %.2f GB' % (scraper_name, video_quality, size)
        multiline_label1 = '[B]%s[/B] | [I][B]%s[/B][/I] | %.2f GB' % (scraper_name, video_quality, size)
    if show_extra_info: label += ' | %s' % details
    multiline_label2 = ''
    if show_filenames:
        label += ' | %s' % filename
        multiline_label1 += ' | %s' % details
        multiline_label2 += '\n        %s' % filename
    else:
        multiline_label2 += '\n        %s' % details
    label = label.replace('| 0 |', '|').replace(' | [I]0 [/I]', '').replace('[I] [/I] | ', '')
    label = label.upper()
    multiline_label1 = multiline_label1.replace('| 0 |', '|').replace(' | [I]0 [/I]', '').replace('[I] [/I] | ', '')
    multiline_label1 = multiline_label1.upper()
    if multiline_label2 != '':
        multiline_label2 = multiline_label2.replace('| 0 |', '|').replace(' | [I]0 [/I]', '').replace('[I] [/I] | ', '')
        multiline_label2 = multiline_label2.upper()
    return label, multiline_label1, multiline_label2
