import xbmcaddon, xbmcgui
import re
import json
from apis.easynews_api import EasyNewsAPI
from modules.utils import get_release_quality, get_file_info, clean_file_name
from scrapers import build_internal_scrapers_label
from modules import settings
# from modules.utils import logger

__addon_id__ = 'plugin.video.fen'
__addon__ = xbmcaddon.Addon(id=__addon_id__)
window = xbmcgui.Window(10000)
EasyNews = EasyNewsAPI()

class EasyNewsSource:
    def __init__(self):
        self.scrape_provider = 'easynews'
        self.sources = []
        self.max_results = int(__addon__.getSetting('easynews_limit'))
        self.max_gb = __addon__.getSetting('easynews_maxgb')
        self.max_bytes = int(self.max_gb) * 1024 * 1024 * 1024

    def results(self, info):
        try:
            self.info = info
            search_name = self._search_name()
            files = EasyNews.search(search_name)
            files = files[0:self.max_results]
            self._label_settings()
            for item in files:
                try:
                    if self.max_bytes:
                        match = re.search('([\d.]+)\s+(.*)', item['size'])
                        if match:
                            size_bytes = self.to_bytes(*match.groups())
                            if size_bytes > self.max_bytes:
                                continue
                    file_name = item['name']
                    file_dl = item['url_dl']
                    size = float(int(item['rawSize']))/1073741824
                    details = get_file_info(file_name)
                    video_quality = get_release_quality(file_name, file_dl)
                    labels = self._build_label(file_name, details, size, video_quality)
                    label = labels[0]
                    multiline_label = labels[1]
                    self.sources.append({'name': file_name,
                                    'label': label,
                                    'multiline_label': multiline_label,
                                    'quality': video_quality,
                                    'size': size,
                                    'url_dl': file_dl,
                                    'id': file_dl,
                                    'local': False,
                                    'direct': True,
                                    'source': self.scrape_provider,
                                    'scrape_provider': self.scrape_provider})
                except: pass

            window.setProperty('easynews_source_results', json.dumps(self.sources))
        
        except Exception as e:
            from modules.utils import logger
            logger('FEN easynews scraper Exception', e)

        return self.sources

    def _search_name(self):
        search_title = clean_file_name(self.info.get("title"))
        db_type = self.info.get("db_type")
        year = self.info.get("year")
        years = '%s,%s,%s' % (str(int(year - 1)), year, str(int(year + 1)))
        season = self.info.get("season")
        episode = self.info.get("episode")
        if db_type == 'movie': search_name = '"%s" %s' % (search_title, years)
        else: search_name = '%s S%02dE%02d' % (search_title,  int(season), int(episode))
        return search_name

    def to_bytes(self, num, unit):
        unit = unit.upper()
        if unit.endswith('B'): unit = unit[:-1]
        units = ['', 'K', 'M', 'G', 'T', 'P', 'E', 'Z']
        try: mult = pow(1024, units.index(unit))
        except: mult = sys.maxint
        return int(float(num) * mult)

    def _label_settings(self):
        scraper_settings = json.loads(self.info['scraper_settings'])
        self.provider_color = settings.provider_color(self.scrape_provider)
        self.show_extra_info = scraper_settings['extra_info']
        self.show_filenames = scraper_settings['show_filenames']
        self.second_line_color = scraper_settings['multiline_highlight']
        self.highlight_type = scraper_settings['highlight_type']
        if self.highlight_type == '1':
            self.highlight_4K = scraper_settings['highlight_4K']
            self.highlight_1080p = scraper_settings['highlight_1080p']
            self.highlight_720p = scraper_settings['highlight_720p']
            self.highlight_SD = scraper_settings['highlight_SD']
        else:
            # Single Line...
            if self.provider_color == '':
                self.single_leading = ''
                self.single_closing = ''
            else:
                self.single_leading = '[COLOR=%s]' % self.provider_color
                self.single_closing = '[/COLOR]'
            # Multiline...
            if self.provider_color == '':
                self.multi1_leading = ''
                self.multi1_closing = ''
            else:
                self.multi1_leading = '[COLOR=%s]' % self.provider_color
                self.multi1_closing = '[/COLOR]'
            if self.second_line_color == '':
                self.multi2_leading = self.multi1_leading
                self.multi2_closing = self.multi1_closing
            else:
                self.multi2_leading = '[COLOR=%s]' % self.second_line_color
                self.multi2_closing = '[/COLOR]'

    def _build_label(self, file_name, details, size, video_quality):
        label, multiline_label1, multiline_label2 = build_internal_scrapers_label('EASY', self.show_filenames, self.show_extra_info, file_name, details, size, video_quality)
        if self.highlight_type == '1':
            if video_quality.upper() == '4K': leading_color = self.highlight_4K
            elif video_quality.upper()  == '1080P': leading_color = self.highlight_1080p
            elif video_quality.upper() == '720P': leading_color = self.highlight_720p
            else: leading_color = self.highlight_SD
            if self.second_line_color == '': multiline_open = leading_color
            else: multiline_open = self.second_line_color
            label = '[COLOR=%s]' % leading_color + label + '[/COLOR]'
            multiline_label = '[COLOR=%s]' % leading_color + multiline_label1 + '[/COLOR]' + '[COLOR=%s]' % multiline_open + multiline_label2 + '[/COLOR]'
        else:
            label = self.single_leading + label + self.single_closing
            multiline_label = self.multi1_leading + multiline_label1 + self.multi1_closing + self.multi2_leading + multiline_label2 + self.multi2_closing
        return label, multiline_label

