# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin, xbmcaddon
import os
from sys import argv
from datetime import datetime, timedelta
import requests
import re
from modules import dom_parser
from modules import settings
from modules.fen_cache import cache_object
from modules.settings import get_theme
from modules.nav_utils import build_url, setView, paginate_list
from modules.utils import imdb_sort_list, to_utf8, remove_accents, replace_html_codes, string_alphanum_to_num
# from modules.utils import logger

__addon_id__ = 'plugin.video.fen'
__addon__ = xbmcaddon.Addon(id=__addon_id__)
__handle__ = int(argv[1])
addon_dir = xbmc.translatePath(__addon__.getAddonInfo('path'))
icon_directory = get_theme()
default_imdb_icon = os.path.join(icon_directory, 'imdb.png')
fanart = os.path.join(addon_dir, 'fanart.png')

imdb_user = string_alphanum_to_num(__addon__.getSetting('imdb_user'))
base_url = 'http://www.imdb.com/'
watchlist_url = 'user/ur%s/watchlist'
user_list_movies_url = 'list/%s/?view=detail&sort=%s&title_type=movie,short,video,tvShort,tvMovie,tvSpecial&start=1'
user_list_tvshows_url = 'list/%s/?view=detail&sort=%s&title_type=tvSeries,tvMiniSeries&start=1'
lists_link = 'user/ur%s/lists?tab=all&sort=mdfd&order=desc&filter=titles'

def imdb_user_lists(db_type):
    string = "%s_%s_%s" % ('imdb_user_lists', db_type, imdb_user)
    url = base_url + lists_link % imdb_user
    params = {'url': url, 'action': 'imdb_user_lists', 'db_type': db_type}
    return cache_object(get_imdb, string, params, False, 0.5)

def imdb_watchlist(db_type, foo_var, page_no, letter):
    sort = imdb_sort_list()
    string = "%s_%s_%s_%s" % ('imdb_watchlist', db_type, imdb_user, sort)
    url = base_url + watchlist_url % imdb_user
    params = {'url': url, 'action': 'imdb_watchlist', 'db_type': db_type, 'sort': sort}
    original_list =  cache_object(get_imdb, string, params, False, 0.5)
    if settings.paginate():
        limit = settings.page_limit()
        final_list, total_pages = paginate_list(original_list, page_no, letter, limit)
    else: final_list, total_pages = original_list, 1
    return final_list, total_pages

def imdb_user_list_contents(db_type, list_id, page_no, letter):
    sort = imdb_sort_list()
    string = "%s_%s_%s_%s_%s" % ('imdb_user_list_contents', db_type, imdb_user, list_id, sort)
    params = {'url': list_id, 'action': 'imdb_user_list_contents', 'db_type': db_type, 'sort': sort}
    original_list = cache_object(get_imdb, string, params, False, 0.5)
    if settings.paginate():
        limit = settings.page_limit()
        final_list, total_pages = paginate_list(original_list, page_no, letter, limit)
    else: final_list, total_pages = original_list, 1
    return final_list, total_pages

def get_imdb(params):
    imdb_list = []
    action = params['action']
    url = params['url']
    if 'date' in params:
        date_time = (datetime.utcnow() - timedelta(hours = 5))
        for i in re.findall('date\[(\d+)\]', url):
            url = url.replace('date[%s]' % i, (date_time - timedelta(days = int(i))).strftime('%Y-%m-%d'))
    if action in ('imdb_watchlist', 'imdb_user_list_contents'):
        list_url_type = user_list_movies_url if params['db_type'] == 'movies' else user_list_tvshows_url
        if action == 'imdb_watchlist':
            url = dom_parser.parseDOM(to_utf8(remove_accents(requests.get(url).text)), 'meta', ret='content', attrs = {'property': 'pageId'})[0]
        url = base_url + list_url_type % (url, params['sort'])
        result = requests.get(url)
        result = to_utf8(remove_accents(result.text))
        result = result.replace('\n', ' ')
        items = dom_parser.parseDOM(result, 'div', attrs = {'class': '.+? lister-item'})
        items += dom_parser.parseDOM(result, 'div', attrs = {'class': 'lister-item .+?'})
        items += dom_parser.parseDOM(result, 'div', attrs = {'class': 'list_item.+?'})
        for item in to_utf8(items):
            try:
                title = dom_parser.parseDOM(item, 'a')[1]
                year = dom_parser.parseDOM(item, 'span', attrs = {'class': 'lister-item-year.+?'})
                year = re.findall('(\d{4})', year[0])[0]
                imdb_id = dom_parser.parseDOM(item, 'a', ret='href')[0]
                imdb_id = re.findall('(tt\d*)', imdb_id)[0]
                imdb_list.append({'title': str(title), 'year': str(year), 'imdb_id': str(imdb_id)})
            except: pass
    elif action == 'imdb_user_lists':
        result = requests.get(url)
        result = to_utf8(remove_accents(result.text))
        items = dom_parser.parseDOM(result, 'li', attrs = {'class': 'ipl-zebra-list__item user-list'})    
        for item in to_utf8(items):
            try:
                title = dom_parser.parseDOM(item, 'a')[0]
                title = replace_html_codes(title)
                url = dom_parser.parseDOM(item, 'a', ret='href')[0]
                list_id = url.split('/list/', 1)[-1].strip('/')
                imdb_list.append({'title': title, 'list_id': list_id})
            except: pass
    return imdb_list

def imdb_build_user_lists(db_type):
    user_lists = imdb_user_lists(db_type)
    mode = 'build_movie_list' if db_type == 'movies' else 'build_tvshow_list'
    for item in user_lists:
        url_params = {'mode': mode, 'action': 'imdb_user_list_contents', 'list_id': item['list_id']}
        url = build_url(url_params)
        listitem = xbmcgui.ListItem(item['title'])
        listitem.setArt({'icon': default_imdb_icon, 'poster': default_imdb_icon, 'thumb': default_imdb_icon, 'fanart': fanart, 'banner': default_imdb_icon})
        xbmcplugin.addDirectoryItem(__handle__, url, listitem, isFolder=True)
    xbmcplugin.setContent(__handle__, 'files')
    xbmcplugin.endOfDirectory(__handle__)
    setView('view.main')

def clear_imdb_cache(silent=False):
    try:
        import xbmcvfs
        try: from sqlite3 import dbapi2 as database
        except ImportError: from pysqlite2 import dbapi2 as database
        profile_dir = xbmc.translatePath(__addon__.getAddonInfo('profile'))
        if not xbmcvfs.exists(profile_dir): xbmcvfs.mkdirs(profile_dir)
        FEN_DB = os.path.join(profile_dir, "fen_cache.db")
        dbcon = database.connect(FEN_DB)
        dbcur = dbcon.cursor()
        dbcur.execute("DELETE FROM fencache WHERE id LIKE 'imdb_%'")
        dbcon.commit()
        dbcon.close()
        return True
    except: return False

# def imdb_movies_new(page_no):
#     string = "%s_%s" % ('imdb_movies_new', page_no)
#     start = get_start(page_no)
#     url = base_url % 'feature,tv_movie&num_votes=1000,&production_status=released&release_date=date[365],date[90]&sort=moviemeter,asc&count=20&start=%s&ref_=adv_nxt' % start
#     return cache_object(get_imdb, string, url, False)

# def imdb_movies_languages(lang, page_no):
#     string = "%s_%s_%s" % ('imdb_movies_languages', lang, page_no)
#     start = get_start(page_no)
#     url = base_url % 'feature,tv_movie&num_votes=100,&production_status=released&primary_language=%s&sort=moviemeter,asc&count=20&start=%s&ref_=adv_nxt' % (lang, start)
#     return cache_object(get_imdb, string, url, False)

# def imdb_movies_oscar_winners(page_no):
#     string = "%s_%s" % ('imdb_movies_oscar_winners', page_no)
#     start = get_start(page_no)
#     url = base_url + 'search/title?title_type=feature,tv_movie&production_status=released&groups=oscar_best_picture_winners&sort=year,desc&count=20&start=%s&ref_=adv_nxt' % start
#     return cache_object(get_imdb, string, url, False)

# def imdb_tv_new(page_no):
#     string = "%s_%s" % ('imdb_tv_new', page_no)
#     start = get_start(page_no)
#     url = base_url % 'tv_series,mini_series&languages=en&num_votes=100,&release_date=date[60],date[0]&sort=release_date,desc&count=20&start=%s&ref_=adv_nxt' % start
#     return cache_object(get_imdb, string, url, False)

# def imdb_tv_languages(lang, page_no):
#     string = "%s_%s_%s" % ('imdb_tv_languages', lang, page_no)
#     start = get_start(page_no)
#     url = base_url % 'tv_series,mini_series&num_votes=100,&production_status=released&primary_language=%s&sort=moviemeter,asc&count=20&start=%s&ref_=adv_nxt' % (lang, start)
#     return cache_object(get_imdb, string, url, False)

# def get_start(page_no):
#     return (str(((int(page_no)-1)*20)+1) if page_no > 1 else '1')





