
class DefaultMenus:
    
    def RootList(self):
        return [
            {
                "iconImage": "movies.png", 
                "mode": "navigator.main",
                "action": "MovieList",
                "name": "Movies", 
                "foldername": "Movies"
            }, 
            {
                "iconImage": "tv.png", 
                "mode": "navigator.main",
                "action": "TVShowList",
                "name": "TV Shows", 
                "foldername": "TV Shows"
            }, 
            {
                "iconImage": "search.png", 
                "mode": "navigator.search", 
                "name": "Search", 
                "foldername": "Search"
            }, 
            {
                "iconImage": "discover.png", 
                "mode": "navigator.discover_main", 
                "name": "Discover", 
                "foldername": "Discover"
            }, 
            {
                "name": "Popular People", 
                "iconImage": "genre_comedy.png", 
                "foldername": "Popular People", 
                "mode": "build_popular_people"
            }, 
            {
                "iconImage": "favourites.png", 
                "mode": "navigator.favourites", 
                "name": "Favourites", 
                "foldername": "Favourites"
            }, 
            {
                "iconImage": "library.png", 
                "mode": "navigator.subscriptions", 
                "name": "Subscriptions", 
                "foldername": "Subscriptions Root"
            }, 
            {
                "iconImage": "library_kodi.png", 
                "mode": "navigator.kodi_library", 
                "name": "Kodi Library", 
                "foldername": "Kodi Library Root"
            }, 
            {
                "iconImage": "downloads.png", 
                "mode": "navigator.downloads", 
                "name": "Downloads", 
                "foldername": "Fen Downloads"
            }, 
            {
                "iconImage": "lists.png", 
                "mode": "navigator.my_content", 
                "name": "My Lists", 
                "foldername": "My Lists"
            }, 
            {
                "iconImage": "premium.png", 
                "mode": "navigator.premium", 
                "name": "My Services", 
                "foldername": "My Services"
            }, 
            {
                "iconImage": "settings2.png", 
                "mode": "navigator.tools", 
                "name": "Tools", 
                "foldername": "Tools"
            }, 
            {
                "iconImage": "settings.png", 
                "mode": "navigator.settings", 
                "name": "Settings", 
                "foldername": "Settings"
            }
        ]

    def MovieList(self):
        return [
            {
                "name": "Trending", 
                "iconImage": "trending.png", 
                "foldername": "Trending", 
                "mode": "build_movie_list", 
                "action": "trakt_movies_trending"
            }, 
            {
                "name": "Popular", 
                "iconImage": "popular.png", 
                "foldername": "Popular", 
                "mode": "build_movie_list", 
                "action": "tmdb_movies_popular"
            }, 
            {
                "action": "tmdb_movies_premieres", 
                "iconImage": "fresh.png", 
                "mode": "build_movie_list", 
                "name": "Premieres", 
                "foldername": "Movies Premiering"
            }, 
            {
                "name": "Latest Releases", 
                "iconImage": "dvd.png", 
                "foldername": "Latest Releases", 
                "mode": "build_movie_list", 
                "action": "tmdb_movies_latest_releases"
            }, 
            {
                "action": "trakt_movies_top10_boxoffice", 
                "iconImage": "box_office.png", 
                "mode": "build_movie_list", 
                "name": "Top 10 Box Office", 
                "foldername": "Movies Top 10 Box Office"
            }, 
            {
                "name": "Blockbusters", 
                "iconImage": "most_voted.png", 
                "foldername": "Blockbusters", 
                "mode": "build_movie_list", 
                "action": "tmdb_movies_blockbusters"
            }, 
            {
                "name": "In Theaters", 
                "iconImage": "intheatres.png", 
                "foldername": "In Theaters", 
                "mode": "build_movie_list", 
                "action": "tmdb_movies_in_theaters"
            }, 
            {
                "name": "Top Rated", 
                "iconImage": "top_rated.png", 
                "foldername": "Top Rated", 
                "mode": "build_movie_list", 
                "action": "tmdb_movies_top_rated"
            }, 
            {
                "name": "Up Coming", 
                "iconImage": "lists.png", 
                "foldername": "Up Coming", 
                "mode": "build_movie_list", 
                "action": "tmdb_movies_upcoming"
            }, 
            {
                "name": "Anticipated", 
                "iconImage": "most_anticipated.png", 
                "foldername": "Anticipated", 
                "mode": "build_movie_list", 
                "action": "trakt_movies_anticipated"
            }, 
            {
                "name": "Oscar Winners", 
                "iconImage": "oscar-winners.png", 
                "foldername": "Oscar Winners", 
                "mode": "build_movie_list", 
                "action": "imdb_movies_oscar_winners"
            }, 
            {
                "name": "Mosts", 
                "menu_type": "movie", 
                "iconImage": "trakt.png", 
                "foldername": "Mosts", 
                "mode": "navigator.trakt_mosts"
            }, 
            {
                "name": "Genres", 
                "menu_type": "movie", 
                "iconImage": "genres.png", 
                "foldername": "Genres", 
                "mode": "navigator.genres"
            }, 
            {
                "name": "Languages", 
                "menu_type": "movie", 
                "iconImage": "languages.png", 
                "foldername": "Movie Languages", 
                "mode": "navigator.languages"
            }, 
            {
                "name": "Years", 
                "menu_type": "movie", 
                "iconImage": "calender.png", 
                "foldername": "Movie Years", 
                "mode": "navigator.years"
            }, 
            {
                "name": "Certifications", 
                "menu_type": "movie", 
                "iconImage": "certifications.png", 
                "foldername": "Certifications", 
                "mode": "navigator.certifications"
            }, 
            {
                "name": "Because You Watched...", 
                "iconImage": "because_you_watched.png", 
                "foldername": "Because You Watched", 
                "mode": "navigator.because_you_watched", 
                "menu_type": "movie"
            }, 
            {
                "foldername": "Watched", 
                "iconImage": "watched_1.png", 
                "mode": "build_movie_list",  
                "action": "watched_movies", 
                "name": "Watched"
            }, 
            {
                "foldername": "In Progress", 
                "iconImage": "player.png", 
                "mode": "build_movie_list",  
                "action": "in_progress_movies", 
                "name": "In Progress"
            }, 
            {
                "name": "Search", 
                "iconImage": "search.png", 
                "foldername": "Movie Search", 
                "mode": "build_movie_list", 
                "action": "tmdb_movies_search", 
                "query": "NA"
            }
        ]
    
    def TVShowList(self):
        return [
            {
                "action": "trakt_tv_trending", 
                "iconImage": "trending.png", 
                "mode": "build_tvshow_list", 
                "name": "Trending", 
                "foldername": "TV Trending"
            }, 
            {
                "action": "tmdb_tv_popular", 
                "iconImage": "popular.png", 
                "mode": "build_tvshow_list", 
                "name": "Popular", 
                "foldername": "TV Popular"
            }, 
            {
                "action": "tmdb_tv_premieres", 
                "iconImage": "fresh.png", 
                "mode": "build_tvshow_list", 
                "name": "Premieres", 
                "foldername": "TV Premiering"
            }, 
            {
                "action": "tmdb_tv_top_rated", 
                "iconImage": "top_rated.png", 
                "mode": "build_tvshow_list", 
                "name": "Top Rated", 
                "foldername": "TV Top Rated"
            }, 
            {
                "action": "tmdb_tv_airing_today", 
                "iconImage": "live.png", 
                "mode": "build_tvshow_list", 
                "name": "Airing Today"
            }, 
            {
                "action": "tmdb_tv_on_the_air", 
                "iconImage": "ontheair.png", 
                "mode": "build_tvshow_list", 
                "name": "On the Air", 
                "foldername": "TV On the Air"
            }, 
            {
                "name": "Up Coming", 
                "iconImage": "lists.png", 
                "foldername": "Up Coming", 
                "mode": "build_tvshow_list", 
                "action": "tmdb_tv_upcoming"
            }, 
            {
                "action": "trakt_tv_anticipated", 
                "iconImage": "most_anticipated.png", 
                "mode": "build_tvshow_list", 
                "name": "Anticipated"
            }, 
            {
                "menu_type": "tvshow", 
                "iconImage": "trakt.png", 
                "mode": "navigator.trakt_mosts", 
                "name": "Mosts", 
                "foldername": "TV Trakt Mosts"
            }, 
            {
                "menu_type": "tvshow", 
                "iconImage": "genres.png", 
                "mode": "navigator.genres", 
                "name": "Genres", 
                "foldername": "TV Genres"
            }, 
            {
                "menu_type": "tvshow", 
                "iconImage": "networks.png", 
                "mode": "navigator.networks", 
                "name": "Networks", 
                "foldername": "TV Networks"
            }, 
            {
                "menu_type": "tvshow", 
                "iconImage": "languages.png", 
                "mode": "navigator.languages", 
                "name": "Languages", 
                "foldername": "TV Show Languages"
            }, 
            {
                "name": "Years", 
                "menu_type": "tvshow", 
                "iconImage": "calender.png", 
                "foldername": "TV Show Years", 
                "mode": "navigator.years"
            }, 
            {
                "menu_type": "tvshow", 
                "iconImage": "certifications.png", 
                "mode": "navigator.certifications", 
                "name": "Certifications", 
                "foldername": "TV Show Certifications"
            }, 
            {
                "name": "Because You Watched...", 
                "iconImage": "because_you_watched.png", 
                "foldername": "Because You Watched", 
                "mode": "navigator.because_you_watched", 
                "menu_type": "tvshow"
            }, 
            {
                "foldername": "Watched", 
                "iconImage": "watched_1.png", 
                "mode": "build_tvshow_list",  
                "action": "watched_tvshows", 
                "name": "Watched"
            }, 
            {
                "action": "in_progress_tvshows", 
                "iconImage": "in_progress_tvshow.png", 
                "mode": "build_tvshow_list", 
                "name": "In Progress TV Shows", 
                "foldername": "In Progress TV Shows"
            }, 
            {
                "iconImage": "player.png", 
                "mode": "build_in_progress_episode", 
                "name": "In Progress Episodes", 
                "foldername": "In Progress Episodes"
            }, 
            {
                "iconImage": "next_episodes.png", 
                "mode": "build_next_episode", 
                "name": "Next Episodes", 
                "foldername": "It Next Episodes"
            }, 
            {
                "name": "Search", 
                "iconImage": "search.png", 
                "foldername": "TV Show Search", 
                "mode": "build_tvshow_list", 
                "action": "tmdb_tv_search", 
                "query": "NA"
            }
        ]

    def DefaultMenuItems(self):
        return ['RootList', 'MovieList', 'TVShowList']






