# -*- coding: utf-8 -*-
import xbmc, xbmcaddon
from sys import argv
try: from urlparse import parse_qsl
except ImportError: from urllib.parse import parse_qsl
from modules.utils import selection_dialog, multiselect_dialog
# from modules.utils import logger

__addon__ = xbmcaddon.Addon(id='plugin.video.fen')

def similar_recommendations_choice():
    import json
    from modules.nav_utils import build_url
    from modules.utils import selection_dialog
    import tikimeta
    params = dict(parse_qsl(argv[2].replace('?','')))
    db_type = params.get('db_type')
    meta_type = 'movie' if db_type  =='movies' else 'tvshow'
    try: meta_user_info = json.loads(params.get('meta_user_info'))
    except: meta_user_info = tikimeta.retrieve_user_info()
    dl = ['Similar', 'Recommended']
    fl = ['trakt_%s_related' % db_type, 'tmdb_%s_recommendations' % db_type]
    string = 'Please Choose Movie Search Option:' if db_type == 'movies' else 'Please Choose TV Show Search Option:'
    mode = 'build_%s_list' % meta_type
    choice = selection_dialog(dl, fl, string)
    if not choice: return
    try:
        sim_recom_params = {'mode': mode, 'action': choice, 'sim_recom_tmdb': params.get('sim_recom_tmdb'), 'sim_recom_imdb': params.get('sim_recom_imdb'), 'sim_recom_name': params.get('sim_recom_name'), 'from_search': params.get('from_search')}
        xbmc.executebuiltin('Container.Update(%s)' % build_url(sim_recom_params))
    except: return

def movie_reviews(tmdb_id, rootname, poster):
    from apis.tmdb_api import tmdb_movies_reviews
    reviews_info = tmdb_movies_reviews(tmdb_id)
    total_results = reviews_info['total_results']
    if total_results == 0:
        from modules.nav_utils import notification
        return notification('No Reviews Found for Movie', 3500)
    import xbmcgui
    dialog = xbmcgui.Dialog()
    review_list = []
    all_reviews = reviews_info['results']
    for item in all_reviews:
        line1 = 'Review by: [B]%s[/B]' % item['author']
        line2 = '[I]%s...[/I]' % item['content'][:60]
        icon = poster
        listitem = xbmcgui.ListItem(line1, line2)
        listitem.setArt({'icon': icon})
        listitem.setProperty('review_id', str(item['id']))
        listitem.setProperty('reviewer_name', item['author'])
        listitem.setProperty('review_content', item['content'])
        review_list.append(listitem)
    selection = dialog.select('FEN - Choose Review...', review_list, useDetails=True)
    if selection >= 0:
        review_id = review_list[selection].getProperty('review_id')
        reviewer_name = review_list[selection].getProperty('reviewer_name')
        review_content = review_list[selection].getProperty('review_content')
    else: return
    heading = '%s Review by [B]%s[/B]' % (rootname, reviewer_name)
    dialog.textviewer(heading, review_content)
    if total_results > 1: return movie_reviews(tmdb_id, rootname, poster)

def set_quality(quality_setting=None):
    params = dict(parse_qsl(argv[2].replace('?','')))
    quality_setting = quality_setting if quality_setting else params['quality_setting']
    string = 'Please Choose Autoplay Filters' if quality_setting == 'autoplay' else 'Please Choose Result Filters:'
    setting = 'autoplay_quality' if quality_setting == 'autoplay' else 'results_quality'
    dl = ['Include SD', 'Include 720p', 'Include 1080p', 'Include 4K']
    fl = ['SD', '720p', '1080p', '4K']
    try: preselect = [fl.index(i) for i in __addon__.getSetting(setting).split(', ')]
    except: preselect = []
    filters = multiselect_dialog(string, dl, fl, preselect)
    if filters is None: return
    if filters == []:
        import xbmcgui
        xbmcgui.Dialog().ok('FEN Filters', 'You must select at least 1 Filter Setting.', '', 'Please Retry.....')
        return set_quality(quality_setting)
    from modules.nav_utils import toggle_setting
    toggle_setting(setting, ', '.join(filters))

def enable_scrapers():
    from modules.settings import active_scrapers
    from modules.nav_utils import toggle_setting
    scrapers = ['external', 'furk', 'easynews', 'rd-cloud', 'pm-cloud', 'ad-cloud', 'local', 'downloads', 'folders']
    preselect = [scrapers.index(i) for i in active_scrapers(group_folders=True)]
    scrapers_dialog = [i.upper() for i in scrapers]
    scraper_choice = multiselect_dialog('Choose Fen Scrapers', scrapers_dialog, scrapers, preselect=preselect)
    if scraper_choice is None: return
    return [toggle_setting('provider.%s' % i, ('true' if i in scraper_choice else 'false')) for i in scrapers]

def set_active_cloud_store(current_active):
    debrid_clouds = [('real-debrid', 'RD', 'Real Debrid'), ('premiumize.me', 'PM', 'Premiumize'), ('alldebrid', 'AD', 'All Debrid')]
    dialog_list = [i[2] for i in debrid_clouds]
    function_list = [i[0] for i in debrid_clouds]
    preselect = [debrid_clouds.index(i) for i in current_active]
    store_torrents_choice = multiselect_dialog('Choose Debrid Clouds to Store Resolved Torrents', dialog_list, function_list, preselect=preselect)
    if store_torrents_choice is None: return
    for i in function_list:
        if i in store_torrents_choice: __addon__.setSetting('store_torrent.%s' % i, 'true')
        else: __addon__.setSetting('store_torrent.%s' % i, 'false')

def set_subtitle_action():
    from modules.nav_utils import toggle_setting
    choices = ('Auto', 'Select', 'Off')
    choice = selection_dialog(choices, choices, 'Fen - Choose Subtitles Action')
    if choice: return toggle_setting('subtitles.subs_action', choice)

def set_display_mode():
    from modules.nav_utils import toggle_setting
    names = ('Directory', 'Very Simple Directory', 'Dialog')
    settings = ('0', '1', '2')
    choice = selection_dialog(names, settings, 'Fen - Choose Display Mode')
    if choice: return toggle_setting('display_mode', choice)

def results_sorting_choice():
    from modules.nav_utils import toggle_setting
    settings = [('Quality, Provider, Size', '0'), ('Quality, Size, Provider','1'), ('Provider, Quality, Size', '2'),
                ('Provider, Size, Quality', '3'), ('Size, Quality, Provider', '4'), ('Size, Provider, Quality', '5')]
    choice = selection_dialog([i[0] for i in settings], settings, 'Fen - Choose Results Sorting')
    if choice:
        toggle_setting('results.sort_order_display', choice[0])
        toggle_setting('results.sort_order', choice[1])

def subscriptions_update_interval():
    from modules.nav_utils import toggle_setting
    import time
    from datetime import datetime, timedelta
    from modules.nav_utils import open_settings
    params = dict(parse_qsl(argv[2].replace('?','')))
    subscription_timer = __addon__.getSetting('subscription_timer')
    if params['update_type'] == 'interval':
        subscriptions_update_label = 'subscriptions_update_label1'
        intervals = [('1 Hour', 1), ('2 Hours', 2), ('4 Hours', 4), ('8 Hours', 8), ('12 Hours', 12), ('16 Hours', 16), ('24 Hours', 24)]
        try: last_run_time = datetime.strptime(__addon__.getSetting('service_time'), "%Y-%m-%d %H:%M:%S") - timedelta(hours=int(subscription_timer))
        except TypeError: last_run_time = datetime(*(time.strptime(__addon__.getSetting('service_time'), "%Y-%m-%d %H:%M:%S")[0:6])) - timedelta(hours=int(subscription_timer))
        choice = selection_dialog([i[0] for i in intervals], intervals, 'Fen - Choose Subscription Update Interval')
        if not choice: choice = ('24 Hours', 24)
        interval = str(choice[1])
        interval_display = choice[0]
        new_run_time = last_run_time + timedelta(hours=int(interval))
        new_run_time = new_run_time.strftime("%Y-%m-%d %H:%M:%S")
    else:
        subscriptions_update_label = 'subscriptions_update_label2'
        intervals = []
        for i in range(24): intervals.append(('%02d:00' % i, i))
        choice = selection_dialog([i[0] for i in intervals], intervals, 'Fen - Choose Daily Subscription Update Time')
        if not choice: choice = ('06:00', 6)
        sub_hour = choice[1]
        interval_display = choice[0]
        interval = subscription_timer
        now = datetime.today()
        sub_day = now.day + 1 if sub_hour == 0 else now.day
        new_run_time = now.replace(day=sub_day, hour=sub_hour, minute=0, second=0, microsecond=0) + timedelta(days=1)
        difference = new_run_time - now
        if '1 day' in str(difference): new_run_time = now.replace(day=sub_day, hour=sub_hour, minute=0, second=0, microsecond=0)
        new_run_time = new_run_time.strftime("%Y-%m-%d %H:%M:%S")
    toggle_setting('subscription_timer', interval)
    toggle_setting(subscriptions_update_label, interval_display)
    toggle_setting('service_time', new_run_time)

def unaired_episode_color_choice():
    from modules.nav_utils import toggle_setting
    dialog = 'Please Choose Color for Unaired Episodes'
    chosen_color = color_chooser(dialog, no_color=True)
    if chosen_color: toggle_setting('unaired_episode_colour', chosen_color)

def scraper_dialog_color_choice():
    from modules.nav_utils import toggle_setting
    params = dict(parse_qsl(argv[2].replace('?','')))
    setting ='int_dialog_highlight' if params['setting'] == 'internal' else 'ext_dialog_highlight'
    dialog = 'Please Choose Color for Internal Scrapers Progress Dialog Highlight'
    chosen_color = color_chooser(dialog)
    if chosen_color: toggle_setting(setting, chosen_color)

def next_episode_color_choice(setting=None):
    from modules.nav_utils import open_settings
    params = dict(parse_qsl(argv[2].replace('?','')))
    choices = [('Airdate', 'nextep.airdate_colour'),
                ('Unaired', 'nextep.unaired_colour'),
                ('Unwatched', 'nextep.unwatched_colour')]
    prelim_setting = params.get('setting', None) if not setting else setting
    title, setting = [(i[0], i[1]) for i in choices if i[0] == prelim_setting][0]
    dialog = 'Please Choose Color for %s Highlight' % title
    chosen_color = color_chooser(dialog, no_color=True)
    if chosen_color: __addon__.setSetting(setting, chosen_color)

def next_episode_options_choice(setting=None):
    from modules.nav_utils import notification
    from modules.utils import selection_dialog
    params = dict(parse_qsl(argv[2].replace('?','')))
    choices = [
            ('Sort Type', 'nextep.sort_type', [('RECENTLY WATCHED', '0'), ('AIRDATE', '1'), ('TITLE', '2')]),
            ('Sort Order', 'nextep.sort_order', [('DESCENDING', '0'), ('ASCENDING', '1')]),
            ('Include Unaired', 'nextep.include_unaired', [('OFF', 'false'), ('ON', 'true')]),
            ('Include Trakt or Fen Unwatched', 'nextep.include_unwatched', [('OFF', 'false'), ('ON', 'true')]),
            ('Cache To Disk', 'nextep.cache_to_disk', [('OFF', 'false'), ('ON', 'true')]),
            ('Include Airdate in Title', 'nextep.include_airdate', [('OFF', 'false'), ('ON', 'true')]),
            ('Airdate Format', 'nextep.airdate_format', [('DAY-MONTH-YEAR', '0'), ('YEAR-MONTH-DAY', '1'), ('MONTH-DAY-YEAR', '2')])
                ]
    prelim_setting = params.get('setting') if not setting else setting
    title, setting = [(i[0], i[1]) for i in choices if i[0] == prelim_setting][0]
    string = 'Please Choose Setting for %s' % title
    full_list = [i[2] for i in choices if i[0] == prelim_setting][0]
    dialog_list = [i[0] for i in full_list]
    function_list = [i[1] for i in full_list]
    selection = selection_dialog(dialog_list, function_list, string)
    if not selection: return
    setting_name = [i[0] for i in full_list if i[1] == selection][0]
    __addon__.setSetting(setting, selection)
    notification('%s set to %s' % (title, setting_name), 6000)

def next_episode_context_choice():
    from modules.utils import selection_dialog
    from modules.nav_utils import toggle_setting, build_url
    from modules import settings
    params = dict(parse_qsl(argv[2].replace('?','')))
    content_settings = settings.nextep_content_settings()
    display_settings = settings.nextep_display_settings()
    airdate_replacement = [('%d-%m-%Y', 'Day-Month-Year'), ('%Y-%m-%d', 'Year-Month-Day'), ('%m-%d-%Y', 'Month-Day-Year')]
    sort_type_status = ('Recently Watched', 'Airdate', 'Title')[content_settings['sort_type']]
    sort_order_status = ('Descending', 'Ascending')[content_settings['sort_order']]
    toggle_sort_order_SETTING = ('nextep.sort_order', ('0' if sort_order_status == 'Ascending' else '1'))
    cache_to_disk_status = str(content_settings['cache_to_disk'])
    toggle_cache_to_disk_SETTING = ('nextep.cache_to_disk', ('true' if cache_to_disk_status == 'False' else 'false'))
    unaired_status = str(content_settings['include_unaired'])
    toggle_unaired_SETTING = ('nextep.include_unaired', ('true' if unaired_status == 'False' else 'false'))
    unwatched_status = str(content_settings['include_unwatched'])
    toggle_unwatched_SETTING = ('nextep.include_unwatched', ('true' if unwatched_status == 'False' else 'false'))
    airdate_status = str(display_settings['include_airdate'])
    toggle_airdate_SETTING = ('nextep.include_airdate', ('true' if airdate_status == 'False' else 'false'))
    airdate_format = settings.nextep_airdate_format()
    airdate_format_status = [airdate_format.replace(i[0], i[1]) for i in airdate_replacement if i[0] == airdate_format][0]
    airdate_highlight = display_settings['airdate_colour'].capitalize()
    unaired_highlight = display_settings['unaired_colour'].capitalize()
    unwatched_highlight = display_settings['unwatched_colour'].capitalize()
    choices = [
            ('MANAGE IN PROGRESS SHOWS', 'manage_in_progress'),
            ('SORT TYPE: [I]Currently [B]%s[/B][/I]' % sort_type_status, 'Sort Type'),
            ('SORT ORDER: [I]Currently [B]%s[/B][/I]' % sort_order_status, 'toggle_sort_order'),
            ('CACHE TO DISK: [I]Currently [B]%s[/B][/I]' % cache_to_disk_status, 'toggle_cache_to_disk'),
            ('INCLUDE UNAIRED EPISODES: [I]Currently [B]%s[/B][/I]' % unaired_status, 'toggle_unaired'),
            ('INCLUDE WATCHLIST/UNWATCHED TV: [I]Currently [B]%s[/B][/I]' % unwatched_status, 'toggle_unwatched'),
            ('INCLUDE AIRDATE: [I]Currently [B]%s[/B][/I]' % airdate_status, 'toggle_airdate'),
            ('AIRDATE FORMAT: [I]Currently [B]%s[/B][/I]' % airdate_format_status, 'Airdate Format'),
            ('AIRDATE HIGHLIGHT: [I]Currently [B]%s[/B][/I]' % airdate_highlight, 'Airdate'),
            ('UNAIRED HIGHLIGHT: [I]Currently [B]%s[/B][/I]' % unaired_highlight, 'Unaired'),
            ('UNWATCHED HIGHLIGHT: [I]Currently [B]%s[/B][/I]' % unwatched_highlight, 'Unwatched')]
    if settings.watched_indicators() == 0: choices.append(('MANAGE UNWATCHED TV SHOWS', 'manage_unwatched'))
    if settings.watched_indicators() in (1,2): choices.append(('CLEAR TRAKT CACHE', 'clear_cache'))
    string = 'Next Episode Manager'
    dialog_list = [i[0] for i in choices]
    function_list = [i[1] for i in choices]
    choice = selection_dialog(dialog_list, function_list, string)
    if not choice: return
    if choice in ('toggle_sort_order', 'toggle_cache_to_disk', 'toggle_unaired', 'toggle_unwatched', 'toggle_airdate'):
        setting = eval(choice + '_SETTING')
        toggle_setting(setting[0], setting[1])
    elif choice == 'clear_cache':
        from modules.nav_utils import clear_cache
        clear_cache('trakt')
    else:
        if choice in ('manage_in_progress', 'manage_unwatched'):
            xbmc.executebuiltin('Container.Update(%s)' % build_url({'mode': 'build_next_episode_manager', 'action': choice})); return
        elif choice in ('Airdate','Unaired', 'Unwatched'): function = next_episode_color_choice
        else: function = next_episode_options_choice
        function(choice)
    xbmc.executebuiltin("Container.Refresh")
    xbmc.executebuiltin('RunPlugin(%s)' % build_url({'mode': 'next_episode_context_choice'}))

def scraper_quality_color_choice():
    from modules.nav_utils import toggle_setting
    params = dict(parse_qsl(argv[2].replace('?','')))
    setting = params['setting']
    dialog = 'Please Choose Color for Scraper Quality Highlight'
    chosen_color = color_chooser(dialog)
    if chosen_color: toggle_setting(setting, chosen_color)

def external_scrapers_manager():
    import xbmcgui
    import json
    from modules.nav_utils import build_url
    dialog = xbmcgui.Dialog()
    icon = xbmcaddon.Addon(id='script.module.openscrapers').getAddonInfo('icon')
    fail_color = 'crimson'
    all_color = 'mediumvioletred'
    debrid_color = __addon__.getSetting('prem.identify')
    torrent_color = __addon__.getSetting('torrent.identify')
    tools_menu = \
        [('[COLOR %s][B]FAILURES[/B][/COLOR]', fail_color, '[B]- Disable Failing External Scrapers[/B]', {'mode': 'external_scrapers_disable'}),
        ('[COLOR %s][B]FAILURES[/B][/COLOR]', fail_color, '[B]- Reset Failing External Scraper Stats[/B]', {'mode': 'external_scrapers_reset_stats'}),
        ('[COLOR %s][B]ALL SCRAPERS[/B][/COLOR]', all_color , '[B]- Enable All Scrapers[/B]', {'mode': 'toggle_all', 'folder': 'all_eng', 'setting': 'true'}),
        ('[COLOR %s][B]ALL SCRAPERS[/B][/COLOR]', all_color , '[B]- Disable All Scrapers[/B]', {'mode': 'toggle_all', 'folder': 'all_eng', 'setting': 'false'}),
        ('[COLOR %s][B]ALL SCRAPERS[/B][/COLOR]', all_color , '[B]- Enable/Disable Specific Scrapers[/B]',{'mode': 'enable_disable_specific_all', 'folder': 'all_eng'}),
        ('[COLOR %s][B]DEBRID SCRAPERS[/B][/COLOR]', debrid_color , '[B]- Enable All Debrid Scrapers[/B]', {'mode': 'toggle_all', 'folder': 'en_DebridOnly', 'setting': 'true'}),
        ('[COLOR %s][B]DEBRID SCRAPERS[/B][/COLOR]', debrid_color , '[B]- Disable All Debrid Scrapers[/B]', {'mode': 'toggle_all', 'folder': 'en_DebridOnly', 'setting': 'false'}),
        ('[COLOR %s][B]DEBRID SCRAPERS[/B][/COLOR]', debrid_color , '[B]- Enable/Disable Specific Debrid Scrapers[/B]', {'mode': 'enable_disable_specific_all', 'folder': 'en_DebridOnly'}),
        ('[COLOR %s][B]TORRENT SCRAPERS[/B][/COLOR]', torrent_color , '[B]- Enable All Torrent Scrapers[/B]', {'mode': 'toggle_all', 'folder': 'en_Torrent', 'setting': 'true'}),
        ('[COLOR %s][B]TORRENT SCRAPERS[/B][/COLOR]', torrent_color , '[B]- Disable All Torrent Scrapers[/B]', {'mode': 'toggle_all', 'folder': 'en_Torrent', 'setting': 'false'}),
        ('[COLOR %s][B]TORRENT SCRAPERS[/B][/COLOR]', torrent_color , '[B]- Enable/Disable Specific Torrent Scrapers[/B]', {'mode': 'enable_disable_specific_all', 'folder': 'en_Torrent'})]
    choice_list = []
    for item in tools_menu:
        line1 = item[0] % item[1]
        line2 = item[2]
        listitem = xbmcgui.ListItem(line1, line2)
        listitem.setArt({'icon': icon})
        choice_list.append(listitem)
    chosen_tool = dialog.select("External Scrapers Manager", choice_list, useDetails=True)
    if chosen_tool < 0: return
    from modules import external_source_utils
    params = tools_menu[chosen_tool][3]
    mode = params['mode']
    if mode == 'external_scrapers_disable':
        external_source_utils.external_scrapers_disable()
    elif mode == 'external_scrapers_reset_stats':
        external_source_utils.external_scrapers_reset_stats()
    elif mode == 'toggle_all':
        external_source_utils.toggle_all(params['folder'], params['setting'])
    elif mode == 'enable_disable_specific_all':
        external_source_utils.enable_disable_specific_all(params['folder'])
    return external_scrapers_manager()

def switch_settings():
    from modules.nav_utils import toggle_setting, settings_layout
    choices = ('Basic', 'Advanced (Multiple Submenus)')
    choice = selection_dialog(choices, choices, 'Fen - Choose Settings Layout')
    if choice:
        toggle_setting('settings_layout', choice)
        settings_layout(choice)

def scraper_color_choice():
    from modules.nav_utils import toggle_setting
    params = dict(parse_qsl(argv[2].replace('?','')))
    choices = [('furk', 'provider.furk_colour'),
                ('easynews', 'provider.easynews_colour'),
                ('pm-cloud', 'provider.pm-cloud_colour'),
                ('rd-cloud', 'provider.rd-cloud_colour'),
                ('ad-cloud', 'provider.ad-cloud_colour'),
                ('local', 'provider.local_colour'),
                ('downloads', 'provider.downloads_colour'),
                ('folders', 'provider.folders_colour'),
                ('premium', 'prem.identify'),
                ('torrent', 'torrent.identify'),
                ('second_line', 'secondline.identify')]
    title, setting = [(i[0], i[1]) for i in choices if i[0] == params.get('setting')][0]
    dialog = 'Please Choose Color for %s Results Highlight' % title.upper()
    chosen_color = color_chooser(dialog, no_color=True)
    if chosen_color: toggle_setting(setting, chosen_color)

def folder_sources_choice():
    import xbmcgui
    from modules.nav_utils import toggle_setting
    params = dict(parse_qsl(argv[2].replace('?','')))
    setting = params['setting']
    folder = xbmcgui.Dialog().browse(0, 'FEN - Select Directory...', '')
    if not folder: folder = 'None'
    __addon__.setSetting(setting, folder)

def internal_scrapers_order_choice():
    import xbmcgui
    from modules.nav_utils import toggle_setting
    window = xbmcgui.Window(10000)
    try: current_ordering = window.getProperty('FEN_internal_scrapers_order').split(', ')
    except: current_ordering = ['']
    if len(current_ordering) != 4:
        from modules.settings import internal_scraper_order
        current_ordering = internal_scraper_order()
    default = [('FILES', current_ordering.index("FILES")),
               ('FURK', current_ordering.index("FURK")),
               ('EASYNEWS', current_ordering.index("EASYNEWS")),
               ('CLOUD', current_ordering.index("CLOUD"))]
    choices = sorted(default, key=lambda x: x[1])
    adjust_scraper = selection_dialog([i[0] for i in choices], [i[0] for i in choices], 'Fen - Choose Scraper to Change Order')
    if not adjust_scraper: return window.clearProperty('FEN_internal_scrapers_order')
    choices = [('Place [B]%s[/B] 1st' % adjust_scraper, (0, current_ordering.index(adjust_scraper))),
               ('Place [B]%s[/B] 2nd' % adjust_scraper, (1, current_ordering.index(adjust_scraper))),
               ('Place [B]%s[/B] 3rd' % adjust_scraper, (2, current_ordering.index(adjust_scraper))),
               ('Place [B]%s[/B] 4th' % adjust_scraper, (3, current_ordering.index(adjust_scraper)))]
    positioning_info = selection_dialog([i[0] for i in choices], [i[1] for i in choices], 'Fen - Choose %s Scraper Position' % adjust_scraper)
    if not positioning_info: return internal_scrapers_order_choice()
    new_position = positioning_info[0]
    current_position = positioning_info[1]
    current_ordering.insert(new_position, current_ordering.pop(current_position))
    new_order_setting = (', ').join(current_ordering)
    window.setProperty('FEN_internal_scrapers_order', new_order_setting)
    toggle_setting('internal_scrapers_order', new_order_setting)
    return internal_scrapers_order_choice()

def build_add_to_remove_from_list(meta='', media_type='', orig_mode='', from_search=''):
    import json
    from modules.settings import trakt_list_subscriptions, watched_indicators
    from modules.nav_utils import build_url
    params = dict(parse_qsl(argv[2].replace('?','')))
    media_type = params.get('media_type', '')
    orig_mode = params.get('orig_mode', '')
    from_search = params.get('from_search', '')
    meta = json.loads(params.get('meta', None))
    main_listing = [('Add to...', 'add'), ('Remove from...', 'remove')]
    mlc = selection_dialog([i[0] for i in main_listing], [i[1] for i in main_listing], 'Choose Add to or Remove from...')
    if mlc == None: return
    string = "Choose Selection to Add Item To" if mlc == 'add' else "Choose Selection to Remove Item From"
    heading = 'Add to ' if mlc == 'add' else 'Remove from '
    listing = [(heading + 'Trakt List', 'trakt'), (heading + 'Fen Favourites', 'favourites')]
    if not trakt_list_subscriptions(): listing.append((heading + 'Fen Subscriptions', 'subscriptions'))
    if media_type == 'tvshow' and watched_indicators() == 0: listing.append((heading + 'Fen Next Episode', 'unwatched_next_episode'))
    if mlc == 'remove': listing.append((heading + 'Cache (Re-cache %s Info)' % ('Movie' if media_type == 'movie' else 'TV Show'), 'refresh'))
    choice = selection_dialog([i[0] for i in listing], [i[1] for i in listing], string)
    if choice == None: return
    elif choice == 'trakt': url = {'mode': ('trakt.trakt_add_to_list' if mlc == 'add' else 'trakt.trakt_remove_from_list'), 'tmdb_id': meta["tmdb_id"], 'imdb_id': meta["imdb_id"], 'tvdb_id': meta["tvdb_id"], 'db_type': media_type}
    elif choice == 'favourites': url = {'mode': ('add_to_favourites' if mlc == 'add' else 'remove_from_favourites'), 'db_type': media_type, 'tmdb_id': meta["tmdb_id"], 'title': meta['title']}
    elif choice == 'subscriptions': url = {'mode': 'subscriptions_add_remove', 'action': mlc, 'db_type': media_type, 'tmdb_id': meta["tmdb_id"], 'orig_mode': orig_mode}
    elif choice == 'unwatched_next_episode': url = {'mode': 'add_next_episode_unwatched', 'action': mlc, 'title': meta["title"], 'tmdb_id': meta["tmdb_id"], 'imdb_id': meta["imdb_id"]}
    elif choice == 'refresh': url = {'mode': 'refresh_cached_data', 'db_type': media_type, 'id_type': 'tmdb_id', 'media_id': meta['tmdb_id']}
    xbmc.executebuiltin('RunPlugin(%s)' % build_url(url))

def extras_menu(params):
    import json
    from modules.utils import merge_dicts
    from modules.nav_utils import build_url, movie_genres, tvshow_genres, networks
    def _process_dicts(_key, _dict):
        new_dict = {}
        for key, value in _dict.items():
            if key in _key: new_dict[key] = value
        return new_dict
    def process_list_dicts(_key, _value, _return_value, dict_list):
        for item in dict_list:
            if _key in item and item[_key] == _value:
                return item[_return_value]
    meta = json.loads(params['meta'])
    media_type = params['media_type']
    rootname = meta['rootname']
    tmdb_id = meta['tmdb_id']
    trailer = meta['trailer']
    director = meta.get('director', None)
    year = meta.get('year', None)
    genre = meta.get('genre', None)
    network = meta.get('studio', None)
    if media_type in ('tv', 'season', 'episode'): base_media = 'tv'
    else: base_media = 'movies'
    if network:
        if base_media == 'tv': network_id = process_list_dicts('name', network, 'id', networks)
        else: network_id = network
    else: network_id = None
    if genre: genre_dict = _process_dicts(genre, merge_dicts(movie_genres, tvshow_genres))
    else: genre_dict = None
    sim_recom_runner = "RunPlugin(%s)" % build_url({"mode": "similar_recommendations_choice", "db_type": base_media, 'sim_recom_name': rootname, "sim_recom_tmdb": tmdb_id, "sim_recom_imdb": meta['imdb_id'], "meta_user_info": params['meta_user_info']})
    if params['all_trailers'] and meta.get('all_trailers', False): trailer_runner = "RunPlugin(%s)" % build_url({'mode': 'play_trailer', 'url': trailer, 'all_trailers': json.dumps(meta['all_trailers'])})
    else: trailer_runner = "RunPlugin(%s)" % build_url({'mode': 'play_trailer', 'url': trailer})
    actors_runner = "RunPlugin(%s)" % build_url({"mode": "people_search.extras_show_all_actors", "media_rootname": rootname, "full_cast": json.dumps(meta['cast'])})
    director_runner = "RunPlugin(%s)" % build_url({"mode": "people_search.extras_person_data", "person_name": director})
    year_runner = "RunPlugin(%s)" % build_url({"mode": "container_update", "final_params": json.dumps({'mode': 'build_%s_list' % ('movie' if base_media == 'movies' else 'tvshow'), 'action': 'tmdb_%s_year' % base_media, 'year': year})})
    genre_runner = "RunPlugin(%s)" % build_url({"mode": "container_update", "final_params": json.dumps({'mode': 'build_%s_list' % ('movie' if base_media == 'movies' else 'tvshow'), 'action': 'tmdb_%s_genres' % base_media, 'genre_list': json.dumps(genre_dict)})})
    network_runner = "RunPlugin(%s)" % build_url({"mode": "container_update", "final_params": json.dumps({'mode': 'build_%s_list' % ('movie' if base_media == 'movies' else 'tvshow'), 'action': 'tmdb_%s_networks' % base_media, 'network_id': network_id, 'network_name': network})})
    reviews_runner = "RunPlugin(%s)" % build_url({'mode': 'movie_reviews_choice', 'rootname': rootname, 'tmdb_id': tmdb_id, 'poster': meta['poster']})
    play_random_params = {'mode': 'play_fetch_random', 'db_type': 'episode', 'meta': json.dumps(meta)}
    if media_type in ('season', 'episode'): play_random_params['default_season'] = params['default_season']
    play_random_runner = "RunPlugin(%s)" % build_url(play_random_params)
    extended_info_runner = 'RunScript(script.extendedinfo,info=%s,id=%s)' % (('extendedinfo' if base_media == 'movies' else 'extendedtvinfo'), tmdb_id)
    choices = [("Similar/Recommended", sim_recom_runner)]
    if trailer: choices += [("Play Trailer", trailer_runner)]
    if media_type == 'movies': choices += [("Read Reviews", reviews_runner)]
    choices += [("Actors Info", actors_runner)]
    if media_type == 'movies' and director: choices += [("Director Info", director_runner)]
    choices += [("Extended Info", extended_info_runner)]
    if year: choices += [("More from Year: [B][I]%s[/I][/B]" % year, year_runner)]
    if genre_dict: choices += [("More from Genre/s: [B][I]%s[/I][/B]" % genre, genre_runner)]
    if network_id: choices += [("More from %s: [B][I]%s[/I][/B]" % ('Studio' if base_media == 'movies' else 'Network', network), network_runner)]
    if media_type != 'movies': choices += [("Play Random%s" % (' [B][I]Season %s[/I][/B]' % str(params['default_season']) if media_type in ('season', 'episode') else ''), play_random_runner)]
    choice = selection_dialog([i[0] for i in choices], [i[1] for i in choices], 'Fen Extras: %s' % rootname)
    if not choice: return
    xbmc.executebuiltin(choice)

def options_menu(from_results=False, suggestion=None, list_name=None, play_params=None):
    from modules.nav_utils import toggle_setting, build_url, open_settings, clear_cache, cached_page_clear, clear_and_rescrape
    from modules import settings
    params = dict(parse_qsl(argv[2].replace('?','')))
    content = xbmc.getInfoLabel('Container.Content')
    if not content: content = params.get('content', None)
    from_results = params.get('from_results', from_results)
    suggestion = params.get('suggestion', suggestion)
    list_name = params.get('list_name', list_name)
    play_params = params.get('play_params', play_params)
    autoplay_status, autoplay_toggle, filter_setting = ('On', 'false', 'autoplay_quality') if settings.auto_play() else ('Off', 'true', 'results_quality')
    quality_filter_setting = 'autoplay' if autoplay_status == 'On' else 'results'
    autoplay_next_status, autoplay_next_toggle = ('On', 'false') if settings.autoplay_next_episode() else ('Off', 'true')
    display_mode = settings.display_mode()
    display_mode_status = 'Directory' if display_mode == 0 else 'Very Simple Directory' if display_mode == 1 else 'Dialog'
    results_sorting_status = __addon__.getSetting('results.sort_order_display')
    autoplay_hevc_status = settings.autoplay_hevc()
    current_subs_action_status = __addon__.getSetting('subtitles.subs_action')
    active_scrapers = [i.replace('-', '') for i in settings.active_scrapers(group_folders=True)]
    current_scrapers_status = ', '.join([i.upper()[:3] for i in active_scrapers]) if len(active_scrapers) > 0 else 'NONE'
    current_filter_status =  ', '.join(settings.quality_filter(filter_setting))
    indicators_status, indicators_toggle = ('Trakt', '0') if settings.watched_indicators() in (1, 2) else ('Fen', '1')
    cached_torrents_status, cached_torrents_toggle = ('On', 'false') if __addon__.getSetting('torrent.check.cache') =='true' else ('Off', 'true')
    uncached_torrents_status, uncached_torrents_toggle = ('On', 'false') if __addon__.getSetting('torrent.display.uncached') =='true' else ('Off', 'true')
    active_cloud_store = settings.active_store_torrent_to_cloud()
    active_cloud_store_status = ', '.join([i[1] for i in active_cloud_store]) if len(active_cloud_store) > 0 else 'NONE'
    furk_easy_suggestion = params.get('suggestion', '')
    listing = []  
    if play_params: listing += [('RESCRAPE & SELECT SOURCE', 'rescrape_select')]
    listing += [('AUTOPLAY: [I]Currently [B]%s[/B][/I]' % autoplay_status, 'toggle_autoplay')]
    if autoplay_status == 'On':
        listing += [('HEVC AUTOPLAY FILTER: [I]Currently [B]%s[/B][/I]' % autoplay_hevc_status, 'set_autoplay_hevc')]
        listing += [('AUTOPLAY NEXT EPISODE: [I]Currently [B]%s[/B][/I]' % autoplay_next_status, 'toggle_autoplay_next')]
    listing += [('ENABLE SCRAPERS: [I]Currently [B]%s[/B][/I]' % current_scrapers_status, 'enable_scrapers')]
    if autoplay_status == 'Off':
        listing += [('DISPLAY MODE: [I]Currently [B]%s[/B][/I]' % display_mode_status, 'set_display_mode')]
        listing += [('RESULTS SORTING: [I]Currently [B]%s[/B][/I]' % results_sorting_status, 'set_results_sorting')]
    listing += [('QUALITY FILTERS: [I]Currently [B]%s[/B][/I]' % current_filter_status, 'set_filters')]
    listing += [('DOWNLOAD SUBTITLES: [I]Currently [B]%s[/B][/I]' % current_subs_action_status, 'set_subs_action')]
    if settings.cache_page(): listing += [('CLEAR BOOKMARK PAGE PROGRESS', 'clear_cache_page')]
    listing += [('SWITCH INDICATOR PROVIDER: [I]Currently [B]%s[/B][/I]' % indicators_status, 'toggle_indicators')]
    if 'external' in active_scrapers:
        listing += [('CHECK FOR CACHED TORRENTS: [I]Currently [B]%s[/B][/I]' % cached_torrents_status, 'toggle_cached_torrents')]
        if cached_torrents_status == 'On':
            listing += [(' - SHOW UNCACHED TORRENTS: [I]Currently [B]%s[/B][/I]' % uncached_torrents_status, 'toggle_torrents_display_uncached')]
            listing += [(' - ADD TORRENTS TO CLOUD: [I]Currently [B]%s[/B][/I]' % active_cloud_store_status, 'set_active_cloud_store')]
    if content in ('movies', 'episodes', 'movie', 'episode'): listing += [('FURK/EASYNEWS SEARCH: [B][I]%s[/I][/B]' % furk_easy_suggestion, 'search_directly')]
    if settings.watched_indicators() in (1,2): listing += [('CLEAR TRAKT CACHE', 'clear_trakt_cache')]
    listing += [('EXTERNAL SCRAPERS MANAGER', 'open_external_scrapers_manager')]
    listing += [('OPEN TIKI META SETTINGS', 'open_meta_settings')]
    listing += [('OPEN OPENSCRAPERS SETTINGS', 'open_scraper_settings')]
    listing += [('OPEN FEN SETTINGS', 'open_fen_settings')]
    listing += [('[B]SAVE SETTINGS AND EXIT[/B]', 'save_and_exit')]
    xbmc.sleep(500)
    choice = selection_dialog([i[0] for i in listing], [i[1] for i in listing], 'Fen Options...')
    if choice == 'rescrape_select': return clear_and_rescrape(play_params)
    elif choice == 'toggle_autoplay': toggle_setting('auto_play', autoplay_toggle)
    elif choice == 'set_autoplay_hevc': set_autoplay_hevc()
    elif choice == 'toggle_autoplay_next': toggle_setting('autoplay_next_episode', autoplay_next_toggle)
    elif choice == 'enable_scrapers': enable_scrapers()
    elif choice == 'set_display_mode': set_display_mode()
    elif choice == 'set_results_sorting': results_sorting_choice()
    elif choice == 'set_filters': set_quality(quality_filter_setting)
    elif choice == 'set_subs_action': set_subtitle_action()
    elif choice == 'clear_cache_page': cached_page_clear(action=list_name)
    elif choice == 'toggle_indicators': toggle_setting('watched_indicators', indicators_toggle)
    elif choice == 'toggle_cached_torrents': toggle_setting('torrent.check.cache', cached_torrents_toggle)
    elif choice == 'toggle_torrents_display_uncached': toggle_setting('torrent.display.uncached', uncached_torrents_toggle)
    elif choice == 'set_active_cloud_store': set_active_cloud_store(active_cloud_store)
    elif choice == 'search_directly': furk_easynews_direct_search_choice(suggestion, from_results, list_name)
    elif choice == 'clear_trakt_cache': clear_cache('trakt')
    elif choice == 'open_external_scrapers_manager': external_scrapers_manager()
    elif choice == 'open_meta_settings': xbmc.executebuiltin('Addon.OpenSettings(script.module.tikimeta)')
    elif choice == 'open_scraper_settings': xbmc.executebuiltin('Addon.OpenSettings(script.module.openscrapers)')
    elif choice == 'open_fen_settings': open_settings('0.0')
    if choice in ('clear_cache_page', 'toggle_indicators', 'clear_trakt_cache') and content in ('movies', 'tvshows', 'seasons', 'episodes'): xbmc.executebuiltin('Container.Refresh')
    if choice in (None, 'rescrape_select', 'save_and_exit', 'clear_cache_page', 'toggle_indicators', 'clear_trakt_cache', 'search_directly', 'open_meta_settings', 'open_scraper_settings', 'open_fen_settings', 'open_external_scrapers_manager'): return
    xbmc.executebuiltin('RunPlugin(%s)' % build_url({'mode': 'options_menu_choice', 'from_results': from_results, 'suggestion': suggestion, 'list_name': list_name, 'play_params': play_params}))

def set_autoplay_hevc():
    from modules.settings import active_scrapers
    from modules.nav_utils import toggle_setting
    options = ['Include', 'Exclude', 'Prefer']
    options_choice = selection_dialog(options, options, 'Choose HEVC Autoplay Setting')
    if options_choice < 0: return
    return toggle_setting('autoplay_hevc', options_choice)

def furk_easynews_direct_search_choice(suggestion, from_results, list_name):
    from modules.nav_utils import build_url
    direct_search_furk_params = {'mode': 'furk.search_furk', 'db_type': 'video', 'suggestion': suggestion}
    direct_search_easynews_params = {'mode': 'easynews.search_easynews', 'suggestion': suggestion}
    choices = [('SEARCH FURK', direct_search_furk_params), ('SEARCH EASYNEWS', direct_search_easynews_params)]
    choice = selection_dialog([i[0] for i in choices], [i[1] for i in choices], 'Choose Direct Search Provider')
    if not choice: xbmc.executebuiltin('RunPlugin(%s)' % build_url({'mode': 'playback_menu', 'from_results': from_results, 'suggestion': suggestion, 'list_name': list_name}))
    else: xbmc.executebuiltin('Container.Update(%s)' % build_url(choice))

def color_chooser(msg_dialog, no_color=False):
    color_chart = [
          'black', 'white', 'whitesmoke', 'gainsboro', 'lightgray', 'silver', 'darkgray', 'gray', 'dimgray',
          'snow', 'floralwhite', 'ivory', 'beige', 'cornsilk', 'antiquewhite', 'bisque', 'blanchedalmond',
          'burlywood', 'darkgoldenrod', 'ghostwhite', 'azure', 'lightsaltegray', 'lightsteelblue',
          'powderblue', 'lightblue', 'skyblue', 'lightskyblue', 'deepskyblue', 'dodgerblue', 'royalblue',
          'blue', 'mediumblue', 'midnightblue', 'navy', 'darkblue', 'cornflowerblue', 'slateblue', 'slategray',
          'yellowgreen', 'springgreen', 'seagreen', 'steelblue', 'teal', 'fuchsia', 'deeppink', 'darkmagenta',
          'blueviolet', 'darkviolet', 'darkorchid', 'darkslateblue', 'darkslategray', 'indigo', 'cadetblue',
          'darkcyan', 'darkturquoise', 'turquoise', 'cyan', 'paleturquoise', 'lightcyan', 'mintcream', 'honeydew',
          'aqua', 'aquamarine', 'chartreuse', 'greenyellow', 'palegreen', 'lawngreen', 'lightgreen', 'lime',
          'mediumspringgreen', 'mediumturquoise', 'lightseagreen', 'mediumaquamarine', 'mediumseagreen',
          'limegreen', 'darkseagreen', 'forestgreen', 'green', 'darkgreen', 'darkolivegreen', 'olive', 'olivedab',
          'darkkhaki', 'khaki', 'gold', 'goldenrod', 'lightyellow', 'lightgoldenrodyellow', 'lemonchiffon',
          'yellow', 'seashell', 'lavenderblush', 'lavender', 'lightcoral', 'indianred', 'darksalmon',
          'lightsalmon', 'pink', 'lightpink', 'hotpink', 'magenta', 'plum', 'violet', 'orchid', 'palevioletred',
          'mediumvioletred', 'purple', 'maroon', 'mediumorchid', 'mediumpurple', 'mediumslateblue', 'thistle',
          'linen', 'mistyrose', 'palegoldenrod', 'oldlace', 'papayawhip', 'moccasin', 'navajowhite', 'peachpuff',
          'sandybrown', 'peru', 'chocolate', 'orange', 'darkorange', 'tomato', 'orangered', 'red', 'crimson',
          'salmon', 'coral', 'firebrick', 'brown', 'darkred', 'tan', 'rosybrown', 'sienna', 'saddlebrown'
          ]
    color_display = ['[COLOR=%s]%s[/COLOR]' % (i, i.capitalize()) for i in color_chart]
    if no_color:
        color_chart.insert(0, 'No Color')
        color_display.insert(0, 'No Color')
    choice = selection_dialog(color_display, color_chart, msg_dialog)
    if not choice: return
    return choice
