# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin, xbmcaddon
from datetime import datetime, timedelta
import requests
import re
try: from urlparse import urlparse
except: from urllib.parse import urlparse
from modules import dom_parser
from modules.fen_cache import cache_object
from modules.utils import imdb_sort_list, to_utf8, remove_accents, replace_html_codes, string_alphanum_to_num
# from modules.utils import logger

__addon_id__ = 'plugin.video.fen'
__addon__ = xbmcaddon.Addon(id=__addon_id__)

imdb_user = string_alphanum_to_num(__addon__.getSetting('imdb_user'))
base_url = 'http://www.imdb.com/'
watchlist_url = 'user/ur%s/watchlist'
user_list_movies_url = 'list/%s/?view=detail&sort=%s&title_type=movie,short,video,tvShort,tvMovie,tvSpecial&start=1&page=%s'
user_list_tvshows_url = 'list/%s/?view=detail&sort=%s&title_type=tvSeries,tvMiniSeries&start=1&page=%s'
lists_link = 'user/ur%s/lists?tab=all&sort=mdfd&order=desc&filter=titles'

def imdb_user_lists(db_type):
    string = "%s_%s_%s" % ('imdb_user_lists', db_type, imdb_user)
    url = base_url + lists_link % imdb_user
    params = {'url': url, 'action': 'imdb_user_lists', 'db_type': db_type}
    return cache_object(get_imdb, string, params, False, 0.5)[0]

def imdb_watchlist(db_type, foo_var, page_no):
    sort = imdb_sort_list()
    string = "%s_%s_%s_%s_%s" % ('imdb_watchlist', db_type, imdb_user, sort, page_no)
    url = base_url + watchlist_url % imdb_user
    params = {'url': url, 'action': 'imdb_watchlist', 'db_type': db_type, 'sort': sort, 'page_no': page_no}
    return cache_object(get_imdb, string, params, False, 0.5)

def imdb_user_list_contents(db_type, list_id, page_no):
    sort = imdb_sort_list()
    string = "%s_%s_%s_%s_%s_%s" % ('imdb_user_list_contents', db_type, imdb_user, list_id, sort, page_no)
    params = {'url': list_id, 'action': 'imdb_user_list_contents', 'db_type': db_type, 'sort': sort, 'page_no': page_no}
    return cache_object(get_imdb, string, params, False, 0.5)

def get_imdb(params):
    imdb_list = []
    action = params['action']
    url = params['url']
    next_page = None
    if 'date' in params:
        date_time = (datetime.utcnow() - timedelta(hours = 5))
        for i in re.findall('date\[(\d+)\]', url):
            url = url.replace('date[%s]' % i, (date_time - timedelta(days = int(i))).strftime('%Y-%m-%d'))
    if action in ('imdb_watchlist', 'imdb_user_list_contents'):
        list_url_type = user_list_movies_url if params['db_type'] == 'movies' else user_list_tvshows_url
        if action == 'imdb_watchlist':
            url = dom_parser.parseDOM(to_utf8(remove_accents(requests.get(url).text)), 'meta', ret='content', attrs = {'property': 'pageId'})[0]
        url = base_url + list_url_type % (url, params['sort'], params['page_no'])
        result = requests.get(url)
        result = to_utf8(remove_accents(result.text))
        result = result.replace('\n', ' ')
        items = dom_parser.parseDOM(result, 'div', attrs={'class': '.+? lister-item'})
        items += dom_parser.parseDOM(result, 'div', attrs={'class': 'lister-item .+?'})
        items += dom_parser.parseDOM(result, 'div', attrs={'class': 'list_item.+?'})
        for item in to_utf8(items):
            try:
                title = dom_parser.parseDOM(item, 'a')[1]
                year = dom_parser.parseDOM(item, 'span', attrs={'class': 'lister-item-year.+?'})
                year = re.findall('(\d{4})', year[0])[0]
                imdb_id = dom_parser.parseDOM(item, 'a', ret='href')[0]
                imdb_id = re.findall('(tt\d*)', imdb_id)[0]
                imdb_list.append({'title': str(title), 'year': str(year), 'imdb_id': str(imdb_id)})
            except: pass
        try:
            result = result.replace('"class="lister-page-next', '" class="lister-page-next')
            next_page = dom_parser.parseDOM(result, 'a', ret='href', attrs = {'class': '.*?lister-page-next.*?'})
            if len(next_page) == 0:
                next_page = dom_parser.parseDOM(result, 'div', attrs = {'class': 'pagination'})[0]
                next_page = zip(dom_parser.parseDOM(next_page, 'a', ret='href'), dom_parser.parseDOM(next_page, 'a'))
                next_page = [i[0] for i in next_page if 'Next' in i[1]]
        except:
            next_page = None
    elif action == 'imdb_user_lists':
        result = requests.get(url)
        result = to_utf8(remove_accents(result.text))
        items = dom_parser.parseDOM(result, 'li', attrs={'class': 'ipl-zebra-list__item user-list'})    
        for item in to_utf8(items):
            try:
                title = dom_parser.parseDOM(item, 'a')[0]
                title = replace_html_codes(title)
                url = dom_parser.parseDOM(item, 'a', ret='href')[0]
                list_id = url.split('/list/', 1)[-1].strip('/')
                imdb_list.append({'title': title, 'list_id': list_id})
            except: pass
    return (imdb_list, next_page)

def clear_imdb_cache(silent=False):
    import os
    try:
        import xbmcvfs
        try: from sqlite3 import dbapi2 as database
        except ImportError: from pysqlite2 import dbapi2 as database
        window = xbmcgui.Window(10000)
        profile_dir = xbmc.translatePath(__addon__.getAddonInfo('profile'))
        if not xbmcvfs.exists(profile_dir): xbmcvfs.mkdirs(profile_dir)
        FEN_DB = os.path.join(profile_dir, "fen_cache.db")
        dbcon = database.connect(FEN_DB)
        dbcur = dbcon.cursor()
        dbcur.execute("SELECT id FROM fencache WHERE id LIKE 'imdb_%'")
        imdb_results = [str(i[0]) for i in dbcur.fetchall()]
        if not imdb_results: return True
        dbcur.execute("DELETE FROM fencache WHERE id LIKE 'imdb_%'")
        dbcon.commit()
        dbcon.close()
        for i in imdb_results: window.clearProperty(i)
        return True
    except: return False






