# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin, xbmcaddon
from sys import argv
from apis.tmdb_api import tmdb_media_images
from modules.nav_utils import build_url, setView
# from modules.utils import logger

__addon_id__ = 'plugin.video.fen'
__addon__ = xbmcaddon.Addon(id=__addon_id__)
__handle__ = int(argv[1])

image_base = 'http://image.tmdb.org/t/p/%s%s'
fanart = __addon__.getAddonInfo('fanart')

def media_image_results(db_type, tmdb_id, image_type):
    results = tmdb_media_images(db_type, tmdb_id)
    for item in results[image_type]:
        image_url = image_base % ('original', item['file_path'])
        name = '%sx%s' % (item['height'], item['width'])
        url_params = {'mode': 'show_image', 'image_url': image_url}
        url = build_url(url_params)
        listitem = xbmcgui.ListItem(name)
        listitem.setArt({'icon': image_url, 'poster': image_url, 'thumb': image_url, 'fanart': fanart, 'banner': image_url})
        xbmcplugin.addDirectoryItem(__handle__, url, listitem, isFolder=False)
    xbmcplugin.setContent(__handle__, 'files')
    xbmcplugin.endOfDirectory(__handle__)
    setView('view.main')

def show_image(image_url=None):
    if not image_url:
        try: from urlparse import parse_qsl
        except ImportError: from urllib.parse import parse_qsl
        params = dict(parse_qsl(argv[2].replace('?','')))
        image_url = params['image_url']
    xbmc.executebuiltin('ShowPicture(%s)' % image_url)