# -*- coding: utf-8 -*-
import xbmc, xbmcaddon, xbmcgui
import os
import sys
import re
import json
import time
from datetime import datetime
from importlib import import_module
from threading import Thread
try: from sqlite3 import dbapi2 as database
except Exception: from pysqlite2 import dbapi2 as database
from modules.nav_utils import show_busy_dialog, hide_busy_dialog, notification
from modules.utils import byteify, clean_file_name
from modules.utils import local_string as ls
from modules import external_source_utils
try: import resolveurl
except Exception: pass
# from modules.utils import logger

__fen__ = xbmcaddon.Addon(id='plugin.video.fen')
__external__ = xbmcaddon.Addon(id='script.module.openscrapers')

window = xbmcgui.Window(10000)
monitor = xbmc.Monitor()

class ExternalSource:
	def __init__(self, sourceDict, debrid_enabled, debrid_hosters, active_scrapers, progressDialog=None):
		self.scrape_provider = 'external'
		self.sourceDict = sourceDict
		self.debrid_enabled = debrid_enabled
		self.debrid_hosters = debrid_hosters
		self.internal_activated = len(active_scrapers) > 1
		self.progressDialog = progressDialog
		self.sources = []
		self.internal_sources = []
		self.processed_internal_sources = []
		self.active_scrapers = 0
		self.duplicates = 0
		self.database_timeout = 60.0
		self.getConstants()

	def results(self, info):
		self.info = info
		self.scraper_settings = json.loads(info['scraper_settings'])
		results = []
		results = self.getSources((info['title'] if info['db_type'] == 'movie' else info['ep_name']),
							info['year'], info['imdb_id'], info['tvdb_id'], info['season'], info['episode'],
							(info['title'] if info['db_type'] == 'episode' else None), info['premiered'], info['language'])
		return results

	def getSources(self, title, year, imdb, tvdb, season, episode, tvshowtitle, premiered, language):
		def _scraperDialog():
			diag_format = ' 4K: %s | 1080p: %s | 720p: %s | SD: %s | %s: %s'
			exonly_diag_format = '4K: %s | 1080p: %s | 720p: %s | SD: %s | %s: %s'
			loaded_scrapers = 0
			close_dialog = True
			start_time = time.time()
			end_time = start_time + timeout
			while not self.progressDialog.iscanceled():
				try:
					if monitor.abortRequested() is True: return sys.exit()
					self.internalResults()
					internalSource_4k_label = total_format % (int_dialog_highlight, self.internalSources4K)
					internalSource_1080_label = total_format % (int_dialog_highlight, self.internalSources1080p)
					internalSource_720_label = total_format % (int_dialog_highlight, self.internalSources720p)
					internalSource_sd_label = total_format % (int_dialog_highlight, self.internalSourcesSD)
					internalSource_total_label = total_format % (int_dialog_highlight, self.internalSourcesTotal)
					source_4k_label = total_format % (ext_dialog_highlight, self.source_4k)
					source_1080_label = total_format % (ext_dialog_highlight, self.source_1080)
					source_720_label = total_format % (ext_dialog_highlight, self.source_720)
					source_sd_label = total_format % (ext_dialog_highlight, self.source_sd)
					source_total_label = total_format % (ext_dialog_highlight, self.total)
					current_time = time.time()
					current_progress = max((current_time - start_time), 0)
					try:
						alive_threads = [x.getName() for x in threads if x.is_alive() is True]
						len_alive_threads = len(alive_threads)
						info = [x[1] for x in scrapers_display if x[0] in alive_threads]
						percent = int((current_progress/float(timeout))*100)
						if self.internal_activated:
							line1 = string6 + diag_format % (internalSource_4k_label, internalSource_1080_label,
													  internalSource_720_label, internalSource_sd_label, str(string4), internalSource_total_label)
							line2 = string7 + diag_format % (source_4k_label, source_1080_label, source_720_label, source_sd_label, str(string4), source_total_label)
						else:
							line1 = string7
							line2 = exonly_diag_format % (source_4k_label, source_1080_label, source_720_label, source_sd_label, str(string4), source_total_label)
						if loaded_scrapers < self.active_scrapers:
							add_time = min(float((self.active_scrapers - loaded_scrapers))/10, 0.5)
							start_time += add_time
							end_time += add_time
							line3 = string_red % str(len_alive_threads)
							loaded_scrapers = self.active_scrapers
						elif len_alive_threads > 6: line3 = string3 % str(len_alive_threads)
						else: line3 = string3 % ', '.join(info).upper()
						self.progressDialog.update(percent, line1, line2, line3)
						if pre_emp == 'true':
							combined_source_4k = self.source_4k + self.internalSources4K
							combined_source_1080 = self.source_1080 + self.internalSources1080p
							combined_source_720 = self.source_720 + self.internalSources720p
							combined_source_sd = self.source_sd + self.internalSourcesSD
							combined_total = self.total + self.internalSourcesTotal
							pre_emp_compare = combined_source_4k if pre_emp_quality == '1' else combined_source_1080 if pre_emp_quality == '2' else \
											  combined_source_720 if pre_emp_quality == '3' else combined_source_sd if pre_emp_quality == '4' else combined_total
							if pre_emp_compare >= pre_emp_limit: close_dialog = False; break
						if finish_early:
							if finish_early_default:
								if percent >= 50:
									if len_alive_threads <= 5: close_dialog = False; break
									if len(self.sources) >= 100 * len_alive_threads: close_dialog = False; break
							else:
								if finish_percent and percent >= finish_percent: close_dialog = False; break
								if finish_scrapers and len_alive_threads <= finish_scrapers: close_dialog = False; break
								if finish_results and len(self.sources) >= finish_results: close_dialog = False; break
						if len_alive_threads == 0: close_dialog = False; break
						if end_time < current_time: close_dialog = False; break
						time.sleep(0.1)
					except: pass
				except Exception: pass
			if close_dialog:
				try: self.progressDialog.close()
				except Exception: pass
				del self.progressDialog
				self.progressDialog = None
			return
		def _scraperDialogBG():
			diag_format = '4K:%s|1080p:%s|720p:%s|SD:%s|T:%s'
			loaded_scrapers = 0
			start_time = time.time()
			end_time = start_time + timeout
			while not monitor.abortRequested() is True:
				try:
					self.internalResults()
					combined_source_4k = self.source_4k + self.internalSources4K
					combined_source_1080 = self.source_1080 + self.internalSources1080p
					combined_source_720 = self.source_720 + self.internalSources720p
					combined_source_sd = self.source_sd + self.internalSourcesSD
					combined_total = self.total + self.internalSourcesTotal
					source_4k_label = total_format % (ext_dialog_highlight, combined_source_4k)
					source_1080_label = total_format % (ext_dialog_highlight, combined_source_1080)
					source_720_label = total_format % (ext_dialog_highlight, combined_source_720)
					source_sd_label = total_format % (ext_dialog_highlight, combined_source_sd)
					source_total_label = total_format % (ext_dialog_highlight, combined_total)
					current_time = time.time()
					current_progress = current_time - start_time
					try:
						alive_threads = [x.getName() for x in threads if x.is_alive() is True]
						len_alive_threads = len(alive_threads)
						info = [x[1] for x in scrapers_display if x[0] in alive_threads]
						percent = int((current_progress/float(timeout))*100)
						line1 = string3 % (str(len(info)))
						line2 = diag_format % (source_4k_label, source_1080_label, source_720_label, source_sd_label, source_total_label)
						self.progressDialog.update(percent, line1, line2)
						if pre_emp == 'true':
							pre_emp_compare = combined_source_4k if pre_emp_quality == '1' else combined_source_1080 if pre_emp_quality == '2' else \
											  combined_source_720 if pre_emp_quality == '3' else combined_source_sd if pre_emp_quality == '4' else combined_total
							if pre_emp_compare >= pre_emp_limit: break
						if loaded_scrapers < self.active_scrapers:
							add_time = min(float((self.active_scrapers - loaded_scrapers))/10, 0.5)
							start_time += add_time
							end_time += add_time
							loaded_scrapers = self.active_scrapers
						if finish_early:
							if finish_early_default:
								if percent >= 50:
									if len_alive_threads <= 5: break
									if len(self.sources) >= 100 * len_alive_threads: break
							else:
								if finish_percent and percent >= finish_percent: break
								if finish_scrapers and len_alive_threads <= finish_scrapers: break
								if finish_results and len(self.sources) >= finish_results: break
						if len_alive_threads == 0: break
						if end_time < current_time: break
						time.sleep(0.1)
					except: pass
				except Exception: pass
			try: self.progressDialog.close()
			except Exception: pass
			del self.progressDialog
			self.progressDialog = None
			return
		def _background():
			start_time = time.time()
			end_time = start_time + timeout
			while time.time() < end_time:
				if pre_emp == 'true':
					combined_source_4k = self.source_4k + self.internalSources4K
					combined_source_1080 = self.source_1080 + self.internalSources1080p
					combined_source_720 = self.source_720 + self.internalSources720p
					combined_source_sd = self.source_sd + self.internalSourcesSD
					combined_total = self.total + self.internalSourcesTotal
					pre_emp_compare = combined_source_4k if pre_emp_quality == '1' else combined_source_1080 if pre_emp_quality == '2' else\
									  combined_source_720 if pre_emp_quality == '3' else combined_source_sd if pre_emp_quality == '4' else combined_total
					if pre_emp_compare >= pre_emp_limit: return
				alive_threads = [x.getName() for x in threads if x.is_alive() is True]
				time.sleep(0.5)
				if len(alive_threads) <= 5: return
				if len(self.sources) >= 100 * len(alive_threads): return
		def _make_dialog():
			xbmc.sleep(200)
			if self.background: _background()
			elif self.dialog_background: _scraperDialogBG()
			else: _scraperDialog()
		if self.remove_failing_sources == 'true': self.sourcesRemoveFailing()
		content = 'movie' if tvshowtitle is None else 'tvshow'
		sourceDict = self.sourceDict
		threads = []
		scrapers_display = []
		dialog_thread = []
		if content == 'movie':
			title = external_source_utils.normalize(title)
			for i in range(len(sourceDict)):
				threads.append(Thread(target=self.getMovieSource, args=(title, title, [], year, imdb, sourceDict[i][0], sourceDict[i][1])))
				scrapers_display.append((threads[i].getName(), sourceDict[i][0]))
		else:
			tvshowtitle = external_source_utils.normalize(tvshowtitle)
			for i in range(len(sourceDict)):
				threads.append(Thread(target=self.getEpisodeSource, args=(title, year, imdb, tvdb, season, episode, tvshowtitle, tvshowtitle, [], premiered, sourceDict[i][0], sourceDict[i][1])))
				scrapers_display.append((threads[i].getName(), sourceDict[i][0]))
		pre_emp = __fen__.getSetting('preemptive.termination')
		pre_emp_quality = __fen__.getSetting('preemptive.quality')
		try: pre_emp_limit = int(__fen__.getSetting('preemptive.limit'))
		except: pre_emp_limit = 1000
		try: timeout = int(__fen__.getSetting('scrapers.timeout.1'))
		except: timeout = 60
		int_dialog_highlight = __fen__.getSetting('int_dialog_highlight')
		if not int_dialog_highlight or int_dialog_highlight == '': int_dialog_highlight = 'darkgoldenrod'
		ext_dialog_highlight = __fen__.getSetting('ext_dialog_highlight')
		if not ext_dialog_highlight or ext_dialog_highlight == '': ext_dialog_highlight = 'dodgerblue'
		finish_early = True if __fen__.getSetting('search.finish.early') == 'true' else False
		if finish_early:
			finish_early_default = True if __fen__.getSetting('search.finish.default') == 'true' else False
			if not finish_early_default:
				try: finish_percent = min(int(__fen__.getSetting('search.finish.percent')), 100)
				except: finish_percent = 0
				try: finish_scrapers = int(__fen__.getSetting('search.finish.scrapers'))
				except: finish_scrapers = 0
				try: finish_results = int(__fen__.getSetting('search.finish.results'))
				except: finish_results = 0
		string1 = ls(32674)
		string2 = ls(32675)
		string3 = ls(32676)
		string4 = ls(32677)
		string_red = ls(32832)
		if self.internal_activated:
			string6 = '[COLOR %s][B]Int:[/B][/COLOR]' % int_dialog_highlight
			string7 = '[COLOR %s][B]Ext:[/B][/COLOR]' % ext_dialog_highlight
		else:
			string7 = '[COLOR %s]%s[/COLOR]' % (ext_dialog_highlight, ls(32118))
		line1 = line2 = line3 = ""
		total_format = '[COLOR %s][B]%s[/B][/COLOR]'
		dialog_thread.append(Thread(target=_make_dialog))
		start_time = time.time()
		end_time = start_time + timeout
		[i.start() for i in dialog_thread]
		[i.start() for i in threads]
		[i.join() for i in dialog_thread]
		self.sourcesStats(sourceDict, self.sources)
		self.sourcesFilter()
		show_busy_dialog()
		self.sourcesLabels()
		return self.sources

	def getMovieSource(self, title, localtitle, aliases, year, imdb, source, module_path):
		try:
			dbcon = database.connect(self.providerDatabase, timeout=self.database_timeout)
			dbcur = dbcon.cursor()
			dbcur.execute('''PRAGMA synchronous = OFF''')
			dbcur.execute('''PRAGMA journal_mode = OFF''')
		except Exception: pass
		if imdb == '0':
			try:
				dbcur.execute("DELETE FROM rel_src WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ?", (source, imdb, '', ''))
				dbcur.execute("DELETE FROM rel_url WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ?", (source, imdb, '', ''))
				dbcon.commit()
			except Exception: pass
		try:
			sources = []
			dbcur.execute("SELECT * FROM rel_src WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ?", (source, imdb, '', ''))
			match = dbcur.fetchone()
			t1 = int(re.sub('[^0-9]', '', str(match[5])))
			t2 = int(datetime.now().strftime("%Y%m%d%H%M"))
			update = abs(t2 - t1) > 120
			if update is False:
				sources = eval(match[4].encode('utf-8'))
				self.sourcesQualityCount(sources)
				return self.sources.extend(sources)
		except Exception: pass
		try:
			url = None
			dbcur.execute("SELECT * FROM rel_url WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ?", (source, imdb, '', ''))
			url = dbcur.fetchone()
			url = eval(url[4].encode('utf-8'))
		except Exception: pass
		try:
			call = import_module(module_path).source()
			if not getattr(call, 'movie', None): return
			self.active_scrapers += 1
		except: return
		try:
			if url is None:
				url = call.movie(imdb, title, localtitle, aliases, year)
			if url is None:
				return
			dbcur.execute("DELETE FROM rel_url WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ?", (source, imdb, '', ''))
			dbcur.execute("INSERT INTO rel_url Values (?, ?, ?, ?, ?)", (source, imdb, '', '', repr(url)))
			dbcon.commit()
		except Exception: pass
		try:
			sources = []
			sources = call.sources(url, self.hostDict, self.hostprDict)
			sources = [json.loads(t) for t in set(json.dumps(d, sort_keys=True) for d in sources)]
			sources = self.sourcesUpdate(source, sources)
			self.sourcesQualityCount(sources)
			self.sources.extend(sources)
			dbcur.execute("DELETE FROM rel_src WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ?", (source, imdb, '', ''))
			dbcur.execute("INSERT INTO rel_src Values (?, ?, ?, ?, ?, ?)", (source, imdb, '', '', repr(sources), datetime.now().strftime("%Y-%m-%d %H:%M")))
			dbcon.commit()
		except Exception: pass

	def getEpisodeSource(self, title, year, imdb, tvdb, season, episode, tvshowtitle, localtvshowtitle, aliases, premiered, source, module_path):
		try:
			dbcon = database.connect(self.providerDatabase)
			dbcur = dbcon.cursor()
			dbcur.execute('''PRAGMA synchronous = OFF''')
			dbcur.execute('''PRAGMA journal_mode = OFF''')
		except Exception: pass
		try:
			sources = []
			dbcur.execute(
				"SELECT * FROM rel_src WHERE source = '%s' AND imdb_id = '%s' AND season = '%s' AND episode = '%s'" %
				(source, imdb, season, episode))
			match = dbcur.fetchone()
			t1 = int(re.sub('[^0-9]', '', str(match[5])))
			t2 = int(datetime.now().strftime("%Y%m%d%H%M"))
			update = abs(t2 - t1) > 120
			if update is False:
				sources = eval(match[4].encode('utf-8'))
				self.sourcesQualityCount(sources)
				return self.sources.extend(sources)
		except Exception: pass
		try:
			url = None
			dbcur.execute(
				"SELECT * FROM rel_url WHERE source = '%s' AND imdb_id = '%s' AND season = '%s' AND episode = '%s'" %
				(source, imdb, '', ''))
			url = dbcur.fetchone()
			url = eval(url[4].encode('utf-8'))
		except Exception: pass
		try:
			call = import_module(module_path).source()
			if not getattr(call, 'tvshow', None): return
			self.active_scrapers += 1
		except: return
		try:
			if url is None:
				url = call.tvshow(imdb, tvdb, tvshowtitle, localtvshowtitle, aliases, year)
			if url is None:
				return
			dbcur.execute(
				"DELETE FROM rel_url WHERE source = '%s' AND imdb_id = '%s' AND season = '%s' AND episode = '%s'" %
				(source, imdb, '', ''))
			dbcur.execute("INSERT INTO rel_url Values (?, ?, ?, ?, ?)", (source, imdb, '', '', repr(url)))
			dbcon.commit()
		except Exception: pass
		try:
			ep_url = None
			dbcur.execute(
				"SELECT * FROM rel_url WHERE source = '%s' AND imdb_id = '%s' AND season = '%s' AND episode = '%s'" %
				(source, imdb, season, episode))
			ep_url = dbcur.fetchone()
			ep_url = eval(ep_url[4].encode('utf-8'))
		except Exception: pass
		try:
			if url is None:
				raise Exception()
			if ep_url is None:
				ep_url = call.episode(url, imdb, tvdb, title, premiered, season, episode)
			if ep_url is None:
				return
			dbcur.execute(
				"DELETE FROM rel_url WHERE source = '%s' AND imdb_id = '%s' AND season = '%s' AND episode = '%s'" %
				(source, imdb, season, episode))
			dbcur.execute("INSERT INTO rel_url Values (?, ?, ?, ?, ?)", (source, imdb, season, episode, repr(ep_url)))
			dbcon.commit()
		except Exception: pass
		try:
			sources = []
			sources = call.sources(ep_url, self.hostDict, self.hostprDict)
			sources = [json.loads(t) for t in set(json.dumps(d, sort_keys=True) for d in sources)]
			sources = self.sourcesUpdate(source, sources)
			self.sourcesQualityCount(sources)
			self.sources.extend(sources)
			dbcur.execute(
				"DELETE FROM rel_src WHERE source = '%s' AND imdb_id = '%s' AND season = '%s' AND episode = '%s'" %
				(source, imdb, season, episode))
			dbcur.execute("INSERT INTO rel_src Values (?, ?, ?, ?, ?, ?)", (source, imdb, season,
																			episode, repr(sources), datetime.now().strftime("%Y-%m-%d %H:%M")))
			dbcon.commit()
		except Exception: pass

	def sourcesFilter(self):
		def _processFilters(d):
			for k, v in d.items():
				#TORRENTS...
				if self.torrentCheckCache == 'false':
					self.filter += [dict(i.items() + [('debrid', k)]) for i in torrentSources if i.get('cache_provider') == 'Unchecked']
				else:
					if k in ('Real-Debrid', 'Premiumize.me', 'AllDebrid'):
						self.filter += [dict(i, **{'debrid':k}) for i in torrentSources if k == i.get('cache_provider')]
						if self.uncachedTorrents == 'true':
							self.filter += [dict(i, **{'debrid':k}) for i in torrentSources if 'Uncached' in i.get('cache_provider') and k in i.get('cache_provider')]
					elif torrentSources:
						if torrentSources[0].get('cache_provider') == 'Unchecked':
							self.filter += [dict(i, **{'debrid':k}) for i in torrentSources if i.get('cache_provider') == 'Unchecked']
				#HOSTERS
				valid_hosters = [i for i in result_hosters if i in v]
				self.filter += [dict(i, **{'debrid':k}) for i in hoster_sources if i['source'].split('.')[0] in valid_hosters]
		if 'true' in (self.removeDuplicates, self.removeDuplicatesTorrents):
			if len(self.sources) > 0:
				self.sources = list(self.sourcesRemoveDuplicates(self.sources))
				if not self.suppress_notifications: notification(ls(32679) % self.duplicates, 2500)
		hoster_sources = [i for i in self.sources if not 'hash' in i]
		torrentSources = self.sourcesProcessTorrents([i for i in self.sources if 'hash' in i])
		self.filter = []
		result_hosters = list(set([i['source'].split('.')[0].lower() for i in self.sources]))
		threads = []
		for d in self.debrid_hosters: threads.append(Thread(target=_processFilters, args=(d,)))
		[i.start() for i in threads]
		[i.join() for i in threads]
		if self.include_nondebrid == 'true' and self.hostDict:
			self.filter += [i for i in hoster_sources if not i['source'] in self.hostprDict and i['debridonly'] is False]
		self.sources = self.filter
		if not self.captcha == 'true':
			filter = [i for i in self.sources if i['source'].lower() in self.hostcapDict and 'debrid' not in i]
			self.sources = [i for i in self.sources if i not in filter]
		filter = [i for i in self.sources if i['source'].lower() in self.hostblockDict and 'debrid' not in i]
		self.sources = [i for i in self.sources if i not in filter]

	def sourcesLabels(self):
		def _processLabels(item):
			try:
				extraInfo = item.get('extraInfo', None)
				URLName = item.get('URLName', None)
				provider = item['provider']
				try: size = item['size_label']
				except: size = None
				quality = item['quality']
				source = item['source'].rsplit('.', 1)[0]
				debrid = item.get('debrid', None)
				cache_provider = item.get('cache_provider', None)
				if debrid:
					if debrid.lower() == 'real-debrid':
						if cache_provider:
							if cache_provider == 'Unchecked': debrid = 'RD UNCHECKED'
							elif 'Uncached' in cache_provider and debrid in cache_provider: debrid = 'RD UNCACHED'
							else: debrid = '[B]RD CACHED[/B]'
						else: debrid = 'RD'
					elif debrid.lower() == 'premiumize.me':
						if cache_provider:
							if cache_provider == 'Unchecked': debrid = 'PM UNCHECKED'
							elif 'Uncached' in cache_provider and debrid in cache_provider: debrid = 'PM UNCACHED'
							else: debrid = '[B]PM CACHED[/B]'
						else: debrid = 'PM'
					elif debrid.lower() == 'alldebrid':
						if cache_provider:
							if cache_provider == 'Unchecked': debrid = 'AD UNCHECKED'
							elif 'Uncached' in cache_provider and debrid in cache_provider: debrid = 'AD UNCACHED'
							else: debrid = '[B]AD CACHED[/B]'
						else: debrid = 'AD'
				else:
					item['debrid'] = ''
				label = ''
				multiline_label1 = ''
				multiline_label2 = '\n        '
				if debrid:
					label += debrid
					multiline_label1 += debrid
				else:
					label += provider
					multiline_label1 += provider
				if quality.upper() in ['4K', '1080P', '720P', 'TELE', 'SCR', 'CAM']:
					label += ' | [I][B]%s[/B][/I]' % quality
					multiline_label1 += ' | [I][B]%s[/B][/I]' % quality
				else:
					label += ' | [I]SD[/I]'
					multiline_label1 += ' | [I]SD[/I]'
				if size not in ('0', '0.0', '0 GB', '0.0 GB', '0.00 GB', '', 'None', None):
					label += ' | %s' % size
					multiline_label1 += ' | %s' % size
				if debrid:
					label += ' | %s' % provider
					multiline_label1 += ' | %s' % provider
				if source.lower() == 'torrent' and any(i in cache_provider for i in ('Unchecked', 'Uncached')) and 'seeders' in item:
					label += ' | %s SEEDS' % item['seeders']
					multiline_label1 += ' | %s SEEDS' % item['seeders']
				else:
					label += ' | %s' % source
					multiline_label1 += ' | %s' % source
				if enableExtraInfo:
					if extraInfo: label += ' | %s' % extraInfo
					if enableShowFilenames:
						if URLName: label += ' | %s' % URLName
						if extraInfo: multiline_label1 += ' | %s' % extraInfo
						if URLName: multiline_label2 += URLName
					else:
						if extraInfo: multiline_label2 += extraInfo
				elif enableShowFilenames:
					if URLName: label += ' | %s' % URLName
					if URLName: multiline_label2 += URLName
				label = label.replace('| 0 |', '|').replace(' | [I]0 [/I]', '').replace('[I] [/I] | ', '')
				label = label.upper()
				multiline_label1 = multiline_label1.replace('| 0 |', '|').replace(' | [I]0 [/I]', '').replace('[I] [/I] | ', '')
				multiline_label1 = multiline_label1.upper()
				if multiline_label2 != '':
					multiline_label2 = multiline_label2.replace('| 0 |', '|').replace(' | [I]0 [/I]', '').replace('[I] [/I] | ', '')
					multiline_label2 = multiline_label2.upper()
				if highlightType == '1':
					if quality.upper() == '4K': LeadingColor = highlight_4K
					elif quality.upper()  == '1080P': LeadingColor = highlight_1080p
					elif quality.upper() == '720P': LeadingColor = highlight_720p
					else: LeadingColor = highlight_SD
					if multiLineHighlight == '': multilineOpen = LeadingColor
					else: multilineOpen = multiLineHighlight
					item['label'] = '[COLOR=%s]' % LeadingColor + label + '[/COLOR]'
					item['multiline_label'] = '[COLOR=%s]' % LeadingColor + multiline_label1 + '[/COLOR]' + '[COLOR=%s]' % multilineOpen + multiline_label2 + '[/COLOR]'
				else:
					if debrid:
						if 'torrent' in source.lower():
							item['label'] = singleTorrentLeading + label + singleTorrentClosing
							item['multiline_label'] = multi1TorrentLeading + multiline_label1 + multi1TorrentClosing + multi2TorrentLeading + multiline_label2 + multi2TorrentClosing
						else:
							item['label'] = singlePremiumLeading + label + singlePremiumClosing
							item['multiline_label'] = multi1PremiumLeading + multiline_label1 + multi1PremiumClosing + multi2PremiumLeading + multiline_label2 + multi2PremiumClosing
					else:
						item['label'] = label
						item['multiline_label'] = multiline_label1 + multi1RegularLeading + multiline_label2 + multi1RegularClosing
			except:
				pass
		enableExtraInfo = self.scraper_settings['extra_info']
		enableShowFilenames = self.scraper_settings['show_filenames']
		multiLineHighlight = self.scraper_settings['multiline_highlight']
		highlightType = self.scraper_settings['highlight_type']
		if highlightType == '1':
			highlight_4K = self.scraper_settings['highlight_4K']
			highlight_1080p = self.scraper_settings['highlight_1080p']
			highlight_720p = self.scraper_settings['highlight_720p']
			highlight_SD = self.scraper_settings['highlight_SD']
		else:
			premiumHighlight = self.scraper_settings['premium_highlight']
			torrentHighlight = self.scraper_settings['torrent_highlight']
			# Single Line...
			# Torrent...
			if torrentHighlight == '':
				singleTorrentLeading = ''
				singleTorrentClosing = ''
			else:
				singleTorrentLeading = '[COLOR=%s]' % torrentHighlight
				singleTorrentClosing = '[/COLOR]'
			# Premium...
			if premiumHighlight == '':
				singlePremiumLeading = ''
				singlePremiumClosing = ''
			else:
				singlePremiumLeading = '[COLOR=%s]' % premiumHighlight
				singlePremiumClosing = '[/COLOR]'
			# Multiline...
			# Torrent...
			if torrentHighlight == '':
				multi1TorrentLeading = ''
				multi1TorrentClosing = ''
			else:
				multi1TorrentLeading = '[COLOR=%s]' % torrentHighlight
				multi1TorrentClosing = '[/COLOR]'
			if multiLineHighlight == '':
				multi2TorrentLeading = multi1TorrentLeading
				multi2TorrentClosing = multi1TorrentClosing
			else:
				multi2TorrentLeading = '[COLOR=%s]' % multiLineHighlight
				multi2TorrentClosing = '[/COLOR]'
			# Premium...
			if premiumHighlight == '':
				multi1PremiumLeading = ''
				multi1PremiumClosing = ''
			else:
				multi1PremiumLeading = '[COLOR=%s]' % premiumHighlight
				multi1PremiumClosing = '[/COLOR]'
			if multiLineHighlight == '':
				multi2PremiumLeading = multi1PremiumLeading
				multi2PremiumClosing = multi1PremiumClosing
			else:
				multi2PremiumLeading = '[COLOR=%s]' % multiLineHighlight
				multi2PremiumClosing = '[/COLOR]'
			# Regular...
			if multiLineHighlight == '':
				multi1RegularLeading = ''
				multi1RegularClosing = ''
			else:
				multi1RegularLeading = '[COLOR=%s]' % multiLineHighlight
				multi1RegularClosing = '[/COLOR]'
		threads = []
		for i in self.sources: threads.append(Thread(target=_processLabels, args=(i,)))
		[i.start() for i in threads]
		[i.join() for i in threads]
		self.sources = [i for i in self.sources if 'label' in i and 'multiline_label' in i]

	def sourcesUpdate(self, source, sources):
		def _addInfoandName(i):
			url = i['url']
			if 'name' in i: URLName = clean_file_name(i['name']).replace('html', ' ').replace('+', ' ')
			else: URLName = external_source_utils.getFileNameMatch(self.info['title'], url, i.get('name', None))
			extraInfo = external_source_utils.getFileType(url)
			return _updateSource(i, {'extraInfo': extraInfo, 'URLName': URLName})
		def _updateQuality(i):
			current_quality = i['quality']
			if 'name' in i: release_name = i['name']
			else: release_name = i['url']
			quality = external_source_utils.update_release_quality(release_name, current_quality)
			i.update({'quality': quality})
		def _getSize(i):
			size = 0
			size_label = None
			try:
				size = i['size']
				size_label = '%.2f GB' % size
			except:
				pass
			return _updateSource(i, {'external_size': size, 'size_label': size_label, 'size': 0})
		def _lowercase_hash(i):
			if 'hash' in i:
				_hash = i['hash'].lower()
				i['hash'] = _hash
		def _updateSource(i, update_dict):
			i.update(update_dict)
		source = byteify(source)
		for i in sources:
			update_dict = {'provider': source, 'external': True, 'scrape_provider': self.scrape_provider}
			_updateSource(i, update_dict)
			_getSize(i)
			_addInfoandName(i)
			_updateQuality(i)
			_lowercase_hash(i)
		return sources
	
	def sourcesQualityCount(self, sources=None):
		if sources:
			for i in sources:
				quality = i['quality']
				if quality == '4K': self.source_4k += 1
				elif quality in ['1440p', '1080p']: self.source_1080 += 1
				elif quality in ['720p', 'HD']: self.source_720 += 1
				elif quality in ['SD', 'CAM', 'TELE', 'SCR']: self.source_sd += 1
				self.total += 1
		else:
			for i in self.internal_sources:
				if i in self.processed_internal_sources: continue
				quality = i['quality']
				if quality == '4K': self.internalSources4K += 1
				elif quality in ['1440p', '1080p']: self.internalSources1080p += 1
				elif quality in ['720p', 'HD']: self.internalSources720p += 1
				elif quality in ['SD', 'CAM', 'TELE', 'SCR']: self.internalSourcesSD += 1
				self.internalSourcesTotal += 1
				self.processed_internal_sources.append(i)

	def sourcesRemoveDuplicates(self, sources):
		uniqueURLs = set()
		uniqueHashes = set()
		for source in sources:
			try:
				if self.removeDuplicates == 'true':
					if source['url'] not in uniqueURLs:
						uniqueURLs.add(source['url'])
						if self.removeDuplicatesTorrents == 'true':
							if 'hash' in source:
								if source['hash'] not in uniqueHashes:
									uniqueHashes.add(source['hash'])
									yield source
								else: self.duplicates += 1
							else: yield source
						else: yield source
					else: self.duplicates += 1
				elif self.removeDuplicatesTorrents == 'true':
					if 'hash' in source:
						if source['hash'] not in uniqueHashes:
							uniqueHashes.add(source['hash'])
							yield source
						else:
							self.duplicates += 1
					else: yield source
				else: yield source
			except:
				yield source
	
	def sourcesProcessTorrents(self, torrentSources):
		def _return_unchecked_sources():
			try: self.progressDialog.close()
			except Exception: pass
			del self.progressDialog
			for i in torrentSources: i.update({'cache_provider': 'Unchecked'})
			return torrentSources
		if len(torrentSources) == 0:
			try: self.progressDialog.close()
			except Exception: pass
			return torrentSources
		hashList = []
		for i in torrentSources:
			try:
				infoHash = str(i['hash'])
				if len(infoHash) == 40: hashList.append(infoHash)
				else: torrentSources.remove(i)
			except: torrentSources.remove(i)
		if len(torrentSources) == 0:
			try: self.progressDialog.close()
			except Exception: pass
			return torrentSources
		if self.torrentCheckCache == 'false': return _return_unchecked_sources()
		if len(self.debrid_enabled) == 0: return _return_unchecked_sources()
		from modules.debrid import DebridCheck
		try:
			xbmc.sleep(100)
			DBCheck = DebridCheck()
			torrent_results = []
			hashList = list(set(hashList))
			xbmc.sleep(100)
			cached_hashes = DBCheck.run(hashList, self.suppress_notifications, self.debrid_enabled, self.progressDialog)
			del self.progressDialog
			for item in [('Real-Debrid', 'rd_cached_hashes'), ('Premiumize.me', 'pm_cached_hashes'), ('AllDebrid', 'ad_cached_hashes')]:
				if item[0] in self.debrid_enabled:
					torrent_results.extend([dict(i, **{'cache_provider':item[0]}) for i in torrentSources if i['hash'] in cached_hashes[item[1]]])
					if self.uncachedTorrents == 'true':
						torrent_results.extend([dict(i, **{'cache_provider':'Uncached %s' % item[0]}) for i in torrentSources if not i['hash'] in cached_hashes[item[1]]])
			return torrent_results
		except:
			notification(ls(32574), time=2500)
			return _return_unchecked_sources()

	def sourcesStats(self, sourceDict, sources):
		try:
			insert_list = []
			all_sources = [i[0] for i in sourceDict]
			working_scrapers = sorted(list(set([i['provider'] for i in sources])))
			non_working_scrapers = sorted([i for i in all_sources if not i in working_scrapers])
			dbcon = database.connect(self.providerDatabase, timeout=self.database_timeout)
			dbcur = dbcon.cursor()
			dbcur.execute('''PRAGMA synchronous = OFF''')
			dbcur.execute('''PRAGMA journal_mode = OFF''')
			dbcur.execute("SELECT * FROM scr_perf")
			scraper_stats = dbcur.fetchall()
			if scraper_stats != []:
				for i in scraper_stats:
					try:
						scraper, success, fail = str(i[0]), i[1], i[2]
						if scraper in working_scrapers:
							insert_list.append((scraper, success+1, fail))
							working_scrapers.remove(scraper)
						else:
							insert_list.append((scraper, success, fail+1))
							non_working_scrapers.remove(scraper)
					except: pass
			if len(working_scrapers) > 0:
				for scraper in working_scrapers:
					insert_list.append((scraper, 1, 0))
			if len(non_working_scrapers) > 0:
				for scraper in non_working_scrapers:
					insert_list.append((scraper, 0, 1))
			dbcur.executemany("INSERT OR REPLACE INTO scr_perf VALUES (?, ?, ?)", insert_list)
			dbcon.commit()
			dbcon.close()
		except: pass

	def sourcesRemoveFailing(self):
		def _check_sources(item):
			if item[1] + item[2] >= threshold:
				if float(item[2])/2 >= float(item[1]):
					remove_sources.append(item[0])
		try:
			threads = []
			remove_sources = []
			try: threshold = int(__fen__.getSetting('failing_scrapers.threshold'))
			except: threshold = 25
			activeSources = [i[0] for i in self.sourceDict]
			scrapers = external_source_utils.external_scrapers_fail_stats()
			scrapers = [i for i in scrapers if i[0] in activeSources]
			for i in scrapers: threads.append(Thread(target=_check_sources, args=(i,)))
			[i.start() for i in threads]
			[i.join() for i in threads]
			if len(remove_sources) > 0:
				for i in remove_sources: __external__.setSetting('provider.%s' % i, 'false')
				self.sourceDict = [i for i in self.sourceDict if not i[0] in remove_sources]
				if not self.suppress_notifications: notification(ls(32680) % len(remove_sources), 2500)
		except: pass

	def internalResults(self):
		try: internal_sources = json.loads(window.getProperty('internal_sources_results'))
		except: internal_sources = []
		if len(internal_sources) == len(self.processed_internal_sources): return
		self.internal_sources.extend(internal_sources)
		self.sourcesQualityCount()

	def makeProgressDialog(self):
		if self.background: return
		if self.dialog_background: self.progressDialog = xbmcgui.DialogProgressBG()
		else: self.progressDialog = xbmcgui.DialogProgress()
		progressTitle = self.meta.get('rootname')
		self.progressDialog.create(progressTitle, '')
		self.progressDialog.update(0)
		self.progressDialog.update(0, ls(32678))

	def getConstants(self):
		show_busy_dialog()
		self.meta = json.loads(window.getProperty('fen_media_meta'))
		self.background = self.meta.get('background', False)
		self.dialog_background = self.meta.get('dialog_background', False)
		self.suppress_notifications = True if self.background or self.dialog_background else False
		external_source_utils.checkDatabase()
		self.providerDatabase = os.path.join(xbmc.translatePath(__fen__.getAddonInfo('profile')), "ext_providers3.db")
		self.hostprDict = ['1fichier.com', 'oboom.com', 'rapidgator.net', 'rg.to', 'uploaded.net', 'uploaded.to', 'uploadgig.com', 'ul.to',
						   'filefactory.com', 'nitroflare.com', 'turbobit.net', 'uploadrocket.net', 'multiup.org']
		self.hostcapDict = ['hugefiles.net', 'hugefiles.cc', 'vidup.me', 'vidup.tv', 'flashx.tv', 'flashx.to', 'flashx.sx', 'flashx.bz', 'flashx.cc', 'vshare.eu', 'vshare.io',
							'thevideo.me', 'vev.io', 'uptobox.com', 'uptostream.com', 'jetload.net', 'jetload.tv', 'jetload.to']
		self.hosthqDict = ['gvideo', 'google.com', 'thevideo.me', 'raptu.com', 'filez.tv', 'uptobox.com', 'uptostream.com', 'xvidstage.com', 'xstreamcdn.com', 'idtbox.com']
		self.hostblockDict = ['waaw.tv', 'hqq.watch', 'netu.tv', 'hqq.tv', 'waaw1.tv', 'netu.tv', 'movdivx.com', 'divxme.com', 'streamflv.com', 'speedvid.net',
							  'powvideo.net', 'powvideo.cc', 'estream.to', 'estream.nu', 'estream.xyz', 'openload.io', 'openload.co', 'oload.tv', 'oload.stream',
							  'oload.win', 'oload.download', 'oload.info', 'oload.icu', 'oload.fun', 'oload.space', 'oload.life', 'openload.pw', 'streamango.com',
							  'streamcherry.com', 'fruitstreams.com', 'fruitadblock.net', 'fruithosted.net', 'fruithosts.net', 'streamin.to', 'torba.se', 'rapidvideo.com',
							  'rapidvideo.is', 'rapidvid.to', 'youtube.com', 'facebook.com', 'twitch.tv', ]
		self.torrentCheckCache, self.uncachedTorrents = __fen__.getSetting('torrent.check.cache'), __fen__.getSetting('torrent.display.uncached')
		self.removeDuplicates, self.removeDuplicatesTorrents = __fen__.getSetting('remove.duplicates'), __fen__.getSetting('remove.duplicates.torrents')
		self.include_nondebrid, self.captcha, self.remove_failing_sources = __fen__.getSetting('include_nondebrid_results'), __fen__.getSetting('hosts.captcha'), __fen__.getSetting('remove.failing_scrapers')
		self.internalSourcesTotal, self.internalSources4K, self.internalSources1080p, self.internalSources720p, self.internalSourcesSD = (0 for _ in range(5))
		self.total, self.source_4k, self.source_1080, self.source_720, self.source_sd = (0 for _ in range(5))
		if self.debrid_enabled == []:
			en_DebridOnly = external_source_utils.scraperNames('en_DebridOnly')
			en_Torrent = external_source_utils.scraperNames('en_Torrent')
			total_debrid = en_DebridOnly + en_Torrent
			self.sourceDict = [i for i in self.sourceDict if not i[0] in total_debrid]
		try:
			self.hostDict = resolveurl.relevant_resolvers(order_matters=True)
			self.hostDict = [i.domains for i in self.hostDict if '*' not in i.domains]
			self.hostDict = [i.lower() for i in reduce(lambda x, y: x+y, self.hostDict)]
			self.hostDict = [x for y, x in enumerate(self.hostDict) if x not in self.hostDict[:y]]
		except Exception:
			self.hostDict = []
		if not self.progressDialog: self.makeProgressDialog()
		hide_busy_dialog()
