# -*- coding: utf-8 -*-
import xbmc, xbmcaddon, xbmcvfs, xbmcgui
import os
import re
try: from urlparse import urlparse
except ImportError: from urllib.parse import urlparse
try: from sqlite3 import dbapi2 as database
except Exception: from pysqlite2 import dbapi2 as database
from modules.utils import to_utf8, replace_html_codes, confirm_dialog
from modules.utils import local_string as ls
# from modules.utils import logger

__addon__ = xbmcaddon.Addon(id='plugin.video.fen')
__external__ = xbmcaddon.Addon(id='script.module.openscrapers')
data_path = xbmc.translatePath(__addon__.getAddonInfo('profile'))
database_path = os.path.join(data_path, "ext_providers3.db")
scraper_module_base_folder = os.path.join(xbmc.translatePath(__external__.getAddonInfo('path')), 'lib', 'openscrapers')

window = xbmcgui.Window(10000)

def sources():
	sourceDict = []
	try:
		provider = 'OpenScrapers'
		sourceFolder = getScraperFolder(provider)
		sourceFolderLocation = os.path.join(scraper_module_base_folder, sourceFolder)
		sourceSubFolders = ['en', 'en_DebridOnly', 'en_Torrent']
		path = 'openscrapers.sources_openscrapers.%s.%s'
		for item in sourceSubFolders:
			files = xbmcvfs.listdir(os.path.join(sourceFolderLocation, item))[1]
			for m in files:
				try:
					if not os.path.splitext(urlparse(m).path)[-1] == '.py':
						continue
					module_name = m.split('.')[0]
					if module_name == '__init__':
						continue
					if enabledCheck(module_name):
						module_path = path % (item, module_name)
						sourceDict.append((module_name, module_path))
				except: pass
	except: pass
	return sourceDict

def importSingleSource(source):
	sourceDict = []
	try:
		provider = 'OpenScrapers'
		sourceFolder = getScraperFolder(provider)
		sourceFolderLocation = os.path.join(scraper_module_base_folder, sourceFolder)
		sourceSubFolders = ['en', 'en_DebridOnly', 'en_Torrent']
		path = 'openscrapers.sources_openscrapers.%s.%s'
		for item in sourceSubFolders:
			files = xbmcvfs.listdir(os.path.join(sourceFolderLocation, item))[1]
			for m in files:
				if not os.path.splitext(urlparse(m).path)[-1] == '.py':
					continue
				module_name = m.split('.')[0]
				if module_name == source:
					module_path = path % (item, module_name)
					return module_path
	except: return None

def enabledCheck(module_name):
	if __external__.getSetting('provider.' + module_name) == 'true': return True
	return False

def enabledScrapersXML():
	import xml.etree.ElementTree as ET
	from modules.nav_utils import get_kodi_version
	kodi_version = get_kodi_version()
	enabled_scrapers = []
	root = ET.parse(os.path.join(xbmc.translatePath(__external__.getAddonInfo('profile')), 'settings.xml')).getroot()
	for item in root:
		setting_id = item.get('id')
		if setting_id.startswith('provider'):
			if kodi_version >= 18: setting_value = item.text
			else: setting_value = item.get('value')
			if setting_value == 'true':
				enabled_scrapers.append(setting_id.split('.')[1])
	return enabled_scrapers

def normalize(title):
	try:
		try: return title.decode('ascii').encode("utf-8")
		except: pass
		
		try: import unicodedata
		except ImportError: return
		title = u'%s' % obj
		title = ''.join(c for c in unicodedata.normalize('NFD', title) if unicodedata.category(c) != 'Mn')

		return str(title)
	except:
		return title

def getModuleProvider():
	moduleProvider = __external__.getSetting('module.provider')
	if moduleProvider in ('', None):
		__external__.setSetting('module.provider', 'OpenScrapers')
		moduleProvider = 'OpenScrapers'
	return moduleProvider

def deleteProviderCache(silent=False):
	try:
		if not xbmcvfs.exists(database_path): return 'failure'
		if not silent:
			if not confirm_dialog(): return 'cancelled'
		dbcon = database.connect(database_path)
		dbcur = dbcon.cursor()
		for i in ('rel_url', 'rel_src'): dbcur.execute("DELETE FROM %s" % i)
		dbcon.commit()
		dbcur.execute("VACUUM")
		dbcon.close()
		return 'success'
	except: return 'failure'

def checkDatabase():
	if not xbmcvfs.exists(data_path): xbmcvfs.mkdirs(data_path)
	dbcon = database.connect(database_path)
	dbcon.execute("""CREATE TABLE IF NOT EXISTS rel_url
					  (source text, imdb_id text, season text, episode text,
					  rel_url text, unique (source, imdb_id, season, episode)) 
				   """)
	dbcon.execute("""CREATE TABLE IF NOT EXISTS rel_src
					  (source text, imdb_id text, season text, episode text,
					  hosts text, added text, unique (source, imdb_id, season, episode)) 
				   """)
	dbcon.execute("""CREATE TABLE IF NOT EXISTS scr_perf
					  (source text, success integer, failure integer, unique (source)) 
				   """)
	dbcon.close()

def external_scrapers_fail_stats():
	checkDatabase()
	dbcon = database.connect(database_path)
	dbcur = dbcon.cursor()
	dbcur.execute("SELECT * FROM scr_perf")
	results = dbcur.fetchall()
	results = sorted([(str(i[0]), i[1], i[2]) for i in results], key=lambda k: k[2] - k[1], reverse=True)
	return results

def external_scrapers_disable():
	from modules.utils import multiselect_dialog
	dialog = xbmcgui.Dialog()
	scrapers = external_scrapers_fail_stats()
	try: scrapers = [i for i in scrapers if __external__.getSetting('provider.%s' % i[0]) == 'true']
	except: scrapers = []
	if not scrapers: return dialog.ok('Fen', ls(32581))
	scrapers_dialog = ['[B]%s[/B] | %s: %s | [COLOR=green]%s: %d[/COLOR] | [COLOR=red]%s: %d[/COLOR]' % (i[0].upper(), ls(32677).upper(), (i[1] + i[2]), ls(32576).upper(),i[1], ls(32490).upper(), i[2]) for i in scrapers]
	scraper_choice = multiselect_dialog(ls(32024), scrapers_dialog, scrapers)
	if not scraper_choice: return
	if confirm_dialog(): clear_database = True
	else: clear_database = False
	checkDatabase()
	dbcon = database.connect(database_path)
	dbcur = dbcon.cursor()
	for i in scraper_choice:
		if clear_database: dbcur.execute("DELETE FROM scr_perf WHERE source = ?", (i[0],))
		__external__.setSetting('provider.%s' % i[0], 'false')
	if clear_database:
		dbcon.commit()
	return dialog.ok('FEN', ls(32576))

def external_scrapers_reset_stats(silent=False):
	try:
		checkDatabase()
		if not silent:
			if not confirm_dialog(): return
		dbcon = database.connect(database_path)
		dbcur = dbcon.cursor()
		dbcur.execute("DELETE FROM scr_perf")
		dbcon.commit()
		dbcur.execute("VACUUM")
		dbcon.close()
		if silent: return
		return xbmcgui.Dialog().ok('FEN', ls(32576))
	except:
		if silent: return
		return xbmcgui.Dialog().ok('FEN', ls(32574))

def _ext_scrapers_notice(status):
	from modules.nav_utils import notification
	notification(status, 2500)

def toggle_all(folder, setting, silent=False):
	try:
		sourcelist = scraperNames(folder)
		for i in sourcelist:
			source_setting = 'provider.' + i
			__external__.setSetting(source_setting, setting)
		if silent: return
		return _ext_scrapers_notice(ls(32576))
	except:
		if silent: return
		return _ext_scrapers_notice(ls(32574))

def enable_disable_specific_all(folder):
	try:
		from modules.utils import multiselect_dialog
		enabled, disabled = scrapersStatus(folder)
		all_sources = sorted(enabled + disabled)
		preselect = [all_sources.index(i) for i in enabled]
		chosen = multiselect_dialog('Fen', [i.upper() for i in all_sources], all_sources, preselect)
		if not chosen: return
		for i in all_sources:
			if i in chosen: __external__.setSetting('provider.' + i, 'true')
			else: __external__.setSetting('provider.' + i, 'false')
		return _ext_scrapers_notice(ls(32576))
	except: return _ext_scrapers_notice(ls(32574))

def scrapersStatus(folder='all_eng'):
	providers = scraperNames(folder)
	enabled = [i for i in providers if __external__.getSetting('provider.' + i) == 'true']
	disabled = [i for i in providers if i not in enabled]
	return enabled, disabled

def scraperNames(folder):
	providerList = []
	provider = 'OpenScrapers'
	sourceFolder = getScraperFolder(provider)
	sourceFolderLocation = os.path.join(scraper_module_base_folder, sourceFolder)
	sourceSubFolders = ['en', 'en_DebridOnly', 'en_Torrent']
	if folder != 'all_eng':
		sourceSubFolders = [i for i in sourceSubFolders if i == folder]
	for item in sourceSubFolders:
		files = xbmcvfs.listdir(os.path.join(sourceFolderLocation, item))[1]
		for m in files:
			if not os.path.splitext(urlparse(m).path)[-1] == '.py':
				continue
			module_name = m.split('.')[0]
			if module_name == '__init__':
				continue
			providerList.append(module_name)
	return providerList

def getScraperFolder(scraper_source):
	sourceSubFolders = ['en', 'en_DebridOnly', 'en_Torrent']
	try: sourceFolder = [i for i in sourceSubFolders if scraper_source.lower() in i.lower()][0]
	except: sourceFolder = setDefault()
	return sourceFolder

def setDefault():
	__external__.setSetting('module.provider', 'OpenScrapers')
	sourceFolder = 'sources_openscrapers'
	return sourceFolder

def getFileNameMatch(title, url, name=None):
	from modules.utils import clean_file_name
	if name: return clean_file_name(name)
	try: from urllib import unquote
	except ImportError: from urllib.parse import unquote
	from modules.utils import clean_title, normalize
	title_match = None
	try:
		title = clean_title(normalize(title))
		name_url = unquote(url)
		try: file_name = clean_title(name_url.split('/')[-1])
		except: return title_match
		test = name_url.split('/')
		for item in test:
			test_url = str(clean_title(normalize(item)))
			if title in test_url:
				title_match = clean_file_name(str(item)).replace('html', ' ').replace('+', ' ')
				break
	except:
		pass
	return title_match

def update_release_quality(release_name, current_quality):
	quality = current_quality
	try:
		if release_name is None: return current_quality
		try: release_name = release_name.encode('utf-8')
		except: pass
		release_name = release_name.upper()
		fmt = re.sub('(.+)(\d{4}|S\d+E\d+)(\.|\)\.|\)|\]\.|\]|\s)', '', release_name)
		fmt = fmt.lower()
		if any(i in ['dvdscr', 'r5', 'r6'] for i in fmt): quality = 'SCR'
		elif any(i in ['camrip', 'hdcam', 'dvdcam', 'cam'] for i in fmt): quality = 'CAM'
		elif any(i in ['tc', 'tsrip', 'hdts', 'dvdts', 'hdtc', 'telecine', 'tc720p', 'tc720', 'hd-tc', 'hd-ts', 'telesync', 'ts'] for i in fmt): quality = 'TELE'
		elif '2160p' in fmt: quality = '4K'
		elif '2160' in fmt: quality = '4K'
		elif 'uhd' in fmt: quality = '4K'
		elif '4k' in fmt: quality = '4K'
		elif '1080p' in fmt: quality = '1080p'
		elif '1080' in fmt: quality = '1080p'
		elif 'fullhd' in fmt: quality = '1080p'
		elif '720p' in fmt: quality = '720p'
		elif 'hdtv' in fmt: quality = 'SD'
		elif '480p' in fmt: quality = 'SD'
		elif '480' in fmt: quality = 'SD'
		elif '576p' in fmt: quality = 'SD'
		elif '576' in fmt: quality = 'SD'
	except: pass
	return quality

def getFileType(url):
	try:
		url = replace_html_codes(url)
		url = re.sub('[^A-Za-z0-9]+', ' ', url)
		url = url.encode('utf-8')
		url = str(url.lower())
	except:
		url = str(url.lower())
	info = ''
	if any(i in url for i in [' h 265 ', ' h265 ', ' x265 ', ' hevc ']):
		info += '[B]HEVC[/B] |'
	if ' hi10p ' in url:
		info += ' HI10P |'
	if ' 10bit ' in url:
		info += ' 10BIT |'
	if any(i in url for i in [' bluray ', ' blu ray ']):
		info += ' BLURAY |'
	if any(i in url for i in [' bd r ', ' bdr ', ' bd rip ', ' bdrip ', ' br rip ', ' brrip ']):
		info += ' BD-RIP |'
	if ' remux ' in url:
		info += ' REMUX |'
	if any(i in url for i in [' dvdrip ', ' dvd rip ']):
		info += ' DVD-RIP |'
	if any(i in url for i in [' dvd ', ' dvdr ', ' dvd r ']):
		info += ' DVD |'
	if any(i in url for i in [' webdl ', ' web dl ', ' web ', ' web rip ', ' webrip ']):
		info += ' WEB |'
	if ' hdtv ' in url:
		info += ' HDTV |'
	if ' sdtv ' in url:
		info += ' SDTV |'
	if any(i in url for i in [' hdrip ', ' hd rip ']):
		info += ' HDRIP |'
	if any(i in url for i in [' uhdrip ', ' uhd rip ']):
		info += ' UHDRIP |'
	if ' xvid ' in url:
		info += ' XVID |'
	if ' avi ' in url:
		info += ' AVI |'
	if ' hdr ' in url:
		info += ' HDR |'
	if ' imax ' in url:
		info += ' IMAX |'
	if ' ac3 ' in url:
		info += ' AC3 |'
	if ' eac3 ' in url:
		info += ' EAC3 |'
	if ' aac ' in url:
		info += ' AAC |'
	if any(i in url for i in [' dd ', ' dolby ', ' dolbydigital ', ' dolby digital ']):
		info += ' DD |'
	if any(i in url for i in [' truehd ', ' true hd ']):
		info += ' TRUEHD |'
	if ' atmos ' in url:
		info += ' ATMOS |'
	if any(i in url for i in [' ddplus ', ' dd plus ', ' ddp ']):
		info += ' DD+ |'
	if ' dts ' in url:
		info += ' DTS |'
	if any(i in url for i in [' hdma ', ' hd ma ']):
		info += ' HD.MA |'
	if any(i in url for i in [' hdhra ', ' hd hra ']):
		info += ' HD.HRA |'
	if any(i in url for i in [' dtsx ', ' dts x ']):
		info += ' DTS:X |'
	if ' dd5 1 ' in url:
		info += ' DD | 5.1 |'
	if any(i in url for i in [' 5 1 ', ' 6ch ']):
		info += ' 5.1 |'
	if any(i in url for i in [' 7 1 ', ' 8ch ']):
		info += ' 7.1 |'
	if any (i in url for i in [' subs ', ' subbed ', ' sub ']):
		info += ' SUBS |'
	if any (i in url for i in [' dub ', ' dubbed ', ' dublado ']):
		info += ' DUB |'
	info = info.rstrip('|')
	return info



