# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin, xbmcaddon
from sys import argv
from apis.tmdb_api import tmdb_media_images
from modules.nav_utils import build_url, add_dir
from modules.utils import local_string as ls
# from modules.utils import logger

__addon_id__ = 'plugin.video.fen'
__addon__ = xbmcaddon.Addon(id=__addon_id__)
__handle__ = int(argv[1])

image_base = 'http://image.tmdb.org/t/p/%s%s'
icon = __addon__.getAddonInfo('icon')
fanart = __addon__.getAddonInfo('fanart')

def media_image_results(db_type, tmdb_id, image_type):
	results = tmdb_media_images(db_type, tmdb_id)
	count = 0
	for item in results[image_type]:
		count += 1
		cm = []
		image_url = image_base % ('original', item['file_path'])
		name = '%03d_%sx%s' % (count, item['height'], item['width'])
		url_params = {'mode': 'show_image', 'image_url': image_url}
		down_file_params = {'mode': 'download_file', 'name': name, 'url': image_url, 'db_type': 'image', 'image': icon}
		url = build_url(url_params)
		cm.append((ls(32747),'RunPlugin(%s)' % build_url(down_file_params)))
		listitem = xbmcgui.ListItem(name)
		listitem.addContextMenuItems(cm)
		listitem.setArt({'icon': image_url, 'poster': image_url, 'thumb': image_url, 'fanart': fanart, 'banner': image_url})
		xbmcplugin.addDirectoryItem(__handle__, url, listitem, isFolder=False)
	xbmcplugin.setContent(__handle__, 'files')
	xbmcplugin.endOfDirectory(__handle__)

def imdb_image_results(imdb_id, page_no, count):
	from apis.imdb_api import imdb_images
	image_info, next_page = imdb_images(imdb_id, page_no)
	count = int(count)
	for item in image_info:
		try:
			count += 1
			cm = []
			image_thumb = item['thumb']
			image_url = item['image']
			name = '%03d_%s' % (count, item['title'])
			url_params = {'mode': 'show_image', 'image_url': image_url}
			down_file_params = {'mode': 'download_file', 'name': name, 'url': image_url, 'db_type': 'image', 'image': icon}
			url = build_url(url_params)
			cm.append((ls(32747),'RunPlugin(%s)' % build_url(down_file_params)))
			listitem = xbmcgui.ListItem(name)
			listitem.addContextMenuItems(cm)
			listitem.setArt({'icon': image_thumb, 'poster': image_thumb, 'thumb': image_thumb, 'fanart': fanart, 'banner': image_thumb})
			xbmcplugin.addDirectoryItem(__handle__, url, listitem, isFolder=False)
		except: pass
	if len(image_info) == 48: add_dir({'mode': 'imdb_image_results', 'imdb_id': imdb_id, 'page_no': int(page_no)+1, 'count': count}, ls(32799), iconImage='item_next.png')
	xbmcplugin.setContent(__handle__, 'files')
	xbmcplugin.endOfDirectory(__handle__)

def show_image(image_url=None):
	if not image_url:
		try: from urlparse import parse_qsl
		except ImportError: from urllib.parse import parse_qsl
		params = dict(parse_qsl(argv[2].replace('?','')))
		image_url = params['image_url']
	xbmc.executebuiltin('ShowPicture(%s)' % image_url)
