# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin, xbmcaddon
from sys import argv
from apis.tmdb_api import tmdb_media_images
from modules.nav_utils import build_url, add_dir, setView
from modules.utils import local_string as ls
# from modules.utils import logger

__addon_id__ = 'plugin.video.fen'
__addon__ = xbmcaddon.Addon(id=__addon_id__)
__handle__ = int(argv[1])

image_base = 'http://image.tmdb.org/t/p/%s%s'
icon = __addon__.getAddonInfo('icon')
fanart = __addon__.getAddonInfo('fanart')

def media_image_results(db_type, tmdb_id, image_type):
	results = tmdb_media_images(db_type, tmdb_id)
	count = 0
	for item in results[image_type]:
		count += 1
		cm = []
		image_url = image_base % ('original', item['file_path'])
		thumb_url = image_base % ('w185', item['file_path'])
		name = '%sx%s_%03d' % (item['height'], item['width'], count)
		url_params = {'mode': 'show_image', 'image_url': image_url}
		down_file_params = {'mode': 'download_file', 'name': name, 'url': (image_url, thumb_url), 'db_type': 'image', 'image': icon}
		url = build_url(url_params)
		cm.append((ls(32747),'RunPlugin(%s)' % build_url(down_file_params)))
		listitem = xbmcgui.ListItem(name)
		listitem.addContextMenuItems(cm)
		listitem.setArt({'icon': thumb_url, 'poster': thumb_url, 'thumb': thumb_url, 'fanart': fanart, 'banner': thumb_url})
		xbmcplugin.addDirectoryItem(__handle__, url, listitem, isFolder=False)
	xbmcplugin.setContent(__handle__, 'images')
	xbmcplugin.endOfDirectory(__handle__)
	setView('view.images', 'images')

def imdb_image_results(imdb_id, page_no, count):
	from apis.imdb_api import imdb_images
	image_info, next_page = imdb_images(imdb_id, page_no)
	count = int(count)
	for item in image_info:
		try:
			count += 1
			cm = []
			thumb_url = item['thumb']
			image_url = item['image']
			name = '%s_%03d' % (item['title'], count)
			url_params = {'mode': 'show_image', 'image_url': image_url}
			down_file_params = {'mode': 'download_file', 'name': name, 'url': (image_url, thumb_url), 'db_type': 'image', 'image': icon}
			url = build_url(url_params)
			cm.append((ls(32747),'RunPlugin(%s)' % build_url(down_file_params)))
			listitem = xbmcgui.ListItem(name)
			listitem.addContextMenuItems(cm)
			listitem.setArt({'icon': thumb_url, 'poster': thumb_url, 'thumb': thumb_url, 'fanart': fanart, 'banner': thumb_url})
			xbmcplugin.addDirectoryItem(__handle__, url, listitem, isFolder=False)
		except: pass
	if len(image_info) == 48: add_dir({'mode': 'imdb_image_results', 'imdb_id': imdb_id, 'page_no': int(page_no)+1, 'count': count}, ls(32799), iconImage='item_next.png')
	xbmcplugin.setContent(__handle__, 'images')
	xbmcplugin.endOfDirectory(__handle__)
	setView('view.images', 'images')

def browser_image(folder_path):
	import xbmcvfs
	import os
	files = xbmcvfs.listdir(folder_path)[1]
	files = sorted(files)
	thumbs_path = os.path.join(folder_path, '.thumbs')
	thumbs = xbmcvfs.listdir(thumbs_path)[1]
	thumbs = sorted(thumbs)
	for item in files:
		try:
			cm = []
			image_url = os.path.join(folder_path, item)
			try:
				thumb_url = [i for i in thumbs if i == item][0]
				thumb_url = os.path.join(thumbs_path, thumb_url)
			except:
				thumb_url = image_url
			url_params = {'mode': 'show_image', 'image_url': image_url}
			url = build_url(url_params)
			cm.append(('[B]%s[/B]' % ls(32785),'RunPlugin(%s)' % build_url({'mode': 'delete_image', 'image_url': image_url, 'thumb_url': thumb_url})))
			listitem = xbmcgui.ListItem(item)
			listitem.addContextMenuItems(cm)
			listitem.setArt({'icon': thumb_url, 'poster': thumb_url, 'thumb': thumb_url, 'fanart': fanart, 'banner': thumb_url})
			xbmcplugin.addDirectoryItem(__handle__, url, listitem, isFolder=False)
		except: pass
	xbmcplugin.setContent(__handle__, 'images')
	xbmcplugin.endOfDirectory(__handle__)
	setView('view.images', 'images')


def show_image(image_url=None):
	if not image_url:
		try: from urlparse import parse_qsl
		except ImportError: from urllib.parse import parse_qsl
		params = dict(parse_qsl(argv[2].replace('?','')))
		image_url = params['image_url']
	xbmc.executebuiltin('ShowPicture(%s)' % image_url)

def delete_image(image_url=None, thumb_url=None):
	if not xbmcgui.Dialog().yesno('Fen', ls(32580)): return
	import xbmcvfs
	from modules.nav_utils import notification
	if not image_url:
		try: from urlparse import parse_qsl
		except ImportError: from urllib.parse import parse_qsl
		params = dict(parse_qsl(argv[2].replace('?','')))
		image_url = params['image_url']
		thumb_url = params['thumb_url']
	xbmcvfs.delete(thumb_url)
	try: xbmcvfs.delete(image_url)
	except: return notification(ls(32490), 1500)
	xbmc.executebuiltin('Container.Refresh')
	return notification(ls(32576), 1500)

