import xbmc, xbmcgui, xbmcvfs
import os
import time
import xml.etree.ElementTree as ET
from datetime import datetime, timedelta
import _strptime  # fix bug in python import
from modules.external_source_utils import cleanProviderDatabase, checkDatabase
from modules.setting_reader import get_setting, set_setting, make_settings_dict
from modules.nav_utils import get_kodi_version
from modules.utils import gen_file_hash, local_string
from modules import settings
# from modules.utils import logger

window = xbmcgui.Window(10000)

monitor = xbmc.Monitor()

class CheckSettingsFile():
	def run(self):
		profile_dir = xbmc.translatePath('special://userdata/addon_data/plugin.video.fen')
		if not xbmcvfs.exists(profile_dir): xbmcvfs.mkdirs(profile_dir)
		settings_xml = os.path.join(profile_dir, 'settings.xml')
		if not xbmcvfs.exists(settings_xml):
			__addon__ = settings.addon()
			addon_version = __addon__.getAddonInfo('version')
			__addon__.setSetting('version_number', addon_version)
		return

class SettingsMonitor(xbmc.Monitor):
	def __init__ (self):
		xbmc.Monitor.__init__(self)
		xbmc.log("[FEN] Settings Monitor Service Starting...", 2)

	def onSettingsChanged(self):
		window.clearProperty('fen_settings')
		xbmc.sleep(50)
		refreshed = make_settings_dict()

class ReuseLanguageInvokerCheck:
	def run(self):
		xbmc.log("[FEN] ReuseLanguageInvokerCheck Service Starting...", 2)
		if get_kodi_version() < 18: return
		xbmc.sleep(2000)
		addon_dir = xbmc.translatePath('special://home/addons/plugin.video.fen')
		addon_xml = os.path.join(addon_dir, 'addon.xml')
		tree = ET.parse(addon_xml)
		root = tree.getroot()
		current_addon_setting = get_setting('reuse_language_invoker', 'true')
		try: current_xml_setting = [str(i.text) for i in root.iter('reuselanguageinvoker')][0]
		except: return xbmc.log("[FEN] Finished ReuseLanguageInvokerCheck Service", 2)
		if current_xml_setting == current_addon_setting:
			return xbmc.log("[FEN] Finished ReuseLanguageInvokerCheck Service", 2)
		if xbmcgui.Dialog().yesno('Fen', local_string(33021)):
			for item in root.iter('reuselanguageinvoker'):
				item.text = current_addon_setting
				hash_start = gen_file_hash(addon_xml)
				tree.write(addon_xml)
				hash_end = gen_file_hash(addon_xml)
				xbmc.log("[FEN] Finished ReuseLanguageInvokerCheck Service", 2)
				if hash_start != hash_end: return xbmcgui.Dialog().ok('Fen', local_string(33020))
				else: xbmcgui.Dialog().ok('Fen', local_string(32574))
		return xbmc.log("[FEN] Finished ReuseLanguageInvokerCheck Service", 2)

class AutoRun:
	def run(self):
		try:
			xbmc.log("[FEN] Autostart Service Starting...", 2)
			if settings.auto_start_fen(): xbmc.executebuiltin('RunAddon(plugin.video.fen)')
			xbmc.log("[FEN] Finished Autostart Service", 2)
			return
		except: return

class ClearSubs:
	def run(self):
		xbmc.log("[FEN] Clear Subtitles Service Starting...", 2)
		if get_setting('subtitles.clear_on_start') == 'true':
			subtitle_path = xbmc.translatePath('special://temp/')
			files = xbmcvfs.listdir(subtitle_path)[1]
			for i in files:
				try:
					if i.startswith('FENSubs_'): xbmcvfs.delete(os.path.join(subtitle_path, i))
				except: pass
		xbmc.log("[FEN] Finished Clear Subtitles Service...", 2)

class ClearTraktServices:
	def run(self):
		xbmc.log("[FEN] Trakt Service Starting...", 2)
		if settings.refresh_trakt_on_startup():
			try:
				from modules.trakt_cache import clear_cache_on_startup
				clear_cache_on_startup()
			except: pass
		if settings.sync_fen_watchstatus():
			try:
				from apis.trakt_api import sync_watched_trakt_to_fen
				sync_watched_trakt_to_fen(dialog=False)
			except: pass
		xbmc.log("[FEN] Finished Trakt Service...", 2)

class SubscriptionsUpdater:
	def run(self):
		xbmc.log("[FEN] Subscription service starting...", 2)
		hours = settings.subscription_timer()
		while not monitor.abortRequested():
			if settings.subscription_update():
				try:
					next_run  = datetime.fromtimestamp(time.mktime(time.strptime(get_setting('service_time'), "%Y-%m-%d %H:%M:%S")))
					now = datetime.now()
					if now > next_run:
						if xbmc.Player().isPlaying() == False:
							if xbmc.getCondVisibility('Library.IsScanningVideo') == False:
								monitor.waitForAbort(3)
								xbmc.log("[FEN] Updating video subscriptions", 2)
								xbmc.executebuiltin('RunPlugin(plugin://plugin.video.fen/?&mode=update_subscriptions)')
								monitor.waitForAbort(0.5)
								if get_setting('subsciptions.update_type') == '1':
									next_update = datetime.now() + timedelta(hours=24)
									next_update = next_update.strftime('%Y-%m-%d') + ' %s:00' % get_setting('subscriptions_update_label2')
								else:
									next_update = str(now + timedelta(hours=hours)).split('.')[0]
								set_setting('service_time', next_update)
								monitor.waitForAbort(0.5)
								xbmc.log("[FEN] Subscriptions updated. Next run at " + get_setting('service_time'), 2)
								monitor.waitForAbort(3)
						else:
							xbmc.log("[FEN] Player is running, waiting until finished", 2)
				except: pass
			monitor.waitForAbort(30)

settings_monitor = SettingsMonitor()

CheckSettingsFile().run()
ReuseLanguageInvokerCheck().run()
AutoRun().run()
ClearSubs().run()
ClearTraktServices().run()
SubscriptionsUpdater().run()
settings_monitor.waitForAbort()
