# -*- coding: utf-8 -*-
import xbmcgui, xbmcplugin
from sys import argv
from threading import Thread
from modules.nav_utils import setView
from indexers.tvshows import build_episode
from metadata import tvshow_meta, retrieve_user_info, check_meta_database
from modules.in_progress import get_in_progress_episodes
from modules.nav_utils import external_browse
from modules.utils import get_datetime, make_thread_list
from modules import settings
# from modules.utils import logger

window = xbmcgui.Window(10000)

def build_in_progress_episode():
	import json
	from modules.indicators_bookmarks import get_watched_info_tv
	def _process_eps(item):
		meta = tvshow_meta('tmdb_id', item[0], meta_user_info)
		episode_item = {"season": int(item[1]), "episode": int(item[2]), "meta": meta, "adjust_hours": adjust_hours, "current_date": current_date,
						"date_format": date_format, "unaired_color": unaired_color, "watched_indicators": watched_indicators}
		listitem = build_episode(episode_item, watched_info, use_trakt, meta_user_info, display_title, is_widget)['listitem']
		xbmcplugin.addDirectoryItem(__handle__, listitem[0], listitem[1], isFolder=listitem[2])
	__handle__ = int(argv[1])
	check_meta_database()
	display_title = settings.single_ep_display_title()
	watched_info, use_trakt = get_watched_info_tv()
	meta_user_info = retrieve_user_info(window)
	adjust_hours = settings.date_offset()
	current_date = get_datetime()
	date_format = settings.single_ep_format()
	unaired_color = settings.unaired_color()
	is_widget = external_browse()
	watched_indicators = settings.watched_indicators()
	window.clearProperty('fen_fanart_error')
	episodes = get_in_progress_episodes()
	threads = list(make_thread_list(_process_eps, episodes, Thread))
	[i.join() for i in threads]
	xbmcplugin.setContent(__handle__, 'episodes')
	xbmcplugin.endOfDirectory(__handle__, cacheToDisc=True)
	setView('view.episode_lists', 'episodes')
	