# -*- coding: utf-8 -*-
import xbmcgui
from modules.nav_utils import build_url, execute_builtin
# from modules.utils import logger

class BaseDialog(xbmcgui.WindowXMLDialog):
	def __init__(self, *args):
		xbmcgui.WindowXMLDialog.__init__(self, args)
		self.closing_actions = [xbmcgui.ACTION_PARENT_DIR, xbmcgui.ACTION_PREVIOUS_MENU, xbmcgui.ACTION_STOP, xbmcgui.ACTION_NAV_BACK]
		self.selection_actions = [xbmcgui.ACTION_SELECT_ITEM, xbmcgui.ACTION_MOUSE_START]
		self.context_actions = [xbmcgui.ACTION_CONTEXT_MENU, xbmcgui.ACTION_MOUSE_RIGHT_CLICK, xbmcgui.ACTION_MOUSE_LONG_CLICK]
		self.info_actions = [xbmcgui.ACTION_SHOW_INFO]
		self.left_actions = [xbmcgui.ACTION_MOVE_LEFT]
		self.right_actions = [xbmcgui.ACTION_MOVE_RIGHT]
		self.up_actions = [xbmcgui.ACTION_MOVE_UP]
		self.down_actions = [xbmcgui.ACTION_MOVE_DOWN]

	def make_listitem(self):
		return xbmcgui.ListItem()

	def build_url(self, params):
		return build_url(params)

	def execute_code(self, command):
		return execute_builtin(command)
	
	def get_position(self, window_id):
		return self.getControl(window_id).getSelectedPosition()

	def make_contextmenu_item(self, label, action, params):
		cm_item = self.make_listitem()
		cm_item.setProperty('tikiskins.context.label', label)
		cm_item.setProperty('tikiskins.context.action', action % self.build_url(params))
		return cm_item
