# -*- coding: utf-8 -*-
import os
import json
from threading import Thread
import metadata
from windows.base_dialog import BaseDialog
from apis import tmdb_api as TMDb
from apis.imdb_api import people_get_imdb_id, imdb_videos
from indexers.images import Images
from indexers.dialogs import imdb_videos_choice, extras_menu
from modules.player import FenPlayer
from modules.settings import get_theme
from modules.kodi_utils import translate_path, notification
from modules.nav_utils import show_text
from modules.utils import calculate_age, local_string as ls
from modules.utils import logger

icon_directory = get_theme()
tmdb_image_base = 'https://image.tmdb.org/t/p/%s%s'
fanart = translate_path('special://home/addons/plugin.video.fen/fanart.png')
button_ids = [10, 11, 50]

class DialogPersonXML(BaseDialog):
	def __init__(self, *args, **kwargs):
		BaseDialog.__init__(self, args)
		self.set_starting_constants(kwargs)
		self.make_person_data(kwargs)
		self.make_biography()
		self.set_properties()

	def onInit(self):
		self.make_more_from('movie')

	def run(self):
		self.doModal()

	def onClick(self, controlID):
		if controlID in button_ids:
			if controlID == 10:
				Images().run({'mode': 'people_image_results', 'actor_name': self.person_name, 'actor_id': self.person_id,
							'actor_image': self.person_image, 'page_no': 1, 'rolling_count': 0})
			elif controlID == 11:
				Images().run({'mode': 'people_tagged_image_results', 'actor_name': self.person_name, 'actor_id': self.person_id,
							'actor_image': self.person_image, 'page_no': 1, 'rolling_count': 0})
			elif controlID == 50:
				show_text(self.person_name, self.person_biography, font_size='large')
		else: return self.onAction(self.selection_actions[0], controlID)

	def onAction(self, action, controlID=None):
		if action in self.selection_actions:
			try:
				selected = self.list_items_dict[controlID]
				current_index = self.get_position(controlID)
				chosen_listitem = selected['list'][current_index]
				chosen_var = chosen_listitem.getProperty(selected['property'])
			except: pass
			if controlID in (2050, 2051):
				if controlID == 2050: function, db_type = metadata.movie_meta, 'movie'
				else: function, db_type = metadata.tvshow_meta, 'tvshow'
				meta = function('tmdb_id', chosen_var, metadata.retrieve_user_info())
				if not meta: return
				extras_menu(db_type, json.dumps(meta), False)
			elif controlID == 2052:
				params = json.loads(chosen_var)
				chosen = imdb_videos_choice(params['videos'], params['thumb'])
				if not chosen: return
				FenPlayer().run(chosen, 'video')
				self.close()
		elif action in self.down_actions: self.create_list()
		elif action in self.up_actions: self.position -= 1
		elif action in self.closing_actions: self.close()

	def create_list(self):
		self.position += 1
		if self.position == 2:
			Thread(target=self.make_more_from, args=('tvshow',)).start()
		elif self.position == 3:
			Thread(target=self.make_imdb_videos).start()

	def make_biography(self):
		bio_info = TMDb.tmdb_people_biography(self.person_id)
		if bio_info.get('biography', None) in ('', None): bio_info = TMDb.tmdb_people_biography(self.person_id, 'en')
		gender = bio_info.get('gender')
		if gender == 1: self.person_gender = ls(32844)
		elif gender == 2: self.person_gender = ls(32843)
		else: self.person_gender = ''
		place_of_birth = bio_info.get('place_of_birth')
		if place_of_birth: self.person_place_of_birth = place_of_birth
		else: self.person_place_of_birth = ''
		biography = bio_info.get('biography')
		if biography: self.person_biography = biography
		else: self.person_biography = ls(32760)
		birthday = bio_info.get('birthday')
		if birthday: self.person_birthday = birthday
		else: self.person_birthday = ''
		deathday = bio_info.get('deathday')
		if deathday: self.person_deathday = deathday
		else: self.person_deathday = ''
		if self.person_deathday: self.person_age = calculate_age(self.person_birthday, '%Y-%m-%d', self.person_deathday)
		elif self.person_birthday: self.person_age = calculate_age(self.person_birthday, '%Y-%m-%d')
		else:self.person_age = ''

	def make_person_data(self, kwargs):
		if kwargs['query']:
			try:
				self.person_data = TMDb.tmdb_people_info(kwargs['query'])[0]
			except:
				notification(ls(32760))
				self.close()
			self.person_name = self.person_data['name']
			self.person_id = self.person_data['id']
			image_path = self.person_data['profile_path']
			if not image_path: self.person_image = os.path.join(icon_directory, 'genre_family.png')
			else: self.person_image = tmdb_image_base % ('h632', image_path)
		else:
			self.person_name = kwargs['actor_name']
			self.person_id = kwargs['actor_id']
			self.person_image = kwargs['actor_image']

	def make_more_from(self, db_type):
		def builder():
			used_ids = []
			for item in data:
				try:
					tmdb_id = item['id']
					if tmdb_id in used_ids: continue
					listitem = self.make_listitem()
					poster_path = item['poster_path']
					if not poster_path: thumbnail = os.path.join(icon_directory, 'box_office.png')
					else: thumbnail = tmdb_image_base % ('w780', poster_path)
					listitem.setProperty('tikiskins.person.more_from_%ss.name' % db_type, item[name_key])
					listitem.setProperty('tikiskins.person.more_from_%ss.thumbnail' % db_type, thumbnail)
					listitem.setProperty('tikiskins.person.more_from_%ss.tmdb_id' % db_type, str(tmdb_id))
					used_ids.append(tmdb_id)
					yield listitem
				except: pass
		try:
			if db_type == 'movie' and self.more_from_movies_made: return
			elif self.more_from_tvshows_made: return
			function = TMDb.tmdb_movies_actor_roles if db_type == 'movie' else TMDb.tmdb_tv_actor_roles
			name_key = 'title' if db_type == 'movie' else 'name'
			data = function(self.person_id)
			item_list = list(builder())
			if db_type == 'movie': _id = self.more_from_movies_id
			else: _id = self.more_from_tvshows_id
			self.setProperty('tikiskins.person.more_from_%ss.number' % db_type, '(x%02d)' % len(item_list))
			self.list_items_dict[_id] = {'list': item_list, 'property': 'tikiskins.person.more_from_%ss.tmdb_id' % db_type}
			control = self.getControl(_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.person.more_from_%ss.number' % db_type, '(x00)')
		if db_type == 'movie': self.more_from_movies_made = True
		else: self.more_from_tvshows_made = True

	def make_imdb_videos(self):
		def builder():
			for count, item in enumerate(data, 1):
				try:
					listitem = self.make_listitem()
					listitem.setProperty('tikiskins.person.imdb_videos.name', '%01d. %s' % (count, item['title']))
					listitem.setProperty('tikiskins.person.imdb_videos.thumbnail', item['poster'])
					listitem.setProperty('tikiskins.person.imdb_videos.params', json.dumps({'videos': json.dumps(item['videos']), 'thumb': item['poster']}))
					yield listitem
				except: pass
		if self.imdb_videos_made == True: return
		try:
			imdb_id = people_get_imdb_id(self.person_name, self.person_id)
			data = imdb_videos(imdb_id)
			item_list = list(builder())
			self.setProperty('tikiskins.person.imdb_videos.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.imdb_videos_id] = {'list': item_list, 'property': 'tikiskins.person.imdb_videos.params'}
			control = self.getControl(self.imdb_videos_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.person.imdb_videos.number', '(x00)')
		self.imdb_videos_made = True

	def set_starting_constants(self, kwargs):
		self.list_items_dict = {}
		self.position = 0
		self.more_from_movies_id, self.more_from_movies_made = 2050, False
		self.more_from_tvshows_id, self.more_from_tvshows_made = 2051, False
		self.imdb_videos_id, self.imdb_videos_made = 2052, False

	def set_properties(self):
		self.setProperty('tikiskins.person.name', self.person_name)
		self.setProperty('tikiskins.person.id', str(self.person_id))
		self.setProperty('tikiskins.person.image', self.person_image)
		self.setProperty('tikiskins.person.fanart', fanart)
		self.setProperty('tikiskins.person.gender', self.person_gender)
		self.setProperty('tikiskins.person.place_of_birth', self.person_place_of_birth)
		self.setProperty('tikiskins.person.biography', self.person_biography)
		self.setProperty('tikiskins.person.birthday', self.person_birthday)
		self.setProperty('tikiskins.person.deathday', self.person_deathday)
		self.setProperty('tikiskins.person.age', str(self.person_age))