# -*- coding: utf-8 -*-
import xbmcvfs
try: from sqlite3 import dbapi2 as database
except ImportError: from pysqlite2 import dbapi2 as database
from modules.kodi_utils import translate_path

def check_databases():
	data_path = translate_path('special://profile/addon_data/plugin.video.fen/')
	if not xbmcvfs.exists(data_path): xbmcvfs.mkdirs(data_path)

	# Navigator
	dbcon = database.connect(translate_path("special://profile/addon_data/plugin.video.fen/navigator.db"))
	dbcon.execute("""CREATE TABLE IF NOT EXISTS navigator
					  (list_name text, list_type text, list_contents text) 
				   """)
	dbcon.close()

	# Watched Status
	dbcon = database.connect(translate_path("special://profile/addon_data/plugin.video.fen/watched_status.db"))
	dbcon.execute("""CREATE TABLE IF NOT EXISTS progress
					  (db_type text, media_id text, season integer, episode integer,
					  resume_point text, curr_time text,
					  unique(db_type, media_id, season, episode)) 
				   """)
	dbcon.execute("""CREATE TABLE IF NOT EXISTS watched_status
					  (db_type text, media_id text, season integer,
					  episode integer, last_played text, title text,
					  unique(db_type, media_id, season, episode)) 
				   """)
	dbcon.execute("""CREATE TABLE IF NOT EXISTS exclude_from_next_episode
					  (media_id text, title text) 
				   """)
	dbcon.execute("""CREATE TABLE IF NOT EXISTS unwatched_next_episode
					  (media_id text) 
				   """)
	dbcon.close()

	# Favourites
	dbcon = database.connect(translate_path("special://profile/addon_data/plugin.video.fen/favourites.db"))
	dbcon.execute("""CREATE TABLE IF NOT EXISTS favourites
					  (db_type text, tmdb_id text, title text, unique (db_type, tmdb_id)) 
				   """)
	dbcon.close()

	# Views
	dbcon = database.connect(translate_path("special://profile/addon_data/plugin.video.fen/views.db"))
	dbcon.execute("""CREATE TABLE IF NOT EXISTS views
					  (view_type text, view_id text, unique (view_type)) 
				   """)
	dbcon.close()

	# Trakt
	dbcon = database.connect(translate_path("special://profile/addon_data/plugin.video.fen/fen_trakt2.db"))
	dbcon.execute("""CREATE TABLE IF NOT EXISTS fentrakt(
				id text unique, data text, expires INTEGER)
						""")
	dbcon.close()

	# Fen Cache
	dbcon = database.connect(translate_path("special://profile/addon_data/plugin.video.fen/fen_cache2.db"))
	dbcon.execute("""CREATE TABLE IF NOT EXISTS fencache(
				id text unique, data text, expires INTEGER)
						""")
	dbcon.close()

	# Meta Cache
	dbcon = database.connect(translate_path("special://profile/addon_data/plugin.video.fen/metacache3.db"))
	dbcon.execute("""CREATE TABLE IF NOT EXISTS metadata
					  (db_type text not null, tmdb_id text not null, imdb_id text, tvdb_id text,
					  meta text, expires integer, unique (db_type, tmdb_id))
				   """)
	dbcon.execute("""CREATE TABLE IF NOT EXISTS season_metadata
					  (tmdb_id text not null unique, meta text,
					  expires integer)
				   """)
	dbcon.execute("""CREATE TABLE IF NOT EXISTS function_cache
					 (string_id text not null, data text,
					 expires integer)
				  """)
	dbcon.close()

	# Debrid Cache
	dbcon = database.connect(translate_path("special://profile/addon_data/plugin.video.fen/debridcache.db"))
	dbcon.execute("""CREATE TABLE IF NOT EXISTS debrid_data
				  (hash text not null, debrid text not null, cached text, expires integer, unique (hash, debrid))
					""")
	dbcon.close()

	# External Providers Cache
	dbcon = database.connect(translate_path('special://profile/addon_data/plugin.video.fen/ext_providers3.db'))
	dbcon.execute("""CREATE TABLE IF NOT EXISTS rel_url
					  (source text, imdb_id text, season text, episode text,
					  rel_url text, unique (source, imdb_id, season, episode)) 
				   """)
	dbcon.execute("""CREATE TABLE IF NOT EXISTS rel_src
					  (source text, imdb_id text, season text, episode text,
					  hosts text, added text, unique (source, imdb_id, season, episode)) 
				   """)
	dbcon.execute("""CREATE TABLE IF NOT EXISTS scr_perf
					  (source text, success integer, failure integer, unique (source)) 
				   """)
	dbcon.close()
