# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcvfs
import json
try: from sqlite3 import dbapi2 as database
except: from pysqlite2 import dbapi2 as database

def container_update(params):
	from modules.nav_utils import build_url
	try: final_params = json.loads(params['final_params'])
	except: final_params = params['final_params']
	execute_builtin('Container.Update(%s)' % build_url(final_params))

def translate_path(path):
	try: translate = xbmcvfs.translatePath(path)
	except: translate = xbmc.translatePath(path)
	return translate

def sleep(time):
	return xbmc.sleep(time)

def execute_builtin(command):
	return xbmc.executebuiltin(command)

def get_kodi_version():
	return int(xbmc.getInfoLabel("System.BuildVersion")[0:2])

def get_video_database_path():
	db_paths = {17: '107', 18: '116', 19: '119'}
	database_path = translate_path('special://profile/Database/MyVideos%s.db' % db_paths[get_kodi_version()])
	return database_path

def show_busy_dialog():
	if get_kodi_version() >= 18: return execute_builtin('ActivateWindow(busydialognocancel)')
	else: return execute_builtin('ActivateWindow(busydialog)')

def hide_busy_dialog():
	if get_kodi_version() >= 18: return execute_builtin('Dialog.Close(busydialognocancel)')
	else: return execute_builtin('Dialog.Close(busydialog)')

def close_all_dialog():
	execute_builtin('Dialog.Close(all,true)')

def notification(line1, time=5000, icon=None, sound=False):
	if not icon: icon = translate_path('special://home/addons/plugin.video.fen/icon.png')
	xbmcgui.Dialog().notification('Fen', line1, icon, time, sound)

def external_browse():
	return 'fen' not in xbmc.getInfoLabel('Container.PluginName')

def setView(view_type, content='files'):
	if external_browse(): return
	views_db = translate_path('special://profile/addon_data/plugin.video.fen/views.db')
	if not content == 'addons': sleep(500)
	t = 0
	try:
		dbcon = database.connect(views_db)
		dbcur = dbcon.cursor()
		while not xbmc.getInfoLabel('Container.Content') == content:
			if external_browse(): return
			t += 1
			if t >= 20: return
			sleep(100)
		dbcur.execute("SELECT view_id FROM views WHERE view_type = ?", (str(view_type),))
		view_id = dbcur.fetchone()[0]
		execute_builtin("Container.SetViewMode(%s)" % str(view_id))
		dbcon.close()
	except: return