# -*- coding: utf-8 -*-
import xbmc, xbmcgui
import os
import json
from threading import Thread
from datetime import datetime, timedelta
try: from sqlite3 import dbapi2 as database
except ImportError: from pysqlite2 import dbapi2 as database
import metadata
from windows.base_dialog import BaseDialog
from apis import tmdb_api, imdb_api
from apis.trakt_api import trakt_get_next_episodes
from indexers import dialogs
from indexers.images import Images
from indexers.people import person_data_dialog
from modules import settings
from modules.sources import Sources
from modules.meta_lists import networks
from modules.indicators_bookmarks import detect_bookmark, get_watched_status, get_watched_info_movie
from modules.nav_utils import show_text
from modules.kodi_utils import translate_path, execute_builtin, close_all_dialog
from modules.settings import skin_location, get_language
from modules.utils import ok_dialog, local_string as ls
# from modules.utils import logger

icon_directory = settings.get_theme()
tmdb_image_base = 'https://image.tmdb.org/t/p/%s%s'
button_ids = [10, 11, 12, 13, 14, 15, 16, 17, 50]
parentsguide_levels = {'mild': ls(32996), 'moderate': ls(32997), 'severe': ls(32998)}
parentsguide_inputs = {'Sex & Nudity': (ls(32990), 'porn.png'), 'Violence & Gore': (ls(32991), 'genre_war.png'), 'Profanity': (ls(32992), 'bad_language.png'),
						'Alcohol, Drugs & Smoking': (ls(32993), 'drugs_alcohol.png'), 'Frightening & Intense Scenes': (ls(32994), 'genre_horror.png')}

class DialogExtrasXML(BaseDialog):
	def __init__(self, *args, **kwargs):
		BaseDialog.__init__(self, args)
		self.set_starting_constants(kwargs)
		self.set_properties()

	def run(self):
		self.doModal()
		return self.selected

	def onClick(self, controlID):
		if controlID in button_ids:
			if controlID == 10:
				if self.db_type == 'movie':
					url_params = {'mode': 'play_media', 'vid_type': 'movie', 'query': self.rootname, 'tmdb_id': self.meta['tmdb_id'], 'imdb_id': self.meta['imdb_id']}
					Sources().playback_prep(url_params)
				else:
					close_all_dialog()
					url_params = self.make_tvshow_browse_params()
					self.selected = (self.folder_runner, self.build_url(url_params))
					self.close()
			elif controlID == 11:
				trailer_params = dialogs.play_trailer(self.db_type, self.rootname, self.poster, self.meta['tmdb_id'], self.meta['trailer'], self.meta['all_trailers'])
				if not trailer_params: return ok_dialog()
				self.selected = (self.plugin_runner, trailer_params)
				self.close()
			elif controlID == 12:
				base_media = 'movies' if self.db_type == 'movie' else 'tv'
				keyword_params = dialogs.imdb_keywords_choice({'db_type': base_media, 'meta': self.meta})
				if not keyword_params: return
				close_all_dialog()
				self.selected = (self.folder_runner, self.build_url(keyword_params))
				self.close()
			elif controlID == 13:
				Images().run({'mode': 'imdb_image_results', 'imdb_id': self.meta['imdb_id'], 'page_no': 1, 'rolling_count': 0})
			elif controlID == 14:
				dialogs.media_extra_info(self.db_type, self.meta)
			elif controlID == 15:
				if not self.genre: return
				genre_choices = dialogs.genres_choice(self.db_type, self.genre, self.rootname, self.poster)
				if not genre_choices: return
				close_all_dialog()
				if self.db_type == 'movie': action = 'tmdb_movies_genres'
				else: action = 'tmdb_tv_genres'
				mode = 'build_%s_list' % self.db_type
				self.selected = (self.folder_runner, self.build_url({'mode': mode, 'action': action, 'genre_id': ','.join(genre_choices)}))
				self.close()
			elif controlID == 16:
				if self.db_type == 'movie':
					director = self.meta.get('director', None)
					if not director: return
					person_data_dialog({'query': director})
				else:
					close_all_dialog()
					self.selected = (self.plugin_runner, self.build_url({'mode': 'play_fetch_random', 'db_type': 'episode', 'meta': json.dumps(self.meta)}))
					self.close()
			elif controlID == 17:
				dialogs.trakt_manager_choice({'tmdb_id': self.meta['tmdb_id'], 'imdb_id': self.meta['imdb_id'], 'tvdb_id': self.meta['tvdb_id'], 'db_type': self.db_type})
			elif controlID == 50:
				show_text(self.rootname, self.plot, font_size='large')
		else: return self.onAction(self.selection_actions[0], controlID)

	def onAction(self, action, controlID=None):
		if action in self.selection_actions:
			try:
				selected = self.list_items_dict[controlID]
				current_index = self.get_position(controlID)
				chosen_listitem = selected['list'][current_index]
				chosen_var = chosen_listitem.getProperty(selected['property'])
			except: pass
			if controlID == 2050:
				person_data_dialog({'query': chosen_var})
			elif controlID in (2051, 2059, 2060, 2061, 2062):
				function = metadata.movie_meta if self.db_type == 'movie' else metadata.tvshow_meta
				meta = function('tmdb_id', chosen_var, metadata.retrieve_user_info())
				if not meta: return
				url_params = {'mode': 'extras_menu_choice', 'media_type': self.db_type, 'meta': json.dumps(meta), 'is_widget': self.is_widget}
				execute_builtin('RunPlugin(%s)' % self.build_url(url_params))
			elif controlID in (2052, 2053, 2054, 2055):
				if controlID == 2055:
					listings = json.loads(chosen_var)
					if not listings: return
					chosen_var = '\n\n'.join(['%02d. %s' % (count, i) for count, i in enumerate(listings, 1)])
				show_text(self.meta['rootname'], chosen_var, font_size='large')
			elif controlID == 2056:
				chosen = dialogs.imdb_videos_choice(chosen_var, self.poster)
				if not chosen: return
				imdb_video_params = self.build_url({'mode': 'media_play', 'url': chosen, 'rootname': 'video'})
				self.selected = (self.plugin_runner, imdb_video_params)
				self.close()
			elif controlID in (2057, 2058):
				slideshow_params = {'mode': 'slideshow_image', 'all_images': chosen_var, 'current_index': current_index}
				ending_position = Images().run(slideshow_params)
				control = self.getControl(controlID)
				control.selectItem(ending_position)
		elif action in self.down_actions: self.create_list(self.getFocusId())
		elif action in self.closing_actions: self.close()

	def create_list(self, current_focus):
		if current_focus in (10, 11, 12, 13, 14, 15, 16, 17):
			for item in (self.make_cast, self.make_recommended, self.make_reviews): Thread(target=item).start()
		elif current_focus == 50: Thread(target=self.make_trivia).start()
		elif current_focus in (2050, 3050): Thread(target=self.make_blunders).start()
		elif current_focus in (2051, 3051): Thread(target=self.make_imdb_parentsguide).start()
		elif current_focus in (2052, 3052): Thread(target=self.make_imdb_videos).start()
		elif current_focus in (2054, 3054): Thread(target=self.make_tmdb_artwork, args=('posters',)).start()
		elif current_focus in (2055, 3055): Thread(target=self.make_tmdb_artwork, args=('backdrops',)).start()
		elif current_focus in (2057, 3057): Thread(target=self.make_more_from_year).start()
		elif current_focus in (2058, 3058): Thread(target=self.make_more_from_genres).start()
		elif current_focus in (2059, 3059): Thread(target=self.make_more_from_network).start()
		elif current_focus in (2060, 3060):
			if self.db_type == 'movie' and self.meta['extra_info']['collection_id']: Thread(target=self.make_more_from_collection).start()
			else: self.setProperty('tikiskins.extras.make.collection', 'false')

	def make_cast(self):
		def builder():
			for item in self.meta['cast']:
				try:
					listitem = self.make_listitem()
					thumbnail = item['thumbnail']
					if not thumbnail: thumbnail = os.path.join(icon_directory, 'genre_family.png')
					listitem.setProperty('tikiskins.extras.name', item['name'])
					listitem.setProperty('tikiskins.extras.role', item['role'])
					listitem.setProperty('tikiskins.extras.thumbnail', thumbnail)
					yield listitem
				except: pass
		if self.cast_made == True: return
		try:
			item_list = list(builder())
			self.setProperty('tikiskins.extras.cast.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.cast_id] = {'list': item_list, 'property': 'tikiskins.extras.name'}
			control = self.getControl(self.cast_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.extras.cast.number', '(x00)')
		self.cast_made = True

	def make_recommended(self):
		if self.recommended_made == True: return
		try:
			function = tmdb_api.tmdb_movies_recommendations if self.db_type == 'movie' else tmdb_api.tmdb_tv_recommendations
			data = function(self.meta['tmdb_id'], 1)['results']
			item_list = list(self.make_tmdb_listitems(data))
			self.setProperty('tikiskins.extras.recommended.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.recommended_id] = {'list': item_list, 'property': 'tikiskins.extras.tmdb_id'}
			control = self.getControl(self.recommended_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.extras.recommended.number', '(x00)')
		self.recommended_made = True

	def make_reviews(self):
		def builder():
			for count, item in enumerate(data, 1):
				try:
					listitem = self.make_listitem()
					if item['spoiler']: content = '[B][COLOR red][%s][/COLOR][CR]%02d. [I]%s - %s - %s[/I][/B]\n\n%s' \
													% (spoiler_str, count, item['rating'], item['date'], item['title'], item['content'])
					else: content = '[B]%02d. [I]%s - %s - %s[/I][/B]\n\n%s' % (count, item['rating'], item['date'], item['title'], item['content'])
					listitem.setProperty('tikiskins.extras.text', content)
					yield listitem
				except: pass
		if self.reviews_made == True: return
		try:
			spoiler_str = ls(32985).upper()
			data = imdb_api.imdb_reviews(self.meta['imdb_id'])
			item_list = list(builder())
			self.setProperty('tikiskins.extras.imdb_reviews.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.reviews_id] = {'list': item_list, 'property': 'tikiskins.extras.text'}
			control = self.getControl(self.reviews_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.extras.imdb_reviews.number', '(x00)')
		self.reviews_made = True

	def make_trivia(self):
		def builder(content):
			for count, item in enumerate(data, 1):
				try:
					listitem = self.make_listitem()
					listitem.setProperty('tikiskins.extras.text', '[B]%s %02d.[/B][CR][CR]%s' % (content.upper(), count, item))
					yield listitem
				except: pass
		if self.trivia_made == True: return
		try:
			data = imdb_api.imdb_trivia(self.meta['imdb_id'], 'trivia')
			item_list = list(builder('trivia'))
			self.setProperty('tikiskins.extras.imdb_trivia.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.trivia_id] = {'list': item_list, 'property': 'tikiskins.extras.text'}
			control = self.getControl(self.trivia_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.extras.imdb_trivia.number', '(x00)')
		self.trivia_made = True

	def make_blunders(self):
		def builder(content):
			for count, item in enumerate(data, 1):
				try:
					listitem = self.make_listitem()
					listitem.setProperty('tikiskins.extras.text', '[B]%s %02d.[/B][CR][CR]%s' % (content.upper(), count, item))
					yield listitem
				except: pass
		if self.blunders_made == True: return
		try:
			data = imdb_api.imdb_trivia(self.meta['imdb_id'], 'blunders')
			item_list = list(builder('blunders'))
			self.setProperty('tikiskins.extras.imdb_blunders.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.blunders_id] = {'list': item_list, 'property': 'tikiskins.extras.text'}
			control = self.getControl(self.blunders_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.extras.imdb_blunders.number', '(x00)')
		self.blunders_made = True

	def make_imdb_parentsguide(self):
		def builder():
			for item in data:
				try:
					listitem = self.make_listitem()
					name = parentsguide_inputs[item['title']][0]
					ranking = parentsguide_levels[item['ranking'].lower()].upper()
					if item['listings']:
						ranking += ' (x%02d)' % len(item['listings'])
					icon = os.path.join(icon_directory, parentsguide_inputs[item['title']][1])
					listitem.setProperty('tikiskins.extras.name', name)
					listitem.setProperty('tikiskins.extras.ranking', ranking)
					listitem.setProperty('tikiskins.extras.thumbnail', icon)
					listitem.setProperty('tikiskins.extras.listings', json.dumps(item['listings']))
					yield listitem
				except: pass
		if self.imdb_parentsguide_made == True: return
		try:
			data = imdb_api.imdb_parentsguide(self.meta['imdb_id'])
			item_list = list(builder())
			self.setProperty('tikiskins.extras.imdb_parentsguide.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.imdb_parentsguide_id] = {'list': item_list, 'property': 'tikiskins.extras.listings'}
			control = self.getControl(self.imdb_parentsguide_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.extras.imdb_parentsguide.number', '(x00)')
		self.imdb_parentsguide_made = True

	def make_imdb_videos(self):
		def builder():
			for count, item in enumerate(data, 1):
				try:
					listitem = self.make_listitem()
					listitem.setProperty('tikiskins.extras.name', '%01d. %s' % (count, item['title']))
					listitem.setProperty('tikiskins.extras.thumbnail', item['poster'])
					listitem.setProperty('tikiskins.extras.qualities', json.dumps(item['videos']))
					yield listitem
				except: pass
		if self.imdb_videos_made == True: return
		try:
			data = imdb_api.imdb_videos(self.meta['imdb_id'])
			item_list = list(builder())
			self.setProperty('tikiskins.extras.imdb_videos.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.imdb_videos_id] = {'list': item_list, 'property': 'tikiskins.extras.qualities'}
			control = self.getControl(self.imdb_videos_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.extras.imdb_videos.number', '(x00)')
		self.imdb_videos_made = True

	def make_tmdb_artwork(self, image_type):
		def builder():
			for count, item in enumerate(data, 1):
				try:
					listitem = self.make_listitem()
					thumb_url = tmdb_image_base % ('w780', item['file_path'])
					name = '%sx%s' % (item['height'], item['width'])
					listitem.setProperty('tikiskins.extras.name', '%01d. %s' % (count, name))
					listitem.setProperty('tikiskins.extras.thumbnail', thumb_url)
					listitem.setProperty('tikiskins.extras.all_images', json_all_images)
					yield listitem
				except: pass
		try:
			if image_type == 'posters' and self.tmdb_artwork_posters_made: return
			elif self.tmdb_artwork_backdrops_made: return
			dbtype = 'movie' if self.db_type == 'movie' else 'tv'
			data = tmdb_api.tmdb_media_images(dbtype, self.meta['tmdb_id'])[image_type]
			data = sorted(data, key=lambda x: x['file_path'])
			json_all_images = json.dumps([(tmdb_image_base % ('original', i['file_path']), '%sx%s' % (i['height'], i['width'])) for i in data])
			item_list = list(builder())
			if image_type == 'posters': _id = self.tmdb_artwork_posters_id
			else: _id = self.tmdb_artwork_backdrops_id
			self.setProperty('tikiskins.extras.tmdb_artwork.%s.number' % image_type, '(x%02d)' % len(item_list))
			self.list_items_dict[_id] = {'list': item_list, 'property': 'tikiskins.extras.all_images'}
			control = self.getControl(_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.extras.tmdb_artwork.%s.number' % image_type, '(x00)')
		if image_type == 'posters': self.tmdb_artwork_posters_made = True
		else: self.tmdb_artwork_backdrops_made = True

	def make_more_from_year(self):
		if self.more_from_year_made == True: return
		try:
			function = tmdb_api.tmdb_movies_year if self.db_type == 'movie' else tmdb_api.tmdb_tv_year
			data = self.remove_current_tmdb_mediaitem(function(self.year, 1)['results'])
			item_list = list(self.make_tmdb_listitems(data))
			self.setProperty('tikiskins.extras.more_from_year.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.more_from_year_id] = {'list': item_list, 'property': 'tikiskins.extras.tmdb_id'}
			control = self.getControl(self.more_from_year_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.extras.more_from_year.number', '(x00)')
		self.more_from_year_made = True

	def make_more_from_genres(self):
		if self.more_from_genres_made == True: return
		try:
			function = tmdb_api.tmdb_movies_genres if self.db_type == 'movie' else tmdb_api.tmdb_tv_genres
			genre_dict = dialogs.genres_choice(self.db_type, self.genre, self.rootname, self.poster, return_genres=True)
			genre_list = ','.join([i['value'][0] for i in genre_dict])
			data = self.remove_current_tmdb_mediaitem(function(genre_list, 1)['results'])
			item_list = list(self.make_tmdb_listitems(data))
			self.setProperty('tikiskins.extras.more_from_genres.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.more_from_genres_id] = {'list': item_list, 'property': 'tikiskins.extras.tmdb_id'}
			control = self.getControl(self.more_from_genres_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.extras.more_from_genres.number', '(x00)')
		self.more_from_genres_made = True

	def make_more_from_network(self):
		if self.more_from_networks_made == True: return
		try:
			network = self.meta['studio']
			network_id = [i['id'] for i in tmdb_api.tmdb_company_id(network)['results'] if i['name'] == network][0] \
						if self.db_type == 'movie' else [item['id'] for item in networks() if 'name' in item and item['name'] == network][0]
			function = tmdb_api.tmdb_movies_networks if self.db_type == 'movie' else tmdb_api.tmdb_tv_networks
			data = self.remove_current_tmdb_mediaitem(function(network_id, 1)['results'])
			item_list = list(self.make_tmdb_listitems(data))
			self.setProperty('tikiskins.extras.more_from_networks.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.more_from_networks_id] = {'list': item_list, 'property': 'tikiskins.extras.tmdb_id'}
			control = self.getControl(self.more_from_networks_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.extras.more_from_networks.number', '(x00)')
		self.more_from_networks_made = True

	def make_more_from_collection(self):
		if self.more_from_collection_made == True: return
		try:
			data = tmdb_api.tmdb_movies_collection(self.meta['extra_info']['collection_id'])
			poster_path = data['poster_path']
			if not poster_path: poster = os.path.join(icon_directory, 'box_office.png')
			else: poster = tmdb_image_base % ('w780', poster_path)
			self.setProperty('tikiskins.extras.more_from_collection.name', data['name'])
			self.setProperty('tikiskins.extras.more_from_collection.overview', data['overview'])
			self.setProperty('tikiskins.extras.more_from_collection.poster', poster)
			data = sorted(data['parts'], key=lambda k: k.get('release_date', '2050-01-01').split('-')[0])
			item_list = list(self.make_tmdb_listitems(data))
			self.setProperty('tikiskins.extras.more_from_collection.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.more_from_collection_id] = {'list': item_list, 'property': 'tikiskins.extras.tmdb_id'}
			control = self.getControl(self.more_from_collection_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.extras.more_from_collection.number', '(x00)')
		self.more_from_collection_made = True

	def get_finish(self):
		if self.percent_watched in ('0', '100') and self.listitem_check():
			finished = xbmc.getInfoLabel('ListItem.EndTime')
		else:
			kodi_clock = xbmc.getInfoLabel('System.Time')
			if any(i in kodi_clock for i in ['AM', 'PM']): _format = '%I:%M %p'
			else: _format = '%H:%M'
			current_time = datetime.now()
			remaining_time = ((100 - int(self.percent_watched))/100) * self.duration_data
			finish_time = current_time + timedelta(minutes=remaining_time)
			finished = finish_time.strftime(_format)
		return '[B]%s: %s[/B]' % (ls(33062), finished)

	def get_duration(self):
		self.duration_data = int(float(self.meta['duration'])/60)
		duration_str = ls(33058) % self.duration_data
		return duration_str

	def get_progress(self):
		try: resume_point, curr_time = detect_bookmark(self.db_type, self.meta['tmdb_id'])
		except: resume_point = 0
		if resume_point in (0, '0', 0.0, '0.0'):
			try:
				playcount = self.meta['playcount']
			except:
				watched_info, use_trakt = get_watched_info_movie()
				playcount, overlay = get_watched_status(watched_info, use_trakt, 'movie', self.meta['tmdb_id'])
				self.meta.update({'playcount': playcount, 'overlay': overlay})
			if playcount == 1: self.percent_watched = '100'
			else: self.percent_watched = '0'
		else: self.percent_watched = str(int(float(resume_point)))
		progress_status = '%s%% %s' % (self.percent_watched, ls(32475))
		return progress_status

	def get_last_aired(self):
		extra_info = self.meta['extra_info']
		if 'last_episode_to_air' in extra_info:
			last_ep = extra_info['last_episode_to_air']
			last_aired = 'S%.2dE%.2d' % (last_ep['season_number'], last_ep['episode_number'])
		else: return ''
		return '[B]%s:[/B] %s' % (ls(32634), last_aired)

	def get_next_aired(self):
		extra_info = self.meta['extra_info']
		if 'next_episode_to_air' in extra_info:
			next_ep = extra_info['next_episode_to_air']
			next_aired = 'S%.2dE%.2d' % (next_ep['season_number'], next_ep['episode_number'])
		else: return ''
		return '[B]%s:[/B] %s' % (ls(32635), next_aired)

	def get_next_episode(self):
		if settings.watched_indicators() in (1, 2): ep_list = trakt_get_next_episodes(include_hidden=True, hidden_full_info=True)
		else:
			watched_db = translate_path('special://profile/addon_data/plugin.video.fen/watched_status.db')
			seen = set()
			dbcon = database.connect(watched_db)
			dbcur = dbcon.cursor()
			dbcur.execute('''SELECT media_id, season, episode, last_played FROM watched_status WHERE db_type=?''', ('episode',))
			rows = dbcur.fetchall()
			rows = sorted(rows, key = lambda x: (x[0], x[1], x[2]), reverse=True)
			ep_list = [{"tmdb_id": int(a), "season": int(b), "episode": int(c), "last_played": d} for a, b, c, d in rows if not (a in seen or seen.add(a))]
		try: info = [i for i in ep_list if i['tmdb_id'] == self.meta['tmdb_id']][0]
		except: return ''
		current_season = info['season']
		current_episode = info['episode']
		season_data = self.meta['season_data']
		curr_season_data = [i for i in season_data if i['season_number'] == current_season][0]
		season = current_season if current_episode < curr_season_data['episode_count'] else current_season + 1
		episode = current_episode + 1 if current_episode < curr_season_data['episode_count'] else 1
		try: info = [i for i in season_data if i['season_number'] == season][0]
		except: return ''
		if info['episode_count'] >= episode:
			next_episode = 'S%.2dE%.2d' % (season, episode)
			return '[B]%s: %s[/B]' % (ls(33041), next_episode)
		else: return ''

	def make_tvshow_browse_params(self):
		total_seasons = self.meta['total_seasons']
		all_episodes = settings.default_all_episodes()
		show_all_episodes = True if all_episodes in (1, 2) else False
		meta_json = json.dumps(self.meta)
		if show_all_episodes:
			if all_episodes == 1 and total_seasons > 1: url_params = {'mode': 'build_season_list', 'meta': meta_json, 'tmdb_id': self.meta['tmdb_id']}
			else: url_params = {'mode': 'build_episode_list', 'meta': meta_json, 'tmdb_id': self.meta['tmdb_id'], 'season': 'all'}
		else: url_params = {'mode': 'build_season_list', 'meta': meta_json, 'tmdb_id': self.meta['tmdb_id']}
		return url_params

	def original_poster(self):
		poster = self.meta['poster']
		try:
			if 'w185' in poster: poster = poster.replace('w185', 'original')
			elif 'w342' in poster: poster = poster.replace('w342', 'original')
			elif 'w780' in poster: poster = poster.replace('w780', 'original')
		except: pass
		return poster

	def listitem_check(self):
		return xbmc.getInfoLabel('ListItem.Title') == self.meta['title']

	def remove_current_tmdb_mediaitem(self, data):
		return [i for i in data if int(i['id']) != int(self.meta.get('tmdb_id'))]

	def make_tmdb_listitems(self, data):
		name_key = 'title' if self.db_type == 'movie' else 'name'
		release_key = 'release_date' if self.db_type == 'movie' else 'first_air_date'
		for item in data:
			try:
				listitem = self.make_listitem()
				poster_path = item['poster_path']
				if not poster_path: thumbnail = os.path.join(icon_directory, 'box_office.png')
				else: thumbnail = tmdb_image_base % ('w780', poster_path)
				try: year = item[release_key].split('-')[0]
				except: year = item[release_key]
				listitem.setProperty('tikiskins.extras.name', item[name_key])
				listitem.setProperty('tikiskins.extras.release_date', year)
				listitem.setProperty('tikiskins.extras.vote_average', '%.1f' % item['vote_average'])
				listitem.setProperty('tikiskins.extras.thumbnail', thumbnail)
				listitem.setProperty('tikiskins.extras.tmdb_id', str(item['id']))
				yield listitem
			except: pass

	def set_starting_constants(self, kwargs):
		self.list_items_dict = {}
		self.selected = None
		self.cast_id, self.cast_made = 2050, False
		self.recommended_id, self.recommended_made = 2051, False
		self.reviews_id, self.reviews_made = 2052, False
		self.trivia_id, self.trivia_made = 2053, False
		self.blunders_id, self.blunders_made = 2054, False
		self.imdb_parentsguide_id, self.imdb_parentsguide_made = 2055, False
		self.imdb_videos_id, self.imdb_videos_made = 2056, False
		self.tmdb_artwork_posters_id, self.tmdb_artwork_posters_made = 2057, False
		self.tmdb_artwork_backdrops_id, self.tmdb_artwork_backdrops_made = 2058, False
		self.more_from_year_id, self.more_from_year_made = 2059, False
		self.more_from_genres_id, self.more_from_genres_made = 2060, False
		self.more_from_networks_id, self.more_from_networks_made = 2061, False
		self.more_from_collection_id, self.more_from_collection_made = 2062, False
		self.is_widget = kwargs['is_widget']
		self.meta = kwargs['meta']
		self.db_type = self.meta['mediatype']#movie, tvshow
		if self.is_widget: self.folder_runner = 'ActivateWindow(Videos,%s,return)'
		else: self.folder_runner = 'Container.Update(%s)'
		self.plugin_runner = 'RunPlugin(%s)'
		self.enable_scrollbars = settings.extras_enable_scrollbars()
		self.title = self.meta['title']
		self.year = str(self.meta['year'])
		self.rootname = self.meta['rootname']
		self.poster = self.original_poster()
		self.fanart = self.meta['fanart']
		self.clearlogo = self.meta['clearlogo']
		self.plot = self.meta['tvshow_plot'] if 'tvshow_plot' in self.meta else self.meta['plot']
		self.rating = str(self.meta['rating'])
		self.mpaa = self.meta['mpaa']
		self.status = self.meta['extra_info'].get('status', '').replace('Series', '')
		self.genre = self.meta['genre']
		self.network = self.meta['studio']
		if not self.network: self.network = ''
		self.duration = self.get_duration()
		if self.db_type == 'movie':
			self.progress = self.get_progress()
			self.finish_watching = self.get_finish()
			self.last_aired_episode, self.next_aired_episode, self.next_episode = '', '', ''
		else:
			self.progress, self.finish_watching = '', ''
			self.last_aired_episode = self.get_last_aired()
			if self.status.lower() not in ('', 'ended', 'canceled'): self.next_aired_episode = self.get_next_aired()
			else: self.next_aired_episode = ''
			self.next_episode = self.get_next_episode()

	def set_properties(self):
		self.setProperty('tikiskins.extras.db_type', self.db_type)
		self.setProperty('tikiskins.extras.fanart', self.fanart)
		self.setProperty('tikiskins.extras.clearlogo', self.clearlogo)
		self.setProperty('tikiskins.extras.poster', self.poster)
		self.setProperty('tikiskins.extras.title', self.title)
		self.setProperty('tikiskins.extras.plot', self.plot)
		self.setProperty('tikiskins.extras.year', self.year)
		self.setProperty('tikiskins.extras.rating', self.rating)
		self.setProperty('tikiskins.extras.mpaa', self.mpaa)
		self.setProperty('tikiskins.extras.status', self.status)
		self.setProperty('tikiskins.extras.genre', self.genre)
		self.setProperty('tikiskins.extras.network', self.network)
		self.setProperty('tikiskins.extras.duration', self.duration)
		self.setProperty('tikiskins.extras.progress', self.progress)
		self.setProperty('tikiskins.extras.finish_watching', self.finish_watching)
		self.setProperty('tikiskins.extras.last_aired_episode', self.last_aired_episode)
		self.setProperty('tikiskins.extras.next_aired_episode', self.next_aired_episode)
		self.setProperty('tikiskins.extras.next_episode', self.next_episode)
		self.setProperty('tikiskins.extras.enable_scrollbars', self.enable_scrollbars)
