# -*- coding: utf-8 -*-
import xbmcgui
from threading import Thread
try: from sqlite3 import dbapi2 as database
except ImportError: from pysqlite2 import dbapi2 as database
from metadata import tvshow_meta, retrieve_user_info
from modules.kodi_utils import translate_path
from modules.utils import make_thread_list
from modules import settings
# from modules.utils import logger

WATCHED_DB = translate_path('special://profile/addon_data/plugin.video.fen/watched_status.db')

window = xbmcgui.Window(10000)

def in_progress_movie(db_type, page_no, letter):
	from modules.nav_utils import paginate_list
	paginate = settings.paginate()
	limit = settings.page_limit()
	dbcon = database.connect(WATCHED_DB)
	dbcur = dbcon.cursor()
	dbcur.execute('''SELECT media_id FROM progress WHERE db_type=? ORDER BY rowid DESC''', ('movie',))
	rows = dbcur.fetchall()
	data = [i[0] for i in rows if not i[0] == '']
	original_list = [{'media_id': i} for i in data]
	if paginate: final_list, total_pages = paginate_list(original_list, page_no, letter, limit)
	else: final_list, total_pages = original_list, 1
	return final_list, total_pages

def in_progress_tvshow(db_type, page_no, letter):
	from modules.utils import sort_for_article
	from modules.nav_utils import paginate_list
	paginate = settings.paginate()
	limit = settings.page_limit()
	meta_user_info = retrieve_user_info(window)
	data = []
	if settings.watched_indicators() in (1, 2):
		from apis.trakt_api import trakt_indicators_tv
		def _process(item):
			meta = tvshow_meta('tmdb_id', str(item[0]), meta_user_info)
			if item[1] > len(item[2]): data.append((item[0], item[3]))
		data = []
		meta_user_info = retrieve_user_info(window)
		in_progress_result = trakt_indicators_tv()
		threads = list(make_thread_list(_process, in_progress_result, Thread))
		[i.join() for i in threads]
	else:
		from modules.indicators_bookmarks import get_watched_status_tvshow, get_watched_info_tv
		def _process(item):
			meta = tvshow_meta('tmdb_id', item[0], meta_user_info)
			watched_status = get_watched_status_tvshow(watched_info, use_trakt, meta['tmdb_id'], meta.get('total_aired_eps'))
			if not watched_status[0] == 1: data.append(item)
		dbcon = database.connect(WATCHED_DB)
		dbcur = dbcon.cursor()
		dbcur.execute('''SELECT media_id, title, last_played FROM watched_status WHERE db_type=? ORDER BY rowid DESC''', ('episode',))
		rows1 = dbcur.fetchall()
		in_progress_result = list(set(rows1))
		watched_info, use_trakt = get_watched_info_tv()
		threads = list(make_thread_list(_process, in_progress_result, Thread))
		[i.join() for i in threads]
		data = [(s,[i[1] for i in data if i[0] == s][0], [i[2] for i in data if i[0] == s][0]) for s in sorted(set([i[0] for i in data]))]
	data = sort_for_article(data, 1, settings.ignore_articles())
	original_list = [{'media_id': i[0]} for i in data]
	if paginate: final_list, total_pages = paginate_list(original_list, page_no, letter, limit)
	else: final_list, total_pages = original_list, 1
	return final_list, total_pages

def get_in_progress_episodes():
	dbcon = database.connect(WATCHED_DB)
	dbcur = dbcon.cursor()
	dbcur.execute('''SELECT media_id, season, episode, curr_time FROM progress WHERE db_type=? ORDER BY rowid DESC''', ('episode',))
	return dbcur.fetchall()
	