# -*- coding: utf-8 -*-
import xbmc
from windows.base_dialog import BaseDialog
from modules.kodi_utils import sleep
# from modules.utils import logger

class VideoPlayerXML(BaseDialog):
	def __init__(self, *args, **kwargs):
		BaseDialog.__init__(self, args)
		self.video = kwargs['video']
		self.meta = kwargs['meta']
		self.player = xbmc.Player()
		self.set_properties()

	def onInit(self):
		self.monitor()

	def run(self):
		self.doModal()
	
	def onAction(self, action, controlID=None):
		if action in self.closing_actions:
			self.player.stop()
			self.close()

	def monitor(self):
		self.execute_code('PlayMedia(%s, 1)' % self.video)
		while not self.player.isPlayingVideo(): sleep(100)
		sleep(100)
		progress_bar = self.getControl(5000)
		total_time = self.player.getTotalTime()
		while self.player.isPlayingVideo():
			try:
				current_point = (self.player.getTime() / float(total_time)) * 100
				progress_bar.setPercent(current_point)
			except: pass
			sleep(1000)
		self.close()

	def set_properties(self):
		self.setProperty('tikiskins.videoplayer.fanart', self.meta['fanart'])
		self.setProperty('tikiskins.videoplayer.clearlogo', self.meta['clearlogo'])
		self.setProperty('tikiskins.videoplayer.title', self.meta['title'])
