# -*- coding: utf-8 -*-
import xbmc, xbmcvfs, xbmcgui
import os
import re
import json
try: from urlparse import urlparse
except ImportError: from urllib.parse import urlparse
try: from urllib import unquote
except ImportError: from urllib.parse import unquote
try: from sqlite3 import dbapi2 as database
except Exception: from pysqlite2 import dbapi2 as database
from caches.fen_cache import cache_object
from fenomscrapers import pack_sources
from fenomscrapers.modules.control import setting as fenom_setting, setSetting as fenom_setSetting
from modules.kodi_utils import translate_path
from modules.utils import confirm_dialog, ok_dialog, replace_html_codes, local_string as ls
from modules.settings_reader import get_setting
from modules.settings import date_offset
# from modules.utils import logger

database_path = translate_path('special://profile/addon_data/plugin.video.fen/ext_providers3.db')
sourceFolderLocation = translate_path('special://home/addons/script.module.fenomscrapers/lib/fenomscrapers/sources_fenomscrapers')
window = xbmcgui.Window(10000)

RES_4K = [' 4k ', ' hd4k ', ' 4khd ', ' uhd ', ' ultrahd ', ' ultra hd ', ' 2160 ', ' 2160p ', ' hd2160 ', ' 2160hd ']
RES_1080 = [' 1080 ', ' 1080p ', ' 1080i ', ' hd1080 ', ' 1080hd ', ' hd1080p ', ' m1080p ', ' fullhd ', ' full hd ', ' 1o8o ', ' 1o8op ']
RES_720 = [' 720 ', ' 720p ', ' 720i ', ' hd720 ', ' 720hd ', ' hd720p ', ' hd ', ' 72o ', ' 72op ']
RES_SD = ['sd', ' 576 ', ' 576p ', ' 576i ', ' sd576 ', ' 576sd ', ' 480 ', ' 480p ', ' 480i ', ' sd480 ', ' 480sd ', ' 360 ', ' 360p ',
		' 360i ', ' sd360 ', ' 360sd ', ' 240 ', ' 240p ', ' 240i ', ' sd240 ', ' 240sd ']
CAM = [' cam ', ' camrip ', ' hdcam ', ' hd cam ', ' cam rip ', ' dvdcam ']
SCR = [' scr ', ' screener ', ' dvdscr ', ' dvd scr ', ' r5 ', ' r6 ']
TELE = [' tc ', ' tsrip ', ' hdts ', ' hdtc ', ' dvdts ', ' telesync ', ' ts ']
HEVC = [' hevc ', ' h265 ', ' h 265 ', ' x265 ', ' x 265 ', ' dv ', ' dolby vision ', ' dolbyvision ', ' hdr ', ' hdr10 ', ' 2160p remux ']
BLURAY = [' bluray ', ' blu ray ']
BDRIP = [' bdr ', ' bd r ', ' bdrip ', ' bd rip ', ' br rip ', ' brrip ']
REMUX = [' remux ', ' bdremux ', ' bd remux ']
DVDRIP = [' dvdrip ', ' dvd rip ']
DVD = [' dvd ', ' dvdr ', ' dvd r ']
WEB = [' webdl ', ' web dl ', ' web ', ' webrip ', ' web rip ']
HDRIP = [' hdrip ', ' hd rip ']
UHDRIP = [' uhdrip ', ' uhd rip ']
HDR = [' hdr ', ' hdr10 ', ' hdr 10 ', ' dolbyvision ', ' dolby vision ', ' hlg ', '2160p bluray remux',
		'uhd bluray 2160p', '2160p uhd bluray', '2160p bluray hevc truehd', '2160p remux']
AC3 = [' ac3 ', ' ac 3 ']
DD = [' dd ', ' dolby ', ' dolbydigital ', ' dolby digital ']
TRUEHD = [' truehd ', ' true hd ']
DDPLUS = [' ddplus ', ' dd plus ', ' ddp ', ' eac3 ', ' eac 3 ']
HDMA = [' hdma ', ' hd ma ']
HDHRA = [' hdhra ', ' hd hra ']
DV = [' dv ', ' dolby vision ', ' dolbyvision ']
DTSX = [' dtsx ', ' dts x ']
DD51 = [' dd5 1 ', ' dd5 1ch ', ' dd5 1 ch ']
DDP51 = [' ddp5 1 ', ' ddp5 1ch ', ' ddp5 1 ch ']
D51 = [' 5 1 ', ' 5 1ch ', ' 5 1 ch ', ' 6ch ', ' 6 ch ']
D71 = [' 7 1 ', ' 7 1ch ', ' 7 1 ch ', ' 8ch ', ' 8 ch ']
SUBS = [' subs ', ' subbed ', ' sub ', ' korsub ']
DUB = [' dub ', ' dubbed ', ' dublado ']

def sources():
	def import_info():
		for item in sourceSubFolders:
			files = xbmcvfs.listdir(os.path.join(sourceFolderLocation, item))[1]
			for m in files:
				try:
					m_split = m.split('.')
					if m_split[1] == 'pyo': continue
					module_name = m_split[0]
					if module_name == '__init__': continue
					if not enabledScraper(module_name): continue
					module_path = path % (item, module_name)
					yield (module_name, module_path)
				except: pass
	try:
		sourceDict = []
		sourceSubFolders = ['hosters', 'torrents']
		path = 'fenomscrapers.sources_fenomscrapers.%s.%s'
		sourceDict = list(import_info())
	except: pass
	return sourceDict

def enabledScraper(module_name):
	return fenom_setting('provider.%s' % module_name) == 'true'

def packSources():
	return pack_sources()

def internal_results(provider, sources):
	window.setProperty('%s.internal_results' % provider, json.dumps(sources))

def normalize(title):
	try:
		try: return title.decode('ascii').encode("utf-8")
		except: pass
		try: import unicodedata
		except ImportError: return
		title = u'%s' % obj
		title = ''.join(c for c in unicodedata.normalize('NFD', title) if unicodedata.category(c) != 'Mn')
		return str(title)
	except:
		return title

def deleteProviderCache(silent=False):
	try:
		if not xbmcvfs.exists(database_path): return 'failure'
		if not silent:
			if not confirm_dialog(): return 'cancelled'
		dbcon = database.connect(database_path)
		dbcur = setPRAGMAS(dbcon)
		for i in ('rel_url', 'rel_src'): dbcur.execute("DELETE FROM %s" % i)
		dbcon.commit()
		dbcur.execute("VACUUM")
		dbcon.close()
		return 'success'
	except: return 'failure'

def deleteProviderCacheSingle(imdb_id):
	try:
		if not xbmcvfs.exists(database_path): return False
		dbcon = database.connect(database_path)
		dbcur = setPRAGMAS(dbcon)
		for i in ('rel_url', 'rel_src'): dbcur.execute("DELETE FROM %s WHERE imdb_id=?" % i, (imdb_id,))
		dbcon.commit()
		dbcur.execute("VACUUM")
		dbcon.close()
		return True
	except: return False

def setPRAGMAS(dbcon):
	dbcur = dbcon.cursor()
	dbcur.execute('''PRAGMA synchronous = OFF''')
	dbcur.execute('''PRAGMA journal_mode = OFF''')
	return dbcur

def external_scrapers_fail_stats():
	dbcon = database.connect(database_path)
	dbcur = setPRAGMAS(dbcon)
	dbcur.execute("SELECT * FROM scr_perf")
	results = dbcur.fetchall()
	results = sorted([(str(i[0]), i[1], i[2]) for i in results], key=lambda k: k[2] - k[1], reverse=True)
	return results

def external_scrapers_disable():
	from modules.utils import select_dialog
	from modules.settings import ext_addon
	icon = ext_addon('script.module.fenomscrapers').getAddonInfo('icon')
	scrapers = external_scrapers_fail_stats()
	try: scrapers = [i for i in scrapers if fenom_setting('provider.%s' % i[0]) == 'true']
	except: scrapers = []
	if not scrapers: return ok_dialog(text=ls(32581), top_space=True)
	list_items = [{'line1': '[B]%s[/B] | %s: %s | [COLOR=green]%s: %d[/COLOR] | [COLOR=red]%s: %d[/COLOR]' % \
						(i[0].upper(), ls(32677).upper(), (i[1] + i[2]), ls(32576).upper(),i[1], ls(32490).upper(), i[2]), 'icon': icon} for i in scrapers]
	kwargs = {'items': json.dumps(list_items), 'heading': ls(32024), 'enumerate': 'false', 'multi_choice': 'true', 'multi_line': 'false'}
	scraper_choice = select_dialog(scrapers, **kwargs)
	if scraper_choice == None: return
	if confirm_dialog(): clear_database = True
	else: clear_database = False
	dbcon = database.connect(database_path)
	dbcur = setPRAGMAS(dbcon)
	for i in scraper_choice:
		if clear_database: dbcur.execute("DELETE FROM scr_perf WHERE source = ?", (i[0],))
		fenom_setSetting('provider.%s' % i[0], 'false')
	if clear_database:
		dbcon.commit()
	return ok_dialog(text=ls(32576), top_space=True)

def external_scrapers_reset_stats(silent=False):
	try:
		if not silent:
			if not confirm_dialog(): return
		dbcon = database.connect(database_path)
		dbcur = setPRAGMAS(dbcon)
		dbcur.execute("DELETE FROM scr_perf")
		dbcon.commit()
		dbcur.execute("VACUUM")
		dbcon.close()
		if silent: return
		return ok_dialog(text=ls(32576), top_space=True)
	except:
		if silent: return
		return ok_dialog(text=ls(32574), top_space=True)

def _ext_scrapers_notice(status):
	from modules.kodi_utils import notification
	notification(status, 2500)

def toggle_all(folder, setting, silent=False):
	try:
		sourcelist = scraperNames(folder)
		for i in sourcelist:
			source_setting = 'provider.' + i
			fenom_setSetting(source_setting, setting)
		if silent: return
		return _ext_scrapers_notice(ls(32576))
	except:
		if silent: return
		return _ext_scrapers_notice(ls(32574))

def enable_disable_specific_all(folder):
	try:
		from modules.utils import select_dialog
		from modules.settings import ext_addon
		icon = ext_addon('script.module.fenomscrapers').getAddonInfo('icon')
		enabled, disabled = scrapersStatus(folder)
		all_sources = sorted(enabled + disabled)
		preselect = [all_sources.index(i) for i in enabled]
		list_items = [{'line1': i.upper(), 'icon': icon} for i in all_sources]
		kwargs = {'items': json.dumps(list_items), 'heading': 'Fen', 'enumerate': 'false', 'multi_choice': 'true', 'multi_line': 'false', 'preselect': preselect}
		chosen = select_dialog(all_sources, **kwargs)
		if chosen == None: return
		for i in all_sources:
			if i in chosen: fenom_setSetting('provider.' + i, 'true')
			else: fenom_setSetting('provider.' + i, 'false')
		return _ext_scrapers_notice(ls(32576))
	except: return _ext_scrapers_notice(ls(32574))

def scrapersStatus(folder='all'):
	providers = scraperNames(folder)
	enabled = [i for i in providers if fenom_setting('provider.' + i) == 'true']
	disabled = [i for i in providers if i not in enabled]
	return enabled, disabled

def scraperNames(folder):
	providerList = []
	sourceSubFolders = ['hosters', 'torrents']
	if folder != 'all':
		sourceSubFolders = [i for i in sourceSubFolders if i == folder]
	for item in sourceSubFolders:
		files = xbmcvfs.listdir(os.path.join(sourceFolderLocation, item))[1]
		for m in files:
			if not os.path.splitext(urlparse(m).path)[-1] == '.py':
				continue
			module_name = m.split('.')[0]
			if module_name == '__init__':
				continue
			providerList.append(module_name)
	return providerList

def pack_enable_check(meta, season, episode):
	extra_info = meta['extra_info']
	status = extra_info['status'].lower()
	if status in ('ended', 'canceled'): return True, True
	from metadata import season_episodes_meta, retrieve_user_info
	from modules.utils import adjust_premiered_date, get_datetime
	adjust_hours = date_offset()
	current_date = get_datetime()
	meta_user_info = retrieve_user_info(window)
	episodes_data = season_episodes_meta(season, meta, meta_user_info)
	unaired_episodes = [adjust_premiered_date(i['premiered'], adjust_hours)[0] for i in episodes_data]
	if None in unaired_episodes or any(i > current_date for i in unaired_episodes): return False, False
	else: return True, False
	return False, False

def getFileNameMatch(title, url, name=None):
	from modules.utils import clean_file_name
	if name: return clean_file_name(name)
	try: from urllib import unquote
	except ImportError: from urllib.parse import unquote
	from modules.utils import clean_title, normalize
	title_match = None
	try:
		title = clean_title(normalize(title))
		name_url = unquote(url)
		try: file_name = clean_title(name_url.split('/')[-1])
		except: return title_match
		test = name_url.split('/')
		for item in test:
			test_url = str(clean_title(normalize(item)))
			if title in test_url:
				title_match = clean_file_name(str(item)).replace('html', ' ').replace('+', ' ')
				break
	except:
		pass
	return title_match

def sourcesRemoveFailing(sourceDict, Thread, background=False):
	def _check_sources(item):
		if item[1] + item[2] >= threshold:
			if float(item[2])/2 >= float(item[1]):
				remove_sources.append(item[0])
	try:
		threads = []
		remove_sources = []
		threshold = int(get_setting('failing_scrapers.threshold', '25'))
		activeSources = [i[0] for i in sourceDict]
		scrapers = external_scrapers_fail_stats()
		scrapers = [i for i in scrapers if i[0] in activeSources]
		for i in scrapers: threads.append(Thread(target=_check_sources, args=(i,)))
		[i.start() for i in threads]
		[i.join() for i in threads]
		if len(remove_sources) > 0:
			for i in remove_sources:
				fenom_setSetting('provider.%s' % i, 'false')
			sourceDict = [i for i in sourceDict if not i[0] in remove_sources]
			if not background: _ext_scrapers_notice(ls(32680) % len(remove_sources))
	except: pass
	return sourceDict

def supported_video_extensions():
	supported_video_extensions = xbmc.getSupportedMedia('video').split('|')
	return [i for i in supported_video_extensions if not i in ('','.zip')]

def seas_ep_query_list(season, episode):
	return ['s%02de%02d' % (int(season), int(episode)),
			'%dx%02d' % (int(season), int(episode)),
			'%02dx%02d' % (int(season), int(episode)),
			'season%02depisode%02d' % (int(season), int(episode)),
			'season%depisode%02d' % (int(season), int(episode)),
			'season%depisode%d' % (int(season), int(episode))]

def seas_ep_filter(season, episode, release_title, split=False):
	try: from urllib import unquote
	except: from urllib.parse import unquote
	string_list = []
	release_title = re.sub(r'[^A-Za-z0-9-]+', '.', unquote(release_title).replace('\'', '')).lower()
	string1 = r'(s<<S>>e<<E>>)|' \
			  r'(s<<S>>\.e<<E>>)|' \
			  r'(s<<S>>ep<<E>>)|' \
			  r'(s<<S>>\.ep<<E>>)'
	string2 = r'(season\.<<S>>\.episode\.<<E>>)|' \
			  r'(season<<S>>\.episode<<E>>)|' \
			  r'(season<<S>>episode<<E>>)|' \
			  r'(<<S>>x<<E>>\.)|' \
			  r'(s<<S>>e\(<<E>>\))|' \
			  r'(s<<S>>\.e\(<<E>>\))|' \
			  r'(<<S>>\.<<E>>\.)'
	string3 = r'(<<S>><<E>>\.)'
	string4 = r'(s<<S>>e<<E1>>e<<E2>>)|' \
			  r'(s<<S>>e<<E1>>-e<<E2>>)|' \
			  r'(s<<S>>e<<E1>>\.e<<E2>>)|' \
			  r'(s<<S>>e<<E1>>-<<E2>>)-|' \
			  r'(s<<S>>e<<E1>>\.<<E2>>)\.|' \
			  r'(s<<S>>e<<E1>><<E2>>)'
	string5 = r'(?<![a-z])(ep<<E>>[.-])|' \
			  r'(?<![a-z])(ep[.-]<<E>>[.-])'
	string_list.append(string1.replace('<<S>>', str(season).zfill(2)).replace('<<E>>', str(episode).zfill(2)))
	string_list.append(string1.replace('<<S>>', str(season)).replace('<<E>>', str(episode).zfill(2)))
	string_list.append(string2.replace('<<S>>', str(season).zfill(2)).replace('<<E>>', str(episode).zfill(2)))
	string_list.append(string2.replace('<<S>>', str(season)).replace('<<E>>', str(episode).zfill(2)))
	string_list.append(string2.replace('<<S>>', str(season).zfill(2)).replace('<<E>>', str(episode)))	
	string_list.append(string2.replace('<<S>>', str(season)).replace('<<E>>', str(episode)))
	string_list.append(string3.replace('<<S>>', str(season).zfill(2)).replace('<<E>>', str(episode).zfill(2)))
	string_list.append(string3.replace('<<S>>', str(season)).replace('<<E>>', str(episode).zfill(2)))
	string_list.append(string4.replace('<<S>>', str(season).zfill(2)).replace('<<E1>>', str(episode-1).zfill(2)).replace('<<E2>>', str(episode).zfill(2)))
	string_list.append(string4.replace('<<S>>', str(season).zfill(2)).replace('<<E1>>', str(episode).zfill(2)).replace('<<E2>>', str(episode+1).zfill(2)))
	string_list.append(string5.replace('<<E>>', str(episode).zfill(2)))
	final_string = '|'.join(string_list)
	reg_pattern = re.compile(final_string)
	if split:
		return release_title.split(re.search(reg_pattern, release_title).group(), 1)[1]
	else:
		return bool(re.search(reg_pattern, release_title))

def extras_filter():
	return ['sample', 'extra', 'extras', 'deleted', 'unused', 'footage', 'inside', 'blooper', 'bloopers', 'making.of', 'feature', 'featurette', 'behind.the.scenes', 'trailer']

def find_season_in_release_title(release_title):
	try: from urllib import unquote
	except: from urllib.parse import unquote
	release_title = re.sub(r'[^A-Za-z0-9-]+', '.', unquote(release_title).replace('\'', '')).lower()
	match = None
	regex_list = [r's(\d+)', r's\.(\d+)', r'(\d+)x', r'(\d+)\.x', r'season(\d+)', r'season\.(\d+)']
	for item in regex_list:
		try:
			match = re.search(item, release_title)
			if match:
				match = int(str(match.group(1)).lstrip('0'))
				break
		except: pass
	return match

def check_title(title, release_title, aliases, year, season, episode):
	try:
		if season:
			if not seas_ep_filter(season, episode, release_title): return False
			hdlr = 'S%02dE%02d' % (int(season), int(episode))
		else: hdlr = str(year)
		all_titles = [title]
		if aliases: all_titles += aliases
		cleaned_titles = []
		for i in all_titles: cleaned_titles.append(clean_title(i.replace('!', '').replace('(', '').replace(')', '').replace('&', 'and')))
		release_title = release_title_format(release_title)
		release_title = release_title.split(hdlr.lower())[0].replace(str(year), '').replace('(', '').replace(')', '').replace('&', 'and')
		release_title = release_title.split('2160p')[0].split('4k')[0].split('1080p')[0].split('720p')[0]
		release_title = clean_title(release_title)
		if not any(release_title == i for i in cleaned_titles):	return False
		return True
	except:
		return True

def release_title_format(release_title):
	try:
		release_title = release_title.lower().replace("'", "").lstrip('.').rstrip('.')
		fmt = '.%s.' % re.sub(r'[^a-z0-9-~]+', '.', release_title).replace('.-.', '-').replace('-.', '-').replace('.-', '-').replace('--', '-')
		return fmt
	except:
		return release_title.lower()

def clean_title(title):
	try:
		import re
		if not title: return
		title = title.lower()
		title = re.sub(r'&#(\d+);', '', title)
		title = re.sub(r'(&#[0-9]+)([^;^0-9]+)', '\\1;\\2', title)
		title = re.sub(r'(&#[0-9]+)([^;^0-9]+)', '\\1;\\2', title)
		title = title.replace('&quot;', '\"').replace('&amp;', '&')
		title = re.sub(r'\n|([\[({].+?[})\]])|([:;–\-"\',!_.?~$@])|\s', '', title)
	except: pass
	return title

def get_release_quality(release_name, release_link=None):
	quality = 'default'
	try:
		try:
			fmt = replace_html_codes(release_name)
			fmt = unquote(fmt)
			fmt = fmt.lower()
			fmt = re.sub(r'[^a-z0-9]+', ' ', fmt)
			fmt = fmt + ' '
		except:
			fmt = str(release_name)
		if any(i in fmt for i in CAM): quality = 'CAM'
		elif any(i in fmt for i in SCR): quality = 'SCR'
		elif any(i in fmt for i in TELE): quality = 'TELE'
		elif any(i in fmt for i in RES_4K): quality = '4K'
		elif any(i in fmt for i in RES_1080): quality = '1080p'
		elif any(i in fmt for i in RES_720): quality = '720p'
		elif any(i in fmt for i in RES_SD): quality = 'SD'
	except: pass
	if quality == 'default':
		if release_link:
			try:
				try:
					fmt = replace_html_codes(release_link)
					fmt = unquote(fmt)
					fmt = fmt.lower()
					fmt = re.sub(r'[^a-z0-9]+', ' ', fmt)
					fmt = fmt + ' '
				except:
					fmt = str(release_link)
				if any(i in fmt for i in CAM): quality = 'CAM'
				elif any(i in fmt for i in SCR): quality = 'SCR'
				elif any(i in fmt for i in TELE): quality = 'TELE'
				elif any(i in fmt for i in RES_4K): quality = '4K'
				elif any(i in fmt for i in RES_1080): quality = '1080p'
				elif any(i in fmt for i in RES_720): quality = '720p'
				elif any(i in fmt for i in RES_SD): quality = 'SD'
			except: pass
		else: pass
	if quality == 'default': quality = 'SD'
	return quality

def get_file_info(url):
	try:
		url = replace_html_codes(url)
		url = unquote(url)
		url = url.lower()
		url = re.sub(r'[^a-z0-9]+', ' ', url)
		url = url + ' '
	except:
		url = str(url)
	info = ''
	if any(i in url for i in HEVC):
		info += '[B]HEVC[/B] |'
	if any(i in url for i in HDR):
		info += ' [B]HDR[/B] |'
	if any(i in url for i in DV):
		info += ' [B]D/VISION[/B] |'
	if ' hi10p ' in url:
		info += ' HI10P |'
	if ' 10bit ' in url:
		info += ' 10BIT |'
	if ' 3d ' in url:
		info += ' 3D |'
	if any(i in url for i in BLURAY):
		info += ' BLURAY |'
	if any(i in url for i in BDRIP):
		info += ' BD-RIP |'
	if any(i in url for i in REMUX):
		info += ' REMUX |'
	if any(i in url for i in DVDRIP):
		info += ' DVD-RIP |'
	if any(i in url for i in DVD):
		info += ' DVD |'
	if any(i in url for i in WEB):
		info += ' WEB |'
	if ' hdtv ' in url:
		info += ' HDTV |'
	if ' sdtv ' in url:
		info += ' SDTV |'
	if any(i in url for i in HDRIP):
		info += ' HDRIP |'
	if any(i in url for i in UHDRIP):
		info += ' UHDRIP |'

	if ' imax ' in url:
		info += ' IMAX |'
	if any(i in url for i in AC3):
		info += ' AC3 |'
	if ' aac ' in url:
		info += ' AAC |'
	if ' aac5 1 ' in url:
		info += ' AAC | 5.1 |'
	if any(i in url for i in DD):
		info += ' DD |'
	if any(i in url for i in TRUEHD):
		info += ' TRUEHD |'
	if ' atmos ' in url:
		info += ' ATMOS |'
	if any(i in url for i in DDPLUS):
		info += ' DD+ |'
	if ' dts ' in url:
		info += ' DTS |'
	if any(i in url for i in HDMA):
		info += ' HD.MA |'
	if any(i in url for i in HDHRA):
		info += ' HD.HRA |'
	if any(i in url for i in DTSX):
		info += ' DTS:X |'
	if any(i in url for i in DD51):
		info += ' DD | 5.1 |'
	if any(i in url for i in DDP51):
		info += ' DD+ | 5.1 |'
	if ' opus ' in url:
		info += ' OPUS |'
	if any(i in url for i in D51):
		info += ' 5.1 |'
	if any(i in url for i in D71):
		info += ' 7.1 |'
	if any(i in url for i in SUBS):
		info += ' SUBS |'
	if any(i in url for i in DUB):
		info += ' DUB |'
	info = info.rstrip('|')
	return info




