# -*- coding: utf-8 -*-
from windows.base_dialog import BaseDialog
# from modules.utils import logger

class VideoPlayerXML(BaseDialog):
	def __init__(self, *args, **kwargs):
		BaseDialog.__init__(self, args)
		self.video = kwargs['video']
		self.meta = kwargs['meta']
		self.set_properties()

	def onInit(self):
		self.player.play(self.video, windowed=True)
		self.monitor()

	def run(self):
		self.doModal()
	
	def onAction(self, action, controlID=None):
		if action in self.closing_actions:
			self.player.stop()
			self.close()

	def monitor(self):
		while not self.player.isPlayingVideo(): self.sleep(100)
		self.sleep(100)
		progress_bar = self.getControl(5000)
		total_time = self.player.getTotalTime()
		while self.player.isPlayingVideo():
			try:
				current_point = (self.player.getTime() / float(total_time)) * 100
				progress_bar.setPercent(current_point)
			except: pass
			self.sleep(1000)
		self.close()

	def set_properties(self):
		self.setProperty('tikiskins.videoplayer.fanart', self.meta['fanart'])
		self.setProperty('tikiskins.videoplayer.clearlogo', self.meta['clearlogo'])
		self.setProperty('tikiskins.videoplayer.title', self.meta['title'])
