# -*- coding: utf-8 -*-
import xbmc, xbmcgui
import time
import json
from threading import Thread
from sys import exit as sysexit
try: from urllib import unquote
except ImportError: from urllib.parse import unquote
from windows import open_window
from scrapers.external import ExternalSource
from scrapers.folder_scraper import FolderScraper
from modules import debrid
from modules import resolver
from modules.player import FenPlayer
from modules.source_utils import sources, scraperNames
from modules.kodi_utils import translate_path, notification, show_busy_dialog, hide_busy_dialog, sleep
from modules.utils import clean_file_name, string_to_float, to_utf8, safe_string, remove_accents, select_dialog, confirm_dialog, local_string as ls
from modules.settings_reader import get_setting
from modules import settings
# from modules.utils import logger

window = xbmcgui.Window(10000)
dialog = xbmcgui.Dialog()
monitor = xbmc.Monitor()

class Sources():
	def __init__(self):
		self.progress_dialog = None
		self.filters_ignored = False
		self.params = {}
		self.threads = []
		self.providers = []
		self.sources = []
		self.prescrape_scrapers = []
		self.prescrape_threads = []
		self.prescrape_sources = []
		self.remove_scrapers = []
		self.prescrape = 'true'
		self.disabled_ignored = 'false'
		self.exclude_list = ['furk', 'easynews']
		self.direct_ext_scrapers = ['ororo', 'filepursuit', 'gdrive']
		self.folder_scrapers = ('folder1', 'folder2', 'folder3', 'folder4', 'folder5')
		self.internal_scrapers = ('furk', 'easynews', 'rd-cloud', 'pm-cloud', 'ad-cloud', 'folder1', 'folder2', 'folder3', 'folder4', 'folder5')
		self.sourcesTotal = self.sources4K = self.sources1080p = self.sources720p = self.sourcesSD = 0
		self.language = get_setting('meta_language')

	def playback_prep(self, params=None):
		self._clear_properties()
		if params: self.params = params
		self.vid_type = self.params['vid_type']
		self.tmdb_id = self.params['tmdb_id']
		self.query = self.params['query']
		self.ep_name = self.params.get('ep_name')
		self.plot = self.params.get('plot')
		self.prescrape = self.params.get('prescrape', self.prescrape) == 'true'
		self.background = self.params.get('background', 'false') == 'true'
		self.disabled_ignored = self.params.get('disabled_ignored', self.disabled_ignored) == 'true'
		if 'remove_scrapers' in self.params: self.remove_scrapers = json.loads(self.params['remove_scrapers'])
		if 'prescrape_sources' in self.params: self.prescrape_sources = json.loads(self.params['prescrape_sources'])
		if 'autoplay' in self.params: self.autoplay = self.params.get('autoplay', 'False') == 'True'
		else: self.autoplay = settings.auto_play(self.vid_type)
		if 'season' in self.params: self.season = int(self.params['season'])
		else: self.season = ''
		if 'episode' in self.params: self.episode = int(self.params['episode'])
		else: self.episode = ''
		if 'meta' in self.params: self.meta = json.loads(self.params['meta'])
		else: self._grab_meta()
		self.active_scrapers = settings.active_scrapers()
		self.provider_sort_ranks = settings.provider_sort_ranks()
		self.sleep_time = settings.display_sleep_time()
		self.scraper_settings = settings.scraping_settings()
		self.include_prerelease_results = settings.include_prerelease_results()
		self.ignore_filters = settings.ignore_results_filter()
		self.filter_hevc = settings.filter_hevc()
		self.sort_keys = settings.results_sort_order()
		self.display_uncached_torrents = settings.display_uncached_torrents()
		self.quality_filter = self._quality_filter()
		self.filter_size = get_setting('results.filter.size', '0') == 'true'
		self.include_3D_results = get_setting('include_3d_results') == 'true'
		self.include_HDR_results = get_setting('include_hdr_results') == 'true'
		self.include_DV_results = get_setting('include_dv_results') == 'true'
		display_name = clean_file_name(unquote(self.query)) if self.vid_type == 'movie' else '%s - %dx%.2d' % (self.meta['title'], self.season, self.episode)
		self.meta.update({'query': self.query, 'vid_type': self.vid_type, 'media_id': self.tmdb_id, 'rootname': display_name, 'tvshowtitle': self.meta['title'],
						  'season': self.season, 'episode': self.episode, 'background': self.background})
		self.search_info = self._search_info()
		window.setProperty('fen_media_meta', json.dumps(self.meta))
		hide_busy_dialog()
		self.get_sources()

	def get_sources(self):
		results = []
		self.active_scrapers = [i for i in self.active_scrapers if not i in self.remove_scrapers]
		if any(x in self.active_scrapers for x in self.internal_scrapers):
			if self.prescrape:
				results = self.pre_scrape_check()
				if results: results = self.process_results(results)
		if not results:
			self.prescrape = False
			if 'external' in self.active_scrapers:
				self.activate_debrid_info()
				self.activate_external_providers()
			self.orig_results = self.collect_results()
			results = self.process_results(self.orig_results)
			if not results: return self._process_post_results()
		hide_busy_dialog()
		self.play_source(results)

	def collect_results(self):
		if any(x in self.folder_scrapers for x in self.active_scrapers):
			self.check_folder_scrapers(self.active_scrapers, self.providers, False)
		if 'furk' in self.active_scrapers:
			from scrapers.furk import FurkSource
			self.providers.append(('furk', FurkSource()))
		if 'easynews' in self.active_scrapers:
			from scrapers.easynews import EasyNewsSource
			self.providers.append(('easynews', EasyNewsSource()))
		if 'pm-cloud' in self.active_scrapers:
			from scrapers.pm_cache import PremiumizeSource
			self.providers.append(('pm-cloud', PremiumizeSource()))
		if 'rd-cloud' in self.active_scrapers:
			from scrapers.rd_cache import RealDebridSource
			self.providers.append(('rd-cloud', RealDebridSource()))
		if 'ad-cloud' in self.active_scrapers:
			from scrapers.ad_cache import AllDebridSource
			self.providers.append(('ad-cloud', AllDebridSource()))
		if 'external' in self.active_scrapers:
			internal_scrapers = self.active_scrapers[:]
			internal_scrapers.remove('external')
			if not internal_scrapers: internal_scrapers = []
		if self.providers:
			for i in range(len(self.providers)):
				self.threads.append(Thread(target=self.activate_providers, args=(self.providers[i][1], False), name=self.providers[i][0]))
			[i.start() for i in self.threads]
		self.sources.extend(self.prescrape_sources)
		if 'external' in self.active_scrapers or self.background:
			if 'external' in self.active_scrapers:
				internal_scrapers = self.get_folderscraper_names(internal_scrapers)
				self.activate_providers(ExternalSource(self.external_providers, self.debrid_torrent_enabled, self.debrid_valid_hosts, internal_scrapers,
														self.prescrape_sources, self.display_uncached_torrents, self.progress_dialog), False)
			if self.providers:
				[i.join() for i in self.threads]
		else:
			self.scrapers_dialog('internal')
		return self.sources

	def process_results(self, results):
		results = self.filter_results(results)
		results = self.sort_results(results)
		results = self.sort_hevc(results)
		return results

	def filter_results(self, results):
		def _filter():
			for item in results:
				append_item = False
				if item['quality'] in self.quality_filter:
					append_item = True
					if self.filter_size:
						if not item['scrape_provider'].startswith('folder'):
							size = item['size']
							if size < 0.01:
								if not include_unknown_size: append_item = False
							elif size > max_size: append_item = False
					extraInfo = item['extraInfo']
					if append_item and not self.include_3D_results:
						if '3D' in extraInfo: append_item = False
					if append_item and not self.include_HDR_results:
						if 'HDR' in extraInfo: append_item = False
					if append_item and not self.include_DV_results:
						if 'D/VISION' in extraInfo: append_item = False
				if append_item: yield item
		if self.filter_size:
			include_unknown_size = get_setting('results.include.unknown.size') == 'true'
			duration = self.meta['duration'] or (5400 if self.vid_type == 'movie' else 2400)
			max_size = ((0.125 * (0.90 * string_to_float(get_setting('results.size.auto', '20'), '20'))) * duration)/1000
		return list(_filter())

	def sort_results(self, results):
		def _add_keys(item):
			provider = item['scrape_provider']
			if 'folder' in provider: provider = 'files'
			if provider == 'external':
				try: account_type = item['debrid'].lower()
				except: account_type = 'free'
			else: account_type = provider.lower()
			item['provider_rank'] = self._get_provider_rank(account_type)
			item['quality_rank'] = self._get_quality_rank(item.get('quality', 'SD'))
		for item in results: _add_keys(item)
		for item in reversed(self.sort_keys):
			if item == 'size': reverse = True
			else: reverse = False
			results = sorted(results, key=lambda k: k[item], reverse=reverse)
		results = self._sort_uncached_torrents(results)
		results = self._sort_first(results)
		return results

	def sort_hevc(self, results):
		if self.filter_hevc == 1:
			results = [i for i in results if not 'HEVC' in i['extraInfo']]
		elif self.filter_hevc == 2 and self.autoplay:
			hevc_list = [i for i in results if 'HEVC' in i['extraInfo']]
			non_hevc_list = [i for i in results if not i in hevc_list]
			results = hevc_list + non_hevc_list
		return results

	def activate_providers(self, function, prescrape):
		sources = function.results(self.search_info)
		if sources:
			self.sources_quality_count(sources)
			if prescrape: self.prescrape_sources.extend(sources)
			else: self.sources.extend(sources)
	
	def sources_quality_count(self, sources):
		for i in sources:
			quality = i['quality']
			if quality == '4K': self.sources4K += 1
			elif quality in ['1440p', '1080p']: self.sources1080p += 1
			elif quality in ['720p', 'HD']: self.sources720p += 1
			else: self.sourcesSD += 1
			self.sourcesTotal += 1

	def activate_external_providers(self):
		external_providers = sources(self.disabled_ignored)
		if self.debrid_torrent_enabled == []:
			torrent_scrapers = scraperNames('torrents')
			self.exclude_list.extend(torrent_scrapers)
		if self.debrid_valid_hosts == []:
			hoster_scrapers = scraperNames('hosters')
			hoster_scrapers = [i for i in hoster_scrapers if not i in self.direct_ext_scrapers]
			self.exclude_list.extend(hoster_scrapers)
		self.external_providers = [i for i in external_providers if not i[0] in self.exclude_list]

	def activate_debrid_info(self):
		self.debrid_enabled = debrid.debrid_enabled()
		debrid_hoster_enabled = debrid.debrid_type_enabled('hoster', self.debrid_enabled)
		self.debrid_torrent_enabled = debrid.debrid_type_enabled('torrent', self.debrid_enabled)
		self.debrid_valid_hosts = debrid.debrid_valid_hosts(debrid_hoster_enabled)

	def play_source(self, results):
		if self.background:
			return self.play_execute_nextep(results)
		if self.autoplay:
			return self.play_file(results, autoplay=True)
		return self.display_results(results)

	def pre_scrape_check(self):
		if self.autoplay:
			if any(x in self.folder_scrapers for x in self.active_scrapers):
				self.check_folder_scrapers(self.active_scrapers, self.prescrape_scrapers, False)
				self.remove_scrapers.extend(self.folder_scrapers)
		else:
			if any(x in self.folder_scrapers for x in self.active_scrapers) and settings.check_prescrape_sources('folders'):
				self.check_folder_scrapers(self.active_scrapers, self.prescrape_scrapers)
				self.remove_scrapers.extend(self.folder_scrapers)
		if 'furk' in self.active_scrapers and settings.check_prescrape_sources('furk'):
			from scrapers.furk import FurkSource
			self.prescrape_scrapers.append(('furk', FurkSource()))
			self.remove_scrapers.append('furk')
		if 'easynews' in self.active_scrapers and settings.check_prescrape_sources('easynews'):
			from scrapers.easynews import EasyNewsSource
			self.prescrape_scrapers.append(('easynews', EasyNewsSource()))
			self.remove_scrapers.append('easynews')
		if 'rd-cloud' in self.active_scrapers and settings.check_prescrape_sources('rd-cloud'):
			from scrapers.rd_cache import RealDebridSource
			self.prescrape_scrapers.append(('rd-cloud', RealDebridSource()))
			self.remove_scrapers.append('rd-cloud')
		if 'pm-cloud' in self.active_scrapers and settings.check_prescrape_sources('pm-cloud'):
			from scrapers.pm_cache import PremiumizeSource
			self.prescrape_scrapers.append(('pm-cloud', PremiumizeSource()))
			self.remove_scrapers.append('pm-cloud')
		if 'ad-cloud' in self.active_scrapers and settings.check_prescrape_sources('ad-cloud'):
			from scrapers.ad_cache import AllDebridSource
			self.prescrape_scrapers.append(('ad-cloud', AllDebridSource()))
			self.remove_scrapers.append('ad-cloud')
		len_prescrape_scrapers = len(self.prescrape_scrapers)
		if len_prescrape_scrapers == 0: return []
		for i in range(len_prescrape_scrapers):
			self.prescrape_threads.append(Thread(target=self.activate_providers, args=(self.prescrape_scrapers[i][1], True), name=self.prescrape_scrapers[i][0]))
		[i.start() for i in self.prescrape_threads]
		if self.background:
			[i.join() for i in self.prescrape_threads]
		else:
			self.scrapers_dialog('pre_scrape')
		return self.prescrape_sources

	def check_folder_scrapers(self, active_scrapers, append_list, prescrape=True):
		for i in active_scrapers:
			if i.startswith('folder'):
				scraper_name = get_setting('%s.display_name' % i)
				if prescrape:
					if settings.check_prescrape_sources('folders'): append_list.append((scraper_name, FolderScraper(i, scraper_name)))
				else: append_list.append((scraper_name, FolderScraper(i, scraper_name)))

	def get_folderscraper_names(self, internal_scrapers):
		folder_scrapers = [i for i in internal_scrapers if i.startswith('folder')]
		if not folder_scrapers: return internal_scrapers
		internal_scrapers = [i for i in internal_scrapers if not i in folder_scrapers]
		for i in folder_scrapers: internal_scrapers.append(get_setting('%s.display_name' % i))
		return internal_scrapers

	def scrapers_dialog(self, scrape_type):
		def _scraperDialog():
			close_dialog = True
			while not self.progress_dialog.iscanceled():
				try:
					if monitor.abortRequested() is True: return sysexit()
					remaining_providers = [x.getName() for x in _threads if x.is_alive() is True]
					s4k_label = total_format % (int_dialog_hl, self.sources4K)
					s1080_label = total_format % (int_dialog_hl, self.sources1080p)
					s720_label = total_format % (int_dialog_hl, self.sources720p)
					ssd_label = total_format % (int_dialog_hl, self.sourcesSD)
					stotal_label = total_format % (int_dialog_hl, self.sourcesTotal)
					try:
						current_time = time.time()
						current_progress = current_time - start_time
						line1 = '[COLOR %s][B]%s[/B][/COLOR]' % (int_dialog_hl, line1_inst)
						line2 = '[COLOR %s][B]%s[/B][/COLOR] 4K: %s | 1080p: %s | 720p: %s | SD: %s | Total: %s' \
								% (int_dialog_hl, line2_inst, s4k_label, s1080_label, s720_label, ssd_label, stotal_label)
						if len(remaining_providers) > 3: line3_insert = str(len(remaining_providers))
						else: line3_insert = ', '.join(remaining_providers).upper()
						line3 = remaining_providers_str % line3_insert
						percent = int((current_progress/float(timeout))*100)
						self.progress_dialog.update(max(1, percent), line % (line1, line2, line3))
						if len(remaining_providers) == 0: close_dialog = False; break
						if end_time < current_time: close_dialog = False; break
						sleep(self.sleep_time)
					except: pass
				except Exception:
					pass
			if close_dialog: self._kill_progress_dialog()
		hide_busy_dialog()
		timeout = 25
		remaining_providers_str = ls(32676)
		line = '%s[CR]%s[CR]%s'
		int_dialog_hl = get_setting('int_dialog_highlight')
		if not int_dialog_hl or int_dialog_hl == '': int_dialog_hl = 'dodgerblue'
		total_format = '[COLOR %s][B]%s[/B][/COLOR]'
		_progress_title = self.meta.get('rootname')
		if scrape_type == 'internal':
			_threads = self.threads
			line1_inst = ls(32096)
			line2_inst = 'Int:'
		else:
			_threads = self.prescrape_threads
			line1_inst = '%s %s' % (ls(32829), ls(32830))
			line2_inst = 'Pre:'
		start_time = time.time()
		end_time = start_time + timeout
		self.progress_dialog = xbmcgui.DialogProgress()
		self.progress_dialog.create(_progress_title, '')
		self.progress_dialog.update(0)
		_scraperDialog()

	def display_results(self, results):
		window_style = settings.results_xml_style()
		action, chosen_item = open_window(('windows.source_results', 'SourceResultsXML'), 'source_results.xml', settings.skin_location(),
							window_style=window_style, window_id=settings.results_xml_window_number(window_style), results=results,
							meta=self.meta, scraper_settings=self.scraper_settings, prescrape=self.prescrape, filters_ignored=self.filters_ignored)
		if action == 'play':
			if self.prescrape: self._kill_progress_dialog()
			return self.play_file(results, chosen_item)
		elif self.prescrape and action == 'perform_full_search':
			self.params['prescrape'] = 'false'
			self.params['prescrape_sources'] = json.dumps(self.prescrape_sources)
			self.params['remove_scrapers'] = json.dumps(self.remove_scrapers)
			return self.playback_prep()

	def play_execute_nextep(self, results):
		url = self.play_file(results, autoplay=True, background=True)
		if settings.autoplay_next_show_window():
			action = open_window(('windows.next_episode', 'NextEpisode'), 'next_episode.xml', settings.skin_location(), meta=self.meta, function='next_ep')
			if action == 'cancel': return notification(ls(32736), 4500)
		else:
			action = 'close'
			meta = json.loads(window.getProperty('fen_media_meta'))
			notification('%s %s S%02dE%02d' % (ls(32801), meta['title'], meta['season'], meta['episode']), 10000, meta['poster'])
		player = xbmc.Player()
		if action == 'play': player.stop()
		else:
			while player.isPlaying(): sleep(100)
		FenPlayer().run(url)

	def _process_post_results(self):
		if self.ignore_filters and self.orig_results: return self._process_ignore_filters()
		return self._no_results()

	def _process_ignore_filters(self):
		self.filters_ignored = True
		orig_results = [i for i in self.orig_results if not i in self.prescrape_sources]
		orig_results.extend(self.prescrape_sources)
		if self.autoplay:
			orig_results = [i for i in orig_results if not 'Uncached' in i.get('cache_provider', '')]
			if self.filter_size:
				duration = self.meta['duration'] or (5400 if self.vid_type == 'movie' else 2400)
				min_size = 0
				max_size = ((0.125 * (0.90 * string_to_float(get_setting('results.size.auto', '20'), '20'))) * duration)/1000
				orig_results = sorted(orig_results, key=lambda x: x['size'])
				size_list = [i['size'] for i in orig_results]
				nearest_min_index = size_list.index(min(size_list, key=lambda x: abs(x - min_size)))
				nearest_max_index = size_list.index(min(size_list, key=lambda x: abs(x - max_size)))
				nearest_min_results = sorted(orig_results[:nearest_min_index + 1], key=lambda x: x['size'], reverse=True)[:5]
				nearest_max_results = sorted(orig_results[nearest_max_index:], key=lambda x: x['size'])[:5]
				orig_results = nearest_min_results + nearest_max_results
			include_quality = [item for item in orig_results if item['quality'] in self.quality_filter]
			exclude_quality = [item for item in orig_results if not item['quality'] in self.quality_filter]
			results = include_quality + exclude_quality
		else:
			results = self.sort_results(orig_results)
		if self.autoplay: notification(ls(32686))
		return self.play_source(results)

	def _no_results(self):
		hide_busy_dialog()
		if self.background: return notification('%s %s' % (ls(32801), ls(32760)), 5000)
		notification(ls(32760))

	def _search_info(self):
		title = self._get_search_title(self.meta)
		year = self._get_search_year()
		aliases = self._make_alias_dict(title)
		ep_name = self._get_ep_name()
		return {'db_type': self.vid_type, 'title': title, 'year': year, 'tmdb_id': self.tmdb_id,
				'imdb_id': self.meta.get('imdb_id'), 'season': self.season, 'episode': self.episode, 'premiered': self.meta.get('premiered'),
				'tvdb_id': self.meta.get('tvdb_id'), 'aliases': aliases, 'ep_name': ep_name,
				'language': self.language}

	def _get_search_title(self, meta):
		if 'search_title' in meta:
			search_title = meta['search_title']
		else: search_title = meta['title']
		if '(' in search_title: search_title = search_title.split('(')[0]
		return search_title

	def _get_search_year(self):
		year = self.meta.get('year')
		if self.vid_type == "movie" and 'external' in self.active_scrapers:
			if get_setting('search.enable.yearcheck', 'false') == 'true':
				show_busy_dialog()
				from apis.imdb_api import imdb_movie_year
				try: year = imdb_movie_year(self.meta.get('imdb_id'))
				except: year = self.meta.get('year')
				hide_busy_dialog()
		return year

	def _get_ep_name(self):
		ep_name = None
		if self.vid_type == 'episode':
			try: ep_name = to_utf8(safe_string(remove_accents(self.meta.get('ep_name'))))
			except: ep_name = to_utf8(safe_string(self.meta.get('ep_name')))
		return ep_name

	def _make_alias_dict(self, title):
		original_title = self.meta['original_title']
		alternative_titles = self.meta.get('alternative_titles', [])
		country_codes = set([i.replace('GB', 'UK') for i in self.meta.get('country_codes', [])])
		aliases = [{'title': i, 'country': ''} for i in alternative_titles]
		if original_title not in aliases: aliases.append({'title': original_title, 'country': ''})
		if country_codes: aliases.extend([{'title': '%s %s' % (title, i), 'country': ''} for i in country_codes])
		return json.dumps(aliases)

	def _quality_filter(self):
		setting = 'results_quality_%s' % self.vid_type if not self.autoplay else 'autoplay_quality_%s' % self.vid_type
		quality_filter = settings.quality_filter(setting)
		if self.include_prerelease_results and 'SD' in quality_filter: quality_filter += ['SCR', 'CAM', 'TELE']
		return quality_filter

	def _get_quality_rank(self, quality):
		return {'4K': 1, '1080p': 2, '720p': 3, 'SD': 4, 'SCR': 5, 'CAM': 5, 'TELE': 5}[quality]

	def _get_provider_rank(self, account_type):
		return self.provider_sort_ranks[account_type] or 11

	def _sort_first(self, results):
		if not any(x in self.folder_scrapers for x in self.active_scrapers+self.remove_scrapers): return results
		if not get_setting('results.sort_folders_first', 'true') == "true": return results
		for scraper in self.folder_scrapers:
			try:
				inserts = []
				folder_results = [i for i in results if i['scrape_provider'] == scraper]
				for i in folder_results:
					inserts.append(i)
					results.remove(i)
				inserts = sorted(inserts, key=lambda k: k['quality_rank'], reverse=True)
				for i in inserts: results.insert(0, i)
			except: pass
		return results

	def _sort_uncached_torrents(self, results):
		uncached = [i for i in results if 'Uncached' in i.get('cache_provider', '')]
		results = [i for i in results if not i in uncached]
		return results + uncached

	def _grab_meta(self):
		import metadata
		meta_user_info = metadata.retrieve_user_info(window)
		if self.vid_type == "movie":
			self.meta = metadata.movie_meta('tmdb_id', self.tmdb_id, meta_user_info)
			if not 'rootname' in self.meta: self.meta['rootname'] = '{0} ({1})'.format(self.meta['title'], self.meta['year'])
		else:
			self.meta = metadata.tvshow_meta('tmdb_id', self.tmdb_id, meta_user_info)
			episodes_data = metadata.season_episodes_meta(self.season, self.meta, meta_user_info)
			try:
				display_name = '%s - %dx%.2d' % (self.meta['title'], self.season, self.episode)
				episode_data = [i for i in episodes_data if i['episode'] == int(self.episode)][0]
				self.meta.update({'vid_type': 'episode', 'rootname': display_name, 'season': episode_data['season'],
							'episode': episode_data['episode'], 'premiered': episode_data['premiered'], 'ep_name': episode_data['title'],
							'plot': episode_data['plot']})
			except: pass

	def _pack_playback(self, filename, link, meta):
		from modules.source_utils import seas_ep_filter
		meta = json.loads(meta)
		season, episode = meta['season'], meta['episode']
		if seas_ep_filter(season, episode, filename): rootname = None
		else: rootname = 'video'
		FenPlayer().run(link, rootname)

	def _clear_properties(self):
		for item in self.internal_scrapers: window.clearProperty('%s.internal_results' % item)

	def _kill_progress_dialog(self):
		try: self.progress_dialog.close()
		except Exception: pass
		del self.progress_dialog
		self.progress_dialog = None

	def furkPacks(self, name, file_id, highlight=None, meta=None, download=False):
		from apis.furk_api import FurkAPI
		show_busy_dialog()
		t_files = FurkAPI().t_files(file_id)
		t_files = [i for i in t_files if 'video' in i['ct'] and 'bitrate' in i]
		t_files = sorted(t_files, key=lambda k: k['name'].lower())
		hide_busy_dialog()
		if download: return t_files
		default_furk_icon = translate_path('special://home/addons/script.tikiart/resources/media/furk.png')
		list_items = [{'line1': '%.2f GB | %s' % (float(item['size'])/1073741824, clean_file_name(item['name']).upper()), 'icon': default_furk_icon} for item in t_files]
		kwargs = {'items': json.dumps(list_items), 'heading': name, 'highlight': highlight, 'enumerate': 'true', 'multi_choice': 'false', 'multi_line': 'false'}
		chosen_result = select_dialog(t_files, **kwargs)
		if chosen_result is None: return None
		link = chosen_result['url_dl']
		name = chosen_result['name']
		return self._pack_playback(name, link, meta)

	def debridPacks(self, debrid_provider, name, magnet_url, info_hash, highlight=None, meta=None, download=False):
		if debrid_provider == 'Real-Debrid':
			from apis.real_debrid_api import RealDebridAPI as debrid_function
			icon = 'realdebrid.png'
		elif debrid_provider == 'Premiumize.me':
			from apis.premiumize_api import PremiumizeAPI as debrid_function
			icon = 'premiumize.png'
		elif debrid_provider == 'AllDebrid':
			from apis.alldebrid_api import AllDebridAPI as debrid_function
			icon = 'alldebrid.png'
		show_busy_dialog()
		try: debrid_files = debrid_function().display_magnet_pack(magnet_url, info_hash)
		except: debrid_files = None
		debrid_files = sorted(debrid_files, key=lambda k: k['filename'].lower())
		hide_busy_dialog()
		if not debrid_files: return notification(ls(32574))
		if download: return debrid_files, debrid_function
		default_debrid_icon = translate_path('special://home/addons/script.tikiart/resources/media/%s' % icon)
		list_items = [{'line1': '%.2f GB | %s' % (float(item['size'])/1073741824, clean_file_name(item['filename']).upper()), 'icon': default_debrid_icon} for item in debrid_files]
		kwargs = {'items': json.dumps(list_items), 'heading': name, 'highlight': highlight, 'enumerate': 'true', 'multi_choice': 'false', 'multi_line': 'false'}
		chosen_result = select_dialog(debrid_files, **kwargs)
		if chosen_result is None: return None
		url_dl = chosen_result['link']
		if debrid_provider in ('Real-Debrid', 'AllDebrid'):
			link = debrid_function().unrestrict_link(url_dl)
		elif debrid_provider == 'Premiumize.me':
			link = debrid_function().add_headers_to_url(url_dl)
		name = chosen_result['filename']
		return self._pack_playback(name, link, meta)

	def play_file(self, results, source={}, autoplay=False, background=False):
		def _uncached_confirm(item):
			if not confirm_dialog(text=ls(32831) % item['debrid'].upper()):
				return None
			else:
				self.caching_confirmed = True
				return item
		try:
			if autoplay:
				items = [i for i in results if not 'Uncached' in i.get('cache_provider', '')]
				if self.filters_ignored: notification(ls(32686))
			else:
				results = [i for i in results if not 'Uncached' in i.get('cache_provider', '') or i == source]
				source_index = results.index(source)
				leading_index = max(source_index-20, 0)
				items_prev = results[leading_index:source_index]
				trailing_index = 41 - len(items_prev)
				items_next = results[source_index+1:source_index+trailing_index]
				items = [source] + items_next + items_prev
			total_items = len(items)
			line = '%s[CR]%s[CR]%s'
			if not background:
				progressDialog = xbmcgui.DialogProgress()
				progressDialog.create('Fen', line % ('', '', ''))
				progressDialog.update(0)
			while not monitor.abortRequested() or not progressDialog.iscanceled():
				for count, item in enumerate(items, 1):
					try:
						self.caching_confirmed = False
						if not background:
							name = item['name'].replace('.', ' ').replace('-', ' ').upper()
							percent = int(count/float(total_items)*100)
							progressDialog.update(percent, line % ('', name, ''))
						url = self.resolve_sources(item, self.meta)
						if url == 'uncached':
							url = _uncached_confirm(item)
							if url is None: break
						if url: break
					except: pass
				break
			try: progressDialog.close()
			except: pass
			if background: return url
			if self.caching_confirmed:
				return self.resolve_sources(url, self.meta, cache_item=True)
			return FenPlayer().run(url)
		except: pass

	def resolve_sources(self, item, meta, cache_item=False):
		try:
			if 'cache_provider' in item:
				cache_provider = item['cache_provider']
				if meta['vid_type'] == 'episode': title, season, episode = meta['ep_name'], meta['season'], meta['episode']
				else: title, season, episode = self._get_search_title(meta), None, None
				if cache_provider in ('Real-Debrid', 'Premiumize.me', 'AllDebrid'):
					url = resolver.resolve_cached_torrents(cache_provider, item['url'], item['hash'], title, season, episode)
					return url
				if 'Uncached' in cache_provider:
					if cache_item:
						if not 'package' in item: title, season, episode  = None, None, None
						url = resolver.resolve_uncached_torrents(item['debrid'], item['url'], item['hash'], title, season, episode)
						if not url: return None
						if url == 'cache_pack_success': return
						return FenPlayer().run(url)
					else:
						url = 'uncached'
						return url
					return None
			if item.get('scrape_provider', None) in self.internal_scrapers:
				url = resolver.resolve_internal_sources(item['scrape_provider'], item['id'], item['url_dl'], item.get('direct_debrid_link', False))
				return url
			if item.get('debrid') in ('Real-Debrid', 'Premiumize.me', 'AllDebrid') and not item['source'].lower() == 'torrent':
				url = resolver.resolve_debrid(item['debrid'], item['provider'], item['url'])
				if url is not None:
					return url
				else: return None
			else:
				url = item['url']
				return url
		except Exception: return
