# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin
import json
from sys import argv
from datetime import date
from threading import Thread
import _strptime  # fix bug in python import
try: from urlparse import parse_qsl
except ImportError: from urllib.parse import parse_qsl
try: from sqlite3 import dbapi2 as database
except ImportError: from pysqlite2 import dbapi2 as database
from apis.trakt_api import get_trakt_tvshow_id, trakt_get_next_episodes, trakt_fetch_collection_watchlist
from indexers.tvshows import build_episode
from modules.indicators_bookmarks import get_watched_info_tv
from metadata import tvshow_meta, season_episodes_meta, retrieve_user_info
from modules.nav_utils import build_url, remove_meta_keys
from modules.kodi_utils import setView, notification, translate_path, sleep, execute_builtin, external_browse
from modules.utils import jsondate_to_datetime, get_datetime, title_key, make_thread_list, confirm_dialog, local_string as ls
from modules.settings_reader import get_setting
from modules import settings
# from modules.utils import logger

WATCHED_DB = translate_path('special://profile/addon_data/plugin.video.fen/watched_status.db')

window = xbmcgui.Window(10000)

def build_next_episode():
	def _process_eps(item):
		try:
			meta = tvshow_meta('tmdb_id', item['tmdb_id'], meta_user_info)
			current_season = item['season']
			current_episode = item['episode']
			unwatched = item.get('unwatched', False)
			season_data = meta['season_data']
			curr_season_data = [i for i in season_data if i['season_number'] == current_season][0]
			season = current_season if current_episode < curr_season_data['episode_count'] else current_season + 1
			episode = current_episode + 1 if current_episode < curr_season_data['episode_count'] else 1
			if watched_indicators == 1:
				resformat = '%Y-%m-%dT%H:%M:%S.%fZ'
				curr_last_played = item.get('last_played', '2000-01-01T00:00:00.000Z')
			else:
				resformat = '%Y-%m-%d %H:%M:%S'
				curr_last_played = item.get('last_played', '2000-01-01 00:00:00')
			datetime_object = jsondate_to_datetime(curr_last_played, resformat)
			episode_item = {'season': season, 'episode': episode, 'meta': meta, 'curr_last_played_parsed': datetime_object, 'action': 'next_episode',
							'unwatched': unwatched, 'nextep_display_settings': nextep_display_settings, 'include_unaired': include_unaired,
							'adjust_hours': adjust_hours, 'current_date': current_date, 'date_format': date_format, 'watched_indicators': watched_indicators}
			result.append(build_episode(episode_item, watched_info, use_trakt, meta_user_info, display_title, is_widget))
		except: pass
	def process_in_progress_eps(item):
		try:
			meta = tvshow_meta('tmdb_id', item['tmdb_id'], meta_user_info)
			datetime_object = jsondate_to_datetime('2050-01-01 00:00:00', '%Y-%m-%d %H:%M:%S')
			episode_item = {'season': int(item['season']), 'episode': int(item['episode']), 'meta': meta, 'curr_last_played_parsed': datetime_object, 'action': 'next_episode',
							'unwatched': True, 'nextep_display_settings': nextep_display_settings, 'include_unaired': include_unaired,
							'adjust_hours': adjust_hours, 'current_date': current_date, 'date_format': date_format, 'watched_indicators': watched_indicators}
			result.append(build_episode(episode_item, watched_info, use_trakt, meta_user_info, display_title, is_widget))
		except: pass
	try:
		__handle__ = int(argv[1])
		threads = []
		ep_list = []
		result = []
		nextep_settings = settings.nextep_content_settings()
		nextep_display_settings = settings.nextep_display_settings()
		display_title = settings.single_ep_display_title()
		watched_info, use_trakt = get_watched_info_tv()
		adjust_hours = settings.date_offset()
		current_date = get_datetime()
		date_format = settings.single_ep_format()
		is_widget = external_browse()
		meta_user_info = retrieve_user_info(window)
		watched_indicators = settings.watched_indicators()
		include_unaired = nextep_settings['include_unaired']
		if watched_indicators == 1:
			if nextep_settings['include_unwatched']:
				for i in get_unwatched_next_episodes(): ep_list.append(i)
			nextep_display_settings['from_trakt'] = True
			ep_list += trakt_get_next_episodes()
		else:
			nextep_display_settings['from_trakt'] = False
			seen = set()
			dbcon = database.connect(WATCHED_DB)
			dbcur = dbcon.cursor()
			dbcur.execute('''SELECT media_id, season, episode, last_played FROM watched_status WHERE db_type=?''', ('episode',))
			rows = dbcur.fetchall()
			rows = sorted(rows, key = lambda x: (x[0], x[1], x[2]), reverse=True)
			ep_list = [{'tmdb_id': a, 'season': int(b), 'episode': int(c), 'last_played': d} for a, b, c, d in rows if not (a in seen or seen.add(a))]
		ep_list = [i for i in ep_list if not i['tmdb_id'] is None]
		threads = list(make_thread_list(_process_eps, ep_list, Thread))
		[i.join() for i in threads]
		result = [i for i in result if i is not None]
		result = sort_next_eps(result, nextep_settings)
		item_list = [i['listitem'] for i in result]
		xbmcplugin.addDirectoryItems(__handle__, item_list, len(item_list))
		xbmcplugin.setContent(__handle__, 'episodes')
		xbmcplugin.endOfDirectory(__handle__, cacheToDisc=False)
		setView('view.episode_lists', 'episodes')
	except: notification(ls(32574), time=3500)

def sort_next_eps(result, nextep_settings):
	from datetime import timedelta
	from modules.utils import adjust_premiered_date
	def func(function):
		if sort_key == 'name': return title_key(function, ignore_articles)
		else: return function
	ignore_articles = settings.ignore_articles()
	sort_key = nextep_settings['sort_key']
	if nextep_settings['sort_airing_today_to_top']:
		current_date = get_datetime(string=True)
		adjusted_date_list = [adjust_premiered_date(current_date, item)[1] for item in range(-144,24,24)]
		last_weeks_eps = [i for i in result if i['first_aired'] in adjusted_date_list]
		sorted_last_week = sorted(last_weeks_eps, key=lambda i: i['first_aired'])
		other_eps = [i for i in result if not i in last_weeks_eps]
		sorted_other = sorted(other_eps, key=lambda i: func(i[sort_key]), reverse=nextep_settings['sort_direction'])
		sorted_eps = sorted_last_week + sorted_other
	else:
		sorted_eps = sorted(result, key=lambda i: func(i[sort_key]), reverse=nextep_settings['sort_direction'])
	return sorted_eps

def get_unwatched_next_episodes():
	try:
		data = trakt_fetch_collection_watchlist('watchlist', 'tvshow')
		return [{'tmdb_id': get_trakt_tvshow_id(i['media_ids']), 'season': 1, 'episode': 0, 'unwatched': True} for i in data]
	except: return []

def build_next_episode_manager(params):
	from modules.utils import make_thread_list
	from modules.nav_utils import add_dir, focus_index
	from modules.indicators_bookmarks import get_watched_status_tvshow
	def build_content(tmdb_id):
		try:
			cm = []
			meta = tvshow_meta('tmdb_id', tmdb_id, meta_user_info)
			meta_json = json.dumps(meta)
			total_aired_eps = meta['total_episodes']
			title = meta['title']
			if not meta['extra_info']['status'].lower() in ('ended', 'canceled'):
				try: total_aired_eps = meta['total_aired_eps']
				except: pass
			playcount, overlay, total_watched, total_unwatched = get_watched_status_tvshow(watched_info, use_trakt, tmdb_id, total_aired_eps)
			meta.update({'playcount': playcount, 'overlay': overlay, 'total_watched': str(total_watched), 'total_unwatched': str(total_unwatched)})
			display = '[COLOR=red][%s][/COLOR] %s' % (ls(32805).upper(), title) if tmdb_id in exclude_list else '[COLOR=green][%s][/COLOR] %s' % (ls(32804).upper(), title)
			action = 'unhide' if tmdb_id in exclude_list else 'hide'
			url_params = {'mode': 'hide_unhide_trakt_items', 'action': action, 'media_type': 'shows', 'media_id': meta['imdb_id'], 'section': 'progress_watched'}
			url = build_url(url_params)
			browse_url = build_url({'mode': 'build_season_list', 'meta': meta_json})
			cm.append((browse_str,'Container.Update(%s)' % browse_url))
			listitem = xbmcgui.ListItem(display)
			listitem.setProperty('watchedepisodes', str(total_watched))
			listitem.setProperty('unwatchedepisodes', str(total_unwatched))
			listitem.setProperty('totalepisodes', str(total_aired_eps))
			listitem.setProperty('totalseasons', str(meta['total_seasons']))
			listitem.addContextMenuItems(cm)
			listitem.setArt({'poster': meta['poster'], 'fanart': meta['fanart'], 'banner': meta['banner'], 'clearart': meta['clearart'],
							'clearlogo': meta['clearlogo'], 'landscape': meta['landscape']})
			listitem.setCast(meta['cast'])
			listitem.setInfo('video', remove_meta_keys(meta, db_type='tvshow'))
			list_items.append({'listitem': (url, listitem, False), 'display': display})
		except: pass
	__handle__ = int(argv[1])
	list_items = []
	browse_str = ls(32652)
	heading = ls(32806)
	tmdb_list, exclude_list = trakt_get_next_episodes(include_hidden=True)
	if not tmdb_list: return notification(ls(32490), time=5000)
	meta_user_info = retrieve_user_info(window)
	watched_info, use_trakt = get_watched_info_tv()
	threads = list(make_thread_list(build_content, tmdb_list, Thread))
	[i.join() for i in threads]
	item_list = sorted(list_items, key=lambda k: k['display'])
	item_list = [i['listitem'] for i in item_list]
	add_dir({'mode': 'nill'}, '[I][COLOR=grey2]%s[/COLOR][/I]' % heading.upper(), iconImage='settings.png', isFolder=False)
	xbmcplugin.addDirectoryItems(__handle__, item_list, len(item_list))
	xbmcplugin.setContent(__handle__, 'tvshows')
	xbmcplugin.endOfDirectory(__handle__)
	setView('view.main', 'tvshows')
	focus_index(1)

def nextep_playback_info(tmdb_id, current_season, current_episode):
	def _build_next_episode_play():
		ep_data = season_episodes_meta(season, meta, meta_user_info)
		ep_data = [i for i in ep_data if i['episode'] == episode][0]
		airdate = ep_data['premiered']
		d = airdate.split('-')
		episode_date = date(int(d[0]), int(d[1]), int(d[2]))
		if current_date < episode_date: return {'pass': True}
		query = meta['title'] + ' S%.2dE%.2d' % (int(season), int(episode))
		display_name = '%s - %dx%.2d' % (meta['title'], int(season), int(episode))
		meta.update({'vid_type': 'episode', 'rootname': display_name, 'season': season, 'ep_name': ep_data['title'],
					'episode': episode, 'premiered': airdate, 'plot': ep_data['plot']})
		meta_json = json.dumps(meta)
		url_params = {'mode': 'play_media', 'background': 'true', 'vid_type': 'episode', 'tmdb_id': meta['tmdb_id'],
					'query': query, 'tvshowtitle': meta['rootname'], 'season': season,
					'episode': episode, 'meta': meta_json, 'ep_name': ep_data['title']}
		return url_params
	meta_user_info = retrieve_user_info(window)
	meta = tvshow_meta('tmdb_id', tmdb_id, meta_user_info)
	nextep_info = {'pass': True}
	try:
		current_date = get_datetime()
		season_data = meta['season_data']
		curr_season_data = [i for i in season_data if i['season_number'] == current_season][0]
		season = current_season if current_episode < curr_season_data['episode_count'] else current_season + 1
		episode = current_episode + 1 if current_episode < curr_season_data['episode_count'] else 1
		nextep_info =  _build_next_episode_play()
	except: pass
	return nextep_info

def execute_nextep(meta, nextep_settings):
	from windows import open_window
	from modules.sources import Sources
	from modules.player import FenPlayer
	def _get_nextep_params():
		nextep_params = nextep_playback_info(meta['tmdb_id'], int(meta['season']), int(meta['episode']))
		return nextep_params
	def _get_nextep_url():
		Sources().playback_prep(nextep_params)
		return window.getProperty('fen_nextep_url')
	def _confirm_threshold():
		nextep_threshold = nextep_settings['threshold']
		if nextep_threshold == 0: return True
		try: current_number = int(window.getProperty('fen_total_autoplays'))
		except: current_number = 1
		if current_number == nextep_threshold:
			current_number = 1
			window.setProperty('fen_total_autoplays', str(current_number))
			if open_window(('windows.next_episode', 'NextEpisode'), 'next_episode.xml', settings.skin_location(), meta=nextep_meta, function='confirm'): return True
			else:
				notification(ls(32736), 1500)
				return False
		else:
			current_number += 1
			window.setProperty('fen_total_autoplays', str(current_number))
			return True
	def continue_action():
		if run_popup: action = open_window(('windows.next_episode', 'NextEpisode'), 'next_episode.xml', settings.skin_location(), meta=nextep_meta, function='next_ep')
		else: action = 'close'
		return action
	def _control():
		confirm_threshold = False
		final_action = 'cancel'
		while player.isPlayingVideo():
			try:
				total_time = player.getTotalTime()
				curr_time = player.getTime()
				remaining_time = round(total_time - curr_time)
				if remaining_time <= nextep_threshold_check:
					if not confirm_threshold:
						confirm_threshold = _confirm_threshold()
						if not confirm_threshold:
							final_action = 'cancel'
							break
				if remaining_time <= display_nextep_popup:
					final_action = continue_action()
					break
				sleep(200)
			except: pass
		return final_action
	window.clearProperty('fen_nextep_url')
	player = FenPlayer()
	run_popup = nextep_settings['run_popup']
	display_nextep_popup = nextep_settings['window_time']
	nextep_prep = nextep_settings['start_prep']
	nextep_threshold_check = nextep_settings['threshold_check']
	nextep_params = _get_nextep_params()
	if not nextep_params: return notification(ls(32760), 4500)
	nextep_url = _get_nextep_url()
	if not nextep_url: return notification(ls(32760), 4500)
	nextep_meta = json.loads(nextep_params['meta'])
	action = _control()
	if action == 'cancel': return notification(ls(32736), 4500)
	elif action == 'play': player.stop()
	elif action == 'close':
		if not run_popup: notification('%s %s S%02dE%02d' % (ls(32801), nextep_meta['title'], nextep_meta['season'], nextep_meta['episode']), 6500, nextep_meta['poster'])
		while player.isPlayingVideo(): sleep(100)
	sleep(1000)
	player.run(nextep_url)




