# -*- coding: utf-8 -*-
import json
from threading import Thread
import metadata
from windows.base_dialog import BaseDialog
from apis import tmdb_api as TMDb
from apis.imdb_api import people_get_imdb_id, imdb_videos
from indexers.dialogs import imdb_videos_choice
from modules.kodi_utils import translate_path, notification
from modules.settings import skin_location, extras_enable_scrollbars
from modules.utils import calculate_age, local_string as ls
# from modules.utils import logger

tmdb_image_base = 'https://image.tmdb.org/t/p/%s%s'
fanart = translate_path('special://home/addons/plugin.video.fen/fanart.png')
backup_thumbnail = translate_path('special://home/addons/script.tikiart/resources/media/box_office.png')
button_ids = [10, 11, 50]
gender_dict = {1: ls(32844), 2: ls(32843)}

class People(BaseDialog):
	def __init__(self, *args, **kwargs):
		BaseDialog.__init__(self, args)
		self.set_starting_constants(kwargs)
		self.make_person_data(kwargs)
		self.make_biography()
		self.set_properties()

	def onInit(self):
		self.make_more_from('movie')

	def run(self):
		self.doModal()

	def onClick(self, controlID):
		if controlID in button_ids:
			if controlID == 10:
				params = {'mode': 'people_image_results', 'actor_name': self.person_name, 'actor_id': self.person_id,
							'actor_image': self.person_image, 'page_no': 1, 'rolling_count': 0}
				return self.execute_code(self.plugin_runner % self.build_url(params))
			elif controlID == 11:
				params = {'mode': 'people_tagged_image_results', 'actor_name': self.person_name, 'actor_id': self.person_id,
							'actor_image': self.person_image, 'page_no': 1, 'rolling_count': 0}
				return self.execute_code(self.plugin_runner % self.build_url(params))
			elif controlID == 50:
				params = {'mode': 'show_text', 'heading': self.person_name, 'text': self.person_biography, 'font_size': 'large'}
				return self.execute_code(self.plugin_runner % self.build_url(params))
		else: return self.onAction(self.selection_actions[0], controlID)

	def onAction(self, action, controlID=None):
		if action in self.selection_actions:
			try:
				selected = self.list_items_dict[controlID]
				current_index = self.get_position(controlID)
				chosen_listitem = selected['list'][current_index]
				chosen_var = chosen_listitem.getProperty(selected['property'])
			except: pass
			if controlID in (2050, 2051, 2053):
				if controlID in (2050, 2053): function = metadata.movie_meta
				else: function = metadata.tvshow_meta
				meta = function('tmdb_id', chosen_var, metadata.retrieve_user_info())
				if not meta: return
				params = {'mode': 'extras_menu_choice', 'meta': json.dumps(meta), 'is_widget': 'false'}
				return self.execute_code(self.plugin_runner % self.build_url(params))
			elif controlID == 2052:
				params = json.loads(chosen_var)
				chosen = imdb_videos_choice(params['videos'], params['thumb'])
				if not chosen: return
				vid_title = '%s (%s)' % (chosen_listitem.getProperty('tikiskins.person.name'), self.person_name)
				meta = {'fanart': fanart, 'title': vid_title, 'clearlogo': ''}
				params = {'mode': 'open_window', 'import_info': json.dumps(['windows.videoplayer', 'VideoPlayerXML']),
						'args': json.dumps(['videoplayer.xml', skin_location()]), 'kwargs': json.dumps({'meta': meta, 'video': chosen})}
				return self.execute_code(self.plugin_runner % self.build_url(params))
		elif action in self.down_actions: self.create_list(self.getFocusId())
		elif action in self.closing_actions: self.close()

	def create_list(self, current_focus):
		if current_focus in (2050, 3050):
			Thread(target=self.make_more_from, args=('tvshow',)).start()
			Thread(target=self.make_imdb_videos).start()
		elif current_focus in (2052, 3052): Thread(target=self.more_from_director).start()

	def make_biography(self):
		bio_info = TMDb.tmdb_people_biography(self.person_id)
		if bio_info.get('biography', None) in ('', None): bio_info = TMDb.tmdb_people_biography(self.person_id, 'en')
		gender = bio_info.get('gender')
		if gender: self.person_gender = gender_dict[gender]
		else: self.person_gender = ''
		place_of_birth = bio_info.get('place_of_birth')
		if place_of_birth: self.person_place_of_birth = place_of_birth
		else: self.person_place_of_birth = ''
		biography = bio_info.get('biography')
		if biography: self.person_biography = biography
		else: self.person_biography = ls(32760)
		birthday = bio_info.get('birthday')
		if birthday: self.person_birthday = birthday
		else: self.person_birthday = ''
		deathday = bio_info.get('deathday')
		if deathday: self.person_deathday = deathday
		else: self.person_deathday = ''
		if self.person_deathday: self.person_age = calculate_age(self.person_birthday, '%Y-%m-%d', self.person_deathday)
		elif self.person_birthday: self.person_age = calculate_age(self.person_birthday, '%Y-%m-%d')
		else:self.person_age = ''

	def make_person_data(self, kwargs):
		if kwargs['query']:
			try:
				self.person_data = TMDb.tmdb_people_info(kwargs['query'])[0]
			except:
				notification(ls(32760))
				self.close()
			self.person_name = self.person_data['name']
			self.person_id = self.person_data['id']
			image_path = self.person_data['profile_path']
			if not image_path: self.person_image = translate_path('special://home/addons/script.tikiart/resources/media/genre_family.png')
			else: self.person_image = tmdb_image_base % ('h632', image_path)
		else:
			self.person_name = kwargs['actor_name']
			self.person_id = kwargs['actor_id']
			self.person_image = kwargs['actor_image']

	def make_more_from(self, db_type):
		if db_type == 'movie':
			if self.more_from_movies_made: return
			self.more_from_movies_made = True
		else:
			if self.more_from_tvshows_made: return
			self.more_from_tvshows_made = True
		try:
			function = TMDb.tmdb_movies_actor_roles if db_type == 'movie' else TMDb.tmdb_tv_actor_roles
			data = function(self.person_id)
			item_list = list(self.make_tmdb_listitems(data, db_type))
			if db_type == 'movie': _id = self.more_from_movies_id
			else: _id = self.more_from_tvshows_id
			self.setProperty('tikiskins.person.more_from_%ss.number' % db_type, '(x%02d)' % len(item_list))
			self.list_items_dict[_id] = {'list': item_list, 'property': 'tikiskins.person.tmdb_id'}
			control = self.getControl(_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.person.more_from_%ss.number' % db_type, '(x00)')

	def make_imdb_videos(self):
		def builder():
			for count, item in enumerate(data, 1):
				try:
					listitem = self.make_listitem()
					listitem.setProperty('tikiskins.person.name', '%01d. %s' % (count, item['title']))
					listitem.setProperty('tikiskins.person.thumbnail', item['poster'])
					listitem.setProperty('tikiskins.person.params', json.dumps({'videos': json.dumps(item['videos']), 'thumb': item['poster']}))
					yield listitem
				except: pass
		if self.imdb_videos_made == True: return
		self.imdb_videos_made = True
		try:
			imdb_id = people_get_imdb_id(self.person_name, self.person_id)
			data = imdb_videos(imdb_id)
			item_list = list(builder())
			self.setProperty('tikiskins.person.imdb_videos.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.imdb_videos_id] = {'list': item_list, 'property': 'tikiskins.person.params'}
			control = self.getControl(self.imdb_videos_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.person.imdb_videos.number', '(x00)')

	def more_from_director(self):
		if self.more_from_director_made: return
		self.more_from_director_made = True
		try:
			data = TMDb.tmdb_movies_directed(self.person_id)
			item_list = list(self.make_tmdb_listitems(data, 'movie'))
			self.setProperty('tikiskins.person.more_from_director.number', '(x%02d)' % len(item_list))
			self.list_items_dict[self.more_from_director_id] = {'list': item_list, 'property': 'tikiskins.person.tmdb_id'}
			control = self.getControl(self.more_from_director_id)
			control.addItems(item_list)
		except: self.setProperty('tikiskins.person.more_from_director.number', '(x00)')

	def make_tmdb_listitems(self, data, db_type):
		used_ids = []
		name_key = 'title' if db_type == 'movie' else 'name'
		release_key = 'release_date' if db_type == 'movie' else 'first_air_date'
		for item in data:
			try:
				tmdb_id = item['id']
				if tmdb_id in used_ids: continue
				listitem = self.make_listitem()
				poster_path = item['poster_path']
				if not poster_path: thumbnail = backup_thumbnail
				else: thumbnail = tmdb_image_base % ('w780', poster_path)
				try: year = item[release_key].split('-')[0]
				except: year = item[release_key]
				listitem.setProperty('tikiskins.person.name', item[name_key])
				listitem.setProperty('tikiskins.person.release_date', year)
				listitem.setProperty('tikiskins.person.vote_average', '%.1f' % item['vote_average'])
				listitem.setProperty('tikiskins.person.thumbnail', thumbnail)
				listitem.setProperty('tikiskins.person.tmdb_id', str(tmdb_id))
				used_ids.append(tmdb_id)
				yield listitem
			except: pass

	def set_starting_constants(self, kwargs):
		self.list_items_dict = {}
		self.more_from_movies_id, self.more_from_movies_made = 2050, False
		self.more_from_tvshows_id, self.more_from_tvshows_made = 2051, False
		self.imdb_videos_id, self.imdb_videos_made = 2052, False
		self.more_from_director_id, self.more_from_director_made = 2053, False
		self.enable_scrollbars = extras_enable_scrollbars()
		self.plugin_runner = 'RunPlugin(%s)'

	def set_properties(self):
		self.setProperty('tikiskins.person.name', self.person_name)
		self.setProperty('tikiskins.person.id', str(self.person_id))
		self.setProperty('tikiskins.person.image', self.person_image)
		self.setProperty('tikiskins.person.fanart', fanart)
		self.setProperty('tikiskins.person.gender', self.person_gender)
		self.setProperty('tikiskins.person.place_of_birth', self.person_place_of_birth)
		self.setProperty('tikiskins.person.biography', self.person_biography)
		self.setProperty('tikiskins.person.birthday', self.person_birthday)
		self.setProperty('tikiskins.person.deathday', self.person_deathday)
		self.setProperty('tikiskins.person.age', str(self.person_age))
		self.setProperty('tikiskins.person.enable_scrollbars', self.enable_scrollbars)