# -*- coding: utf-8 -*-
import xbmc, xbmcgui
import json
import time
import datetime
from importlib import import_module
from threading import Thread
try: from sqlite3 import dbapi2 as database
except Exception: from pysqlite2 import dbapi2 as database
from windows import show_window
from modules.kodi_utils import show_busy_dialog, hide_busy_dialog, notification, sleep, local_string as ls
from modules.utils import byteify, clean_file_name, base32_to_hex
from modules.settings import display_sleep_time
from modules.settings_reader import get_setting
from modules import source_utils
# from modules.utils import logger

window = xbmcgui.Window(10000)
monitor = xbmc.Monitor()

class ExternalSource:
	def __init__(self, sourceDict, debrid_torrents, debrid_hosters, internal_scrapers, prescrape_sources, display_uncached_torrents, disabled_ignored=False):
		self.scrape_provider = 'external'
		self.sourceDict = sourceDict
		self.debrid_torrents = debrid_torrents
		self.debrid_hosters = debrid_hosters
		self.internal_scrapers = internal_scrapers
		self.prescrape_sources = prescrape_sources
		self.display_uncached_torrents = display_uncached_torrents
		self.disabled_ignored = disabled_ignored
		self.internal_activated = len(self.internal_scrapers) > 0
		self.internal_prescraped = len(self.prescrape_sources) > 0
		self.processed_prescrape = False
		self.sources = []
		self.final_sources = []
		self.processed_internal_scrapers = []
		self.database_timeout = 60.0
		self.getConstants()

	def results(self, info):
		results = []
		self.info = info
		db_type = info['db_type']
		if db_type == 'movie': title, tvshowtitle = info['title'], None
		else: title, tvshowtitle = info['ep_name'], info['title']
		results = self.getSources(db_type, title, info['year'], info['imdb_id'], info['tvdb_id'], info['season'], info['episode'],
									tvshowtitle, info['premiered'], info['language'], info['aliases'])
		return results

	def getSources(self, db_type, title, year, imdb, tvdb, season, episode, tvshowtitle, premiered, language, aliases):
		def _process_threads_movie():
			for i in sourceDict:
				source_display, module_path = i[0], i[1]
				threaded_object = Thread(target=self.getMovieSource, args=(title, aliases, year, imdb, source_display, module_path), name=source_display)
				threaded_object.start()
				yield threaded_object
		def _process_threads_episode():
			for i in sourceDict:
				pack_arg, module_path, source = i[2], i[1], i[0]
				if pack_arg: source_display = pack_display % (i[0], i[2])
				else: source_display = i[0]
				threaded_object = Thread(target=self.getEpisodeSource, args=(title, year, imdb, tvdb, season, episode, tvshowtitle, aliases, premiered, source, module_path, pack_arg), name=source_display)
				threaded_object.start()
				yield threaded_object
		def _scraperDialog():
			diag_format = '4K: %s | 1080p: %s | 720p: %s | SD: %s | %s: %s'
			exonly_diag_format = '4K: %s | 1080p: %s | 720p: %s | SD: %s | %s: %s'
			close_dialog = True
			start_time = time.time()
			end_time = start_time + self.timeout
			while not self.progress_dialog.iscanceled():
				try:
					if monitor.abortRequested() is True: break
					self.internalResults()
					internalSource_4k_label = total_format % (int_dialog_highlight, self.internalSources4K)
					internalSource_1080_label = total_format % (int_dialog_highlight, self.internalSources1080p)
					internalSource_720_label = total_format % (int_dialog_highlight, self.internalSources720p)
					internalSource_sd_label = total_format % (int_dialog_highlight, self.internalSourcesSD)
					internalSource_total_label = total_format % (int_dialog_highlight, self.internalSourcesTotal)
					source_4k_label = total_format % (ext_dialog_highlight, self.source_4k)
					source_1080_label = total_format % (ext_dialog_highlight, self.source_1080)
					source_720_label = total_format % (ext_dialog_highlight, self.source_720)
					source_sd_label = total_format % (ext_dialog_highlight, self.source_sd)
					source_total_label = total_format % (ext_dialog_highlight, self.total)
					current_time = time.time()
					current_progress = max((current_time - start_time), 0)
					try:
						info = [x.getName() for x in threads if x.is_alive() is True]
						percent = int((current_progress/float(self.timeout))*100)
						if self.internal_activated or self.internal_prescraped:
							info.extend([i for i in self.internal_scrapers if not i in self.processed_internal_scrapers])
							line1 = string6 + diag_format % (internalSource_4k_label, internalSource_1080_label,
													  		internalSource_720_label, internalSource_sd_label, str(string4), internalSource_total_label)
							line2 = string7 + diag_format % (source_4k_label, source_1080_label, source_720_label, source_sd_label, str(string4), source_total_label)
						else:
							line1 = string7
							line2 = exonly_diag_format % (source_4k_label, source_1080_label, source_720_label, source_sd_label, str(string4), source_total_label)
						len_alive_threads = len(info)
						if len_alive_threads > 6: line3 = string3 % str(len_alive_threads)
						else: line3 = string3 % ', '.join(info).upper()
						self.progress_dialog.update(line % (line1, line2, line3), percent)
						sleep(self.sleep_time)
						if finish_early:
							if percent >= 50:
								if len_alive_threads <= 5: break
								if len(self.sources) >= 100 * len_alive_threads: break
						if len_alive_threads == 0: break
						if end_time < current_time: break
					except: pass
				except Exception: pass
			self.killProgressDialog()
			return
		def _background():
			start_time = time.time()
			end_time = start_time + self.timeout
			while time.time() < end_time:
				alive_threads = [x.getName() for x in threads if x.is_alive() is True]
				sleep(self.sleep_time)
				if len(alive_threads) <= 5: return
				if len(self.sources) >= 100 * len(alive_threads): return
		line = '%s[CR]%s[CR]%s'
		pack_display = '%s (%s)'
		if db_type == 'movie':
			sourceDict = self.sourceDict
			title = source_utils.normalize(title)
			threads = list(_process_threads_movie())
		else:
			tvshowtitle = source_utils.normalize(tvshowtitle)
			self.season_packs, self.show_packs = source_utils.pack_enable_check(self.meta, season, episode)
			sourceDict = [(i[0], i[1], '') for i in self.sourceDict]
			if self.season_packs: sourceDict.extend([(i[0], i[1], 'season') for i in self.sourceDict if i[0] in self.sourceDictPack])
			if self.show_packs: sourceDict.extend([(i[0], i[1], 'show') for i in self.sourceDict if i[0] in self.sourceDictPack])
			threads = list(_process_threads_episode())
		int_dialog_highlight = get_setting('int_dialog_highlight', 'darkgoldenrod')
		ext_dialog_highlight = get_setting('ext_dialog_highlight', 'dodgerblue')
		finish_early = get_setting('search.finish.early') == 'true'
		string1, string2, string3, string4 = ls(32674), ls(32675), ls(32676), ls(32677)
		if self.internal_activated or self.internal_prescraped:
			string6 = '[COLOR %s][B]Int:[/B][/COLOR]' % int_dialog_highlight
			string7 = '[COLOR %s][B]Ext:[/B][/COLOR]' % ext_dialog_highlight
		else:
			string7 = '[COLOR %s][B]%s[/B][/COLOR]' % (ext_dialog_highlight, ls(32118))
		line1 = line2 = line3 = ''
		total_format = '[COLOR %s][B]%s[/B][/COLOR]'
		if self.background: _background()
		else:
			self.progress_dialog = show_window(('windows.source_progress', 'SourcesProgressXML'), 'source_results_progress.xml', meta=self.meta)
			Thread(target=_scraperDialog).start()
			self.progress_dialog.run()
		self.final_sources.extend(self.sources)
		self.sourcesDuplicates()
		self.sourcesFilter()
		self.sourcesAddInfo()
		return self.final_sources
	
	def getMovieSource(self, title, aliases, year, imdb, source, module_path):
		try:
			dbcon = database.connect(self.providerDatabase, timeout=self.database_timeout)
			dbcur = source_utils.setPRAGMAS(dbcon)
		except: pass
		try:
			sources = []
			dbcur.execute("SELECT * FROM rel_src WHERE source = ? AND imdb_id = ?", (source, imdb))
			match = dbcur.fetchone()
			if match:
				if int(match[5]) > self.sourcesTimestamp(self.time):
					sources = eval(byteify(match[4]))
					self.sourcesQualityCount(sources)
					return self.sources.extend(sources)
				else:
					dbcur.execute("DELETE FROM rel_src WHERE imdb_id = ?", (imdb,))
		except: pass
		try:
			module = import_module(module_path)
			call = module.source()
			if not getattr(call, 'movie', None): return
		except: return
		try:
			url = None
			dbcur.execute("SELECT * FROM rel_url WHERE source = ? AND imdb_id = ?", (source, imdb))
			url = dbcur.fetchone()
			url = eval(byteify(url[4]))
		except: pass
		try:
			if url is None: url = call.movie(imdb, title, aliases, year)
			if url is None: return
			dbcur.execute("DELETE FROM rel_url WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ?", (source, imdb, '', ''))
			dbcur.execute("INSERT INTO rel_url Values (?, ?, ?, ?, ?)", (source, imdb, '', '', repr(url)))
			dbcon.commit()
		except: pass
		try:
			expiry_hours = 24
			sources = []
			sources = call.sources(url, self.hostDict)
			sources = [json.loads(t) for t in set(json.dumps(d, sort_keys=True) for d in sources)]
			sources = self.sourcesUpdate(source, sources)
			self.sourcesQualityCount(sources)
			self.sources.extend(sources)
			dbcur.execute("DELETE FROM rel_src WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ?", (source, imdb, '', ''))
			dbcur.execute("INSERT INTO rel_src Values (?, ?, ?, ?, ?, ?)", (source, imdb, '', '', repr(sources), self.sourcesTimestamp(self.time + datetime.timedelta(hours=expiry_hours))))
			dbcon.commit()
		except: pass

	def getEpisodeSource(self, title, year, imdb, tvdb, season, episode, tvshowtitle, aliases, premiered, source, module_path, pack):
		try:
			dbcon = database.connect(self.providerDatabase, timeout=self.database_timeout)
			dbcur = source_utils.setPRAGMAS(dbcon)
		except: pass
		if pack in ('season', 'show'):
			if pack == 'show': s_check = ''
			else: s_check = season
			e_check = ''
		else:
			s_check, e_check = season, episode
		try:
			sources = []
			dbcur.execute("SELECT * FROM rel_src WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ?", (source, imdb, s_check, e_check))
			match = dbcur.fetchone()
			if match:
				if int(match[5]) > self.sourcesTimestamp(self.time):
					sources = eval(byteify(match[4]))
					if pack == 'show': sources = [i for i in sources if i.get('last_season') >= season]
					self.sourcesQualityCount(sources)
					return self.sources.extend(sources)
				else:
					dbcur.execute("DELETE FROM rel_src WHERE imdb_id = ?", (imdb,))
		except: pass
		try:
			module = import_module(module_path)
			call = module.source()
			if not getattr(call, 'tvshow', None): return
		except: return
		try:
			url = None
			dbcur.execute("SELECT * FROM rel_url WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ", (source, imdb, '', ''))
			url = dbcur.fetchone()
			url = eval(byteify(url[4]))
		except: pass
		try:
			if url is None: url = call.tvshow(imdb, tvdb, tvshowtitle, aliases, year)
			if url is None: return
			dbcur.execute("DELETE FROM rel_url WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ?", (source, imdb, '', ''))
			dbcur.execute("INSERT INTO rel_url Values (?, ?, ?, ?, ?)", (source, imdb, '', '', repr(url)))
			dbcon.commit()
		except: pass
		try:
			ep_url = None
			dbcur.execute("SELECT * FROM rel_url WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ?", (source, imdb, season, episode))
			ep_url = dbcur.fetchone()
			ep_url = eval(byteify(ep_url[4]))
		except: pass
		try:
			if url is None: return
			if ep_url is None: ep_url = call.episode(url, imdb, tvdb, title, premiered, season, episode)
			if ep_url is None: return
			dbcur.execute("DELETE FROM rel_url WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ?", (source, imdb, season, episode))
			dbcur.execute("INSERT INTO rel_url Values (?, ?, ?, ?, ?)", (source, imdb, season, episode, repr(ep_url)))
			dbcon.commit()
		except: pass
		try:
			sources = []
			if not pack:
				expiry_hours = 24
				sources = call.sources(ep_url, self.hostDict)
			elif pack == 'season':
				expiry_hours = 336
				sources = call.sources_packs(ep_url, self.hostDict)
			else:
				expiry_hours = 336
				sources = call.sources_packs(ep_url, self.hostDict, search_series=True, total_seasons=self.meta.get('total_seasons', 1))
			sources = [json.loads(t) for t in set(json.dumps(d, sort_keys=True) for d in sources)]
			sources = self.sourcesUpdate(source, sources)
			self.sourcesQualityCount(sources)
			self.sources.extend(sources)
			dbcur.execute("DELETE FROM rel_src WHERE source = ? AND imdb_id = ? AND season = ? AND episode = ?", (source, imdb, s_check, e_check))
			dbcur.execute("INSERT INTO rel_src VALUES (?, ?, ?, ?, ?, ?)", (source, imdb, s_check, e_check, repr(sources), self.sourcesTimestamp(self.time + datetime.timedelta(hours=expiry_hours))))
			dbcon.commit()
		except: pass

	def sourcesDuplicates(self):
		def _process(sources):
			uniqueURLs = set()
			uniqueHashes = set()
			for source in sources:
				try:
					url = source['url'].lower()
					if url not in uniqueURLs:
						uniqueURLs.add(url)
					if 'hash' in source:
						if source['hash'] not in uniqueHashes:
							uniqueHashes.add(source['hash'])
							yield source
					else: yield source
				except: yield source
		if len(self.final_sources) > 0:
			self.final_sources = list(_process(self.final_sources))

	def sourcesFilter(self):
		def _processTorrentFilters(item):
			if item in ('Real-Debrid', 'Premiumize.me', 'AllDebrid'):
				self.filter += [dict(i, **{'debrid':item}) for i in torrentSources if item == i.get('cache_provider')]
				if self.display_uncached_torrents:
					self.filter += [dict(i, **{'debrid':item}) for i in torrentSources if 'Uncached' in i.get('cache_provider') and item in i.get('cache_provider')]
		def _processHosterFilters(item):
			for k, v in item.items():
				valid_hosters = [i for i in result_hosters if i in v]
				self.filter += [dict(i, **{'debrid':k}) for i in hoster_sources if i['source'] in valid_hosters]
		self.filter = [i for i in self.final_sources if i['provider'] in self.direct_ext_scrapers]
		threads = []
		hoster_sources = [i for i in self.final_sources if not 'hash' in i and not i in self.filter]
		torrentSources = self.sourcesProcessTorrents([i for i in self.final_sources if 'hash' in i])
		result_hosters = list(set([i['source'].lower() for i in self.final_sources if not 'hash' in i]))
		if self.debrid_torrents:
			for item in self.debrid_torrents: threads.append(Thread(target=_processTorrentFilters, args=(item,)))
		if self.debrid_hosters:
			for item in self.debrid_hosters: threads.append(Thread(target=_processHosterFilters, args=(item,)))
		[i.start() for i in threads]
		[i.join() for i in threads]
		self.final_sources = self.filter

	def sourcesAddInfo(self):
		def _addInfoandName(i):
			if 'name' in i: URLName = clean_file_name(i['name']).replace('html', ' ').replace('+', ' ').replace('-', ' ')
			else: URLName = source_utils.getFileNameMatch(self.info['title'], i['url'], i.get('name', None))
			extraInfo = source_utils.get_file_info(URLName)
			return _updateSource(i, {'extraInfo': extraInfo, 'URLName': URLName})
		def _updateQuality(i):
			current_quality = i['quality']
			if 'name_info' in i: release_name = i['name_info']
			elif 'name' in i: release_name = i['name']
			else: release_name = i['url']
			quality = source_utils.get_release_quality(release_name)
			i.update({'quality': quality})
		def _getSize(i):
			size = 0
			size_label = None
			divider = None
			try:
				size = i['size']
				if 'package' in i:
					if i['package'] == 'season': divider = [int(x['episode_count']) for x in self.meta['season_data'] if int(x['season_number']) == int(self.meta['season'])][0]
					else: divider = int(self.meta['total_episodes'])
					size = float(size) / divider
					size_label = '%.2f GB' % size
				else:
					size_label = '%.2f GB' % size
			except: pass
			update_dict = {'size_label': size_label, 'size': size}
			return _updateSource(i, update_dict)
		def _updateSource(i, update_dict):
			i.update(update_dict)
		for i in self.final_sources:
			if 'URLName' in i: continue
			_getSize(i)
			_addInfoandName(i)
			_updateQuality(i)

	def sourcesUpdate(self, source, sources):
		source = byteify(source)
		update_dict = {'provider': source, 'external': True, 'scrape_provider': self.scrape_provider}
		for i in sources:
			i.update(update_dict)
			if 'hash' in i:
				_hash = i['hash'].lower()
				i['hash'] = str(_hash)
		return sources
	
	def sourcesQualityCount(self, sources, internal=False):
		if internal:
			for i in sources:
				quality = i['quality']
				if quality == '4K': self.internalSources4K += 1
				elif quality in ['1440p', '1080p']: self.internalSources1080p += 1
				elif quality in ['720p', 'HD']: self.internalSources720p += 1
				else: self.internalSourcesSD += 1
				self.internalSourcesTotal += 1
		else:
			for i in sources:
				quality = i['quality']
				if quality == '4K': self.source_4k += 1
				elif quality in ['1440p', '1080p']: self.source_1080 += 1
				elif quality in ['720p', 'HD']: self.source_720 += 1
				else: self.source_sd += 1
				self.total += 1

	def sourcesProcessTorrents(self, torrentSources):
		def _return_early(return_list=torrentSources):
			return return_list
		if len(torrentSources) == 0: _return_early()
		if len(self.debrid_torrents) == 0: _return_early([])
		hashList = []
		for i in torrentSources:
			try:
				infoHash = i['hash']
				if len(infoHash) == 40:
					hashList.append(infoHash)
				else:
					converted_hash = base32_to_hex(infoHash)
					if converted_hash: hashList.append(converted_hash)
					else: torrentSources.remove(i)
			except: torrentSources.remove(i)
		if len(torrentSources) == 0: _return_early()
		from modules.debrid import DebridCheck
		try:
			DBCheck = DebridCheck()
			torrent_results = []
			hashList = list(set(hashList))
			cached_hashes = DBCheck.run(hashList, self.background, self.debrid_torrents, self.meta)
			for item in [('Real-Debrid', 'rd_cached_hashes'), ('Premiumize.me', 'pm_cached_hashes'), ('AllDebrid', 'ad_cached_hashes')]:
				if item[0] in self.debrid_torrents:
					torrent_results.extend([dict(i, **{'cache_provider':item[0]}) for i in torrentSources if i['hash'] in cached_hashes[item[1]]])
					if self.display_uncached_torrents:
						torrent_results.extend([dict(i, **{'cache_provider':'Uncached %s' % item[0]}) for i in torrentSources if not i['hash'] in cached_hashes[item[1]]])
			return torrent_results
		except:
			notification(32574, 2500)

	def internalResults(self):
		if self.internal_prescraped and not self.processed_prescrape:
			self.sourcesQualityCount(self.prescrape_sources, internal=True)
			self.processed_prescrape = True
		for i in self.internal_scrapers:
			win_property = window.getProperty('%s.internal_results' % i)
			if win_property in ('checked', '', None): continue
			try: internal_sources = json.loads(win_property)
			except: continue
			window.setProperty('%s.internal_results' % i, 'checked')
			self.processed_internal_scrapers.append(i)
			self.sourcesQualityCount(internal_sources, internal=True)

	def makeHostDict(self):
		pr_list = []
		for item in self.debrid_hosters:
			for k, v in item.items():
				pr_list += v
		return list(set(pr_list))

	def killProgressDialog(self):
		try: self.progress_dialog.close()
		except: pass
		try: del self.progress_dialog
		except: pass

	def getConstants(self):
		self.meta = json.loads(window.getProperty('fen_media_meta'))
		self.background = self.meta.get('background', False)
		if not self.background: show_busy_dialog()
		self.time = datetime.datetime.now()
		self.providerDatabase = source_utils.database_path
		self.direct_ext_scrapers = ['ororo', 'filepursuit', 'gdrive']
		self.hostDict = self.makeHostDict()
		self.sourceDictPack = source_utils.packSources()
		self.sleep_time = display_sleep_time()
		self.timeout = 60 if self.disabled_ignored else int(get_setting('scrapers.timeout.1', '60'))
		self.internalSourcesTotal = self.internalSources4K = self.internalSources1080p = self.internalSources720p = self.internalSourcesSD = 0
		self.total = self.source_4k = self.source_1080 = self.source_720 = self.source_sd = 0
		if not self.background: hide_busy_dialog()

	def sourcesTimestamp(self, date_time):
		return int(time.mktime(date_time.timetuple()))
