# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin
import json
from sys import argv
from threading import Thread
import metadata
from apis.trakt_api import get_trakt_movie_id
from modules.meta_lists import oscar_winners_tmdb_ids
from modules.nav_utils import build_url, remove_meta_keys
from modules.kodi_utils import translate_path, external_browse, setView, local_string as ls
from modules.utils import manual_function_import, make_thread_list_enumerate
from modules import indicators_bookmarks as indicators
from modules import settings
# from modules.utils import logger

window = xbmcgui.Window(10000)
tmdb_main = ('tmdb_movies_popular','tmdb_movies_blockbusters','tmdb_movies_in_theaters', 'tmdb_movies_top_rated',
			'tmdb_movies_upcoming', 'tmdb_movies_latest_releases','tmdb_movies_premieres')
trakt_main = ('trakt_movies_trending','trakt_movies_anticipated','trakt_movies_top10_boxoffice')
trakt_personal = ('trakt_collection', 'trakt_watchlist', 'trakt_collection_widgets')
imdb_personal = ('imdb_watchlist', 'imdb_user_list_contents', 'imdb_keywords_list_contents')
personal = ('in_progress_movies', 'favourites_movies', 'watched_movies')
similar = ('tmdb_movies_similar', 'tmdb_movies_recommendations')
tmdb_special = ('tmdb_movies_languages', 'tmdb_movies_networks', 'tmdb_movies_year', 'tmdb_movies_certifications')
tmdb_special_key_dict = {'tmdb_movies_languages': 'language', 'tmdb_movies_networks': 'company',
						'tmdb_movies_year': 'year', 'tmdb_movies_certifications': 'certification'}
item_jump = translate_path('special://home/addons/script.tikiart/resources/media/item_jump.png')
item_next = translate_path('special://home/addons/script.tikiart/resources/media/item_next.png')
poster_empty = translate_path('special://home/addons/script.tikiart/resources/media/box_office.png')
fanart_empty = translate_path('special://home/addons/plugin.video.fen/fanart.png')
watched_str, unwatched_str, traktmanager_str = ls(32642), ls(32643), ls(32198)
favmanager_str, extras_str, options_str = ls(32197), ls(32645), ls(32646)
hide_str, exit_str, clearprog_str = ls(32648), ls(32649), ls(32651)
nextpage_str, switchjump_str, jumpto_str, genre_str = ls(32799), ls(32784), ls(32964), ls(32847)

class Movies:
	def __init__(self, params):
		self.params = params
		self.items = []
		self.new_page = {}
		self.total_pages = None
		self.exit_list_params = None
		self.is_widget = 'unchecked'
		self.id_type = 'tmdb_id'
		self.list = params.get('list', [])
		self.action = params.get('action', None)
		self.__handle__ = int(argv[1])

	def fetch_list(self):
		try:
			self.is_widget = external_browse()
			content_type = 'movies'
			mode = self.params.get('mode')
			try: page_no = int(self.params.get('new_page', '1'))
			except ValueError: page_no = self.params.get('new_page')
			letter = self.params.get('new_letter', 'None')
			self.exit_list_params = self.params.get('exit_list_params', None)
			if not self.exit_list_params: self.exit_list_params = xbmc.getInfoLabel('Container.FolderPath')
			if self.action in personal:
				if self.action == 'in_progress_movies': var_module, import_function = 'modules.in_progress', 'in_progress_movie'
				elif self.action == 'favourites_movies': var_module, import_function = 'modules.favourites', 'retrieve_favourites'
				else: var_module, import_function = 'modules.indicators_bookmarks', 'get_watched_items'
			else: var_module, import_function = 'apis.%s_api' % self.action.split('_')[0], self.action
			try: function = manual_function_import(var_module, import_function)
			except: pass
			if self.action in tmdb_main:
				data = function(page_no)
				for item in data['results']: self.list.append(item['id'])
				self.new_page = {'new_page': str((data['page'] if 'tmdb' in self.action else page_no) + 1)}
			elif self.action in trakt_main:
				data = function(page_no)
				for item in data: self.list.append(get_trakt_movie_id(item['movie']['ids']))
				if self.action not in ('trakt_movies_top10_boxoffice'):
					self.new_page = {'new_page': str((data['page'] if 'tmdb' in self.action else page_no) + 1)}
			elif self.action in trakt_personal:
				data, total_pages = function('movies', page_no, letter)
				self.list = [i['media_id'] for i in data]
				if total_pages > 2: self.total_pages = total_pages
				try:
					if total_pages > page_no:
						self.new_page = {'new_page': str(page_no + 1), 'new_letter': letter}
				except: pass
			elif self.action in imdb_personal:
				self.id_type = 'imdb_id'
				list_id = self.params.get('list_id', None)
				data, next_page = function('movies', list_id, page_no)
				self.list = [i['imdb_id'] for i in data]
				if next_page:
					self.new_page = {'list_id': list_id, 'new_page': str(page_no + 1), 'new_letter': letter}
			elif self.action in personal:
				data, total_pages = function('movie', page_no, letter)
				self.list = [i['media_id'] for i in data]
				if total_pages > 2: self.total_pages = total_pages
				if total_pages > page_no:
					self.new_page = {'new_page': str(page_no + 1), 'new_letter': letter}
			elif self.action in similar:
				tmdb_id = self.params.get('tmdb_id')
				data = function(tmdb_id, page_no)
				self.list = [i['id'] for i in data['results']]
				if data['page'] < data['total_pages']:
					self.new_page = {'new_page': str(data['page'] + 1), 'tmdb_id': tmdb_id}
			elif self.action in tmdb_special:
				key = tmdb_special_key_dict[self.action]
				function_var = self.params.get(key, None)
				if not function_var: return
				data = function(function_var, page_no)
				self.list = [i['id'] for i in data['results']]
				if data['page'] < data['total_pages']:
					self.new_page = {'new_page': str(data['page'] + 1), key: function_var}
			elif self.action == 'tmdb_movies_discover':
				from indexers.discover import set_history
				name = self.params['name']
				query = self.params['query']
				if page_no == 1: set_history('movie', name, query)
				data = function(query, page_no)
				for item in data['results']: self.list.append(item['id'])
				if data['page'] < data['total_pages']:
					self.new_page = {'query': query, 'name': name, 'new_page': str(data['page'] + 1)}
			elif self.action == 'imdb_movies_oscar_winners':
				self.list = oscar_winners_tmdb_ids()
			elif self.action == 'trakt_movies_mosts':
				for item in (function(self.params['period'], self.params['duration'], page_no)): self.list.append(get_trakt_movie_id(item['movie']['ids']))
				self.new_page = {'period': self.params['period'], 'duration': self.params['duration'], 'new_page': str(page_no + 1)}
			elif self.action == 'trakt_movies_related':
				imdb_id = self.params.get('imdb_id')
				data, total_pages = function(imdb_id, page_no)
				for item in data: self.list.append(get_trakt_movie_id(item['ids']))
				if total_pages > page_no:
					self.new_page = {'new_page': str(page_no + 1), 'imdb_id': imdb_id}
			elif self.action == 'tmdb_movies_genres':
				genre_id = self.params['genre_id'] if 'genre_id' in self.params else self.multiselect_genres(self.params.get('genre_list'))
				if not genre_id: return
				data = function(genre_id, page_no)
				self.list = [i['id'] for i in data['results']]
				if data['page'] < data['total_pages']:
					self.new_page = {'new_page': str(data['page'] + 1), 'genre_id': genre_id}
			elif self.action == 'tmdb_movies_collection':
				data = function(str(self.params['collection_id']))
				self.list = [i['id'] for i in data['parts']]
			elif self.action == 'trakt_recommendations':
				for item in function('movies'): self.list.append(get_trakt_movie_id(item['ids']))
			elif self.action  == 'tmdb_movies_search':
				query = self.params['query']
				data = function(query, page_no)
				total_pages = data['total_pages']
				if total_pages > page_no:
					self.new_page = {'new_page': str(page_no + 1), 'new_letter': letter, 'query': query}
				self.list = [i['id'] for i in data['results']]
			elif self.action  == 'trakt_movies_search':
				query = self.params['query']
				data, total_pages = function(query, page_no, letter)
				for item in data: self.list.append(get_trakt_movie_id(item['movie']['ids']))
				if total_pages > page_no:
					self.new_page = {'new_page': str(page_no + 1), 'new_letter': letter, 'query': query}
			if self.total_pages and not self.is_widget:
				url_params = {'mode': 'build_navigate_to_page', 'db_type': 'Movies', 'current_page': page_no, 'total_pages': self.total_pages, 'transfer_mode': mode,
							'transfer_action': self.action, 'query': self.params.get('search_name', ''), 'actor_id': self.params.get('actor_id', '')}
				self.add_dir(url_params, jumpto_str, item_jump, False)
			item_list = self.worker()
			xbmcplugin.addDirectoryItems(self.__handle__, item_list, len(item_list))
			if self.new_page:
				self.new_page.update({'mode': mode, 'action': self.action, 'exit_list_params': self.exit_list_params})
				self.add_dir(self.new_page)
		except: pass
		xbmcplugin.setContent(self.__handle__, content_type)
		xbmcplugin.endOfDirectory(self.__handle__, cacheToDisc=True)
		setView('view.movies', content_type)
	
	def build_movie_content(self, item_position, _id):
		try:
			cm = []
			item = self.set_meta(_id)
			try: listitem = xbmcgui.ListItem(offscreen=True)
			except: listitem = xbmcgui.ListItem()
			rootname = item['rootname']
			tmdb_id = item['tmdb_id']
			imdb_id = item['imdb_id']
			title = item['title']
			year = item['year']
			poster = item.get(self.poster_main) or item.get(self.poster_backup) or poster_empty
			fanart = item.get(self.fanart_main) or item.get(self.fanart_backup) or fanart_empty
			playcount = item['playcount']
			meta_json = json.dumps(item)
			resumetime = indicators.get_resumetime('movie', tmdb_id)
			url_params = {'mode': 'play_media', 'vid_type': 'movie', 'query': rootname, 'tmdb_id': tmdb_id}
			extras_params = {'mode': 'extras_menu_choice', 'meta': meta_json, 'is_widget': self.is_widget}
			options_params = {'mode': 'options_menu_choice', 'suggestion': rootname, 'content': 'movie', 'meta': meta_json}
			trakt_manager_params = {'mode': 'trakt_manager_choice', 'tmdb_id': tmdb_id, 'imdb_id': imdb_id, 'tvdb_id': 'None', 'db_type': 'movie'}
			fav_manager_params = {'mode': 'favorites_choice', 'db_type': 'movie', 'tmdb_id': tmdb_id, 'title': title}
			if self.open_extras:
				action_params = extras_params
			else:
				action_params = url_params
				cm.append((extras_str, 'RunPlugin(%s)' % build_url(extras_params)))
			cm.append((options_str,'RunPlugin(%s)' % build_url(options_params)))
			cm.append((traktmanager_str,'RunPlugin(%s)' % build_url(trakt_manager_params)))
			cm.append((favmanager_str,'RunPlugin(%s)' % build_url(fav_manager_params)))
			if resumetime != '0':
				cm.append((clearprog_str, 'RunPlugin(%s)' % \
											build_url({'mode': 'watched_unwatched_erase_bookmark', 'db_type': 'movie', 'media_id': tmdb_id, 'refresh': 'true'})))
				listitem.setProperty('fen_in_progress', 'true')
			if playcount:
				unwatched_params = {'mode': 'mark_movie_as_watched_unwatched', 'action': 'mark_as_unwatched', 'media_id': tmdb_id, 'title': title, 'year': year}
				cm.append((unwatched_str % self.watched_title, 'RunPlugin(%s)' % build_url(unwatched_params)))
			else:
				watched_params = {'mode': 'mark_movie_as_watched_unwatched', 'action': 'mark_as_watched', 'media_id': tmdb_id, 'title': title, 'year': year}
				cm.append((watched_str % self.watched_title, 'RunPlugin(%s)' % build_url(watched_params)))
			cm.append((exit_str, 'Container.Refresh(%s)' % self.exit_list_params))
			url = build_url(action_params)
			listitem.setLabel(rootname if self.include_year_in_title else title)
			listitem.setContentLookup(False)
			listitem.addContextMenuItems(cm)
			listitem.setCast(item['cast'])
			listitem.setUniqueIDs({'imdb': str(imdb_id), 'tmdb': str(tmdb_id)})
			listitem.setArt({'poster': poster, 'fanart': fanart, 'icon': poster, 'banner': item['banner'], 'clearart': item['clearart'],
							'clearlogo': item['clearlogo'], 'landscape': item['landscape'], 'discart': item['discart']})
			listitem.setInfo('Video', remove_meta_keys(item, db_type='movie'))
			listitem.setProperty('resumetime', resumetime)
			listitem.setProperty('fen_listitem_meta', meta_json)
			listitem.setProperty('fen_extras_menu_params', json.dumps(extras_params))
			listitem.setProperty('fen_options_menu_params', json.dumps(options_params))
			if self.is_widget:
				listitem.setProperty('fen_widget', 'true')
				listitem.setProperty('fen_playcount', str(playcount))
			self.items.append({'listitem': (url, listitem, False), 'item_no': item_position})
		except: pass

	def set_meta(self, _id):
		meta = metadata.movie_meta(self.id_type, _id, self.meta_user_info)
		if not meta: return
		playcount, overlay = indicators.get_watched_status(self.watched_info, self.use_trakt, 'movie', meta['tmdb_id'])
		meta.update({'playcount': playcount, 'overlay': overlay})
		return meta

	def worker(self):
		if self.is_widget == 'unchecked': self.is_widget = external_browse()
		if not self.exit_list_params: self.exit_list_params = xbmc.getInfoLabel('Container.FolderPath')
		self.watched_info, self.use_trakt = indicators.get_watched_info_movie()
		self.meta_user_info = metadata.retrieve_user_info(window)
		self.watched_title = 'Trakt' if self.use_trakt in (1, 2) else 'Fen'
		self.include_year_in_title = settings.include_year_in_title('movie')
		self.open_extras = settings.extras_open_action('movie')
		self.poster_main, self.poster_backup, self.fanart_main, self.fanart_backup = settings.get_art_provider()
		window.clearProperty('fen_fanart_error')
		threads = list(make_thread_list_enumerate(self.build_movie_content, self.list, Thread))
		[i.join() for i in threads]
		item_list = sorted(self.items, key=lambda k: k['item_no'])
		return [i['listitem'] for i in item_list]

	def multiselect_genres(self, genre_list):
		import os
		from modules.kodi_utils import select_dialog
		def _builder():
			for genre, value in sorted(genre_list.items()):
				function_list.append(value[0])
				yield {'line1': genre, 'icon': os.path.join(icon_directory, value[1])}
		function_list = []
		icon_directory = translate_path('special://home/addons/script.tikiart/resources/media')
		genre_list = json.loads(genre_list)
		list_items = list(_builder())
		kwargs = {'items': json.dumps(list_items), 'heading': genre_str, 'enumerate': 'false', 'multi_choice': 'true', 'multi_line': 'false'}
		genre_ids = select_dialog(function_list, **kwargs)
		if genre_ids == None: return
		return ','.join(genre_ids)

	def get_company(self, company_name):
		from apis.tmdb_api import tmdb_company_id
		company_choice = None
		try:
			results = tmdb_company_id(company_name)
			if results['total_results'] == 1: return results['results'][0]
			try: company_choice = [i for i in results['results'] if i['name'] == company_name][0]
			except: pass
		except: pass
		return company_choice

	def add_dir(self, url_params, list_name=nextpage_str, iconImage=item_next, isFolder=True):
		url = build_url(url_params)
		listitem = xbmcgui.ListItem(list_name)
		listitem.setArt({'icon': iconImage, 'fanart': fanart_empty})
		if url_params['mode'] == 'build_navigate_to_page':
			listitem.setProperty('SpecialSort', 'top')
			listitem.addContextMenuItems([(switchjump_str, 'RunPlugin(%s)' % build_url({'mode': 'toggle_jump_to'}))])
		else:
			listitem.setProperty('SpecialSort', 'bottom')
		xbmcplugin.addDirectoryItem(handle=self.__handle__, url=url, listitem=listitem, isFolder=isFolder)
