# -*- coding: utf-8 -*-
import xbmc, xbmcplugin, xbmcgui, xbmcvfs
import re
import os
import json
from sys import argv
from threading import Thread
try: from urllib import unquote
except ImportError: from urllib.parse import unquote
try: from urlparse import parse_qsl
except ImportError: from urllib.parse import parse_qsl
from apis.opensubtitles_api import OpenSubtitlesAPI
from apis.trakt_api import make_trakt_slug
from indexers.next_episode import nextep_playback_info
from modules import indicators_bookmarks as indicators
from modules.meta_lists import language_choices
from modules.nav_utils import volume_checker, build_url
from modules.kodi_utils import translate_path, close_all_dialog, notification, hide_busy_dialog, sleep, execute_builtin, setView, select_dialog, local_string as ls
from modules.settings_reader import get_setting
from modules.utils import sec2time, clean_file_name, batch_replace, to_utf8
from modules import settings
from modules.utils import logger

window = xbmcgui.Window(10000)
poster_empty = translate_path('special://home/addons/script.tikiart/resources/media/box_office.png')
fanart_empty = translate_path('special://home/addons/plugin.video.fen/fanart.png')

class FenPlayer(xbmc.Player):
	def __init__ (self):
		xbmc.Player.__init__(self)
		self.set_resume = 5
		self.set_watched = 90
		self.media_marked = False
		self.subs_searched = False
		self.nextep_started = False
		self.nextep_info_gathered = False
		self.autoplay_nextep = settings.autoplay_next_episode()

	def run(self, url=None, rootname=None):
		if not url: return
		try:
			if rootname in ('video', 'music'):
				p_list = xbmc.PLAYLIST_VIDEO if rootname == 'video' else xbmc.PLAYLIST_MUSIC
				playlist = xbmc.PlayList(p_list)
				playlist.clear()
				listitem = xbmcgui.ListItem()
				listitem.setInfo(type=rootname, infoLabels={})
				playlist.add(url, listitem)
				close_all_dialog()
				return self.play(playlist)
			self.meta = json.loads(window.getProperty('fen_media_meta'))
			rootname = self.meta['rootname'] if 'rootname' in self.meta else ''
			background = self.meta.get('background', False) == True
			library_item = True if 'from_library' in self.meta else False
			if library_item: bookmark = self.bookmarkLibrary()
			else: bookmark = self.bookmarkFen()
			if bookmark == -1: return
			self.meta.update({'url': url, 'bookmark': bookmark})
			try:
				poster_main, poster_backup, fanart_main, fanart_backup = settings.get_art_provider()
				poster = self.meta.get(poster_main) or self.meta.get(poster_backup) or poster_empty
				fanart = self.meta.get(fanart_main) or self.meta.get(fanart_backup) or fanart_empty
				listitem = xbmcgui.ListItem(path=url)
				if not library_item: listitem.setProperty('StartPercent', str(self.meta.get('bookmark')))
				listitem.setArt({'poster': poster, 'fanart': fanart, 'banner': self.meta.get('banner'), 'clearart': self.meta.get('clearart'),
								'clearlogo': self.meta.get('clearlogo'), 'landscape': self.meta.get('landscape'), 'discart': self.meta.get('discart'),
								'tvshow.clearart': self.meta.get('clearart'), 'tvshow.clearlogo': self.meta.get('clearlogo'), 'tvshow.landscape': self.meta.get('landscape'),
								'tvshow.banner': self.meta.get('banner')})
				listitem.setCast(self.meta['cast'])
				if self.meta['vid_type'] == 'movie':
					listitem.setUniqueIDs({'imdb': str(self.meta['imdb_id']), 'tmdb': str(self.meta['tmdb_id'])})
					listitem.setInfo(
						'video', {'mediatype': 'movie', 'trailer': str(self.meta['trailer']),
						'title': self.meta['title'], 'size': '0', 'duration': self.meta['duration'],
						'plot': self.meta['plot'], 'rating': self.meta['rating'], 'premiered': self.meta['premiered'],
						'studio': self.meta['studio'],'year': self.meta['year'], 'genre': self.meta['genre'],
						'tagline': self.meta['tagline'], 'code': self.meta['imdb_id'], 'imdbnumber': self.meta['imdb_id'],
						'director': self.meta['director'], 'writer': self.meta['writer'], 'votes': self.meta['votes']})
				elif self.meta['vid_type'] == 'episode':
					listitem.setUniqueIDs({'imdb': str(self.meta['imdb_id']), 'tmdb': str(self.meta['tmdb_id']), 'tvdb': str(self.meta['tvdb_id'])})
					listitem.setInfo(
						'video', {'mediatype': 'episode', 'trailer': str(self.meta['trailer']), 'title': self.meta['ep_name'], 'imdbnumber': self.meta['imdb_id'],
						'tvshowtitle': self.meta['title'], 'size': '0', 'plot': self.meta['plot'], 'year': self.meta['year'], 'votes': self.meta['votes'],
						'premiered': self.meta['premiered'], 'studio': self.meta['studio'], 'genre': self.meta['genre'], 'season': int(self.meta['season']),
						'episode': int(self.meta['episode']), 'duration': str(self.meta['duration']), 'rating': self.meta['rating'], 'FileNameAndPath': url})
				try:
					window.clearProperty('script.trakt.ids')
					trakt_ids = {'tmdb': self.meta['tmdb_id'], 'imdb': str(self.meta['imdb_id']), 'slug': make_trakt_slug(self.meta['title'])}
					if self.meta['vid_type'] == 'episode': trakt_ids['tvdb'] = self.meta['tvdb_id']
					window.setProperty('script.trakt.ids', json.dumps(trakt_ids))
				except: pass
			except: pass
			if library_item and not background: xbmcplugin.setResolvedUrl(int(argv[1]), True, listitem)
			else: self.play(url, listitem)
			self.monitor()
		except Exception as e:
			logger('error "run"', str(e))
			return

	def bookmarkFen(self):
		season = self.meta.get('season', '')
		episode = self.meta.get('episode', '')
		if season == 0: season = ''
		if episode == 0: episode = ''
		bookmark = 0
		try:
			resume_point, curr_time = indicators.detect_bookmark(self.meta['vid_type'], self.meta['media_id'], season, episode)
		except Exception as e:
			logger('error "bookmarkFen"', str(e))
			resume_point = 0
		resume_check = float(resume_point)
		if resume_check > 0:
			percent = str(resume_point)
			raw_time = float(curr_time)
			_time = sec2time(raw_time, n_msec=0)
			bookmark = self.getResumeStatus(_time, percent, bookmark)
			if bookmark == 0: indicators.erase_bookmark(self.meta['vid_type'], self.meta['media_id'], season, episode)
		return bookmark

	def bookmarkLibrary(self):
		from modules.kodi_library import get_bookmark_kodi_library
		season = self.meta.get('season', '')
		episode = self.meta.get('episode', '')
		if season == 0: season = ''
		if episode == 0: episode = ''
		bookmark = 0
		try: curr_time = get_bookmark_kodi_library(self.meta['vid_type'], self.meta['media_id'], season, episode)
		except: curr_time = 0.0
		if curr_time > 0:
			self.kodi_library_resumed = False
			_time = sec2time(curr_time, n_msec=0)
			bookmark = self.getResumeStatus(_time, curr_time, bookmark)
			if bookmark == 0: erase_bookmark(self.meta['vid_type'], self.meta['media_id'], season, episode)
		return bookmark

	def getResumeStatus(self, _time, percent, bookmark):
		if settings.auto_resume(self.meta['vid_type']): return percent
		choice = xbmcgui.Dialog().contextmenu([ls(32790) % _time, ls(32791)])
		return percent if choice == 0 else bookmark if choice == 1 else -1

	def monitor(self):
		self.autoplay_next_episode = True if (self.meta['vid_type'] == 'episode' and self.autoplay_nextep and not 'random' in self.meta) else False
		while not self.isPlayingVideo(): sleep(100)
		close_all_dialog()
		volume_checker()
		sleep(1000)
		self.total_time = self.getTotalTime()
		while self.isPlayingVideo():
			try:
				sleep(1000)
				self.curr_time = self.getTime()
				self.current_point = round(float(self.curr_time/self.total_time * 100), 1)
				if self.current_point >= self.set_watched and not self.media_marked:
					self.mediaWatchedMarker()
				if self.autoplay_next_episode:
					if not self.nextep_info_gathered: self.NextEpInfo()
					self.remaining_time = round(self.total_time - self.curr_time)
					if self.remaining_time <= self.start_prep:
						if not self.nextep_started:
							self.runNextEp()
			except: pass
			if not self.subs_searched: self.runSubtitles()
		if not self.media_marked: self.mediaWatchedMarker()
		indicators.clear_local_bookmarks()

	def mediaWatchedMarker(self):
		try:
			self.media_marked = True
			if self.set_resume < self.current_point < self.set_watched:
				window.clearProperty('fen_total_autoplays')
				indicators.set_bookmark(self.meta['vid_type'], self.meta['media_id'], self.curr_time, self.total_time, self.meta.get('season', ''), self.meta.get('episode', ''))
			elif self.current_point >= self.set_watched:
				if self.meta['vid_type'] == 'movie':
					watched_function = indicators.mark_movie_as_watched_unwatched
					watched_update = indicators.get_watched_info_movie
					watched_params = {'mode': 'mark_movie_as_watched_unwatched', 'action': 'mark_as_watched',
					'media_id': self.meta['media_id'], 'title': self.meta['title'], 'year': self.meta['year'],
					'refresh': 'false', 'from_playback': 'true'}
				else:
					watched_function = indicators.mark_episode_as_watched_unwatched
					watched_update = indicators.get_watched_info_tv
					watched_params = {'mode': 'mark_episode_as_watched_unwatched', 'action': 'mark_as_watched',
					'season': self.meta['season'], 'episode': self.meta['episode'], 'media_id': self.meta['media_id'],
					'title': self.meta['title'], 'year': self.meta['year'], 'imdb_id': self.meta['imdb_id'],
					'tvdb_id': self.meta["tvdb_id"], 'refresh': 'false', 'from_playback': 'true'}
				Thread(target=self.runMediaWatched, args=(watched_function, watched_params, watched_update)).start()
			else:
				window.clearProperty('fen_total_autoplays')
		except Exception as e:
			logger('error mediaWatchedMarker', str(e))
			pass

	def runMediaWatched(self, function, params, update):
		try:
			function(params)
			sleep(1000)
			watched_info = update()[0]
		except Exception as e:
			logger('error runMediaWatched', str(e))
			pass

	def NextEpInfo(self):
		try:
			self.nextep_info_gathered = True
			self.nextep_settings = settings.autoplay_next_settings()
			if not self.nextep_settings['run_popup']:
				window_time = round(0.02 * self.total_time)
				self.nextep_settings['window_time'] = window_time
			elif self.nextep_settings['timer_method'] == 'percentage':
				percentage = self.nextep_settings['window_percentage']
				window_time = round((percentage/100) * self.total_time)
				self.nextep_settings['window_time'] = window_time
			else:
				window_time = self.nextep_settings['window_time']
			threshold_check = window_time + 21
			self.start_prep = self.nextep_settings['scraper_time'] + threshold_check
			self.nextep_settings.update({'threshold_check': threshold_check, 'start_prep': self.start_prep})
		except Exception as e:
			logger('error NextEpInfo', str(e))
			pass

	def runNextEp(self):
		try:
			self.nextep_started = True
			from indexers.next_episode import execute_nextep
			try: Thread(target=execute_nextep, args=(self.meta, self.nextep_settings)).start()
			except Exception as e:
				logger('error threading execute_nextep', str(e))
				pass
		except Exception as e:
			logger('error runNextEp', str(e))
			pass

	def runSubtitles(self):
		self.subs_searched = True
		try:
			season = int(self.meta['season']) if self.meta['vid_type'] == 'episode' else None
			episode = int(self.meta['episode']) if self.meta['vid_type'] == 'episode' else None
			Thread(target=Subtitles().get, args=(self.meta['title'], self.meta['imdb_id'], season, episode)).start()
		except: pass

	def onAVStarted(self):
		try: close_all_dialog()
		except: pass

	def onPlayBackStarted(self):
		try: close_all_dialog()
		except: pass

	# def onPlayBackEnded(self):
	# 	try: self.playlist.clear()
	# 	except: pass

	# def onPlayBackStopped(self):
	# 	try: self.playlist.clear()
	# 	except: pass

	def playAudioAlbum(self, t_files=None, name=None, from_seperate=False):
		__handle__ = int(argv[1])
		default_furk_icon = translate_path('special://home/addons/script.tikiart/resources/media/furk.png')
		formats = ('.3gp', ''), ('.aac', ''), ('.flac', ''), ('.m4a', ''), ('.mp3', ''), \
		('.ogg', ''), ('.raw', ''), ('.wav', ''), ('.wma', ''), ('.webm', ''), ('.ra', ''), ('.rm', '')
		params = dict(parse_qsl(argv[2].replace('?','')))
		furk_files_list = []
		playlist = xbmc.PlayList(xbmc.PLAYLIST_MUSIC)
		playlist.clear()
		if from_seperate: t_files = [i for i in t_files if clean_file_name(i['path']) == params.get('item_path')]
		for item in t_files:
			try:
				name = item['path'] if not name else name
				if not 'audio' in item['ct']: continue
				url = item['url_dl']
				track_name = clean_file_name(batch_replace(to_utf8(item['name']), formats))
				listitem = xbmcgui.ListItem(track_name)
				listitem.setArt({'poster': default_furk_icon, 'thumb': default_furk_icon})
				listitem.setInfo(type='music',infoLabels={'title': track_name, 'size': int(item['size']),
														'album': clean_file_name(batch_replace(to_utf8(name), formats)),'duration': item['length']})
				listitem.setProperty('mimetype', 'audio/mpeg')
				playlist.add(url, listitem)
				if from_seperate: furk_files_list.append((url, listitem, False))
			except: pass
		self.play(playlist)
		if from_seperate:
			xbmcplugin.addDirectoryItems(__handle__, furk_files_list, len(furk_files_list))
			setView('view.furk_files')
			xbmcplugin.endOfDirectory(__handle__)

class Subtitles(xbmc.Player):
	def __init__(self):
		xbmc.Player.__init__(self)
		self.os = OpenSubtitlesAPI()
		self.language_dict = language_choices()
		self.auto_enable = get_setting('subtitles.auto_enable')
		self.subs_action = get_setting('subtitles.subs_action')
		self.language1 = self.language_dict[get_setting('subtitles.language')]
		self.quality = ['bluray', 'hdrip', 'brrip', 'bdrip', 'dvdrip', 'webdl', 'webrip', 'webcap', 'web', 'hdtv', 'hdrip']

	def get(self, query, imdb_id, season, episode):
		def _notification(line, _time=3500):
			return notification(line, _time)
		def _video_file_subs():
			try: available_sub_language = self.getSubtitles()
			except: available_sub_language = ''
			if available_sub_language == self.language1:
				if self.auto_enable == 'true': self.showSubtitles(True)
				_notification(32852)
				return True
			return False
		def _downloaded_subs():
			files = xbmcvfs.listdir(subtitle_path)[1]
			if len(files) > 0:
				match_lang1 = None
				match_lang2 = None
				files = [i for i in files if i.endswith('.srt')]
				for item in files:
					if item == search_filename:
						match_lang1 = item
						break
				final_match = match_lang1 if match_lang1 else match_lang2 if match_lang2 else None
				if final_match:
					subtitle = os.path.join(subtitle_path, final_match)
					_notification(32792)
					return subtitle
			return False
		def _searched_subs():
			chosen_sub = None
			search_language = self.language1
			result = self.os.search(query, imdb_id, search_language, season, episode)
			if not result or len(result) == 0:
				_notification(32793)
				return False
			try: video_path = self.getPlayingFile()
			except: video_path = ''
			if '|' in video_path: video_path = video_path.split('|')[0]
			video_path = os.path.basename(video_path)
			if self.subs_action == '1':
				self.pause()
				choices = [i for i in result if i['SubLanguageID'] == search_language and i['SubSumCD'] == '1']
				if len(choices) == 0:
					_notification(32793)
					return False
				string = '%s - %s' % (ls(32246).upper(), video_path)
				dialog_list = ['[B]%s[/B] | [I]%s[/I]' % (i['SubLanguageID'].upper(), i['MovieReleaseName']) for i in choices]
				list_items = [{'line1': item} for item in dialog_list]
				kwargs = {'items': json.dumps(list_items), 'heading': string, 'enumerate': 'true', 'multi_choice': 'false', 'multi_line': 'false'}
				chosen_sub = select_dialog(choices, **kwargs)
				self.pause()
				if not chosen_sub:
					_notification(32736, _time=1500)
					return False
			else:
				try: chosen_sub = [i for i in result if i['MovieReleaseName'].lower() in video_path.lower() and i['SubLanguageID'] == search_language and i['SubSumCD'] == '1'][0]
				except: pass
				if not chosen_sub:
					fmt = re.split(r'\.|\(|\)|\[|\]|\s|\-', video_path)
					fmt = [i.lower() for i in fmt]
					fmt = [i for i in fmt if i in self.quality]
					if season and fmt == '': fmt = 'hdtv'
					result = [i for i in result if i['SubSumCD'] == '1']
					filter = [i for i in result if i['SubLanguageID'] == search_language \
												and any(x in i['MovieReleaseName'].lower() for x in fmt) and any(x in i['MovieReleaseName'].lower() for x in self.quality)]
					filter += [i for i in result if any(x in i['MovieReleaseName'].lower() for x in self.quality)]
					filter += [i for i in result if i['SubLanguageID'] == search_language]
					if len(filter) > 0: chosen_sub = filter[0]
					else: chosen_sub = result[0]
			try: lang = xbmc.convertLanguage(chosen_sub['SubLanguageID'], xbmc.ISO_639_2)
			except: lang = chosen_sub['SubLanguageID']
			sub_format = chosen_sub['SubFormat']
			final_filename = sub_filename + '_%s.%s' % (lang, sub_format)
			download_url = chosen_sub['ZipDownloadLink']
			temp_zip = os.path.join(subtitle_path, 'temp.zip')
			temp_path = os.path.join(subtitle_path, chosen_sub['SubFileName'])
			final_path = os.path.join(subtitle_path, final_filename)
			subtitle = self.os.download(download_url, subtitle_path, temp_zip, temp_path, final_path)
			sleep(1000)
			return subtitle
		if self.subs_action == '2': return
		sleep(2500)
		imdb_id = re.sub(r'[^0-9]', '', imdb_id)
		subtitle_path = translate_path('special://temp/')
		sub_filename = 'FENSubs_%s_%s_%s' % (imdb_id, season, episode) if season else 'FENSubs_%s' % imdb_id
		search_filename = sub_filename + '_%s.srt' % self.language1
		subtitle = _video_file_subs()
		if subtitle: return
		subtitle = _downloaded_subs()
		if subtitle: return self.setSubtitles(subtitle)
		subtitle = _searched_subs()
		if subtitle: return self.setSubtitles(subtitle)





