# -*- coding: utf-8 -*-
from windows.base_dialog import BaseDialog
from modules.kodi_utils import translate_path
from modules.settings import get_art_provider
# from modules.utils import logger

backup_poster = translate_path('special://home/addons/script.tikiart/resources/media/box_office.png')
backup_fanart = translate_path('special://home/addons/plugin.video.fen/fanart.png')

class VideoPlayerXML(BaseDialog):
	def __init__(self, *args, **kwargs):
		BaseDialog.__init__(self, args)
		self.video = kwargs['video']
		self.meta = kwargs['meta']
		self.set_properties()

	def onInit(self):
		self.player.play(self.video, windowed=True)
		self.monitor()

	def run(self):
		self.doModal()
	
	def onAction(self, action, controlID=None):
		if action in self.closing_actions:
			self.player.stop()
			self.exit()

	def monitor(self):
		while not self.player.isPlayingVideo(): self.sleep(100)
		while self.player.isPlayingVideo(): self.sleep(1000)
		self.exit()

	def exit(self):
		self.sleep(500)
		self.close()

	def set_properties(self):
		self.poster_main, self.poster_backup, self.fanart_main, self.fanart_backup = get_art_provider()
		self.setProperty('tikiskins.videoplayer.fanart', self.original_fanart())
		self.setProperty('tikiskins.videoplayer.clearlogo', self.meta['clearlogo'])
		self.setProperty('tikiskins.videoplayer.title', self.meta['title'])

	def original_fanart(self):
		fanart = self.meta.get(self.fanart_main) or self.meta.get(self.fanart_backup) or backup_fanart
		return fanart
