# -*- coding: utf-8 -*-
import xbmcgui, xbmcplugin
from sys import argv
from modules.nav_utils import build_url
from modules.kodi_utils import setView, translate_path, external_browse, local_string as ls
from modules.indicators_bookmarks import get_watched_info_tv
from modules.settings_reader import get_setting
from modules.utils import get_datetime, make_thread_list_enumerate
from modules import settings
# from modules.utils import logger

window = xbmcgui.Window(10000)
dialog = xbmcgui.Dialog()
trakt_icon = translate_path('special://home/addons/script.tikiart/resources/media/trakt.png')
fanart = translate_path('special://home/addons/plugin.video.fen/fanart.png')

def search_trakt_lists(params):
	from apis.trakt_api import trakt_search_lists
	from modules.nav_utils import add_dir
	__handle__ = int(argv[1])
	mode = params.get('mode')
	page = params.get('new_page') if 'new_page' in params else '1'
	search_title = params.get('search_title') if 'search_title' in params else dialog.input("Fen", type=xbmcgui.INPUT_ALPHANUM)
	if not search_title: return
	lists, pages = trakt_search_lists(search_title, page)
	for item in lists:
		try:
			list_key = item['type']
			if list_key == 'officiallist': continue
			list_info = item[list_key]
			name = list_info["name"]
			user = list_info["username"]
			slug = list_info["ids"]["slug"]
			item_count = list_info["item_count"]
			if list_info['privacy'] == 'private' or item_count == 0: continue
			cm = []
			url_params = {'mode': 'trakt.list.build_trakt_list', 'user': user, 'slug': slug}
			trakt_selection_url = {'mode': 'navigator.adjust_main_lists', 'method': 'add_trakt_external', 'name': name, 'user': user, 'slug': slug}
			trakt_folder_selection_url = {'mode': 'navigator.adjust_shortcut_folder_lists', 'method': 'add_trakt_external', 'name': name, 'user': user, 'slug': slug}
			like_list_url = {'mode': 'trakt.trakt_like_a_list', 'user': user, 'list_slug': slug}
			unlike_list_url = {'mode': 'trakt.trakt_unlike_a_list', 'user': user, 'list_slug': slug}
			url = build_url(url_params)
			cm.append((ls(32730),'RunPlugin(%s)' % build_url(trakt_selection_url)))
			cm.append((ls(32731),'RunPlugin(%s)' % build_url(trakt_folder_selection_url)))
			cm.append((ls(32776),'RunPlugin(%s)' % build_url(like_list_url)))
			cm.append((ls(32783),'RunPlugin(%s)' % build_url(unlike_list_url)))
			display = '[B]%s[/B] | [I]%s (x%s)[/I]' % (name.upper(), user, str(item_count))
			listitem = xbmcgui.ListItem(display)
			listitem.setArt({'icon': trakt_icon, 'poster': trakt_icon, 'thumb': trakt_icon, 'fanart': fanart, 'banner': trakt_icon})
			listitem.addContextMenuItems(cm)
			xbmcplugin.addDirectoryItem(__handle__, url, listitem, isFolder=True)
		except: pass
	if pages > page:
		new_page = int(page) + 1
		add_dir({'mode': mode, 'search_title': search_title, 'new_page': str(new_page)}, ls(32799), iconImage='item_next.png')
	xbmcplugin.setContent(__handle__, 'files')
	xbmcplugin.endOfDirectory(__handle__)
	setView('view.main')

def get_trakt_lists(params):
	from apis.trakt_api import trakt_get_lists
	def _process_my_lists():
		for item in lists:
			try:
				cm = []
				name = item["name"]
				user = item["user"]["ids"]["slug"]
				slug = item["ids"]["slug"]
				item_count = item.get('item_count', None)
				if item_count: display_name = '%s (x%s)' % (name, item_count)
				else: display_name = name
				url_params = {'mode': 'trakt.list.build_trakt_list', 'user': user, 'slug': slug}
				trakt_selection_url = {'mode': 'navigator.adjust_main_lists', 'method': 'add_trakt_external', 'name': name, 'user': user, 'slug': slug}
				trakt_folder_selection_url = {'mode': 'navigator.adjust_shortcut_folder_lists', 'method': 'add_trakt_external', 'name': name, 'user': user, 'slug': slug}
				make_new_list_url = {'mode': 'trakt.make_new_trakt_list'}
				delete_list_url = {'mode': 'trakt.delete_trakt_list', 'user': user, 'list_slug': slug}
				url = build_url(url_params)
				cm.append((ls(32730),'RunPlugin(%s)' % build_url(trakt_selection_url)))
				cm.append((ls(32731),'RunPlugin(%s)' % build_url(trakt_folder_selection_url)))
				cm.append((ls(32780),'RunPlugin(%s)' % build_url(make_new_list_url)))
				cm.append((ls(32781),'RunPlugin(%s)' % build_url(delete_list_url)))
				try: listitem = xbmcgui.ListItem(display_name, offscreen=True)
				except: listitem = xbmcgui.ListItem(display_name)
				listitem.setArt({'icon': trakt_icon, 'poster': trakt_icon, 'thumb': trakt_icon, 'fanart': fanart, 'banner': trakt_icon})
				listitem.addContextMenuItems(cm)
				yield (url, listitem, True)
			except: pass
	def _process_liked_lists():
		for item in lists:
			try:
				cm = []
				_item = item['list']
				name = _item["name"]
				user = _item["user"]["ids"]["slug"]
				slug = _item["ids"]["slug"]
				item_count = _item.get('item_count', None)
				if item_count: display_name = '%s (x%s) - [I]%s[/I]' % (name, item_count, user)
				else: display_name = '%s - [I]%s[/I]' % (name, user)
				url_params = {'mode': 'trakt.list.build_trakt_list', 'user': user, 'slug': slug}
				trakt_selection_url = {'mode': 'navigator.adjust_main_lists', 'method': 'add_trakt_external', 'name': name, 'user': user, 'slug': slug}
				trakt_folder_selection_url = {'mode': 'navigator.adjust_shortcut_folder_lists', 'method': 'add_trakt_external', 'name': name, 'user': user, 'slug': slug}
				unlike_list_url = {'mode': 'trakt.trakt_unlike_a_list', 'user': user, 'list_slug': slug}
				url = build_url(url_params)
				try: listitem = xbmcgui.ListItem(display_name, offscreen=True)
				except: listitem = xbmcgui.ListItem(display_name)
				listitem.setArt({'icon': trakt_icon, 'poster': trakt_icon, 'thumb': trakt_icon, 'fanart': fanart, 'banner': trakt_icon})
				cm.append((ls(32730),'RunPlugin(%s)' % build_url(trakt_selection_url)))
				cm.append((ls(32731),'RunPlugin(%s)' % build_url(trakt_folder_selection_url)))
				cm.append((ls(32783),'RunPlugin(%s)' % build_url(unlike_list_url)))
				listitem.addContextMenuItems(cm, replaceItems=False)
				yield (url, listitem, True)
			except: pass
	try:
		__handle__ = int(argv[1])
		list_type = params['list_type']
		lists = trakt_get_lists(list_type)
		if list_type == 'my_lists':
			_process = _process_my_lists
		elif list_type == 'liked_lists':
			_process = _process_liked_lists
		item_list = list(_process())
		xbmcplugin.addDirectoryItems(__handle__, item_list)
		xbmcplugin.setContent(__handle__, 'files')
		xbmcplugin.addSortMethod(__handle__, xbmcplugin.SORT_METHOD_LABEL_IGNORE_THE)
		xbmcplugin.endOfDirectory(__handle__)
		setView('view.main')
	except: pass

def get_trakt_trending_popular_lists(params):
	from apis.trakt_api import trakt_trending_popular_lists
	def _process():
		for item in lists:
			try:
				cm = []
				_item = item['list']
				name = _item["name"]
				user = _item["user"]["ids"]["slug"]
				slug = _item["ids"]["slug"]
				item_count = _item.get('item_count', None)
				if item_count: display_name = '%s (x%s) - [I] %s[/I]' % (name, item_count, user)
				else: display_name = '%s - [I] %s[/I]' % (name, user)
				url_params = {'mode': 'trakt.list.build_trakt_list', 'user': user, 'slug': slug}
				trakt_selection_url = {'mode': 'navigator.adjust_main_lists', 'method': 'add_trakt_external', 'name': name, 'user': user, 'slug': slug}
				trakt_folder_selection_url = {'mode': 'navigator.adjust_shortcut_folder_lists', 'method': 'add_trakt_external', 'name': name, 'user': user, 'slug': slug}
				like_list_url = {'mode': 'trakt.trakt_like_a_list', 'user': user, 'list_slug': slug}
				unlike_list_url = {'mode': 'trakt.trakt_unlike_a_list', 'user': user, 'list_slug': slug}
				url = build_url(url_params)
				try: listitem = xbmcgui.ListItem(display_name, offscreen=True)
				except: listitem = xbmcgui.ListItem(display_name)
				listitem.setArt({'icon': trakt_icon, 'poster': trakt_icon, 'thumb': trakt_icon, 'fanart': fanart, 'banner': trakt_icon})
				cm.append((ls(32730),'RunPlugin(%s)' % build_url(trakt_selection_url)))
				cm.append((ls(32731),'RunPlugin(%s)' % build_url(trakt_folder_selection_url)))
				cm.append((ls(32776),'RunPlugin(%s)' % build_url(like_list_url)))
				cm.append((ls(32783),'RunPlugin(%s)' % build_url(unlike_list_url)))
				listitem.addContextMenuItems(cm)
				yield (url, listitem, True)
			except: pass
	try:
		__handle__ = int(argv[1])
		list_type = params['list_type']
		lists = trakt_trending_popular_lists(list_type)
		item_list = list(_process())
		xbmcplugin.addDirectoryItems(__handle__, item_list)
		xbmcplugin.setContent(__handle__, 'files')
		xbmcplugin.endOfDirectory(__handle__)
		setView('view.main')
	except: pass

def build_trakt_list(params):
	from indexers.movies import Movies
	from indexers.tvshows import TVShows
	from apis.trakt_api import get_trakt_list_contents, get_trakt_movie_id, get_trakt_tvshow_id
	from modules.kodi_utils import sleep
	def _add_misc_dir(url_params, list_name=ls(32799), iconImage='item_next.png', isFolder=True):
		icon = translate_path('special://home/addons/script.tikiart/resources/media/%s' % iconImage)
		listitem = xbmcgui.ListItem(list_name)
		listitem.setArt({'icon': icon, 'poster': icon, 'thumb': icon, 'fanart': fanart, 'banner': icon})
		if url_params['mode'] == 'build_navigate_to_page':
			listitem.setProperty('SpecialSort', 'top')
			listitem.addContextMenuItems([(ls(32784),"RunPlugin(%s)" % build_url({'mode': 'toggle_jump_to'}))])
		else:
			listitem.setProperty('SpecialSort', 'bottom')
		xbmcplugin.addDirectoryItem(handle=__handle__, url=build_url(url_params), listitem=listitem, isFolder=isFolder)
	__handle__ = int(argv[1])
	is_widget = external_browse()
	user = params.get('user')
	slug = params.get('slug')
	cache_page_string = slug
	letter = params.get('new_letter', 'None')
	page_no = int(params.get('new_page', '1'))
	original_list = []
	final_listitems = []
	try:
		result = get_trakt_list_contents(user, slug)
		for item in result:
			try:
				media_type = item['type']
				if not media_type in ('movie', 'show'): continue
				original_list.append({'media_type': media_type, 'title': item[media_type]['title'], 'media_ids': item[media_type]['ids']})
			except: pass
		if settings.paginate():
			from modules.nav_utils import paginate_list
			limit = settings.page_limit()
			final_list, total_pages = paginate_list(original_list, page_no, letter, limit)
		else:
			final_list, total_pages = original_list, 1
		for item in final_list:
			item['media_id'] = get_trakt_movie_id(item['media_ids']) if item['media_type'] == 'movie' else get_trakt_tvshow_id(item['media_ids'])
		movie_list = [(i['media_id'], final_list.index(i), 'movie') for i in final_list if i['media_type'] == 'movie']
		tvshow_list = [(i['media_id'], final_list.index(i), 'tvshow') for i in final_list if i['media_type'] == 'show']
		content = 'movies' if len(movie_list) > len(tvshow_list) else 'tvshows'
		if total_pages > 2 and not is_widget:
			_add_misc_dir({'mode': 'build_navigate_to_page', 'db_type': 'Media', 'user': user, 'slug': slug, 'current_page': page_no, 'total_pages': total_pages,
							'transfer_mode': 'trakt.list.build_trakt_list'}, ls(32964), 'item_jump.png', False)
		if len(movie_list) >= 1:
			movie_listitems = Movies({'list': [i[0] for i in movie_list]}).worker()
			final_listitems.extend([(i, x[1]) for i in movie_listitems for x in movie_list if [str(x[0]) == i[1].getUniqueID('tmdb') and x[2] == 'movie'][0]])
		if len(tvshow_list) >= 1:
			tvshow_listitems = TVShows({'list': [i[0] for i in tvshow_list]}).worker()
			final_listitems.extend([(i, x[1]) for i in tvshow_listitems for x in tvshow_list if [str(x[0]) == i[1].getUniqueID('tmdb') and x[2] == 'tvshow'][0]])
		final_listitems = sorted(final_listitems, key=lambda k: k[1])
		item_list = [i[0] for i in final_listitems]
		xbmcplugin.addDirectoryItems(__handle__, item_list, len(item_list))
		if total_pages > page_no: _add_misc_dir({'mode': 'trakt.list.build_trakt_list', 'user': user, 'slug': slug, 'new_page': str(page_no + 1), 'new_letter': letter})
		xbmcplugin.setContent(__handle__, content)
		xbmcplugin.endOfDirectory(__handle__, cacheToDisc=True)
		if params.get('refreshed'): sleep(1500)
		setView('view.trakt_list', content)
	except:
		from modules.kodi_utils import notification
		notification(32574, 3000)

def get_trakt_my_calendar(params):
	from threading import Thread
	from metadata import tvshow_meta, retrieve_user_info
	from indexers.tvshows import build_episode
	from apis.trakt_api import trakt_get_my_calendar
	def _process(order, item):
		meta = tvshow_meta('tmdb_id', item['tmdb_id'], meta_user_info)
		episode_item = {"season": item['season'], "episode": item['episode'], "meta": meta, "action": "trakt_calendar",
						"include_unaired": True, "first_aired": item['first_aired'], "trakt_calendar": trakt_calendar,
						"adjust_hours": adjust_hours, "current_date": current_date, "date_format": date_format,
						"order": order, "watched_indicators": watched_indicators}
		result.append(build_episode(episode_item, watched_info, art_keys, use_trakt, meta_user_info, display_title, is_widget))
	__handle__ = int(argv[1])
	result = []
	display_title = settings.single_ep_display_title()
	recently_aired = params.get('recently_aired', None)
	current_date = get_datetime()
	data = trakt_get_my_calendar(recently_aired, current_date)
	if recently_aired:
		trakt_calendar = False
		limit = int(get_setting('trakt_widget_limit', '20'))
		data = sorted(data, key=lambda k: k['first_aired'], reverse=True)
		data = data[:limit]
		reverse = True
	else:
		trakt_calendar = True
		data = sorted(data, key=lambda k: k['sort_title'], reverse=False)
		reverse = settings.calendar_sort_order() == 0
	data = sorted(data, key=lambda k: k['first_aired'], reverse=False)
	watched_info, use_trakt = get_watched_info_tv()
	meta_user_info = retrieve_user_info(window)
	adjust_hours = settings.date_offset()
	date_format = settings.single_ep_format()
	is_widget = external_browse()
	watched_indicators = settings.watched_indicators()
	art_keys = settings.get_art_provider()
	threads = list(make_thread_list_enumerate(_process, data, Thread))
	[i.join() for i in threads]
	r = [i for i in result if i is not None]
	r = sorted(r, key=lambda k: k['order'], reverse=reverse)
	item_list = [i['listitem'] for i in r]
	xbmcplugin.addDirectoryItems(__handle__, item_list, len(item_list))
	xbmcplugin.setContent(__handle__, 'episodes')
	xbmcplugin.endOfDirectory(__handle__, cacheToDisc=True)
	setView('view.episode_lists', 'episodes')
	if trakt_calendar and settings.calendar_focus_today():
		today = ls(32849).upper()
		try: index = max([i for i, x in enumerate([i['label'] for i in r]) if today in x])
		except: index = None
		if index:
			from modules.nav_utils import focus_index
			focus_index(index)

