# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcvfs
from xbmcaddon import Addon
import json
try: from sqlite3 import dbapi2 as database
except: from pysqlite2 import dbapi2 as database
# from modules.utils import logger

__addon__ = Addon(id='plugin.video.fen')

def local_string(string):
	try: string = int(string)
	except: return string
	try: string = str(__addon__.getLocalizedString(string))
	except: return __addon__.getLocalizedString(string)
	return string

def container_update(params):
	from modules.nav_utils import build_url
	try: final_params = json.loads(params['final_params'])
	except: final_params = params['final_params']
	execute_builtin('Container.Update(%s)' % build_url(final_params))

def translate_path(path):
	try: translate = xbmcvfs.translatePath(path)
	except: translate = xbmc.translatePath(path)
	return translate

def sleep(time):
	return xbmc.sleep(time)

def execute_builtin(command):
	return xbmc.executebuiltin(command)

def get_kodi_version():
	return int(xbmc.getInfoLabel("System.BuildVersion")[0:2])

def get_video_database_path():
	db_paths = {17: '107', 18: '116', 19: '119'}
	database_path = translate_path('special://profile/Database/MyVideos%s.db' % db_paths[get_kodi_version()])
	return database_path

def show_busy_dialog():
	if get_kodi_version() >= 18: return execute_builtin('ActivateWindow(busydialognocancel)')
	else: return execute_builtin('ActivateWindow(busydialog)')

def hide_busy_dialog():
	if get_kodi_version() >= 18: return execute_builtin('Dialog.Close(busydialognocancel)')
	else: return execute_builtin('Dialog.Close(busydialog)')

def close_all_dialog():
	execute_builtin('Dialog.Close(all,true)')

def external_browse():
	return 'fen' not in xbmc.getInfoLabel('Container.PluginName')

def setView(view_type, content='files'):
	if external_browse(): return
	views_db = translate_path('special://profile/addon_data/plugin.video.fen/views.db')
	if content: sleep(500)
	t = 0
	try:
		dbcon = database.connect(views_db)
		dbcur = dbcon.cursor()
		while not xbmc.getInfoLabel('Container.Content') == content:
			if external_browse(): return
			t += 1
			if t >= 20: return
			sleep(100)
		dbcur.execute("SELECT view_id FROM views WHERE view_type = ?", (str(view_type),))
		view_id = dbcur.fetchone()[0]
		execute_builtin("Container.SetViewMode(%s)" % str(view_id))
		dbcon.close()
	except: return

def ok_dialog(heading='Fen', text='', highlight='royalblue', ok_label='OK', top_space=False):
	from windows import open_window
	if isinstance(heading, int): heading = local_string(heading)
	if isinstance(text, int): text = local_string(text)
	if not text: text = '[CR][CR]%s' % local_string(32760)
	elif top_space: text = '[CR][CR]%s' % text
	kwargs = {'heading': heading, 'text': text, 'highlight': highlight, 'ok_label': ok_label}
	return open_window(('windows.select_ok', 'OK'), 'ok.xml', **kwargs)

def confirm_dialog(heading='Fen', text='', highlight='royalblue', ok_label='OK', cancel_label='Cancel', top_space=False):
	from windows import open_window
	if isinstance(heading, int): heading = local_string(heading)
	if isinstance(text, int): text = local_string(text)
	if isinstance(ok_label, int): ok_label = local_string(ok_label)
	if isinstance(cancel_label, int): cancel_label = local_string(cancel_label)
	if not text: text = '[CR][CR]%s' % local_string(32580)
	elif top_space: text = '[CR][CR]%s' % text
	kwargs = {'heading': heading, 'text': text, 'highlight': highlight, 'ok_label': ok_label, 'cancel_label': cancel_label}
	return open_window(('windows.select_ok', 'YesNo'), 'yesno.xml', **kwargs)

def select_dialog(function_list, **kwargs):
	from windows import open_window
	selection = open_window(('windows.select_ok', 'Select'), 'select.xml', **kwargs)
	if selection in ([], None): return None
	if kwargs.get('multi_choice', 'false') == 'true': return [function_list[i] for i in selection]
	return function_list[selection]

def notification(line1, time=5000, icon=None, sound=False):
	if isinstance(line1, int): line1 = local_string(line1)
	if not icon: icon = translate_path('special://home/addons/plugin.video.fen/icon.png')
	xbmcgui.Dialog().notification('Fen', line1, icon, time, sound)

def show_text(heading, text=None, file=None, font_size='small'):
	from windows import open_window
	from modules import py_tools
	if isinstance(heading, int): heading = local_string(heading)
	if file:
		if py_tools.isPY3:
			with open(file, encoding="utf-8") as r: text = r.read()
		else:
			with open(file) as r: text = r.read()
	return open_window(('windows.textviewer', 'TextViewerXML'), 'textviewer.xml', heading=heading, text=text, font_size=font_size)