# -*- coding: utf-8 -*-
from modules.utils import manual_function_import
from modules.settings import skin_location

location = skin_location()

def create_window(import_info, skin_xml, **kwargs):
	'''
	import_info: list with ['module', 'function']
	'''
	try:
		function = manual_function_import(import_info[0], import_info[1])
		args = (skin_xml, location)
		window = function(*args, **kwargs)
		return window
	except Exception as e:
		from modules.kodi_utils import notification
		from modules.utils import logger
		logger('error in open_window', str(e))
		return notification(32574)

def open_window(import_info, skin_xml, **kwargs):
	'''
	import_info: list with ['module', 'function']
	'''
	try:
		window = create_window(import_info, skin_xml, **kwargs)
		choice = window.run()
		del window
		return choice
	except: pass
