# -*- coding: utf-8 -*-
import xbmc, xbmcgui
from modules.nav_utils import build_url
from modules.kodi_utils import execute_builtin, sleep
from modules.utils import manual_function_import
from modules.settings import skin_location
from modules.utils import logger

location = skin_location()

def create_window(import_info, skin_xml, **kwargs):
	'''
	import_info: list with ['module', 'function']
	'''
	try:
		function = manual_function_import(import_info[0], import_info[1])
		args = (skin_xml, location)
		window = function(*args, **kwargs)
		return window
	except Exception as e:
		from modules.kodi_utils import notification
		# from modules.utils import logger
		logger('error in open_window', str(e))
		return notification(32574)

def open_window(import_info, skin_xml, **kwargs):
	'''
	import_info: list with ['module', 'function']
	'''
	try:
		window = create_window(import_info, skin_xml, **kwargs)
		choice = window.run()
		del window
		return choice
	except: pass

class BaseDialog(xbmcgui.WindowXMLDialog):
	def __init__(self, *args):
		xbmcgui.WindowXMLDialog.__init__(self, args)
		self.closing_actions = [xbmcgui.ACTION_PARENT_DIR, xbmcgui.ACTION_PREVIOUS_MENU, xbmcgui.ACTION_STOP, xbmcgui.ACTION_NAV_BACK]
		self.selection_actions = [xbmcgui.ACTION_SELECT_ITEM, xbmcgui.ACTION_MOUSE_START]
		self.context_actions = [xbmcgui.ACTION_CONTEXT_MENU, xbmcgui.ACTION_MOUSE_RIGHT_CLICK, xbmcgui.ACTION_MOUSE_LONG_CLICK]
		self.info_actions = [xbmcgui.ACTION_SHOW_INFO]
		self.left_actions = [xbmcgui.ACTION_MOVE_LEFT]
		self.right_actions = [xbmcgui.ACTION_MOVE_RIGHT]
		self.up_actions = [xbmcgui.ACTION_MOVE_UP]
		self.down_actions = [xbmcgui.ACTION_MOVE_DOWN]
		self.player = xbmc.Player()

	def make_listitem(self):
		return xbmcgui.ListItem()

	def build_url(self, params):
		return build_url(params)

	def execute_code(self, command):
		return execute_builtin(command)
	
	def get_position(self, window_id):
		return self.getControl(window_id).getSelectedPosition()

	def make_contextmenu_item(self, label, action, params):
		cm_item = self.make_listitem()
		cm_item.setProperty('tikiskins.context.label', label)
		cm_item.setProperty('tikiskins.context.action', action % self.build_url(params))
		return cm_item

	def get_infolabel(self, label):
		return xbmc.getInfoLabel(label)
	
	def open_window(self, import_info, skin_xml, **kwargs):
		return open_window(import_info, skin_xml, **kwargs)

	def sleep(self, time):
		sleep(time)

# class WindowManager:
# 	def __init__(self):
# 		pass

# 	def open(self, import_info, skin_xml, **kwargs):
# 		import json
# 		window = xbmcgui.Window(10000)

# 		new_open = json.dumps({'import_info': import_info, 'skin_xml': skin_xml, 'kwargs': json.dumps(kwargs)})
# 		logger('new_open', new_open)
# 		current_list = window.getProperty('fen_window_manager_list')
# 		if current_list in ('', None): current_list = []
# 		else: current_list = json.loads(current_list)
# 		logger('current_list', current_list)
# 		current_list.append(new_open)

# 		window.setProperty('fen_window_manager_list', json.dumps(current_list))
# 		logger('current_list_property_value', json.loads(window.getProperty('fen_window_manager_list')))
# 		logger('current_list_property_value', type(json.loads(window.getProperty('fen_window_manager_list'))))

# 		first = json.loads(json.loads(json.loads(window.getProperty('fen_window_manager_list'))[0])['kwargs'])
# 		logger('first', first)
# 		logger('first', type(first))




# 		return open_window(import_info, skin_xml, **kwargs)