# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin
import json
from sys import argv
from threading import Thread
import metadata
from apis.trakt_api import get_trakt_tvshow_id
from modules.nav_utils import remove_meta_keys, build_url
from modules.kodi_utils import translate_path, external_browse, setView, local_string as ls
from modules.utils import adjust_premiered_date, make_day, get_datetime, manual_function_import, make_thread_list, make_thread_list_enumerate
from modules import indicators_bookmarks as indicators
from modules import settings
# from modules.utils import logger

tmdb_main = ('tmdb_tv_popular','tmdb_tv_top_rated', 'tmdb_tv_premieres','tmdb_tv_upcoming', 'tmdb_tv_airing_today','tmdb_tv_on_the_air')
trakt_main = ('trakt_tv_anticipated','trakt_tv_trending')
trakt_personal = ('trakt_collection', 'trakt_watchlist', 'trakt_collection_widgets')
imdb_personal = ('imdb_watchlist', 'imdb_user_list_contents', 'imdb_keywords_list_contents')
personal = ('in_progress_tvshows', 'favourites_tvshows', 'watched_tvshows')
similar = ('tmdb_tv_similar', 'tmdb_tv_recommendations')
tmdb_special = ('tmdb_tv_languages', 'tmdb_tv_networks', 'tmdb_tv_year')
tmdb_special_key_dict = {'tmdb_tv_languages': 'language', 'tmdb_tv_networks': 'network_id', 'tmdb_tv_year': 'year'}
item_jump = translate_path('special://home/addons/script.tikiart/resources/media/item_jump.png')
item_next = translate_path('special://home/addons/script.tikiart/resources/media/item_next.png')
poster_empty = translate_path('special://home/addons/script.tikiart/resources/media/box_office.png')
fanart_empty = translate_path('special://home/addons/plugin.video.fen/fanart.png')
window = xbmcgui.Window(10000)
watched_str, unwatched_str, traktmanager_str = ls(32642), ls(32643), ls(32198)
favmanager_str, extras_str, options_str, random_str = ls(32197), ls(32645), ls(32646), ls(32611)
hide_str, exit_str, clearprog_str, nextpage_str, switchjump_str = ls(32648), ls(32650), ls(32651), ls(32799), ls(32784)
season_str, browse_str = ls(32537), ls(32652)
jumpto_str, genre_str = ls(32964), ls(32847)

unaired_label = '[COLOR red][I]%s[/I][/COLOR]'

class TVShows:
	def __init__(self, params):
		self.params = params
		self.items = []
		self.new_page = {}
		self.total_pages = None
		self.exit_list_params = None
		self.is_widget = 'unchecked'
		self.id_type = 'tmdb_id'
		self.list = params.get('list', [])
		self.action = params.get('action', None)
		self.__handle__ = int(argv[1])

	def fetch_list(self):
		try:
			self.is_widget = external_browse()
			content_type = 'tvshows'
			mode = self.params.get('mode')
			try: page_no = int(self.params.get('new_page', '1'))
			except ValueError: page_no = self.params.get('new_page')
			letter = self.params.get('new_letter', 'None')
			self.exit_list_params = self.params.get('exit_list_params', None)
			if not self.exit_list_params: self.exit_list_params = xbmc.getInfoLabel('Container.FolderPath')
			if self.action in personal:
				if self.action == 'in_progress_tvshows': var_module, import_function = 'modules.in_progress', 'in_progress_tvshow'
				elif self.action == 'favourites_tvshows': var_module, import_function = 'modules.favourites', 'retrieve_favourites'
				else: var_module, import_function = 'modules.indicators_bookmarks', 'get_watched_items'
			else: var_module, import_function = 'apis.%s_api' % self.action.split('_')[0], self.action
			try: function = manual_function_import(var_module, import_function)
			except: pass
			if self.action in tmdb_main:
				data = function(page_no)
				for item in data['results']: self.list.append(item['id'])
				self.new_page = {'new_page': str((data['page'] if 'tmdb' in self.action else page_no) + 1)}
			elif self.action in trakt_main:
				data = function(page_no)
				for item in data: self.list.append(get_trakt_tvshow_id(item['show']['ids']))
				self.new_page = {'new_page': str((data['page'] if 'tmdb' in self.action else page_no) + 1)}
			elif self.action in trakt_personal:
				data, total_pages = function('shows', page_no, letter)
				self.list = [i['media_id'] for i in data]
				if total_pages > 2: self.total_pages = total_pages
				try:
					if total_pages > page_no:
						self.new_page = {'new_page': str(page_no + 1), 'new_letter': letter}
				except: pass
			elif self.action in imdb_personal:
				self.id_type = 'imdb_id'
				list_id = self.params.get('list_id', None)
				data, next_page = function('tvshows', list_id, page_no)
				self.list = [i['imdb_id'] for i in data]
				if next_page:
					self.new_page = {'list_id': list_id, 'new_page': str(page_no + 1), 'new_letter': letter}
			elif self.action in personal:
				data, total_pages = function('tvshow', page_no, letter)
				self.list = [i['media_id'] for i in data]
				if total_pages > 2: self.total_pages = total_pages
				if total_pages > page_no:
					self.new_page = {'new_page': str(page_no + 1), 'new_letter': letter}
			elif self.action in similar:
				tmdb_id = self.params['tmdb_id']
				data = function(tmdb_id, page_no)
				self.list = [i['id'] for i in data['results']]
				if data['page'] < data['total_pages']:
					self.new_page = {'new_page': str(data['page'] + 1), 'tmdb_id': tmdb_id}
			elif self.action in tmdb_special:
				key = tmdb_special_key_dict[self.action]
				function_var = self.params.get(key, None)
				if not function_var: return
				data = function(function_var, page_no)
				self.list = [i['id'] for i in data['results']]
				if data['page'] < data['total_pages']:
					self.new_page = {'new_page': str(data['page'] + 1), key: function_var}
			elif self.action == 'tmdb_tv_discover':
				from indexers.discover import set_history
				name = self.params['name']
				query = self.params['query']
				if page_no == 1: set_history('tvshow', name, query)
				data = function(query, page_no)
				for item in data['results']: self.list.append(item['id'])
				if data['page'] < data['total_pages']:
					self.new_page = {'query': query, 'name': name, 'new_page': str(data['page'] + 1)}
			elif self.action == 'trakt_tv_mosts':
				for item in function(self.params['period'], self.params['duration'], page_no): self.list.append((get_trakt_tvshow_id(item['show']['ids'])))
				self.new_page = {'period': self.params['period'], 'duration': self.params['duration'], 'new_page': str(page_no + 1)}
			elif self.action == 'trakt_tv_related':
				imdb_id = self.params.get('imdb_id')
				data, total_pages = function(imdb_id, page_no)
				for item in data: self.list.append(get_trakt_tvshow_id(item['ids']))
				if total_pages > page_no:
					self.new_page = {'new_page': str(page_no + 1), 'imdb_id': imdb_id, 'imdb_id': self.params.get('imdb_id')}
			elif self.action == 'tmdb_tv_genres':
				genre_id = self.params['genre_id'] if 'genre_id' in self.params else self.multiselect_genres(self.params.get('genre_list'))
				if not genre_id: return
				data = function(genre_id, page_no)
				self.list = [i['id'] for i in data['results']]
				if data['page'] < data['total_pages']:
					self.new_page = {'new_page': str(data['page'] + 1), 'genre_id': genre_id}
			elif self.action == 'trakt_tv_certifications':
				for item in function(self.params['certification'], page_no): self.list.append((get_trakt_tvshow_id(item['show']['ids'])))
				self.new_page = {'new_page': str(page_no + 1), 'certification': self.params['certification']}
			elif self.action == 'trakt_recommendations':
				for item in function('shows'): self.list.append(get_trakt_tvshow_id(item['ids']))
			elif self.action == 'tmdb_tv_search':
				query = self.params['query']
				data = function(query, page_no)
				total_pages = data['total_pages']
				if total_pages > page_no:
					self.new_page = {'new_page': str(page_no + 1), 'query': query}
				self.list = [i['id'] for i in data['results']]
			elif self.action  == 'trakt_tv_search':
				query = self.params['query']
				data, total_pages = function(query, page_no, letter)
				for item in data: self.list.append(get_trakt_tvshow_id(item['show']['ids']))
				if total_pages > page_no:
					self.new_page = {'new_page': str(page_no + 1), 'new_letter': letter, 'query': query}
			if self.total_pages and not self.is_widget:
				url_params = {'mode': 'build_navigate_to_page', 'db_type': 'TV Shows', 'current_page': page_no, 'total_pages': self.total_pages, 'transfer_mode': mode,
							'transfer_action': self.action, 'query': self.params.get('search_name', ''), 'actor_id': self.params.get('actor_id', '')}
				self.add_dir(url_params, jumpto_str, item_jump, False)
			item_list = self.worker()
			xbmcplugin.addDirectoryItems(self.__handle__, item_list, len(item_list))
			if self.new_page:
				self.new_page.update({'mode': mode, 'action': self.action, 'exit_list_params': self.exit_list_params})
				self.add_dir(self.new_page)
		except: pass
		xbmcplugin.setContent(self.__handle__, content_type)
		xbmcplugin.endOfDirectory(self.__handle__, cacheToDisc=True)
		setView('view.tvshows', content_type)

	def build_tvshow_content(self, item_position, _id):
		try:
			cm = []
			item = self.set_meta(_id)
			try: listitem = xbmcgui.ListItem(offscreen=True)
			except: listitem = xbmcgui.ListItem()
			rootname = item['rootname']
			tmdb_id = item['tmdb_id']
			tvdb_id = item['tvdb_id']
			imdb_id = item['imdb_id']
			title = item['title']
			year = item['year']
			poster = item.get(self.poster_main) or item.get(self.poster_backup) or poster_empty
			fanart = item.get(self.fanart_main) or item.get(self.fanart_backup) or fanart_empty
			trailer = item['trailer']
			total_seasons = item['total_seasons']
			meta_json = json.dumps(item)
			total_aired_eps = item['total_aired_eps']
			playcount = item['playcount']
			total_watched = item['total_watched']
			total_unwatched = item['total_unwatched']
			if self.show_all_episodes:
				if self.all_episodes == 1 and total_seasons > 1:
					url_params = {'mode': 'build_season_list', 'meta': meta_json, 'tmdb_id': tmdb_id}
				else:
					url_params = {'mode': 'build_episode_list', 'tmdb_id': tmdb_id, 'season': 'all', 'meta': meta_json}
			else:
				url_params = {'mode': 'build_season_list', 'meta': meta_json, 'tmdb_id': tmdb_id}
			options_params = {'mode': 'options_menu_choice', 'content': 'tvshow', 'meta': meta_json}
			extras_params = {'mode': 'extras_menu_choice', 'meta': meta_json, 'is_widget': self.is_widget}
			random_params = {'mode': 'play_fetch_random', 'db_type': 'episode', 'meta': meta_json}
			trakt_manager_params = {'mode': 'trakt_manager_choice', 'tmdb_id': tmdb_id, 'imdb_id': imdb_id, 'tvdb_id': tvdb_id, 'db_type': 'tvshow'}
			fav_manager_params = {'mode': 'favorites_choice', 'db_type': 'tvshow', 'tmdb_id': tmdb_id, 'title': title}
			if self.open_extras: action_params = extras_params
			else:
				action_params = url_params
				cm.append((extras_str, 'RunPlugin(%s)' % build_url(extras_params)))
			cm.append((options_str,'RunPlugin(%s)' % build_url(options_params)))
			cm.append((random_str,'RunPlugin(%s)' % build_url(random_params)))
			cm.append((traktmanager_str,'RunPlugin(%s)' % build_url(trakt_manager_params)))
			cm.append((favmanager_str,'RunPlugin(%s)' % build_url(fav_manager_params)))
			if not playcount:
				watched_params = {'mode': 'mark_tv_show_as_watched_unwatched', 'action': 'mark_as_watched', 'title': title, 'year': year,
									'media_id': tmdb_id, 'imdb_id': imdb_id, 'tvdb_id': tvdb_id}
				cm.append((watched_str % self.watched_title, 'RunPlugin(%s)' % build_url(watched_params)))	
			if total_watched:
				unwatched_params = {'mode': 'mark_tv_show_as_watched_unwatched', 'action': 'mark_as_unwatched', 'title': title, 'year': year,
									'media_id': tmdb_id, 'imdb_id': imdb_id, 'tvdb_id': tvdb_id}
				cm.append((unwatched_str % self.watched_title, 'RunPlugin(%s)' % build_url(unwatched_params)))
			cm.append((exit_str, 'Container.Refresh(%s)' % self.exit_list_params))
			url = build_url(action_params)
			listitem.setLabel(rootname if self.include_year_in_title else title)
			listitem.setContentLookup(False)
			listitem.addContextMenuItems(cm)
			listitem.setCast(item['cast'])
			listitem.setUniqueIDs({'imdb': str(imdb_id), 'tmdb': str(tmdb_id), 'tvdb': str(tvdb_id)})
			listitem.setArt({'poster': poster, 'fanart': fanart, 'icon': poster, 'banner': item['banner'], 'clearart': item['clearart'],
							'clearlogo': item['clearlogo'], 'landscape': item['landscape'], 'tvshow.clearart': item['clearart'], 'tvshow.clearlogo': item['clearlogo'],
							'tvshow.landscape': item['landscape'], 'tvshow.banner': item['banner']})
			listitem.setProperty('watchedepisodes', str(total_watched))
			listitem.setProperty('unwatchedepisodes', str(total_unwatched))
			listitem.setProperty('totalepisodes', str(total_aired_eps))
			listitem.setProperty('totalseasons', str(total_seasons))
			listitem.setProperty('fen_listitem_meta', meta_json)
			listitem.setProperty('fen_extras_menu_params', json.dumps(extras_params))
			listitem.setProperty('fen_options_menu_params', json.dumps(options_params))
			if self.is_widget:
				listitem.setProperty('fen_widget', 'true')
				listitem.setProperty('fen_playcount', str(item['playcount']))
			listitem.setInfo('video', remove_meta_keys(item, db_type='tvshow'))
			listitem.setProperty('fen_sort_order', str(item_position))
			self.items.append((url, listitem, self.is_folder))
		except: pass

	def set_meta(self, _id):
		meta = metadata.tvshow_meta(self.id_type, _id, self.meta_user_info)
		if not meta: return
		playcount, overlay, total_watched, total_unwatched = indicators.get_watched_status_tvshow(self.watched_info, self.use_trakt, meta['tmdb_id'], meta.get('total_aired_eps'))
		meta.update({'playcount': playcount, 'overlay': overlay, 'total_watched': total_watched, 'total_unwatched': total_unwatched})
		return meta

	def worker(self):
		if self.is_widget == 'unchecked': self.is_widget = external_browse()
		if not self.exit_list_params: self.exit_list_params = xbmc.getInfoLabel('Container.FolderPath')
		self.watched_info, self.use_trakt = indicators.get_watched_info_tv()
		self.meta_user_info = metadata.retrieve_user_info(window)
		self.watched_title = 'Trakt' if self.use_trakt in (1, 2) else 'Fen'
		self.all_episodes = settings.default_all_episodes()
		self.show_all_episodes = True if self.all_episodes in (1, 2) else False
		self.include_year_in_title = settings.include_year_in_title('tvshow')
		self.open_extras = settings.extras_open_action('tvshow')
		self.is_folder = False if self.open_extras else True
		self.poster_main, self.poster_backup, self.fanart_main, self.fanart_backup = settings.get_art_provider()
		window.clearProperty('fen_fanart_error')
		threads = list(make_thread_list_enumerate(self.build_tvshow_content, self.list, Thread))
		[i.join() for i in threads]
		return sorted(self.items, key=lambda k: int(k[1].getProperty('fen_sort_order')))

	def multiselect_genres(self, genre_list):
		import os
		from modules.kodi_utils import select_dialog
		def _builder():
			for genre, value in sorted(genre_list.items()):
				function_list.append(value[0])
				yield {'line1': genre, 'icon': os.path.join(icon_directory, value[1])}
		function_list = []
		icon_directory = translate_path('special://home/addons/script.tikiart/resources/media')
		genre_list = json.loads(genre_list)
		list_items = list(_builder())
		kwargs = {'items': json.dumps(list_items), 'heading': genre_str, 'enumerate': 'false', 'multi_choice': 'true', 'multi_line': 'false'}
		genre_ids = select_dialog(function_list, **kwargs)
		if genre_ids == None: return
		return ','.join(genre_ids)

	def add_dir(self, url_params, list_name=nextpage_str, iconImage=item_next, isFolder=True):
		url = build_url(url_params)
		listitem = xbmcgui.ListItem(list_name)
		listitem.setArt({'icon': iconImage, 'fanart': fanart_empty})
		if url_params['mode'] == 'build_navigate_to_page':
			listitem.setProperty('SpecialSort', 'top')
			listitem.addContextMenuItems([(switchjump_str, 'RunPlugin(%s)' % build_url({'mode': 'toggle_jump_to'}))])
		else:
			listitem.setProperty('SpecialSort', 'bottom')
		xbmcplugin.addDirectoryItem(handle=self.__handle__, url=url, listitem=listitem, isFolder=isFolder)

def build_season_list(params):
	def _process():
		running_ep_count = total_aired_eps
		def _unaired_status():
			if episode_count == 0: return True
			season_date_start = adjust_premiered_date(air_date, 0)[0]
			if not season_date_start or current_date < season_date_start: return True
			return False
		for item in season_data:
			try:
				try: listitem = xbmcgui.ListItem(offscreen=True)
				except: listitem = xbmcgui.ListItem()
				cm = []
				overview = item['overview']
				name = item['name']
				poster_path = item['poster_path']
				season_poster = "https://image.tmdb.org/t/p/%s%s" % (image_resolution, poster_path) if poster_path is not None else show_poster
				air_date = item['air_date']
				season_number = item['season_number']
				episode_count = item['episode_count']
				unaired = _unaired_status()
				if unaired:
					if not show_unaired: return
					episode_count = 0
				else:
					running_ep_count -= episode_count
					if running_ep_count < 0: episode_count = running_ep_count + episode_count
				try: year = air_date.split('-')[0]
				except: year = show_year
				plot = overview if overview != '' else show_plot
				title = name if use_season_title and name != '' else '%s %s' % (season_str, str(season_number))
				if unaired: title = unaired_label % title
				playcount, overlay, watched, unwatched = indicators.get_watched_status_season(watched_info, use_trakt, tmdb_id, season_number, episode_count)
				url_params = {'mode': 'build_episode_list', 'tmdb_id': tmdb_id, 'season': season_number}
				extras_params = {'mode': 'extras_menu_choice', 'meta': meta_json, 'is_widget': is_widget}
				options_params = {'mode': 'options_menu_choice'}
				cm.append((extras_str,'RunPlugin(%s)' % build_url(extras_params)))
				cm.append((options_str,'RunPlugin(%s)' % build_url(options_params)))
				if not playcount:
					watched_params = {'mode': 'mark_season_as_watched_unwatched', 'action': 'mark_as_watched', 'title': show_title, 'year': show_year,
									  'media_id': tmdb_id, 'imdb_id': imdb_id, 'tvdb_id': tvdb_id, 'season': season_number}
					cm.append((watched_str % watched_title,'RunPlugin(%s)' % build_url(watched_params)))
				if watched:
					unwatched_params = {'mode': 'mark_season_as_watched_unwatched', 'action': 'mark_as_unwatched', 'title': show_title, 'year': show_year,
										'media_id': tmdb_id, 'imdb_id': imdb_id, 'tvdb_id': tvdb_id, 'season': season_number}
					cm.append((unwatched_str % watched_title,'RunPlugin(%s)' % build_url(unwatched_params)))
				url = build_url(url_params)
				listitem.setLabel(title)
				listitem.setContentLookup(False)
				listitem.setProperty('watchedepisodes', str(watched))
				listitem.setProperty('unwatchedepisodes', str(unwatched))
				listitem.setProperty('totalepisodes', str(episode_count))
				listitem.addContextMenuItems(cm)
				listitem.setArt({'poster': season_poster, 'icon': season_poster, 'thumb': season_poster, 'fanart': fanart, 'banner': banner, 'clearart': clearart,
								'clearlogo': clearlogo, 'landscape': landscape, 'tvshow.clearart': clearart, 'tvshow.clearlogo': clearlogo, 'tvshow.landscape': landscape,
								'tvshow.banner': banner})
				listitem.setCast(cast)
				listitem.setUniqueIDs({'imdb': str(imdb_id), 'tmdb': str(tmdb_id), 'tvdb': str(tvdb_id)})
				listitem.setInfo('video', {'mediatype': 'season', 'trailer': trailer, 'title': title, 'size': '0', 'duration': episode_run_time, 'plot': plot, 'rating': rating,
								'premiered': premiered, 'studio': studio, 'year': year,'genre': genre, 'mpaa': mpaa, 'tvshowtitle': show_title, 'imdbnumber': imdb_id,
								'votes': votes, 'season': season_number,'playcount': playcount, 'overlay': overlay})
				listitem.setProperty('fen_listitem_meta', meta_json)
				listitem.setProperty('fen_options_menu_params', json.dumps(options_params))
				listitem.setProperty('fen_extras_menu_params', json.dumps(extras_params))
				if is_widget:
					listitem.setProperty('fen_widget', 'true')
					listitem.setProperty('fen_playcount', str(playcount))
				yield (url, listitem, True)
			except: pass
	__handle__ = int(argv[1])
	is_widget = external_browse()
	meta_user_info = metadata.retrieve_user_info(window)
	image_resolution = meta_user_info['image_resolution']['poster']
	poster_main, poster_backup, fanart_main, fanart_backup = settings.get_art_provider()
	if 'meta' in params:
		meta = json.loads(params.get('meta'))
	else:
		window.clearProperty('fen_fanart_error')
		meta = metadata.tvshow_meta('tmdb_id', params.get('tmdb_id'), meta_user_info)
	season_data = meta['season_data']
	if not season_data: return
	meta_json = json.dumps(meta)
	tmdb_id, tvdb_id, imdb_id = meta['tmdb_id'], meta['tvdb_id'], meta['imdb_id']
	show_title, show_year, show_plot, banner = meta['title'], meta['year'], meta['plot'], meta['banner']
	show_poster = meta.get(poster_main) or meta.get(poster_backup) or poster_empty
	fanart = meta.get(fanart_main) or meta.get(fanart_backup) or fanart_empty
	clearlogo, clearart, landscape = meta['clearlogo'], meta['clearart'], meta['landscape']
	cast, mpaa, votes = meta['cast'], meta['mpaa'], meta.get('votes')
	trailer, genre, studio = str(meta['trailer']), meta.get('genre'), meta.get('studio')
	episode_run_time, rating, premiered = meta.get('episode_run_time'), meta.get('rating'), meta.get('premiered')
	total_seasons = meta['total_seasons']
	total_aired_eps = meta['total_aired_eps']
	if not settings.show_specials(): season_data = [i for i in season_data if not i['season_number'] == 0]
	season_data = sorted(season_data, key=lambda k: k['season_number'])
	use_season_title = settings.use_season_title()
	show_unaired = settings.show_unaired()
	watched_indicators = settings.watched_indicators()
	watched_title = 'Trakt' if watched_indicators == 1 else 'Fen'
	watched_info, use_trakt = indicators.get_watched_info_tv()
	current_date = get_datetime()
	xbmcplugin.addDirectoryItems(__handle__, list(_process()))
	xbmcplugin.setContent(__handle__, 'seasons')
	xbmcplugin.endOfDirectory(__handle__, cacheToDisc=True)
	setView('view.seasons', 'seasons')
	window.setProperty('fen_media_meta', meta_json)

def build_episode_list(params):
	def _process(item):
		try:
			try: listitem = xbmcgui.ListItem(offscreen=True)
			except: listitem = xbmcgui.ListItem()
			cm = []
			season = item['season']
			episode = item['episode']
			ep_name = item['title']
			premiered = item['premiered']
			all_cast = cast + item.get('guest_stars', [])
			episode_date, premiered = adjust_premiered_date(premiered, adjust_hours)
			playcount, overlay = indicators.get_watched_status(watched_info, use_trakt, 'episode', tmdb_id, season, episode)
			resumetime = indicators.get_resumetime('episode', tmdb_id, season, episode)
			query = title + ' S%.2dE%.2d' % (int(season), int(episode))
			display_name = '%s - %dx%.2d' % (title, season, episode)
			thumb = item['thumb'] if item.get('thumb', None) else fanart
			meta.update({'vid_type': 'episode', 'rootname': display_name, 'season': season, 'episode': episode, 'premiered': premiered, 'ep_name': ep_name, 'plot': item['plot'],
						'thumb': thumb, 'playcount': playcount, 'cast': all_cast, 'tvshow_plot': tvshow_plot})
			item.update({'trailer': trailer, 'tvshowtitle': title, 'premiered': premiered, 'genre': genre, 'duration': duration, 'mpaa': mpaa, 'studio': studio,
						'playcount': playcount, 'overlay': overlay})
			meta_json = json.dumps(meta)
			extras_params = {'mode': 'extras_menu_choice', 'meta': meta_json, 'is_widget': is_widget}
			options_params = {'mode': 'options_menu_choice', 'suggestion': query, 'content': 'episode', 'meta': meta_json}
			url_params = {'mode': 'play_media', 'vid_type': 'episode', 'tmdb_id': tmdb_id, 'imdb_id': imdb_id, 'tvdb_id': tvdb_id, 'query': query,
						'tvshowtitle': meta['rootname'], 'season': season, 'episode': episode}
			url = build_url(url_params)
			display = ep_name
			unaired = False
			if not episode_date or current_date < episode_date:
				if not show_unaired: return
				unaired = True
				display = unaired_label % ep_name
				item['title'] = display
			item['sortseason'] = season
			item['sortepisode'] = episode
			cm.append((extras_str,'RunPlugin(%s)' % build_url(extras_params)))
			cm.append((options_str,'RunPlugin(%s)' % build_url(options_params)))
			if not unaired and resumetime != '0':
				cm.append((clearprog_str, 'RunPlugin(%s)' \
					% build_url({'mode': 'watched_unwatched_erase_bookmark', 'db_type': 'episode', 'media_id': tmdb_id, 'season': season, 'episode': episode, 'refresh': 'true'})))
				listitem.setProperty('fen_in_progress', 'true')
			if not unaired:
				if playcount:
					unwatched_params = {'mode': 'mark_episode_as_watched_unwatched', 'action': 'mark_as_unwatched', 'media_id': tmdb_id, 'imdb_id': imdb_id, 'tvdb_id': tvdb_id,
										'season': season, 'episode': episode,  'title': title, 'year': year}
					cm.append((unwatched_str % watched_title, 'RunPlugin(%s)' % build_url(unwatched_params)))
				else:
					watched_params = {'mode': 'mark_episode_as_watched_unwatched', 'action': 'mark_as_watched', 'media_id': tmdb_id, 'imdb_id': imdb_id, 'tvdb_id': tvdb_id,
									'season': season, 'episode': episode,  'title': title, 'year': year}
					cm.append((watched_str % watched_title, 'RunPlugin(%s)' % build_url(watched_params)))
			listitem.setLabel(display)
			listitem.setContentLookup(False)
			listitem.setProperty('resumetime', resumetime)
			listitem.addContextMenuItems(cm)
			listitem.setArt({'poster': show_poster, 'fanart': fanart, 'thumb': thumb, 'icon':thumb, 'banner': banner, 'clearart': clearart, 'clearlogo': clearlogo,
							'landscape': thumb, 'tvshow.clearart': clearart, 'tvshow.clearlogo': clearlogo, 'tvshow.landscape': thumb, 'tvshow.banner': banner})
			listitem.setCast(all_cast)
			listitem.setUniqueIDs({'imdb': str(imdb_id), 'tmdb': str(tmdb_id), 'tvdb': str(tvdb_id)})
			listitem.setInfo('video', remove_meta_keys(item, db_type='episode'))
			listitem.setProperty('fen_options_menu_params', json.dumps(options_params))
			listitem.setProperty('fen_extras_menu_params', json.dumps(extras_params))
			if is_widget:
				listitem.setProperty('fen_widget', 'true')
				listitem.setProperty('fen_playcount', str(playcount))
			listitem.setProperty('fen_listitem_meta', meta_json)
			listitem.setProperty('fen_sort_order', str(episode))
			items.append((url, listitem, False))
		except: pass
	__handle__ = int(argv[1])
	items = []
	is_widget = external_browse()
	show_unaired = settings.show_unaired()
	poster_main, poster_backup, fanart_main, fanart_backup = settings.get_art_provider()
	meta_user_info = metadata.retrieve_user_info(window)
	all_episodes = True if params.get('season') == 'all' else False
	if all_episodes:
		if 'meta' in params:
			meta = json.loads(params.get('meta'))
		else:
			window.clearProperty('fen_fanart_error')
			meta = metadata.tvshow_meta('tmdb_id', params.get('tmdb_id'), meta_user_info)
	else:
		try:
			meta = json.loads(window.getProperty('fen_media_meta'))
		except:
			window.clearProperty('fen_fanart_error')
			meta = metadata.tvshow_meta('tmdb_id', params.get('tmdb_id'), meta_user_info)
	tmdb_id, tvdb_id, imdb_id = meta['tmdb_id'], meta['tvdb_id'], meta['imdb_id']
	title, year, rootname, banner = meta['title'], meta['year'], meta['rootname'], meta['banner']
	show_poster = meta.get(poster_main) or meta.get(poster_backup) or poster_empty
	fanart = meta.get(fanart_main) or meta.get(fanart_backup) or fanart_empty
	clearlogo, clearart, landscape = meta['clearlogo'], meta['clearart'], meta['landscape']
	cast, mpaa, duration = meta['cast'], meta['mpaa'], meta.get('duration')
	trailer, genre, studio = str(meta['trailer']), meta.get('genre'), meta.get('studio')
	tvshow_plot = meta['plot']
	adjust_hours = settings.date_offset()
	current_date = get_datetime()
	watched_indicators = settings.watched_indicators()
	watched_title = 'Trakt' if watched_indicators == 1 else 'Fen'
	if all_episodes:
		episodes_data = metadata.all_episodes_meta(meta, meta_user_info)
		if not settings.show_specials(): episodes_data = [i for i in episodes_data if not i['season'] == 0]
	else: episodes_data = metadata.season_episodes_meta(params['season'], meta, meta_user_info)
	watched_info, use_trakt = indicators.get_watched_info_tv()
	threads = list(make_thread_list(_process, episodes_data, Thread))
	[i.join() for i in threads]
	item_list = sorted(items, key=lambda k: int(k[1].getProperty('fen_sort_order')))
	xbmcplugin.addDirectoryItems(__handle__, item_list)
	xbmcplugin.setContent(__handle__, 'episodes')
	xbmcplugin.addSortMethod(__handle__, xbmcplugin.SORT_METHOD_EPISODE)
	xbmcplugin.endOfDirectory(__handle__, cacheToDisc=True)
	setView('view.episodes', 'episodes')

def build_episode(item, watched_info, art_keys, use_trakt, meta_user_info, display_title, is_widget):
	def get_art():
		poster_main, poster_backup, fanart_main, fanart_backup = art_keys
		poster = meta.get(poster_main) or meta.get(poster_backup) or poster_empty
		fanart = meta.get(fanart_main) or meta.get(fanart_backup) or fanart_empty
		return poster, fanart
	def check_for_unaired(premiered):
		if item.get('ignore_unaired', False): return False
		unaired = False
		adjust_hours = item.get('adjust_hours', None) or settings.date_offset()
		current_date = item.get('current_date', None) or get_datetime()
		episode_date, premiered = adjust_premiered_date(premiered, adjust_hours)
		if not episode_date or current_date < episode_date: unaired = True
		return unaired, current_date, episode_date, premiered
	def build_display():
		if display_title == 0: title_string = '%s: ' % title
		else: title_string = ''
		if display_title in (0,1): seas_ep = '%dx%.2d - ' % (info['season'], info['episode'])
		else: seas_ep = ''
		if nextep_info:
			date_format = item.get('date_format', None) or settings.single_ep_format()
			if episode_date: display_premiered = make_day(current_date, episode_date, date_format)
			else: display_premiered == 'UNKNOWN'
			airdate = '[[COLOR magenta]%s[/COLOR]] ' % display_premiered if nextep_info['include_airdate'] else ''
			highlight_color = nextep_info['unwatched_color'] if item.get('unwatched', False) else nextep_info['unaired_color'] if unaired else ''
			italics_open, italics_close = ('[I]', '[/I]') if highlight_color else ('', '')
			if highlight_color: episode_info = '%s[COLOR %s]%s %s[/COLOR]%s' % (italics_open, highlight_color, seas_ep, info['title'], italics_close)
			else: episode_info = '%s%s%s%s' % (italics_open, seas_ep, info['title'], italics_close)
			display = '%s%s%s' % (airdate, title_string, episode_info)
		elif trakt_calendar:
			date_format = item.get('date_format', None) or settings.single_ep_format()
			if episode_date: display_premiered = make_day(current_date, episode_date, date_format)
			else: display_premiered == 'UNKNOWN'
			display = '[%s]%s%s%s' % (display_premiered, title_string.upper(), seas_ep, info['title'])
			if unaired:
				displays = display.split(']')
				display = unaired_label % (displays[0], displays[1])
		else:
			color_tags = ('[COLOR red]', '[/COLOR]') if unaired else ('', '')
			display = '%s%s%s%s%s' % (title_string.upper(), color_tags[0], seas_ep, info['title'], color_tags[1])
		return display
	try:
		try: listitem = xbmcgui.ListItem(offscreen=True)
		except: listitem = xbmcgui.ListItem()
		cm = []
		nextep_info = item.get('nextep_display_settings', {})
		trakt_calendar = item.get('trakt_calendar', False)
		action = item.get('action', '')
		meta = item['meta']
		tmdb_id = meta['tmdb_id']
		tvdb_id = meta['tvdb_id']
		imdb_id = meta['imdb_id']
		title = meta['title']
		year = meta['year']
		poster, fanart = get_art()
		episodes_data = metadata.season_episodes_meta(item['season'], meta, meta_user_info)
		info = [i for i in episodes_data if i['episode'] == item['episode']][0]
		season = info['season']
		episode = info['episode']
		premiered = info['premiered']
		duration = meta.get('duration')
		all_cast = meta['cast'] + info.get('guest_stars', [])
		unaired, current_date, episode_date, premiered = check_for_unaired(premiered)
		if unaired and not item.get('include_unaired', False): return
		thumb = info.get('thumb', None) or fanart
		playcount, overlay = indicators.get_watched_status(watched_info, use_trakt, 'episode', tmdb_id, season, episode)
		info.update({'trailer': str(meta.get('trailer')), 'tvshowtitle': title, 'premiered': premiered, 'genre': meta.get('genre'), 'duration': duration, 'mpaa': meta.get('mpaa'),
					'studio': meta.get('studio'), 'playcount': playcount, 'overlay': overlay})
		# resumetime = item.get('resume_point') or indicators.get_resumetime('episode', tmdb_id, duration, season, episode)
		resumetime = indicators.get_resumetime('episode', tmdb_id, season, episode)
		query = title + ' S%.2dE%.2d' % (season, episode)
		display = build_display()
		rootname = '%s (%s)' % (title, year)
		tvshow_plot = meta['plot']
		meta.update({'vid_type': 'episode', 'rootname': rootname, 'season': season, 'episode': episode, 'premiered': premiered, 'ep_name': info['title'], 'plot': info['plot'],
					'thumb': thumb, 'playcount': playcount, 'cast': all_cast, 'tvshow_plot': tvshow_plot})
		meta_json = json.dumps(meta)
		url_params = {'mode': 'play_media', 'vid_type': 'episode', 'tmdb_id': tmdb_id, 'imdb_id': imdb_id, 'tvdb_id': tvdb_id, 'query': query,
					'tvshowtitle': meta['rootname'], 'season': season, 'episode': episode}
		url = build_url(url_params)
		browse_url = build_url({'mode': 'build_season_list', 'meta': meta_json})
		extras_params = {'mode': 'extras_menu_choice', 'meta': meta_json, 'is_widget': is_widget}
		options_params = {'mode': 'options_menu_choice', 'suggestion': query, 'content': 'episode', 'meta': meta_json}
		cm.append((extras_str,'RunPlugin(%s)' % build_url(extras_params)))
		cm.append((options_str,'RunPlugin(%s)' % build_url(options_params)))
		cm.append((browse_str,'Container.Update(%s)' % browse_url))
		if not unaired:
			if resumetime != '0':
				cm.append((clearprog_str, 'RunPlugin(%s)' % build_url({'mode': 'watched_unwatched_erase_bookmark', 'db_type': 'episode', 'media_id': tmdb_id,
																	'season': season, 'episode': episode, 'refresh': 'true'})))
				listitem.setProperty('fen_in_progress', 'true')
			watched_indicators = item.get('watched_indicators') or settings.watched_indicators()
			watched_title = 'Trakt' if watched_indicators == 1 else 'Fen'
			if playcount:
				unwatched_params = {'mode': 'mark_episode_as_watched_unwatched', 'action': 'mark_as_unwatched', 'media_id': tmdb_id, 'imdb_id': imdb_id, 'tvdb_id': tvdb_id,
									'season': season, 'episode': episode,  'title': title, 'year': year}
				cm.append((unwatched_str % watched_title, 'RunPlugin(%s)' % build_url(unwatched_params)))
			else:
				watched_params = {'mode': 'mark_episode_as_watched_unwatched', 'action': 'mark_as_watched', 'media_id': tmdb_id, 'imdb_id': imdb_id, 'tvdb_id': tvdb_id,
								'season': season, 'episode': episode,  'title': title, 'year': year}
				cm.append((watched_str % watched_title, 'RunPlugin(%s)' % build_url(watched_params)))
		if nextep_info.get('from_trakt', False): cm.append((ls(32599),'Container.Update(%s)' % build_url({'mode': 'build_next_episode_manager'})))
		listitem.setLabel(display)
		listitem.setContentLookup(False)
		listitem.setProperty('resumetime', resumetime)
		listitem.setArt({'poster': poster, 'fanart': fanart, 'thumb': thumb, 'icon':thumb, 'banner': meta['banner'], 'clearart': meta['clearart'],
						'clearlogo': meta['clearlogo'], 'landscape': thumb, 'tvshow.clearart': meta['clearart'], 'tvshow.clearlogo': meta['clearlogo'], 'tvshow.landscape': thumb,
						'tvshow.banner': meta['banner']})
		listitem.addContextMenuItems(cm)
		listitem.setCast(all_cast)
		listitem.setUniqueIDs({'imdb': str(imdb_id), 'tmdb': str(tmdb_id), 'tvdb': str(tvdb_id)})
		info['title'] = display
		listitem.setInfo('video', remove_meta_keys(info, db_type='episode'))
		listitem.setProperty('fen_listitem_meta', meta_json)
		listitem.setProperty('fen_options_menu_params', json.dumps(options_params))
		listitem.setProperty('fen_extras_menu_params', json.dumps(extras_params))
		if is_widget:
			listitem.setProperty('fen_widget', 'true')
			listitem.setProperty('fen_playcount', str(playcount))
		return {'listitem': (url, listitem, False), 'curr_last_played_parsed': item.get('curr_last_played_parsed', ''), 'label': display,
				'order': item.get('order', ''), 'name': query, 'first_aired': premiered, 'current_date': current_date, 'episode_date': episode_date}
	except: pass
