# -*- coding: utf-8 -*-
from threading import Thread
from windows import BaseDialog
from modules.image_utils import ImageColors, fetch_image_cache
from modules.kodi_utils import translate_path
from modules.settings import get_art_provider
# from modules.utils import logger

click_actions = {10: 'close', 11: 'play', 12: 'cancel'}
confirm_actions = {10: True, 11: False}

backup_poster = translate_path('special://home/addons/script.tikiart/resources/media/box_office.png')
default_text_color = 'FF302F2F'
default_highlight_color = 'FFB7B4BB'

class NextEpisode(BaseDialog):
	def __init__(self, *args, **kwargs):
		BaseDialog.__init__(self, args)
		self.closed = False
		self.meta = kwargs.get('meta')
		self.function = kwargs.get('function', 'next_ep')# or 'confirm'
		if self.function == 'next_ep':
			self.actions = click_actions
			self.selected = 'close'
		else:
			self.actions = confirm_actions
			self.selected = False
		self.set_properties()

	def onInit(self):
		Thread(target=self.set_hex_values).start()
		self.monitor()

	def run(self):
		self.doModal()
		return self.selected

	def onAction(self, action):
		if action in self.closing_actions:
			self.closed = True
			self.close()

	def onClick(self, controlID):
		self.closed = True
		self.selected = self.actions[controlID]
		self.close()

	def set_properties(self):
		self.poster_main, self.poster_backup, self.fanart_main, self.fanart_backup = get_art_provider()
		self.setProperty('tikiskins.title', self.meta['title'])
		self.setProperty('tikiskins.poster', self.original_poster())
		self.setProperty('tikiskins.fanart', self.original_fanart())
		self.setProperty('tikiskins.nextep_function', self.function)
		if self.function == 'next_ep':
			self.setProperty('tikiskins.next_episode', '[B]%s - %02dx%02d[/B] - %s' % (self.meta['title'], self.meta['season'], self.meta['episode'], self.meta['ep_name']))
		else:
			self.setProperty('tikiskins.title', self.meta['title'])
		self.setProperty('tikiskins.text_color', default_text_color)
		self.setProperty('tikiskins.maincolor_hex', default_highlight_color)

	def original_poster(self):
		self.poster = self.meta.get(self.poster_main) or self.meta.get(self.poster_backup) or backup_poster
		return self.poster

	def original_fanart(self):
		self.fanart = self.meta.get(self.fanart_main) or self.meta.get(self.fanart_backup) or ''
		return self.fanart

	def monitor(self):
		progress_bar = self.getControl(5000)
		if self.function == 'next_ep':
			total_time = self.player.getTotalTime()
			total_remaining = total_time - self.player.getTime()
			while self.player.isPlaying():
				try:
					if self.closed: break
					current_time = self.player.getTime()
					remaining = round(total_time - current_time)
					current_point = (remaining / float(total_remaining)) * 100
					progress_bar.setPercent(current_point)
					self.sleep(1000)
				except: pass
		else:
			for current_point in range(100, 0, -5):
				try:
					if self.closed: break
					if current_point == 0: break
					progress_bar.setPercent(current_point)
					self.sleep(1000)
				except: pass
		self.close()

	def set_hex_values(self):
		while not self.check_poster_cached(self.poster): sleep(50)
		image_path = translate_path('special://thumbnails/%s' % self.db_cache_image)
		maincolor_hex, bright = ImageColors().run(image_path)
		if not bright: self.setProperty('tikiskins.text_color', default_highlight_color)
		self.setProperty('tikiskins.maincolor_hex', maincolor_hex)

	def check_poster_cached(self, poster):
		self.db_cache_image = fetch_image_cache(poster)
		if self.db_cache_image: return True
		return False
