# -*- coding: utf-8 -*-
import xbmcgui, xbmcplugin
from sys import argv
from threading import Thread
from indexers.tvshows import build_episode
from metadata import tvshow_meta, retrieve_user_info
from modules.indicators_bookmarks import get_watched_info_tv
from modules.in_progress import in_progress_episodes
from modules.kodi_utils import external_browse, setView
from modules.utils import get_datetime, make_thread_list_enumerate
from modules import settings
# from modules.utils import logger

window = xbmcgui.Window(10000)

def build_in_progress_episode():
	def _process_eps(order, item):
		meta = tvshow_meta('tmdb_id', item['tmdb_id'], meta_user_info)
		episode_item = {'season': int(item['season']), 'episode': int(item['episode']), 'meta': meta, 'adjust_hours': adjust_hours, 'current_date': current_date,
						'date_format': date_format, 'watched_indicators': watched_indicators, 'order': order}#, 'resume_point': item['resume_point']}
		result.append(build_episode(episode_item, watched_info, art_keys, use_trakt, meta_user_info, display_title, is_widget))
	__handle__ = int(argv[1])
	result = []
	display_title = settings.single_ep_display_title()
	watched_info, use_trakt = get_watched_info_tv()
	meta_user_info = retrieve_user_info(window)
	adjust_hours = settings.date_offset()
	current_date = get_datetime()
	date_format = settings.single_ep_format()
	is_widget = external_browse()
	watched_indicators = settings.watched_indicators()
	art_keys = settings.get_art_provider()
	window.clearProperty('fen_fanart_error')
	episodes = in_progress_episodes()
	# from apis.trakt_api import trakt_progress_tv
	# episodes = trakt_progress_tv()
	episodes = sorted(episodes, key=lambda k: float(k['resume_point']))
	threads = list(make_thread_list_enumerate(_process_eps, episodes, Thread))
	[i.join() for i in threads]
	result = [i for i in result if i is not None]
	result = sorted(result, key=lambda k: k['order'], reverse=True)
	item_list = [i['listitem'] for i in result]
	xbmcplugin.addDirectoryItems(__handle__, item_list, len(item_list))
	xbmcplugin.setContent(__handle__, 'episodes')
	xbmcplugin.endOfDirectory(__handle__, cacheToDisc=True)
	setView('view.episode_lists', 'episodes')
	