import xbmcplugin, xbmcgui
from sys import argv
try: from urllib import unquote, urlencode, quote
except ImportError: from urllib.parse import unquote, urlencode, quote
from apis.easynews_api import import_easynews
from modules.nav_utils import build_url
from modules.kodi_utils import translate_path, setView, ok_dialog, show_text, local_string as ls
from modules.utils import clean_file_name, to_utf8
# from modules.utils import logger

default_easynews_icon = translate_path('special://home/addons/script.tikiart/resources/media/easynews.png')
fanart = translate_path('special://home/addons/plugin.video.fen/fanart.png')
dialog = xbmcgui.Dialog()

EasyNews = import_easynews()

def search_easynews(params):
	from modules.history import add_to_search_history
	__handle__ = int(argv[1])
	default = params.get('suggestion', '')
	search_title = clean_file_name(params.get('query')) if ('query' in params and params.get('query') != 'NA') else None
	if not search_title: search_title = dialog.input('Enter search Term', type=xbmcgui.INPUT_ALPHANUM, defaultt=default)
	if not search_title: return
	try:
		search_name = clean_file_name(unquote(search_title))
		add_to_search_history(search_name, 'easynews_video_queries')
		files = EasyNews.search(search_name)
		if not files: return ok_dialog(text=32760, top_space=True)
		easynews_file_browser(files, __handle__)
	except: pass
	xbmcplugin.setContent(__handle__, 'files')
	xbmcplugin.endOfDirectory(__handle__, cacheToDisc=False)
	setView('view.premium')

def easynews_file_browser(files, __handle__):
	down_str = ls(32747)
	files.sort(key=lambda k: k['name'])
	for count, item in enumerate(files, 1):
		try:
			cm = []
			name = clean_file_name(item['name']).upper()
			url_dl = item['url_dl']
			size = str(round(float(int(item['rawSize']))/1048576000, 1))
			display = '%02d | [B]%s GB[/B] | [I]%s [/I]' % (count, size, name)
			url_params = {'mode': 'easynews.resolve_easynews', 'url_dl': url_dl, 'play': 'true'}
			url = build_url(url_params)
			down_file_params = {'mode': 'downloader', 'name': item['name'], 'url': url_dl, 'action': 'cloud.easynews_direct', 'image': default_easynews_icon}
			cm.append((down_str,'RunPlugin(%s)' % build_url(down_file_params)))
			listitem = xbmcgui.ListItem(display)
			listitem.addContextMenuItems(cm)
			listitem.setArt({'icon': default_easynews_icon, 'poster': default_easynews_icon, 'thumb': default_easynews_icon, 'fanart': fanart, 'banner': default_easynews_icon})
			xbmcplugin.addDirectoryItem(__handle__, url, listitem, isFolder=False)
		except: pass

def resolve_easynews(params):
	url_dl = params['url_dl']
	resolved_link = EasyNews.resolve_easynews(url_dl)
	if params.get('play', 'false') != 'true' : return resolved_link
	from modules.player import FenPlayer
	FenPlayer().run(resolved_link, 'video')

def account_info(params):
	from datetime import datetime
	from modules.utils import jsondate_to_datetime
	try:
		account_info, usage_info = EasyNews.account()
		if not account_info or not usage_info:
			return ok_dialog(text=32574, top_space=True)
		expires = jsondate_to_datetime(to_utf8(account_info[2]), '%Y-%m-%d')
		days_remaining = (expires - datetime.today()).days
		body = []
		append = body.append
		append(ls(32757) % to_utf8(account_info[1]))
		append(ls(32755) % to_utf8(account_info[0]))
		append('[B]%s:[/B] %s' % (ls(32630), to_utf8(account_info[3])))
		append(ls(32750) % expires)
		append(ls(32751) % days_remaining)
		append('%s %s' % (ls(32772), to_utf8(usage_info[2]).replace('years', ls(32472))))
		append(ls(32761) % to_utf8(usage_info[0]).replace('Gigs', 'GB'))
		append(ls(32762) % to_utf8(usage_info[1]).replace('Gigs', 'GB'))
		return show_text('easynews', '\n\n'.join(body), font_size='large')
	except Exception as e:
		line = '%s[CR]%s[CR]%s'
		return ok_dialog(text=line % ('', ls(32574), str(e)), top_space=True)
