# -*- coding: utf-8 -*-
import xbmcgui, xbmcplugin
import json
from sys import argv
from apis.imdb_api import imdb_user_lists, imdb_keyword_search
from modules.nav_utils import build_url
from modules.kodi_utils import translate_path, setView, local_string as ls
# from modules.utils import logger

default_imdb_icon = translate_path('special://home/addons/script.tikiart/resources/media/imdb.png')
fanart = translate_path('special://home/addons/plugin.video.fen/fanart.png')

def imdb_build_user_lists(db_type):
	__handle__ = int(argv[1])
	user_lists = imdb_user_lists(db_type)
	mode = 'build_movie_list' if db_type == 'movies' else 'build_tvshow_list'
	for item in user_lists:
		cm = []
		cm_append = cm.append
		url_params = {'mode': mode, 'action': 'imdb_user_list_contents', 'list_id': item['list_id']}
		imdb_selection_url = {'mode': 'navigator.adjust_main_lists', 'method': 'add_imdb_external', 'name': item['title'], 'imdb_params': json.dumps(url_params)}
		imdb_folder_selection_url = {'mode': 'navigator.adjust_shortcut_folder_lists', 'method': 'add_imdb_external', 'name': item['title'], 'imdb_params': json.dumps(url_params)}
		url = build_url(url_params)
		listitem = xbmcgui.ListItem(item['title'])
		listitem.setArt({'icon': default_imdb_icon, 'poster': default_imdb_icon, 'thumb': default_imdb_icon, 'fanart': fanart, 'banner': default_imdb_icon})
		cm_append((ls(32730),'RunPlugin(%s)' % build_url(imdb_selection_url)))
		cm_append((ls(32731),'RunPlugin(%s)' % build_url(imdb_folder_selection_url)))
		listitem.addContextMenuItems(cm)
		xbmcplugin.addDirectoryItem(__handle__, url, listitem, isFolder=True)
	xbmcplugin.setContent(__handle__, 'files')
	xbmcplugin.endOfDirectory(__handle__, cacheToDisc=False)
	setView('view.main')

def imdb_build_keyword_results(db_type, query):
	__handle__ = int(argv[1])
	results = imdb_keyword_search(query)
	if not results: return
	mode = 'build_%s_list' % db_type
	for count, item in enumerate(results, 1):
		cm = []
		cm_append = cm.append
		keyword = item[0]
		listings = item[1]
		url_params = {'mode': mode, 'action': 'imdb_keywords_list_contents', 'list_id': keyword.lower(), 'iconImage': 'imdb.png'}
		url_json = json.dumps(url_params)
		add_list_params = {'mode': 'navigator.adjust_main_lists', 'method': 'add_external', 'list_name': '%s (IMDb)' % keyword, 'menu_item': url_json}
		add_folder_params = {'mode': 'navigator.adjust_shortcut_folder_lists', 'method': 'add_external', 'name': '%s (IMDb)' % keyword, 'menu_item': url_json}
		url = build_url(url_params)
		listitem = xbmcgui.ListItem('%02d | [B]%s[/B] [I]%s[/I]' % (count, keyword.upper(), listings))
		listitem.setArt({'icon': default_imdb_icon, 'poster': default_imdb_icon, 'thumb': default_imdb_icon, 'fanart': fanart, 'banner': default_imdb_icon})
		cm_append((ls(32730),'RunPlugin(%s)' % build_url(add_list_params)))
		cm_append((ls(32731),'RunPlugin(%s)' % build_url(add_folder_params)))
		listitem.addContextMenuItems(cm)
		xbmcplugin.addDirectoryItem(__handle__, url, listitem, isFolder=True)
	xbmcplugin.setContent(__handle__, 'files')
	xbmcplugin.endOfDirectory(__handle__, cacheToDisc=False)
	setView('view.main')




