# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin, xbmcvfs
import os
from sys import argv
try: from urllib import urlencode
except ImportError: from urllib.parse import urlencode
from modules import kodi_utils
from modules.utils import to_utf8
from modules.settings_reader import get_setting, set_setting
# from modules.utils import logger

ls = kodi_utils.local_string

def build_navigate_to_page(params):
	import json
	from modules.settings import nav_jump_use_alphabet
	use_alphabet = nav_jump_use_alphabet()
	invoker_on = get_setting('reuse_language_invoker') == 'true'
	icon = kodi_utils.translate_path('special://home/addons/script.tikiart/resources/media/item_jump.png')
	fanart = kodi_utils.translate_path('special://home/addons/plugin.video.fen/fanart.png')
	db_type = params.get('db_type')
	def _builder(use_alphabet):
		for i in start_list:
			if use_alphabet: line1, line2 = i.upper(), ls(32821) % (db_type, i.upper())
			else: line1, line2 = '%s %s' % (ls(32022), i), ls(32822) % i
			yield {'line1': line1, 'line2': line2, 'icon': icon}
	if use_alphabet:
		start_list = [chr(i) for i in range(97,123)]
	else:
		start_list = [str(i) for i in range(1, int(params.get('total_pages'))+1)]
		start_list.remove(params.get('current_page'))
	list_items = list(_builder(use_alphabet))
	kwargs = {'items': json.dumps(list_items), 'heading': 'Fen', 'enumerate': 'false', 'multi_choice': 'false', 'multi_line': 'false'}
	new_start = kodi_utils.select_dialog(start_list, **kwargs)
	kodi_utils.sleep(100)
	if new_start == None: return
	if use_alphabet: new_page, new_letter = '', new_start
	else: new_page, new_letter = new_start, None
	url_params = {'mode': params.get('transfer_mode', ''),
					'action': params.get('transfer_action', ''),
					'new_page': new_page,
					'new_letter': new_letter,
					'media_type': params.get('media_type', ''),
					'query': params.get('query', ''),
					'actor_id': params.get('actor_id', ''),
					'user': params.get('user', ''),
					'slug': params.get('slug', ''),
					'final_params': params.get('final_params', '')}
	if not invoker_on:
		kodi_utils.sleep(1500)
		url_params = {'mode': 'container_update', 'final_params': json.dumps(url_params)}
	kodi_utils.execute_builtin('Container.Update(%s)' % build_url(url_params))

def paginate_list(item_list, page, letter, limit=20):
	from modules.utils import chunks
	def _get_start_index(letter):
		if letter == 't':
			try:
				beginswith_tuple = ('s', 'the s', 'a s', 'an s')
				indexes = [i for i,v in enumerate(title_list) if v.startswith(beginswith_tuple)]
				start_index = indexes[-1:][0] + 1
			except: start_index = None
		else:
			beginswith_tuple = (letter, 'the %s' % letter, 'a %s' % letter, 'an %s' % letter)
			try: start_index = next(i for i,v in enumerate(title_list) if v.startswith(beginswith_tuple))
			except: start_index = None
		return start_index
	if letter != 'None':
		from itertools import chain
		try: from itertools import zip_longest
		except ImportError: from itertools import izip_longest as zip_longest
		title_list = [i['title'].lower() for i in item_list]
		start_list = [chr(i) for i in range(97,123)]
		letter_index = start_list.index(letter)
		base_list = [element for element in list(chain.from_iterable([val for val in zip_longest(start_list[letter_index:], start_list[:letter_index][::-1])])) if element != None]
		for i in base_list:
			start_index = _get_start_index(i)
			if start_index: break
		item_list = item_list[start_index:]
	pages = list(chunks(item_list, limit))
	total_pages = len(pages)
	return pages[page - 1], total_pages

def toggle_jump_to():
	from modules.settings import nav_jump_use_alphabet
	(setting, new_action) = ('0', ls(32022)) if nav_jump_use_alphabet() else ('1', ls(32023))
	set_setting('nav_jump', setting)
	kodi_utils.execute_builtin('Container.Refresh')
	kodi_utils.notification(ls(32851) % new_action)

def volume_checker():
	"""
	0% == -60db, 100% == 0db
	"""
	try:
		if get_setting('volumecheck.enabled', 'false') == 'false': return
		if xbmc.getCondVisibility('Player.Muted'): return
		from modules.utils import string_alphanum_to_num
		max_volume = int(min(int(get_setting('volumecheck.percent', '100')), 100))
		current_volume_db = int(string_alphanum_to_num(xbmc.getInfoLabel('Player.Volume').split('.')[0]))
		current_volume_percent = int(100 - ((float(current_volume_db)/60)*100))
		if current_volume_percent > max_volume: kodi_utils.execute_builtin('SetVolume(%d)' % int(max_volume))
	except: pass

def get_search_term(params):
	kodi_utils.close_all_dialog()
	db_type = params.get('db_type', '')
	query = params.get('query')
	search_type = params.get('search_type', 'media_title')
	if not query:
		try: from urllib import unquote
		except ImportError: from urllib.parse import unquote
		query = xbmcgui.Dialog().input('Fen')
		if not query: return
		query = unquote(query)
	if search_type == 'media_title':
		(mode, action) = ('build_movie_list', 'tmdb_movies_search') if db_type == 'movie' else ('build_tvshow_list', 'tmdb_tv_search')
		url = {'mode': mode, 'action': action, 'query': query}
	elif search_type == 'imdb_keyword':
		url = {'mode': 'imdb_build_keyword_results', 'db_type': db_type, 'query': query}
	if kodi_utils.external_browse(): return kodi_utils.execute_builtin('ActivateWindow(10025,%s,return)' % build_url(url))
	return kodi_utils.execute_builtin('Container.Update(%s)' % build_url(url))



def focus_index(index):
	kodi_utils.sleep(100)
	current_window = xbmcgui.Window(xbmcgui.getCurrentWindowId())
	focus_id = current_window.getFocusId()
	try: current_window.getControl(focus_id).selectItem(index)
	except: pass

def open_settings(query, addon='plugin.video.fen'):
	kodi_utils.sleep(250)
	if query:
		try:
			kodi_version = kodi_utils.get_kodi_version()
			button = -100 if kodi_version <= 17 else 100
			control = -200 if kodi_version <= 17 else 80
			kodi_utils.hide_busy_dialog()
			menu, function = query.split('.')
			kodi_utils.execute_builtin('Addon.OpenSettings(%s)' % addon)
			kodi_utils.execute_builtin('SetFocus(%i)' % (int(menu) - button))
			kodi_utils.execute_builtin('SetFocus(%i)' % (int(function) - control))
		except: kodi_utils.execute_builtin('Addon.OpenSettings(%s)' % addon)
	else: kodi_utils.execute_builtin('Addon.OpenSettings(%s)' % addon)

def build_url(url_params):
	try: url = 'plugin://plugin.video.fen/?' + urlencode(url_params)
	except: url = 'plugin://plugin.video.fen/?' + urlencode(to_utf8(url_params))
	return url

def add_dir(url_params, list_name, iconImage='DefaultFolder.png', fanartImage=None, isFolder=True):
	if not fanartImage: fanartImage = kodi_utils.translate_path('special://home/addons/plugin.video.fen/fanart.png')
	icon = kodi_utils.translate_path('special://home/addons/script.tikiart/resources/media/%s' % iconImage)
	url = build_url(url_params)
	listitem = xbmcgui.ListItem(list_name)
	listitem.setArt({'icon': icon, 'poster': icon, 'thumb': icon, 'fanart': fanartImage, 'banner': icon})
	xbmcplugin.addDirectoryItem(handle=int(argv[1]), url=url, listitem=listitem, isFolder=isFolder)

def link_folders(service, folder_name, action):
	import json
	from caches import fen_cache
	def _get_media_type():
		media_type_list = [('movie', ls(32028), 'movies.png'), ('tvshow', ls(32029), 'tv.png')]
		list_items = [{'line1': item[1], 'line2': ls(32693) % item[1], 'icon': os.path.join(theme_folder, item[2])} for item in media_type_list]
		kwargs = {'items': json.dumps(list_items), 'heading': 'Fen', 'enumerate': 'false', 'multi_choice': 'false', 'multi_line': 'true'}
		chosen_media_type = kodi_utils.select_dialog([i[0] for i in media_type_list], **kwargs)
		return chosen_media_type
	theme_folder = kodi_utils.translate_path('special://home/addons/script.tikiart/resources/media')
	dialog = xbmcgui.Dialog()
	_cache = fen_cache.FenCache()
	string = 'FEN_%s_%s' % (service, folder_name)
	current_link = _cache.get(string)
	if action == 'remove':
		if not current_link: return
		if not kodi_utils.confirm_dialog(text=ls(32694) % current_link, top_space=True): return
		try: from sqlite3 import dbapi2 as database
		except ImportError: from pysqlite2 import dbapi2 as database
		cache_file = kodi_utils.translate_path('special://profile/addon_data/plugin.video.fen/fen_cache2.db')
		dbcon = database.connect(cache_file)
		dbcur = dbcon.cursor()
		dbcur.execute("DELETE FROM fencache WHERE id=?", (string,))
		dbcon.commit()
		dbcon.close()
		xbmcgui.Window(10000).clearProperty(string)
		if service == 'FOLDER':
			clear_cache('folder_scraper', silent=True)
		kodi_utils.execute_builtin('Container.Refresh')
		return kodi_utils.ok_dialog(text=32576, top_space=True)
	if current_link:
		line = '%s[CR]%s[CR]%s'
		if not kodi_utils.confirm_dialog(text=line % (ls(32695), '[B]%s[/B]' % current_link, ls(32696))): return
	media_type = _get_media_type()
	if media_type == None: return
	title = dialog.input(ls(32228)).lower()
	if not title: return
	from apis.tmdb_api import tmdb_movies_title_year, tmdb_tv_title_year
	year = dialog.input('%s (%s)' % (ls(32543), ls(32669)), type=xbmcgui.INPUT_NUMERIC)
	function = tmdb_movies_title_year if media_type == 'movie' else tmdb_tv_title_year
	results = function(title, year)['results']
	if len(results) == 0: return kodi_utils.ok_dialog(text=32490, top_space=True)
	name_key = 'title' if media_type == 'movie' else 'name'
	released_key = 'release_date' if media_type == 'movie' else 'first_air_date'
	function_list = []
	append = function_list.append
	def _builder():
		for item in results:
			title = item[name_key]
			try: year = item[released_key].split('-')[0]
			except: year = ''
			if year: rootname = '%s (%s)' % (title, year)
			else: rootname = title
			icon = 'https://image.tmdb.org/t/p/w780%s' % item['poster_path'] if item.get('poster_path') \
																			else kodi_utils.translate_path('special://home/addons/plugin.video.fen/icon.png')
			append(rootname)
			yield {'line1': rootname, 'line2': item['overview'], 'icon': icon}
	list_items = list(_builder())
	kwargs = {'items': json.dumps(list_items), 'heading': 'Fen', 'enumerate': 'false', 'multi_choice': 'false', 'multi_line': 'true'}
	rootname = kodi_utils.select_dialog(function_list, **kwargs)
	if rootname == None: return
	from datetime import timedelta
	_cache.set(string, rootname, expiration=timedelta(days=365))
	if service == 'FOLDER':
		clear_cache('folder_scraper', silent=True)
	kodi_utils.execute_builtin('Container.Refresh')
	return kodi_utils.ok_dialog(text=32576, top_space=True)

def clean_settings():
	import xbmcaddon
	import xml.etree.ElementTree as ET
	from modules import py_tools
	def _make_content(dict_object):
		if kodi_version >= 18:
			content = '<settings version="2">'
			for item in dict_object:
				if item['id'] in active_settings:
					if 'default' in item and 'value' in item: content += '\n    <setting id="%s" default="%s">%s</setting>' % (item['id'], item['default'], item['value'])
					elif 'default' in item: content += '\n    <setting id="%s" default="%s"></setting>' % (item['id'], item['default'])
					elif 'value' in item: content += '\n    <setting id="%s">%s</setting>' % (item['id'], item['value'])
					else: content += '\n    <setting id="%s"></setting>'
				else: removed_append(item)
		else:
			content = '<settings>'
			for item in dict_object:
				if item['id'] in active_settings:
					if 'value' in item: content += '\n    <setting id="%s" value="%s" />' % (item['id'], item['value'])
					else: content += '\n    <setting id="%s" value="" />' % item['id']
				else: removed_append(item)
		content += '\n</settings>'
		return content
	kodi_utils.close_all_dialog()
	kodi_utils.sleep(200)
	line = '%s[CR]%s[CR]%s'
	progressDialog = xbmcgui.DialogProgress()
	progressDialog.create(ls(32577), line % ('', '', ''))
	progressDialog.update(0, line % ('  ', '', ''))
	kodi_version = kodi_utils.get_kodi_version()
	addon_ids = ['plugin.video.fen', 'script.module.fenomscrapers', 'script.module.myaccounts']
	addon_names = [xbmcaddon.Addon(id=i).getAddonInfo('name') for i in addon_ids]
	addon_dirs = [kodi_utils.translate_path(xbmcaddon.Addon(id=i).getAddonInfo('path')) for i in addon_ids]
	profile_dirs = [kodi_utils.translate_path(xbmcaddon.Addon(id=i).getAddonInfo('profile')) for i in addon_ids]
	active_settings_xmls = [os.path.join(kodi_utils.translate_path(xbmcaddon.Addon(id=i).getAddonInfo('path')), 'resources', 'settings.xml') for i in addon_ids]
	if py_tools.isPY3: params = list(zip(addon_names, profile_dirs, active_settings_xmls))
	else: params = zip(addon_names, profile_dirs, active_settings_xmls)
	for addon in params:
		try:
			try:
				if progressDialog.iscanceled(): break
			except Exception: pass
			current_progress = params.index(addon)+1
			removed_settings = []
			active_settings = []
			current_user_settings = []
			removed_append = removed_settings.append
			active_append = active_settings.append
			current_append = current_user_settings.append
			root = ET.parse(addon[2]).getroot()
			for item in root.findall('./category/setting'):
				setting_id = item.get('id')
				if setting_id:
					active_append(setting_id)
			settings_xml = os.path.join(addon[1], 'settings.xml')
			root = ET.parse(settings_xml).getroot()
			for item in root:
				dict_item = {}
				setting_id = item.get('id')
				setting_default = item.get('default')
				if kodi_version >= 18: setting_value = item.text
				else: setting_value = item.get('value')
				dict_item['id'] = setting_id
				if setting_value: dict_item['value'] = setting_value
				if setting_default: dict_item['default'] = setting_default
				current_append(dict_item)
			new_content = _make_content(current_user_settings)
			xml_file = xbmcvfs.File(settings_xml, 'w')
			xml_file.write(new_content)
			xml_file.close()
			percent = int((current_progress/float(len(params)))*100)
			line2 = ls(32812) % addon[0]
			line3 = ls(32813) % len(removed_settings)
			progressDialog.update(percent, line % ('', line2, line3))
		except:
			kodi_utils.notification(32574, 2000)
		kodi_utils.sleep(800)
	try:
		progressDialog.close()
	except Exception:
		pass
	kodi_utils.ok_dialog(text=32576, top_space=True)

def clear_settings_window_properties():
	xbmcgui.Window(10000).clearProperty('fen_settings')
	kodi_utils.notification(32576, 2500)

def open_MyAccounts(params):
	from myaccounts import openMASettings
	query = params.get('query', None)
	openMASettings(query)
	kodi_utils.sleep(100)
	while xbmc.getCondVisibility('Window.IsVisible(addonsettings)') or xbmcgui.Window(10000).getProperty('myaccounts.active') == 'true':
		kodi_utils.sleep(250)
	kodi_utils.sleep(100)
	sync_MyAccounts()
	kodi_utils.sleep(100)
	open_settings('1.0')

def sync_MyAccounts(silent=False):
	import myaccounts
	from modules.settings import ext_addon
	from modules.settings_reader import get_setting, set_setting
	all_acct = myaccounts.getAll()
	try:
		trakt_acct = all_acct.get('trakt')
		if trakt_acct.get('username') not in ('', None) and get_setting('trakt_user') != trakt_acct.get('username'):
				set_setting('trakt_indicators_active', 'true')
				set_setting('watched_indicators', '1')
		set_setting('trakt_user', trakt_acct.get('username'))
	except: pass
	try:
		fu_acct = all_acct.get('furk')
		set_setting('furk_login', fu_acct.get('username'))
		set_setting('furk_password', fu_acct.get('password'))
		if fu_acct.get('api_key') != '': set_setting('furk_api_key', fu_acct.get('api_key'))
		elif get_setting('furk_api_key') != '': ext_addon('script.module.myaccounts').setSetting('furk.api.key', get_setting('furk_api_key'))
	except: pass
	try:
		en_acct = all_acct.get('easyNews')
		set_setting('easynews_user', en_acct.get('username'))
		set_setting('easynews_password', en_acct.get('password'))
	except: pass
	try:
		tmdb_acct = all_acct.get('tmdb')
		tmdb_key = tmdb_acct.get('api_key')
		if not tmdb_key: tmdb_key = '050ee5c6c85883b200be501c878a2aed'
		set_setting('tmdb_api', tmdb_key)
	except: pass
	try:
		fanart_acct = all_acct.get('fanart_tv')
		fanart_key = fanart_acct.get('api_key')
		if not fanart_key: fanart_key = 'fe073550acf157bdb8a4217f215c0882'
		set_setting('fanart_client_key', fanart_key)
	except: pass
	try:
		imdb_acct = all_acct.get('imdb')
		set_setting('imdb_user', imdb_acct.get('user'))
	except: pass
	try:
		rd_acct = all_acct.get('realdebrid')
		if get_setting('rd.username') != rd_acct.get('username'):
			set_setting('rd.username', rd_acct.get('username'))
			set_setting('rd.client_id', rd_acct.get('client_id'))
			set_setting('rd.refresh', rd_acct.get('refresh'))
			set_setting('rd.secret', rd_acct.get('secret'))
			set_setting('rd.token', rd_acct.get('token'))
			set_setting('rd.auth', rd_acct.get('token'))
	except: pass
	try:
		pm_acct = all_acct.get('premiumize')
		set_setting('pm.token', pm_acct.get('token'))
		if get_setting('pm.account_id') != pm_acct.get('username'):
			set_setting('pm.account_id', pm_acct.get('username'))
	except: pass
	try:
		ad_acct = all_acct.get('alldebrid')
		set_setting('ad.token', ad_acct.get('token'))
		if get_setting('ad.account_id') != ad_acct.get('username'):
			set_setting('ad.account_id', ad_acct.get('username'))
	except: pass
	if not silent: kodi_utils.notification(33030, time=1500)

def toggle_language_invoker():
	import xml.etree.ElementTree as ET
	from modules.utils import gen_file_hash
	kodi_utils.close_all_dialog()
	kodi_utils.sleep(100)
	dialog = xbmcgui.Dialog()
	addon_dir = kodi_utils.translate_path('special://home/addons/plugin.video.fen')
	addon_xml = os.path.join(addon_dir, 'addon.xml')
	tree = ET.parse(addon_xml)
	root = tree.getroot()
	try: current_value = [str(i.text) for i in root.iter('reuselanguageinvoker')][0]
	except: return
	current_setting = get_setting('reuse_language_invoker')
	new_value = 'false' if current_value == 'true' else 'true'
	if not kodi_utils.confirm_dialog(text=ls(33018) % (current_value.upper(), new_value.upper())): return
	if new_value == 'true':
		if not kodi_utils.confirm_dialog(text=33019, top_space=True): return
	for item in root.iter('reuselanguageinvoker'):
		item.text = new_value
		hash_start = gen_file_hash(addon_xml)
		tree.write(addon_xml)
		hash_end = gen_file_hash(addon_xml)
		if hash_start != hash_end:
			set_setting('reuse_language_invoker', new_value)
		else: return kodi_utils.ok_dialog(text=32574, top_space=True)
	kodi_utils.ok_dialog(text=33020, top_space=True)
	kodi_utils.execute_builtin('LoadProfile(%s)' % xbmc.getInfoLabel('system.profilename'))

def remove_meta_keys(dict_item, db_type):
	if db_type == 'movie':
		remove = ('fanart_added', 'cast', 'poster', 'rootname', 'imdb_id', 'tmdb_id', 'tvdb_id', 'all_trailers',
				'fanart', 'banner', 'clearlogo', 'clearart', 'landscape', 'discart', 'original_title', 'extra_info',
				'alternative_titles', 'country_codes', 'fanarttv_fanart', 'fanarttv_poster', 'fanart2', 'poster2')
	elif db_type == 'tvshow':
		remove = ('fanart_added', 'cast', 'poster', 'rootname', 'imdb_id', 'tmdb_id', 'tvdb_id', 'all_trailers', 'discart',
				'total_episodes', 'total_seasons', 'total_watched', 'total_unwatched', 'fanart', 'banner', 'clearlogo',
				'clearart', 'landscape', 'season_data', 'original_title', 'extra_info', 'alternative_titles', 'season_summary',
				'country_codes', 'fanarttv_fanart', 'fanarttv_poster', 'total_aired_eps', 'fanart2', 'poster2')
	else:# episode
		remove = ('thumb', 'guest_stars')
	for k in remove: dict_item.pop(k, None)
	return dict_item

def refresh_cached_data(db_type, id_type, media_id, from_list=False):
	from caches.meta_cache import metacache
	try:
		metacache.delete(db_type, id_type, media_id)
		if db_type == 'tvshow':
			metacache.delete_all_seasons_memory_cache(media_id)
		if from_list: return True
		kodi_utils.notification(32576)
		kodi_utils.execute_builtin('Container.Refresh')
	except:
		if from_list: return False
		kodi_utils.notification(32574, 4500)

def clear_cache(cache_type, silent=False):
	profile_dir = kodi_utils.translate_path('special://profile/addon_data/plugin.video.fen/')
	if cache_type == 'meta':
		from caches.meta_cache import delete_meta_cache
		if not delete_meta_cache(silent=silent): return
	elif cache_type == 'internal_scrapers':
		if not silent:
			if not kodi_utils.confirm_dialog(): return
		from apis import furk_api
		from apis import easynews_api
		furk_api.clear_media_results_database()
		easynews_api.clear_media_results_database()
		for item in ('pm_cloud', 'rd_cloud', 'ad_cloud', 'folder_scraper'): clear_cache(item, silent=True)
	elif cache_type == 'external_scrapers':
		from caches.providers_cache import providerCache
		from caches.debrid_cache import DebridCache
		data = providerCache.delete_cache(silent=silent)
		debrid_cache = DebridCache().clear_database()
		if not (data, debrid_cache) == ('success', 'success'): return
	elif cache_type == 'trakt':
		from caches.trakt_cache import clear_all_trakt_cache_data
		if not clear_all_trakt_cache_data(silent=silent): return
	elif cache_type == 'imdb':
		if not silent:
			if not kodi_utils.confirm_dialog(): return
		from apis.imdb_api import clear_imdb_cache
		if not clear_imdb_cache(): return
	elif cache_type == 'pm_cloud':
		if not silent:
			if not kodi_utils.confirm_dialog(): return
		from apis.premiumize_api import PremiumizeAPI
		if not PremiumizeAPI().clear_cache(): return
	elif cache_type == 'rd_cloud':
		if not silent:
			if not kodi_utils.confirm_dialog(): return
		from apis.real_debrid_api import RealDebridAPI
		if not RealDebridAPI().clear_cache(): return
	elif cache_type == 'ad_cloud':
		if not silent:
			if not kodi_utils.confirm_dialog(): return
		from apis.alldebrid_api import AllDebridAPI
		if not AllDebridAPI().clear_cache(): return
	elif cache_type == 'folder_scraper':
		from caches.fen_cache import FenCache
		FenCache().delete_all_folderscrapers()
	else: # 'list'
		if not silent:
			if not kodi_utils.confirm_dialog(): return
		from caches.fen_cache import FenCache
		FenCache().delete_all_lists()
	if not silent: kodi_utils.notification(32576)

def clear_all_cache():
	if not kodi_utils.confirm_dialog(): return
	line = '%s[CR]%s[CR]%s'
	progress_dialog = xbmcgui.DialogProgress()
	progress_dialog.create('Fen', '')
	caches = [('meta', '%s %s' % (ls(32527), ls(32524))), ('internal_scrapers', '%s %s' % (ls(32096), ls(32524))), ('external_scrapers', '%s %s' % (ls(32118), ls(32524))),
			('trakt', ls(32087)), ('imdb', '%s %s' % (ls(32064), ls(32524))), ('list', '%s %s' % (ls(32815), ls(32524))),
			('pm_cloud', '%s %s' % (ls(32061), ls(32524))), ('rd_cloud', '%s %s' % (ls(32054), ls(32524))), ('ad_cloud', '%s %s' % (ls(32063), ls(32524)))]
	for count, cache_type in enumerate(caches, 1):
		progress_dialog.update(int(float(count) / float(len(caches)) * 100), line % ('', '%s....' % ls(32816), cache_type[1]))
		clear_cache(cache_type[0], silent=True)
		kodi_utils.sleep(400)
	progress_dialog.close()
	kodi_utils.sleep(250)
	kodi_utils.ok_dialog(text=32576, top_space=True)

def refresh_icon():
	try: from sqlite3 import dbapi2 as database
	except ImportError: from pysqlite2 import dbapi2 as database
	try:
		icon_path = kodi_utils.translate_path('special://home/addons/plugin.video.fen/icon.png')
		thumbs_folder = kodi_utils.translate_path('special://thumbnails')
		TEXTURE_DB = kodi_utils.translate_path('special://database/Textures13.db')
		dbcon = database.connect(TEXTURE_DB)
		dbcur = dbcon.cursor()
		dbcur.execute("SELECT cachedurl FROM texture WHERE url = ?", (icon_path,))
		image = dbcur.fetchone()[0]
		dbcon.close()
		removal_path = os.path.join(thumbs_folder, image)
		if kodi_utils.confirm_dialog():
			xbmcvfs.delete(removal_path)
			kodi_utils.sleep(200)
			kodi_utils.execute_builtin('ReloadSkin()')
			kodi_utils.sleep(500)
			notice = 32576
		else: return
	except:
		notice = 32574
	kodi_utils.notification(notice)
