# -*- coding: utf-8 -*-
import xbmc, xbmcvfs, xbmcgui
import os
import re
import json
try: from urlparse import urlparse
except ImportError: from urllib.parse import urlparse
try: from urllib import unquote, unquote_plus
except ImportError: from urllib.parse import unquote, unquote_plus
from fenomscrapers import pack_sources
from fenomscrapers.modules.control import setting as fenom_getSetting, setSetting as fenom_setSetting
from modules import kodi_utils
from modules.utils import replace_html_codes
from modules.settings import date_offset
# from modules.utils import logger

source_folder_location = 'special://home/addons/script.module.fenomscrapers/lib/fenomscrapers/sources_fenomscrapers/%s'
source_subfolders = ('hosters', 'torrents')
source_path = 'fenomscrapers.sources_fenomscrapers.%s.%s'
window = xbmcgui.Window(10000)

RES_4K = [' 4k ', ' hd4k ', ' 4khd ', ' uhd ', ' ultrahd ', ' ultra hd ', ' 2160 ', ' 2160p ', ' hd2160 ', ' 2160hd ']
RES_1080 = [' 1080 ', ' 1080p ', ' 1080i ', ' hd1080 ', ' 1080hd ', ' hd1080p ', ' m1080p ', ' fullhd ', ' full hd ', ' 1o8o ', ' 1o8op ']
RES_720 = [' 720 ', ' 720p ', ' 720i ', ' hd720 ', ' 720hd ', ' hd720p ', ' hd ', ' 72o ', ' 72op ']
CAM = [' cam ', ' camrip ', ' hdcam ', ' hd cam ', ' cam rip ', ' dvdcam ']
SCR = [' scr ', ' screener ', ' dvdscr ', ' dvd scr ', ' r5 ', ' r6 ']
TELE = [' tc ', ' tsrip ', ' hdts ', ' hdtc ', ' dvdts ', ' telesync ', ' ts ']
HEVC = [' hevc ', ' h265 ', ' h 265 ', ' x265 ', ' x 265 ', ' dv ', ' dolby vision ', ' dolbyvision ', ' hdr ', ' hdr10 ', ' 2160p remux ']
BLURAY = [' bluray ', ' blu ray ']
BDRIP = [' bdr ', ' bd r ', ' bdrip ', ' bd rip ', ' br rip ', ' brrip ']
REMUX = [' remux ', ' bdremux ', ' bd remux ']
DVDRIP = [' dvdrip ', ' dvd rip ']
DVD = [' dvd ', ' dvdr ', ' dvd r ']
WEB = [' webdl ', ' web dl ', ' web ', ' webrip ', ' web rip ', ' webhd ', ' web hd ']
HDRIP = [' hdrip ', ' hd rip ']
UHDRIP = [' uhdrip ', ' uhd rip ']
HDR = [' hdr ', ' hdr10 ', ' hdr 10 ', ' dolbyvision ', ' dolby vision ', ' hlg ', ' 2160p bluray remux ', ' uhd bluray 2160p ',
		' 2160p uhd bluray ', ' 2160p bluray hevc truehd ', ' 2160p remux ', ' 2160p bluray hevc dts hd ma ']
AC3 = [' ac3 ', ' ac 3 ', ' ac3d ']
DD = [' dd ', ' dolby ', ' dolbydigital ', ' dolby digital ']
TRUEHD = [' truehd ', ' true hd ']
DDPLUS = [' ddplus ', ' dd plus ', ' ddp ', ' eac3 ', ' eac 3 ']
HDMA = [' hdma ', ' hd ma ']
HDHRA = [' hdhra ', ' hd hra ']
DV = [' dv ', ' dolby vision ', ' dolbyvision ']
DTSX = [' dtsx ', ' dts x ']
DD51 = [' dd5 1 ', ' dd5 1ch ', ' dd5 1 ch ']
DDP51 = [' ddp5 1 ', ' ddp5 1ch ', ' ddp5 1 ch ']
D51 = [' 5 1 ', ' 5 1ch ', ' 5 1 ch ', ' 6ch ', ' 6 ch ']
D71 = [' 7 1 ', ' 7 1ch ', ' 7 1 ch ', ' 8ch ', ' 8 ch ']
SUBS = [' subs ', ' subbed ', ' sub ', ' korsub ']
DUB = [' dub ', ' dubbed ', ' dublado ']

def sources(ignore_disabled):
	def import_info():
		for item in source_subfolders:
			files = xbmcvfs.listdir(kodi_utils.translate_path(source_folder_location % item))[1]
			for m in files:
				try:
					m_split = m.split('.')
					if m_split[1] == 'pyo': continue
					module_name = m_split[0]
					if module_name == '__init__': continue
					if not ignore_disabled and not enabledScraper(module_name): continue
					module_path = source_path % (item, module_name)
					yield (module_name, module_path, '')
				except: pass
	try: sourceDict = list(import_info())
	except: sourceDict = []
	return sourceDict

def enabledScraper(module_name):
	return fenom_getSetting('provider.%s' % module_name) == 'true'

def packSources():
	return pack_sources()

def internal_results(provider, sources):
	window.setProperty('%s.internal_results' % provider, json.dumps(sources))

def normalize(title):
	try:
		try: return title.decode('ascii').encode('utf-8')
		except: pass
		try: import unicodedata
		except ImportError: return
		title = u'%s' % obj
		title = ''.join(c for c in unicodedata.normalize('NFD', title) if unicodedata.category(c) != 'Mn')
		return str(title)
	except:
		return title

def _ext_scrapers_notice(status):
	kodi_utils.notification(status, 2500)

def toggle_all(folder, setting, silent=False):
	try:
		sourcelist = scraperNames(folder)
		for i in sourcelist:
			source_setting = 'provider.' + i
			fenom_setSetting(source_setting, setting)
		if silent: return
		return _ext_scrapers_notice(32576)
	except:
		if silent: return
		return _ext_scrapers_notice(32574)

def enable_disable_specific_all(folder):
	try:
		from modules.settings import ext_addon
		icon = ext_addon('script.module.fenomscrapers').getAddonInfo('icon')
		enabled, disabled = scrapersStatus(folder)
		all_sources = sorted(enabled + disabled)
		preselect = [all_sources.index(i) for i in enabled]
		list_items = [{'line1': i.upper(), 'icon': icon} for i in all_sources]
		kwargs = {'items': json.dumps(list_items), 'heading': 'Fen', 'enumerate': 'false', 'multi_choice': 'true', 'multi_line': 'false', 'preselect': preselect}
		chosen = kodi_utils.select_dialog(all_sources, **kwargs)
		if chosen == None: return
		for i in all_sources:
			if i in chosen: fenom_setSetting('provider.' + i, 'true')
			else: fenom_setSetting('provider.' + i, 'false')
		return _ext_scrapers_notice(32576)
	except: return _ext_scrapers_notice(32574)

def scrapersStatus(folder='all'):
	providers = scraperNames(folder)
	enabled = [i for i in providers if fenom_getSetting('provider.' + i) == 'true']
	disabled = [i for i in providers if i not in enabled]
	return enabled, disabled

def scraperNames(folder):
	providerList = []
	append = providerList.append
	sourceSubFolders = ['hosters', 'torrents']
	if folder != 'all':
		sourceSubFolders = [i for i in sourceSubFolders if i == folder]
	for item in sourceSubFolders:
		files = xbmcvfs.listdir(kodi_utils.translate_path(source_folder_location % item))[1]
		for m in files:
			if not os.path.splitext(urlparse(m).path)[-1] == '.py':
				continue
			module_name = m.split('.')[0]
			if module_name == '__init__':
				continue
			append(module_name)
	return providerList

def pack_enable_check(meta, season, episode):
	extra_info = meta['extra_info']
	status = extra_info['status'].lower()
	if status in ('ended', 'canceled'): return True, True
	from metadata import season_episodes_meta, retrieve_user_info
	from modules.utils import adjust_premiered_date, get_datetime
	adjust_hours = date_offset()
	current_date = get_datetime()
	meta_user_info = retrieve_user_info(window)
	episodes_data = season_episodes_meta(season, meta, meta_user_info)
	unaired_episodes = [adjust_premiered_date(i['premiered'], adjust_hours)[0] for i in episodes_data]
	if None in unaired_episodes or any(i > current_date for i in unaired_episodes): return False, False
	else: return True, False
	return False, False

def getFileNameMatch(title, url, name=None):
	from modules.utils import clean_file_name
	if name: return clean_file_name(name)
	from modules.utils import clean_title, normalize
	title_match = None
	try:
		title = clean_title(normalize(title))
		name_url = unquote(url)
		try: file_name = clean_title(name_url.split('/')[-1])
		except: return title_match
		test = name_url.split('/')
		for item in test:
			test_url = str(clean_title(normalize(item)))
			if title in test_url:
				title_match = clean_file_name(str(item)).replace('html', ' ').replace('+', ' ')
				break
	except:
		pass
	return title_match

def clear_scrapers_cache(silent=False):
	for item in ('internal_scrapers', 'external_scrapers'): clear_cache(item, silent=True)
	if not silent: kodi_utils.notification(32576)

def clear_and_rescrape(content, query, meta, season=None, episode=None):
	from caches.providers_cache import providerCache
	from modules.sources import Sources
	from modules.nav_utils import clear_cache
	kodi_utils.show_busy_dialog()
	deleted = providerCache.delete_cache_single(content, meta['tmdb_id'])
	if not deleted: return kodi_utils.notification(32574)
	clear_cache('internal_scrapers', silent=True)
	meta_json = json.dumps(meta)
	if content == 'movie':
		play_params = {'mode': 'play_media', 'vid_type': 'movie', 'query': query, 'tmdb_id': meta['tmdb_id'], 'meta': meta_json, 'autoplay': 'False'}
	else:
		play_params = {'mode': 'play_media', 'vid_type': 'episode', 'tmdb_id': meta['tmdb_id'], 'query': query, 'tvshowtitle': meta['rootname'],
						'season': season, 'episode': episode, 'meta': meta_json, 'autoplay': 'False'}
	kodi_utils.hide_busy_dialog()
	Sources().playback_prep(play_params)

def rescrape_with_disabled(content, query, meta, season=None, episode=None):
	from modules.sources import Sources
	try: meta = json.loads(meta)
	except: pass
	meta_json = json.dumps(meta)
	if content in ('movie', 'movies'):
		play_params = {'mode': 'play_media', 'vid_type': 'movie', 'query': query, 'tmdb_id': meta['tmdb_id'], 'meta': meta_json,
						'autoplay': 'False', 'disabled_ignored': 'true', 'prescrape': 'false'}
	else:
		play_params = {'mode': 'play_media', 'vid_type': 'episode', 'tmdb_id': meta['tmdb_id'],'query': query, 'tvshowtitle': meta['rootname'], 'season': season,
						'episode': episode, 'meta': meta_json, 'autoplay': 'False', 'disabled_ignored': 'true', 'prescrape': 'false'}
	Sources().playback_prep(play_params)

def supported_video_extensions():
	supported_video_extensions = xbmc.getSupportedMedia('video').split('|')
	return [i for i in supported_video_extensions if not i in ('','.zip')]

def seas_ep_query_list(season, episode):
	return ['s%02de%02d' % (int(season), int(episode)),
			'%dx%02d' % (int(season), int(episode)),
			'%02dx%02d' % (int(season), int(episode)),
			'season%02depisode%02d' % (int(season), int(episode)),
			'season%depisode%02d' % (int(season), int(episode)),
			'season%depisode%d' % (int(season), int(episode))]

def seas_ep_filter(season, episode, release_title, split=False):
	string_list = []
	append = string_list.append
	release_title = re.sub(r'[^A-Za-z0-9-]+', '.', unquote(release_title).replace('\'', '')).lower()
	string1 = r'(s<<S>>e<<E>>)|' \
			  r'(s<<S>>\.e<<E>>)|' \
			  r'(s<<S>>ep<<E>>)|' \
			  r'(s<<S>>\.ep<<E>>)'
	string2 = r'(season\.<<S>>\.episode\.<<E>>)|' \
			  r'(season<<S>>\.episode<<E>>)|' \
			  r'(season<<S>>episode<<E>>)|' \
			  r'(<<S>>x<<E>>\.)|' \
			  r'(s<<S>>e\(<<E>>\))|' \
			  r'(s<<S>>\.e\(<<E>>\))|' \
			  r'(<<S>>\.<<E>>\.)'
	string3 = r'(<<S>><<E>>\.)'
	string4 = r'(s<<S>>e<<E1>>e<<E2>>)|' \
			  r'(s<<S>>e<<E1>>-e<<E2>>)|' \
			  r'(s<<S>>e<<E1>>\.e<<E2>>)|' \
			  r'(s<<S>>e<<E1>>-<<E2>>)-|' \
			  r'(s<<S>>e<<E1>>\.<<E2>>)\.|' \
			  r'(s<<S>>e<<E1>><<E2>>)'
	string5 = r'(?<![a-z])(ep<<E>>[.-])|' \
			  r'(?<![a-z])e<<E>>[.-]|' \
			  r'(?<![a-z])(ep[.-]<<E>>[.-])'
	append(string1.replace('<<S>>', str(season).zfill(2)).replace('<<E>>', str(episode).zfill(2)))
	append(string1.replace('<<S>>', str(season)).replace('<<E>>', str(episode).zfill(2)))
	append(string2.replace('<<S>>', str(season).zfill(2)).replace('<<E>>', str(episode).zfill(2)))
	append(string2.replace('<<S>>', str(season)).replace('<<E>>', str(episode).zfill(2)))
	append(string2.replace('<<S>>', str(season).zfill(2)).replace('<<E>>', str(episode)))	
	append(string2.replace('<<S>>', str(season)).replace('<<E>>', str(episode)))
	append(string3.replace('<<S>>', str(season).zfill(2)).replace('<<E>>', str(episode).zfill(2)))
	append(string3.replace('<<S>>', str(season)).replace('<<E>>', str(episode).zfill(2)))
	append(string4.replace('<<S>>', str(season).zfill(2)).replace('<<E1>>', str(episode-1).zfill(2)).replace('<<E2>>', str(episode).zfill(2)))
	append(string4.replace('<<S>>', str(season).zfill(2)).replace('<<E1>>', str(episode).zfill(2)).replace('<<E2>>', str(episode+1).zfill(2)))
	append(string5.replace('<<E>>', str(episode).zfill(2)))
	final_string = '|'.join(string_list)
	reg_pattern = re.compile(final_string)
	if split:
		return release_title.split(re.search(reg_pattern, release_title).group(), 1)[1]
	else:
		return bool(re.search(reg_pattern, release_title))

def extras_filter():
	return ['sample', 'extra', 'extras', 'deleted', 'unused', 'footage', 'inside', 'blooper', 'bloopers', 'making.of', 'feature', 'featurette', 'behind.the.scenes', 'trailer']

def find_season_in_release_title(release_title):
	release_title = re.sub(r'[^A-Za-z0-9-]+', '.', unquote(release_title).replace('\'', '')).lower()
	match = None
	regex_list = [r's(\d+)', r's\.(\d+)', r'(\d+)x', r'(\d+)\.x', r'season(\d+)', r'season\.(\d+)']
	for item in regex_list:
		try:
			match = re.search(item, release_title)
			if match:
				match = int(str(match.group(1)).lstrip('0'))
				break
		except: pass
	return match

def check_title(title, release_title, aliases, year, season, episode):
	try:
		if season:
			if not seas_ep_filter(season, episode, release_title): return False
			hdlr = 'S%02dE%02d' % (int(season), int(episode))
		else: hdlr = str(year)
		all_titles = [title]
		if aliases: all_titles += aliases
		cleaned_titles = []
		append = cleaned_titles.append
		for i in all_titles: append(clean_title(i.replace('!', '').replace('(', '').replace(')', '').replace('&', 'and')))
		release_title = release_title_format(release_title)
		release_title = release_title.split(hdlr.lower())[0].replace(str(year), '').replace('(', '').replace(')', '').replace('&', 'and')
		release_title = release_title.split('2160p')[0].split('4k')[0].split('1080p')[0].split('720p')[0]
		release_title = clean_title(release_title)
		if not any(release_title == i for i in cleaned_titles):	return False
		return True
	except:
		return True

def release_title_format(release_title):
	try:
		release_title = release_title.lower().replace("'", "").lstrip('.').rstrip('.')
		fmt = '.%s.' % re.sub(r'[^a-z0-9-~]+', '.', release_title).replace('.-.', '-').replace('-.', '-').replace('.-', '-').replace('--', '-')
		return fmt
	except:
		return release_title.lower()

def clean_title(title):
	try:
		import re
		if not title: return
		title = title.lower()
		title = re.sub(r'&#(\d+);', '', title)
		title = re.sub(r'(&#[0-9]+)([^;^0-9]+)', '\\1;\\2', title)
		title = re.sub(r'(&#[0-9]+)([^;^0-9]+)', '\\1;\\2', title)
		title = title.replace('&quot;', '\"').replace('&amp;', '&')
		title = re.sub(r'\n|([\[({].+?[})\]])|([:;–\-"\',!_.?~$@])|\s', '', title)
	except: pass
	return title

def get_qual(term):
	if any(i in term for i in SCR): return 'SCR'
	elif any(i in term for i in CAM): return 'CAM'
	elif any(i in term for i in TELE): return 'TELE'
	elif any(i in term for i in RES_4K): return '4K'
	elif any(i in term for i in RES_1080): return '1080p'
	elif any(i in term for i in RES_720): return '720p'
	else: return 'SD'

def get_release_quality(release_info, release_link=None):
	try:
		quality = None
		quality = get_qual(release_info)
		if not quality:
			if release_link:
				release_link = release_link.lower()
				quality = get_qual(release_link)
				if not quality: quality = 'SD'
			else: quality = 'SD'
		return quality
	except: pass

def url_strip(url):
	try:
		url = unquote_plus(url)
		if 'magnet:' in url: url = url.split('&dn=')[1]
		url = url.lower().replace("'", "").lstrip('.').rstrip('.')
		fmt = re.sub(r'[^a-z0-9]+', ' ', url)
		if 'http' in fmt: return None
		if fmt == '': return None
		else: return fmt
	except: return None

def get_file_info(url, link=None):
	url = url_strip(url)
	if link: link = url_strip(link)
	quality = get_release_quality(url, link)
	info = ''
	if any(i in url for i in HEVC):
		info += '[B]HEVC[/B] |'
	if any(i in url for i in HDR):
		info += ' [B]HDR[/B] |'
	if any(i in url for i in DV):
		info += ' [B]D/VISION[/B] |'
	if ' hi10p ' in url:
		info += ' HI10P |'
	if ' 10bit ' in url:
		info += ' 10BIT |'
	if ' 3d ' in url:
		info += ' 3D |'
	if any(i in url for i in BLURAY):
		info += ' BLURAY |'
	if any(i in url for i in BDRIP):
		info += ' BD-RIP |'
	if any(i in url for i in REMUX):
		info += ' REMUX |'
	if any(i in url for i in DVDRIP):
		info += ' DVD-RIP |'
	if any(i in url for i in DVD):
		info += ' DVD |'
	if any(i in url for i in WEB):
		info += ' WEB |'
	if ' hdtv ' in url:
		info += ' HDTV |'
	if ' sdtv ' in url:
		info += ' SDTV |'
	if any(i in url for i in HDRIP):
		info += ' HDRIP |'
	if any(i in url for i in UHDRIP):
		info += ' UHDRIP |'
	if ' imax ' in url:
		info += ' IMAX |'
	if any(i in url for i in AC3):
		info += ' AC3 |'
	if ' aac ' in url:
		info += ' AAC |'
	if ' aac5 1 ' in url:
		info += ' AAC | 5.1 |'
	if any(i in url for i in DD):
		info += ' DD |'
	if any(i in url for i in TRUEHD):
		info += ' TRUEHD |'
	if ' atmos ' in url:
		info += ' ATMOS |'
	if any(i in url for i in DDPLUS):
		info += ' DD+ |'
	if ' dts ' in url:
		info += ' DTS |'
	if any(i in url for i in HDMA):
		info += ' HD.MA |'
	if any(i in url for i in HDHRA):
		info += ' HD.HRA |'
	if any(i in url for i in DTSX):
		info += ' DTS:X |'
	if any(i in url for i in DD51):
		info += ' DD | 5.1 |'
	if any(i in url for i in DDP51):
		info += ' DD+ | 5.1 |'
	if ' opus ' in url:
		info += ' OPUS |'
	if any(i in url for i in D51):
		info += ' 5.1 |'
	if any(i in url for i in D71):
		info += ' 7.1 |'
	if any(i in url for i in SUBS):
		info += ' SUBS |'
	if any(i in url for i in DUB):
		info += ' DUB |'
	info = info.rstrip('|')
	return quality, info




