# -*- coding: utf-8 -*-
import xbmc, xbmcgui, xbmcplugin
from sys import argv
import sqlite3 as database
from modules.nav_utils import build_url
from modules.kodi_utils import translate_path, notification, external_browse, execute_builtin, sleep, local_string as ls
# from modules.utils import logger

views_database = translate_path('special://profile/addon_data/plugin.video.fen/views.db')
settings_icon = translate_path('special://home/addons/script.tikiart/resources/media/settings.png')
fanart = translate_path('special://home/addons/plugin.video.fen/fanart.png')
window = xbmcgui.Window(10000)

def choose_view(view_type, content):
	__handle__ = int(argv[1])
	set_view_str = ls(32547)
	try: listitem = xbmcgui.ListItem(set_view_str, offscreen=True)
	except: listitem = xbmcgui.ListItem(set_view_str)
	params_url = build_url({'mode': 'set_view', 'view_type': view_type})
	listitem.setArt({'icon': settings_icon, 'poster': settings_icon, 'thumb': settings_icon, 'fanart': fanart, 'banner': settings_icon})
	xbmcplugin.addDirectoryItem(__handle__, params_url, listitem, False)
	xbmcplugin.setContent(__handle__, content)
	xbmcplugin.endOfDirectory(__handle__)
	set_view_mode(view_type, content)

def set_view(view_type):
	view_id = str(xbmcgui.Window(xbmcgui.getCurrentWindowId()).getFocusId())
	dbcon = database.connect(views_database)
	dbcon.execute("DELETE FROM views WHERE view_type = ?", (view_type,))
	dbcon.execute("INSERT INTO views VALUES (?, ?)", (view_type, view_id))
	dbcon.commit()
	set_view_property(view_type, view_id)
	notification(xbmc.getInfoLabel('Container.Viewmode').upper(), time=1500)

def set_view_property(view_type, view_id):
	window.setProperty('fen_%s' % view_type, view_id)

def set_view_properties():
	dbcon = database.connect(views_database)
	dbcur = dbcon.cursor()
	dbcur.execute("SELECT * FROM views")
	view_ids = dbcur.fetchall()
	for item in view_ids: window.setProperty('fen_%s' % item[0], item[1])

def set_view_mode(view_type, content='files'):
	if external_browse(): return
	sleep(100)
	t = 0
	view_id = window.getProperty('fen_%s' % view_type)
	try:
		while not xbmc.getInfoLabel('Container.Content') == content:
			t += 1
			if t < 5000: sleep(1)
			else: return
		if not view_id:
			dbcon = database.connect(views_database)
			dbcur = dbcon.cursor()
			dbcur.execute("SELECT view_id FROM views WHERE view_type = ?", (str(view_type),))
			view_id = dbcur.fetchone()[0]
	except: return
	execute_builtin('Container.SetViewMode(%s)' % view_id)
