# -*- coding: utf-8 -*-
import json
from threading import Thread
from datetime import datetime, timedelta
import sqlite3 as database
import metadata
from windows import BaseDialog
from apis import tmdb_api, imdb_api
from apis.trakt_api import trakt_get_next_episodes
from caches.imagehash_cache import cache_imagehash_object
from indexers import dialogs
from indexers.images import Images
from modules.image_utils import ImageColors, fetch_kodi_imagecache
from modules.sources import Sources
from modules.meta_lists import networks
from modules.indicators_bookmarks import detect_bookmark, get_watched_status, get_watched_info_movie
from modules.kodi_utils import translate_path, sleep, close_all_dialog, ok_dialog, local_string as ls
from modules import settings
# from modules.utils import logger

backup_poster = translate_path('special://home/addons/script.tikiart/resources/media/box_office.png')
backup_fanart = translate_path('special://home/addons/plugin.video.fen/fanart.png')
backup_thumbnail = translate_path('special://home/addons/script.tikiart/resources/media/box_office.png')
backup_cast_thumbnail = translate_path('special://home/addons/script.tikiart/resources/media/genre_family.png')
tmdb_image_base = 'https://image.tmdb.org/t/p/%s%s'
button_ids = (10, 11, 12, 13, 14, 15, 16, 17)
parentsguide_levels = {'mild': ls(32996), 'moderate': ls(32997), 'severe': ls(32998)}
parentsguide_inputs = {'Sex & Nudity': (ls(32990), 'porn.png'), 'Violence & Gore': (ls(32991), 'genre_war.png'), 'Profanity': (ls(32992), 'bad_language.png'),
						'Alcohol, Drugs & Smoking': (ls(32993), 'drugs_alcohol.png'), 'Frightening & Intense Scenes': (ls(32994), 'genre_horror.png')}
default_text_color = 'FF302F2F'
default_highlight_color = 'FFB7B4BB'
cast_id = 2050
recommended_id = 2051
reviews_id = 2052
trivia_id = 2053
blunders_id = 2054
imdb_parentsguide_id = 2055
imdb_videos_id = 2056
tmdb_artwork_posters_id = 2057
tmdb_artwork_backdrops_id = 2058
more_from_year_id = 2059
more_from_genres_id = 2060
more_from_networks_id = 2061
more_from_collection_id = 2062

class Extras(BaseDialog):
	def __init__(self, *args, **kwargs):
		BaseDialog.__init__(self, args)
		self.set_starting_constants(kwargs)
		self.set_properties()

	def onInit(self):
		tasks = (self.set_poster, self.make_cast, self.make_recommended, self.make_reviews, self.make_trivia, self.make_blunders,
				self.make_imdb_parentsguide, self.make_imdb_videos, self.make_more_from_year, self.make_more_from_genres, self.make_more_from_network)
		[Thread(target=i).start() for i in tasks]
		Thread(target=self.make_tmdb_artwork, args=('posters',)).start()
		Thread(target=self.make_tmdb_artwork, args=('backdrops',)).start()
		if self.db_type == 'movie' and self.meta['extra_info']['collection_id']: Thread(target=self.make_more_from_collection).start()
		else: self.setProperty('tikiskins.extras.make.collection', 'false')

	def run(self):
		self.doModal()
		return self.selected

	def onClick(self, controlID):
		if controlID in button_ids:
			if controlID == 10:
				if self.db_type == 'movie':
					url_params = {'mode': 'play_media', 'vid_type': 'movie', 'query': self.rootname, 'tmdb_id': self.tmdb_id, 'imdb_id': self.meta['imdb_id']}
					Sources().playback_prep(url_params)
				else:
					close_all_dialog()
					url_params = self.make_tvshow_browse_params()
					self.selected = (self.folder_runner, self.build_url(url_params))
					self.close()
			elif controlID == 11:
				chosen = dialogs.trailer_choice(self.db_type, self.rootname, self.poster, self.tmdb_id, self.meta['trailer'], self.meta['all_trailers'])
				if not chosen: return ok_dialog()
				if self.is_widget == 'true':
					close_all_dialog()
					self.selected = (self.plugin_runner, chosen)
					self.close()
				else:
					params = {'mode': 'open_window', 'import_info': json.dumps(['windows.videoplayer', 'VideoPlayer']),
							'skin_xml': 'videoplayer.xml', 'kwargs': json.dumps({'video': chosen})}
					return self.execute_code(self.plugin_runner % self.build_url(params))
			elif controlID == 12:
				base_media = 'movies' if self.db_type == 'movie' else 'tv'
				keyword_params = dialogs.imdb_keywords_choice(base_media, self.meta['imdb_id'], self.rootname, self.poster)
				if not keyword_params: return
				close_all_dialog()
				self.selected = (self.folder_runner, self.build_url(keyword_params))
				self.close()
			elif controlID == 13:
				params = {'mode': 'imdb_image_results', 'imdb_id': self.meta['imdb_id'], 'media_title': self.rootname, 'page_no': 1, 'rolling_count': 0}
				return self.execute_code(self.plugin_runner % self.build_url(params))
			elif controlID == 14:
				text = dialogs.media_extra_info(self.db_type, self.meta)
				self.open_window(['windows.extras', 'ShowTextMedia'], 'textviewer_media.xml', text=text, poster=self.poster)
			elif controlID == 15:
				if not self.genre: return
				genre_choices = dialogs.genres_choice(self.db_type, self.genre, self.rootname, self.poster)
				if not genre_choices: return
				close_all_dialog()
				if self.db_type == 'movie': action = 'tmdb_movies_genres'
				else: action = 'tmdb_tv_genres'
				mode = 'build_%s_list' % self.db_type
				self.selected = (self.folder_runner, self.build_url({'mode': mode, 'action': action, 'genre_id': ','.join(genre_choices)}))
				self.close()
			elif controlID == 16:
				if self.db_type == 'movie':
					director = self.meta.get('director', None)
					if not director: return
					params = {'mode': 'people_search.person_data_dialog', 'query': director}
					return self.execute_code(self.plugin_runner % self.build_url(params))
				else:
					close_all_dialog()
					self.selected = (self.plugin_runner, self.build_url({'mode': 'play_fetch_random', 'tmdb_id': self.tmdb_id}))
					self.close()
			elif controlID == 17:
				params = {'mode': 'trakt_manager_choice', 'tmdb_id': self.tmdb_id, 'imdb_id': self.meta['imdb_id'], 'tvdb_id': self.meta['tvdb_id'], 'db_type': self.db_type}
				return self.execute_code(self.plugin_runner % self.build_url(params))
		elif controlID == 50:
			self.open_window(['windows.extras', 'ShowTextMedia'], 'textviewer_media.xml', text=self.plot, poster=self.poster)
		else: return self.onAction(self.selection_actions[0], controlID)

	def onAction(self, action, controlID=None):
		if action in self.selection_actions:
			try:
				selected = self.list_items_dict[controlID]
				current_index = self.get_position(controlID)
				chosen_listitem = selected['list'][current_index]
				chosen_var = chosen_listitem.getProperty(selected['property'])
			except: pass
			if controlID == 2050:
				params = {'mode': 'people_search.person_data_dialog', 'query': chosen_var}
				return self.execute_code(self.plugin_runner % self.build_url(params))
			elif controlID in (2051, 2059, 2060, 2061, 2062):
				function = metadata.movie_meta if self.db_type == 'movie' else metadata.tvshow_meta
				meta = function('tmdb_id', chosen_var, metadata.retrieve_user_info())
				if not meta: return
				params = {'mode': 'extras_menu_choice', 'tmdb_id': chosen_var, 'db_type': self.db_type, 'is_widget': self.is_widget, 'is_home': self.is_home}
				return self.execute_code(self.plugin_runner % self.build_url(params))
			elif controlID in (2052, 2053, 2054, 2055):
				if controlID == 2055:
					listings = json.loads(chosen_var)
					if not listings: return
					chosen_var = '\n\n'.join(['%02d. %s' % (count, i) for count, i in enumerate(listings, 1)])
				self.open_window(['windows.extras', 'ShowTextMedia'], 'textviewer_media.xml', text=chosen_var, poster=self.poster)
			elif controlID == 2056:
				chosen = dialogs.imdb_videos_choice(chosen_var, self.poster)
				if not chosen: return
				params = {'mode': 'open_window', 'import_info': json.dumps(['windows.videoplayer', 'VideoPlayer']),
						'skin_xml': 'videoplayer.xml', 'kwargs': json.dumps({'meta': self.meta, 'video': chosen})}
				return self.execute_code(self.plugin_runner % self.build_url(params))
			elif controlID in (2057, 2058):
				slideshow_params = {'mode': 'slideshow_image', 'all_images': chosen_var, 'current_index': current_index}
				ending_position = Images().run(slideshow_params)
				self.getControl(controlID).selectItem(ending_position)
		elif action in self.closing_actions: self.close()
		elif action in self.context_actions:
			if self.getFocusId() == 10 and self.db_type == 'movie':
				params = {'mode': 'rescrape_with_disabled', 'content': 'movie', 'query': self.rootname, 'meta': json.dumps(self.meta)}
				self.execute_code(self.plugin_runner % self.build_url(params))

	def make_cast(self):
		def builder():
			for item in self.meta['cast']:
				try:
					listitem = self.make_listitem()
					thumbnail = item['thumbnail']
					if not thumbnail: thumbnail = backup_cast_thumbnail
					listitem.setProperty('tikiskins.extras.name', item['name'])
					listitem.setProperty('tikiskins.extras.role', item['role'])
					listitem.setProperty('tikiskins.extras.thumbnail', thumbnail)
					yield listitem
				except: pass
		try:
			item_list = list(builder())
			self.setProperty('tikiskins.extras.cast.number', '(x%02d)' % len(item_list))
			self.list_items_dict[cast_id] = {'list': item_list, 'property': 'tikiskins.extras.name'}
			self.add_items(cast_id, item_list)
		except: pass

	def make_recommended(self):
		if not recommended_id in self.enabled_lists: return
		try:
			function = tmdb_api.tmdb_movies_recommendations if self.db_type == 'movie' else tmdb_api.tmdb_tv_recommendations
			data = function(self.tmdb_id, 1)['results']
			item_list = list(self.make_tmdb_listitems(data))
			self.setProperty('tikiskins.extras.recommended.number', '(x%02d)' % len(item_list))
			self.list_items_dict[recommended_id] = {'list': item_list, 'property': 'tikiskins.extras.tmdb_id'}
			self.add_items(recommended_id, item_list)
		except: pass

	def make_reviews(self):
		if not reviews_id in self.enabled_lists: return
		def builder():
			for count, item in enumerate(data, 1):
				try:
					listitem = self.make_listitem()
					if item['spoiler']: content = '[B][COLOR red][%s][/COLOR][CR]%02d. [I]%s - %s - %s[/I][/B]\n\n%s' \
													% (spoiler_str, count, item['rating'], item['date'], item['title'], item['content'])
					else: content = '[B]%02d. [I]%s - %s - %s[/I][/B]\n\n%s' % (count, item['rating'], item['date'], item['title'], item['content'])
					listitem.setProperty('tikiskins.extras.text', content)
					yield listitem
				except: pass
		try:
			spoiler_str = ls(32985).upper()
			data = imdb_api.imdb_reviews(self.meta['imdb_id'])
			item_list = list(builder())
			self.setProperty('tikiskins.extras.imdb_reviews.number', '(x%02d)' % len(item_list))
			self.list_items_dict[reviews_id] = {'list': item_list, 'property': 'tikiskins.extras.text'}
			self.add_items(reviews_id, item_list)
		except: pass

	def make_trivia(self):
		if not trivia_id in self.enabled_lists: return
		def builder():
			for count, item in enumerate(data, 1):
				try:
					listitem = self.make_listitem()
					listitem.setProperty('tikiskins.extras.text', '[B]%s %02d.[/B][CR][CR]%s' % (trivia, count, item))
					yield listitem
				except: pass
		try:
			trivia = ls(32984).upper()
			data = imdb_api.imdb_trivia(self.meta['imdb_id'])
			item_list = list(builder())
			self.setProperty('tikiskins.extras.imdb_trivia.number', '(x%02d)' % len(item_list))
			self.list_items_dict[trivia_id] = {'list': item_list, 'property': 'tikiskins.extras.text'}
			self.add_items(trivia_id, item_list)
		except: pass

	def make_blunders(self):
		if not blunders_id in self.enabled_lists: return
		def builder():
			for count, item in enumerate(data, 1):
				try:
					listitem = self.make_listitem()
					listitem.setProperty('tikiskins.extras.text', '[B]%s %02d.[/B][CR][CR]%s' % (blunders, count, item))
					yield listitem
				except: pass
		try:
			blunders = ls(32986).upper()
			data = imdb_api.imdb_blunders(self.meta['imdb_id'])
			item_list = list(builder())
			self.setProperty('tikiskins.extras.imdb_blunders.number', '(x%02d)' % len(item_list))
			self.list_items_dict[blunders_id] = {'list': item_list, 'property': 'tikiskins.extras.text'}
			self.add_items(blunders_id, item_list)
		except: pass

	def make_imdb_parentsguide(self):
		if not imdb_parentsguide_id in self.enabled_lists: return
		def builder():
			for item in data:
				try:
					listitem = self.make_listitem()
					name = parentsguide_inputs[item['title']][0]
					ranking = parentsguide_levels[item['ranking'].lower()].upper()
					if item['listings']:
						ranking += ' (x%02d)' % len(item['listings'])
					icon = translate_path('special://home/addons/script.tikiart/resources/media/%s' % parentsguide_inputs[item['title']][1])
					listitem.setProperty('tikiskins.extras.name', name)
					listitem.setProperty('tikiskins.extras.ranking', ranking)
					listitem.setProperty('tikiskins.extras.thumbnail', icon)
					listitem.setProperty('tikiskins.extras.listings', json.dumps(item['listings']))
					yield listitem
				except: pass
		try:
			data = imdb_api.imdb_parentsguide(self.meta['imdb_id'])
			item_list = list(builder())
			self.setProperty('tikiskins.extras.imdb_parentsguide.number', '(x%02d)' % len(item_list))
			self.list_items_dict[imdb_parentsguide_id] = {'list': item_list, 'property': 'tikiskins.extras.listings'}
			self.add_items(imdb_parentsguide_id, item_list)
		except: pass

	def make_imdb_videos(self):
		if not imdb_videos_id in self.enabled_lists: return
		def builder():
			for count, item in enumerate(data, 1):
				try:
					listitem = self.make_listitem()
					listitem.setProperty('tikiskins.extras.name', '%01d. %s' % (count, item['title']))
					listitem.setProperty('tikiskins.extras.thumbnail', item['poster'])
					listitem.setProperty('tikiskins.extras.qualities', json.dumps(item['videos']))
					yield listitem
				except: pass
		try:
			data = imdb_api.imdb_videos(self.meta['imdb_id'])
			item_list = list(builder())
			self.setProperty('tikiskins.extras.imdb_videos.number', '(x%02d)' % len(item_list))
			self.list_items_dict[imdb_videos_id] = {'list': item_list, 'property': 'tikiskins.extras.qualities'}
			self.add_items(imdb_videos_id, item_list)
		except: pass

	def make_tmdb_artwork(self, image_type):
		if image_type == 'posters':
			if not tmdb_artwork_posters_id in self.enabled_lists: return
			_id = tmdb_artwork_posters_id
		else:
			if not tmdb_artwork_backdrops_id in self.enabled_lists: return
			_id = tmdb_artwork_backdrops_id
		def builder():
			for count, item in enumerate(data, 1):
				try:
					listitem = self.make_listitem()
					thumb_url = tmdb_image_base % ('w780', item['file_path'])
					name = '%sx%s' % (item['height'], item['width'])
					listitem.setProperty('tikiskins.extras.name', '%01d. %s' % (count, name))
					listitem.setProperty('tikiskins.extras.thumbnail', thumb_url)
					listitem.setProperty('tikiskins.extras.all_images', json_all_images)
					yield listitem
				except: pass
		try:
			dbtype = 'movie' if self.db_type == 'movie' else 'tv'
			data = tmdb_api.tmdb_media_images(dbtype, self.tmdb_id)[image_type]
			data.sort(key=lambda x: x['file_path'])
			json_all_images = json.dumps([(tmdb_image_base % ('original', i['file_path']), '%sx%s' % (i['height'], i['width'])) for i in data])
			item_list = list(builder())
			self.setProperty('tikiskins.extras.tmdb_artwork.%s.number' % image_type, '(x%02d)' % len(item_list))
			self.list_items_dict[_id] = {'list': item_list, 'property': 'tikiskins.extras.all_images'}
			self.add_items(_id, item_list)
		except: pass

	def make_more_from_year(self):
		if not more_from_year_id in self.enabled_lists: return
		try:
			function = tmdb_api.tmdb_movies_year if self.db_type == 'movie' else tmdb_api.tmdb_tv_year
			data = self.remove_current_tmdb_mediaitem(function(self.year, 1)['results'])
			item_list = list(self.make_tmdb_listitems(data))
			self.setProperty('tikiskins.extras.more_from_year.number', '(x%02d)' % len(item_list))
			self.list_items_dict[more_from_year_id] = {'list': item_list, 'property': 'tikiskins.extras.tmdb_id'}
			self.add_items(more_from_year_id, item_list)
		except: pass

	def make_more_from_genres(self):
		if not more_from_genres_id in self.enabled_lists: return
		try:
			function = tmdb_api.tmdb_movies_genres if self.db_type == 'movie' else tmdb_api.tmdb_tv_genres
			genre_dict = dialogs.genres_choice(self.db_type, self.genre, self.rootname, self.poster, return_genres=True)
			genre_list = ','.join([i['value'][0] for i in genre_dict])
			data = self.remove_current_tmdb_mediaitem(function(genre_list, 1)['results'])
			item_list = list(self.make_tmdb_listitems(data))
			self.setProperty('tikiskins.extras.more_from_genres.number', '(x%02d)' % len(item_list))
			self.list_items_dict[more_from_genres_id] = {'list': item_list, 'property': 'tikiskins.extras.tmdb_id'}
			self.add_items(more_from_genres_id, item_list)
		except: pass

	def make_more_from_network(self):
		if not more_from_networks_id in self.enabled_lists: return
		try:
			network = self.meta['studio']
			network_id = [i['id'] for i in tmdb_api.tmdb_company_id(network)['results'] if i['name'] == network][0] \
						if self.db_type == 'movie' else [item['id'] for item in networks() if 'name' in item and item['name'] == network][0]
			function = tmdb_api.tmdb_movies_networks if self.db_type == 'movie' else tmdb_api.tmdb_tv_networks
			data = self.remove_current_tmdb_mediaitem(function(network_id, 1)['results'])
			item_list = list(self.make_tmdb_listitems(data))
			self.setProperty('tikiskins.extras.more_from_networks.number', '(x%02d)' % len(item_list))
			self.list_items_dict[more_from_networks_id] = {'list': item_list, 'property': 'tikiskins.extras.tmdb_id'}
			self.add_items(more_from_networks_id, item_list)
		except: pass

	def make_more_from_collection(self):
		if not more_from_collection_id in self.enabled_lists: return
		try:
			data = tmdb_api.tmdb_movies_collection(self.meta['extra_info']['collection_id'])
			poster_path = data['poster_path']
			if poster_path: poster = tmdb_image_base % (self.poster_resolution, poster_path)
			else: poster = backup_poster
			self.setProperty('tikiskins.extras.more_from_collection.name', data['name'])
			self.setProperty('tikiskins.extras.more_from_collection.overview', data['overview'])
			self.setProperty('tikiskins.extras.more_from_collection.poster', poster)
			item_list = list(self.make_tmdb_listitems(data['parts']))
			item_list.sort(key=lambda k: k.getProperty('tikiskins.extras.release_date'))
			self.setProperty('tikiskins.extras.more_from_collection.number', '(x%02d)' % len(item_list))
			self.list_items_dict[more_from_collection_id] = {'list': item_list, 'property': 'tikiskins.extras.tmdb_id'}
			self.add_items(more_from_collection_id, item_list)
		except: pass

	def get_release_year(self, release_data):
		try:
			if release_data in ('', None): release_data = '2050'
			else: release_data = release_data.split('-')[0]
		except: pass
		return release_data

	def get_finish(self):
		if self.percent_watched in ('0', '100') and self.listitem_check():
			finished = self.get_infolabel('ListItem.EndTime')
		else:
			kodi_clock = self.get_infolabel('System.Time')
			if any(i in kodi_clock for i in ['AM', 'PM']): _format = '%I:%M %p'
			else: _format = '%H:%M'
			current_time = datetime.now()
			remaining_time = ((100 - int(self.percent_watched))/100) * self.duration_data
			finish_time = current_time + timedelta(minutes=remaining_time)
			finished = finish_time.strftime(_format)
		return '[B]%s: %s[/B]' % (ls(33062), finished)

	def get_duration(self):
		return ls(33058) % self.duration_data

	def get_progress(self):
		try: resume_point, curr_time = detect_bookmark(self.db_type, self.tmdb_id)
		except: resume_point = 0
		if resume_point in (0, '0', 0.0, '0.0'):
			watched_info, use_trakt = get_watched_info_movie()
			playcount, overlay = get_watched_status(watched_info, use_trakt, 'movie', self.tmdb_id)
			self.meta.update({'playcount': playcount, 'overlay': overlay})
			if playcount == 1: self.percent_watched = '100'
			else: self.percent_watched = '0'
		else: self.percent_watched = str(int(float(resume_point)))
		progress_status = '%s%% %s' % (self.percent_watched, ls(32475))
		return progress_status

	def get_last_aired(self):
		extra_info = self.meta['extra_info']
		if extra_info.get('last_episode_to_air', False):
			last_ep = extra_info['last_episode_to_air']
			last_aired = 'S%.2dE%.2d' % (last_ep['season_number'], last_ep['episode_number'])
		else: return ''
		return '[B]%s:[/B] %s' % (ls(32634), last_aired)

	def get_next_aired(self):
		extra_info = self.meta['extra_info']
		if extra_info.get('next_episode_to_air', False):
			next_ep = extra_info['next_episode_to_air']
			next_aired = 'S%.2dE%.2d' % (next_ep['season_number'], next_ep['episode_number'])
		else: return ''
		return '[B]%s:[/B] %s' % (ls(32635), next_aired)

	def get_next_episode(self):
		if settings.watched_indicators() == 1: ep_list = trakt_get_next_episodes(include_hidden=True, hidden_full_info=True)
		else:
			watched_db = translate_path('special://profile/addon_data/plugin.video.fen/watched_status.db')
			seen = set()
			dbcon = database.connect(watched_db)
			dbcur = dbcon.cursor()
			dbcur.execute('''SELECT media_id, season, episode, last_played FROM watched_status WHERE db_type=?''', ('episode',))
			rows = dbcur.fetchall()
			rows.sort(key=lambda x: (x[0], x[1], x[2]), reverse=True)
			ep_list = [{'tmdb_id': int(a), 'season': int(b), 'episode': int(c), 'last_played': d} for a, b, c, d in rows if not (a in seen or seen.add(a))]
		try: info = [i for i in ep_list if i['tmdb_id'] == self.tmdb_id][0]
		except: return ''
		current_season = info['season']
		current_episode = info['episode']
		season_data = self.meta['season_data']
		curr_season_data = [i for i in season_data if i['season_number'] == current_season][0]
		season = current_season if current_episode < curr_season_data['episode_count'] else current_season + 1
		episode = current_episode + 1 if current_episode < curr_season_data['episode_count'] else 1
		try: info = [i for i in season_data if i['season_number'] == season][0]
		except: return ''
		if info['episode_count'] >= episode:
			next_episode = 'S%.2dE%.2d' % (season, episode)
			return '[B]%s: %s[/B]' % (ls(33041), next_episode)
		else: return ''

	def make_tvshow_browse_params(self):
		total_seasons = self.meta['total_seasons']
		all_episodes = settings.default_all_episodes()
		show_all_episodes = True if all_episodes in (1, 2) else False
		if show_all_episodes:
			if all_episodes == 1 and total_seasons > 1: url_params = {'mode': 'build_season_list', 'tmdb_id': self.tmdb_id}
			else: url_params = {'mode': 'build_episode_list', 'tmdb_id': self.tmdb_id, 'season': 'all'}
		else: url_params = {'mode': 'build_season_list', 'tmdb_id': self.tmdb_id}
		return url_params

	def original_poster(self):
		poster = self.meta.get(self.poster_main) or self.meta.get(self.poster_backup) or backup_thumbnail
		self.current_poster = poster
		if 'image.tmdb' in self.current_poster:
			try: poster = self.current_poster.replace('w185', 'original').replace('w342', 'original').replace('w780', 'original')
			except: pass
		elif 'fanart.tv' in self.current_poster:
			if not self.check_poster_cached(self.current_poster): self.current_poster = self.meta.get(self.poster_backup) or backup_thumbnail
		return poster

	def original_fanart(self):
		fanart = self.meta.get(self.fanart_main) or self.meta.get(self.fanart_backup) or backup_fanart
		return fanart

	def remove_current_tmdb_mediaitem(self, data):
		return [i for i in data if int(i['id']) != self.tmdb_id]

	def make_tmdb_listitems(self, data):
		name_key = 'title' if self.db_type == 'movie' else 'name'
		release_key = 'release_date' if self.db_type == 'movie' else 'first_air_date'
		for item in data:
			try:
				listitem = self.make_listitem()
				poster_path = item['poster_path']
				if poster_path: thumbnail = tmdb_image_base % (self.poster_resolution, poster_path)
				else: thumbnail = backup_poster
				year = self.get_release_year(item[release_key])
				listitem.setProperty('tikiskins.extras.name', item[name_key])
				listitem.setProperty('tikiskins.extras.release_date', year)
				listitem.setProperty('tikiskins.extras.vote_average', '%.1f' % item['vote_average'])
				listitem.setProperty('tikiskins.extras.thumbnail', thumbnail)
				listitem.setProperty('tikiskins.extras.tmdb_id', str(item['id']))
				yield listitem
			except: pass

	def listitem_check(self):
		return self.get_infolabel('ListItem.Title') == self.meta['title']

	def add_items(self,_id, items):
		self.getControl(_id).addItems(items)

	def set_poster(self):
		if self.current_poster:
			self.getControl(200).setImage(self.current_poster)
			self.getControl(201).setImage(self.poster)
			while not self.check_poster_cached(self.poster): sleep(50)
			self.getControl(200).setImage(self.poster)
			self.set_hex_values()
		else:
			self.setProperty('tikiskins.extras.active_poster', 'false')

	def set_hex_values(self):
		if not self.enable_highlight_colors: return
		if self.db_cache_image == backup_thumbnail:
			maincolor_hex = default_highlight_color
		else:
			image_path = translate_path('special://thumbnails/%s' % self.db_cache_image)
			maincolor_hex, bright = cache_imagehash_object(ImageColors().run, image_path)
			if not bright: self.setProperty('tikiskins.extras.text_color', default_highlight_color)
		self.setProperty('tikiskins.extras.maincolor_hex', maincolor_hex)

	def check_poster_cached(self, poster):
		if poster == backup_thumbnail:
			self.db_cache_image = poster
			return True
		self.db_cache_image = fetch_kodi_imagecache(poster)
		if self.db_cache_image: return True
		return False

	def set_starting_constants(self, kwargs):
		self.list_items_dict = {}
		self.selected = None
		self.is_widget = kwargs['is_widget'].lower()
		self.is_home = kwargs['is_home'].lower()
		self.meta = kwargs['meta']
		self.db_type = self.meta['mediatype']#movie, tvshow
		self.tmdb_id = self.meta['tmdb_id']
		if self.is_widget == 'true' or self.is_home == 'true': self.folder_runner = 'ActivateWindow(Videos,%s,return)'
		else: self.folder_runner = 'Container.Update(%s)'
		self.plugin_runner = 'RunPlugin(%s)'
		self.enabled_lists = settings.extras_enabled_lists()
		self.enable_highlight_colors = settings.extras_enable_highlight_colors()
		self.enable_scrollbars = settings.extras_enable_scrollbars()
		self.poster_resolution = settings.get_resolution()['poster']
		self.poster_main, self.poster_backup, self.fanart_main, self.fanart_backup = settings.get_art_provider()
		self.title = self.meta['title']
		self.year = str(self.meta['year'])
		self.rootname = self.meta['rootname']
		self.poster = self.original_poster()
		self.fanart = self.original_fanart()
		self.clearlogo = self.meta['clearlogo']
		self.plot = self.meta['tvshow_plot'] if 'tvshow_plot' in self.meta else self.meta['plot']
		if not self.plot: self.plot = ls(32760)
		self.rating = str(self.meta['rating'])
		self.mpaa = self.meta['mpaa']
		self.status = self.meta['extra_info'].get('status', '').replace('Series', '')
		self.genre = self.meta['genre']
		self.network = self.meta['studio'] or 'N/A'
		if not self.network: self.network = ''
		self.duration_data = int(float(self.meta['duration'])/60)
		self.duration = self.get_duration()
		if self.db_type == 'movie':
			self.progress = self.get_progress()
			self.finish_watching = self.get_finish()
			self.last_aired_episode, self.next_aired_episode, self.next_episode = '', '', ''
		else:
			self.progress, self.finish_watching = '', ''
			self.last_aired_episode = self.get_last_aired()
			if self.status.lower() not in ('', 'ended', 'canceled'): self.next_aired_episode = self.get_next_aired()
			else: self.next_aired_episode = ''
			self.next_episode = self.get_next_episode()

	def set_properties(self):
		self.setProperty('tikiskins.extras.db_type', self.db_type)
		self.setProperty('tikiskins.extras.fanart', self.fanart)
		self.setProperty('tikiskins.extras.clearlogo', self.clearlogo)
		self.setProperty('tikiskins.extras.title', self.title)
		self.setProperty('tikiskins.extras.plot', self.plot)
		self.setProperty('tikiskins.extras.year', self.year)
		self.setProperty('tikiskins.extras.rating', self.rating)
		self.setProperty('tikiskins.extras.mpaa', self.mpaa)
		self.setProperty('tikiskins.extras.status', self.status)
		self.setProperty('tikiskins.extras.genre', self.genre)
		self.setProperty('tikiskins.extras.network', self.network)
		self.setProperty('tikiskins.extras.duration', self.duration)
		self.setProperty('tikiskins.extras.progress', self.progress)
		self.setProperty('tikiskins.extras.finish_watching', self.finish_watching)
		self.setProperty('tikiskins.extras.last_aired_episode', self.last_aired_episode)
		self.setProperty('tikiskins.extras.next_aired_episode', self.next_aired_episode)
		self.setProperty('tikiskins.extras.next_episode', self.next_episode)
		self.setProperty('tikiskins.extras.enable_scrollbars', self.enable_scrollbars)
		self.setProperty('tikiskins.extras.text_color', default_text_color)
		self.setProperty('tikiskins.extras.maincolor_hex', default_highlight_color)

class ShowTextMedia(BaseDialog):
	def __init__(self, *args, **kwargs):
		BaseDialog.__init__(self, args)
		self.text = kwargs.get('text')
		self.poster = kwargs.get('poster')
		self.focus_id = 2060
		self.set_properties()

	def onInit(self):
		self.setFocusId(self.focus_id)

	def run(self):
		self.doModal()

	def onAction(self, action):
		if action in self.closing_actions: self.close()

	def set_properties(self):
		self.setProperty('tikiskins.text_media.text', self.text)
		self.setProperty('tikiskins.text_media.poster', self.poster)
