# -*- coding: utf-8 -*-
import json
from windows import BaseDialog
# from modules.utils import logger

class ExtrasChooser(BaseDialog):
	def __init__(self, *args, **kwargs):
		BaseDialog.__init__(self, args)
		self.window_id = 5001
		self.kwargs = kwargs
		self.preselect = self.kwargs['preselect']
		self.items = json.loads(self.kwargs['items'])
		self.item_list = []
		self.chosen_indexes = []
		self.append = self.chosen_indexes.append
		self.selected = None
		self.make_menu()

	def onInit(self):
		self.win = self.getControl(self.window_id)
		self.win.addItems(self.item_list)
		if self.preselect:
			for index in self.preselect:
				self.item_list[index].setProperty('tikiskins.check_status', 'checked')
				self.append(index)
		self.setFocusId(self.window_id)

	def run(self):
		self.doModal()
		return self.selected

	def onClick(self, controlID):
		if controlID == 10:
			self.selected = sorted(self.chosen_indexes)
			self.close()
		elif controlID == 11:
			self.close()

	def onAction(self, action):
		if action in self.selection_actions:
			position = self.get_position(self.window_id)
			chosen_listitem = self.item_list[position]
			if chosen_listitem.getProperty('tikiskins.check_status') == 'checked':
				chosen_listitem.setProperty('tikiskins.check_status', '')
				self.chosen_indexes.remove(position)
			else:
				chosen_listitem.setProperty('tikiskins.check_status', 'checked')
				self.append(position)
		elif action in self.closing_actions:
			return self.close()

	def make_menu(self):
		def builder():
			for item in self.items:
				listitem = self.make_listitem()
				listitem.setProperty('tikiskins.extras_chooser.name', item['name'])
				listitem.setProperty('tikiskins.extras_chooser.image', item['image'])
				listitem.setProperty('tikiskins.extras_chooser.item', json.dumps(item))
				yield listitem
		self.item_list = list(builder())
